import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface PostgresqlProviderConfig {
    /**
     * Maximum wait for connection, in seconds. Zero or not specified means wait indefinitely.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql#connect_timeout PostgresqlProvider#connect_timeout}
     *
     * @stability stable
     */
    readonly connectTimeout?: number;
    /**
     * The name of the database to connect to in order to conenct to (defaults to `postgres`).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql#database PostgresqlProvider#database}
     *
     * @stability stable
     */
    readonly database?: string;
    /**
     * Database username associated to the connected user (for user name maps).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql#database_username PostgresqlProvider#database_username}
     *
     * @stability stable
     */
    readonly databaseUsername?: string;
    /**
     * Specify the expected version of PostgreSQL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql#expected_version PostgresqlProvider#expected_version}
     *
     * @stability stable
     */
    readonly expectedVersion?: string;
    /**
     * Name of PostgreSQL server address to connect to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql#host PostgresqlProvider#host}
     *
     * @stability stable
     */
    readonly host?: string;
    /**
     * Maximum number of connections to establish to the database. Zero means unlimited.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql#max_connections PostgresqlProvider#max_connections}
     *
     * @stability stable
     */
    readonly maxConnections?: number;
    /**
     * Password to be used if the PostgreSQL server demands password authentication.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql#password PostgresqlProvider#password}
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * The PostgreSQL port number to connect to at the server host, or socket file name extension for Unix-domain connections.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql#port PostgresqlProvider#port}
     *
     * @stability stable
     */
    readonly port?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql#scheme PostgresqlProvider#scheme}.
     *
     * @stability stable
     */
    readonly scheme?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql#ssl_mode PostgresqlProvider#ssl_mode}.
     *
     * @stability stable
     */
    readonly sslMode?: string;
    /**
     * This option determines whether or with what priority a secure SSL TCP/IP connection will be negotiated with the PostgreSQL server.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql#sslmode PostgresqlProvider#sslmode}
     *
     * @stability stable
     */
    readonly sslmode?: string;
    /**
     * The SSL server root certificate file path. The file must contain PEM encoded data.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql#sslrootcert PostgresqlProvider#sslrootcert}
     *
     * @stability stable
     */
    readonly sslrootcert?: string;
    /**
     * Specify if the user to connect as is a Postgres superuser or not.If not, some feature might be disabled (e.g.: Refreshing state password from Postgres).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql#superuser PostgresqlProvider#superuser}
     *
     * @stability stable
     */
    readonly superuser?: boolean | cdktf.IResolvable;
    /**
     * PostgreSQL user name to connect as.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql#username PostgresqlProvider#username}
     *
     * @stability stable
     */
    readonly username?: string;
    /**
     * Alias name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql#alias PostgresqlProvider#alias}
     *
     * @stability stable
     */
    readonly alias?: string;
    /**
     * clientcert block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql#clientcert PostgresqlProvider#clientcert}
     *
     * @stability stable
     */
    readonly clientcert?: PostgresqlProviderClientcert;
}
/**
 * @stability stable
 */
export interface PostgresqlProviderClientcert {
    /**
     * The SSL client certificate file path. The file must contain PEM encoded data.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql#cert PostgresqlProvider#cert}
     *
     * @stability stable
     */
    readonly cert: string;
    /**
     * The SSL client certificate private key file path. The file must contain PEM encoded data.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql#key PostgresqlProvider#key}
     *
     * @stability stable
     */
    readonly key: string;
}
/**
 * @stability stable
 */
export declare class PostgresqlProviderClientcertOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _cert?;
    /**
     * @stability stable
     */
    get cert(): string | undefined;
    /**
     * @stability stable
     */
    set cert(value: string | undefined);
    /**
     * @stability stable
     */
    get certInput(): string | undefined;
    private _key?;
    /**
     * @stability stable
     */
    get key(): string | undefined;
    /**
     * @stability stable
     */
    set key(value: string | undefined);
    /**
     * @stability stable
     */
    get keyInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/postgresql postgresql}.
 *
 * @stability stable
 */
export declare class PostgresqlProvider extends cdktf.TerraformProvider {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/postgresql postgresql} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: PostgresqlProviderConfig);
    private _connectTimeout?;
    /**
     * @stability stable
     */
    get connectTimeout(): number | undefined | undefined;
    /**
     * @stability stable
     */
    set connectTimeout(value: number | undefined | undefined);
    /**
     * @stability stable
     */
    resetConnectTimeout(): void;
    /**
     * @stability stable
     */
    get connectTimeoutInput(): number | undefined;
    private _database?;
    /**
     * @stability stable
     */
    get database(): string | undefined | undefined;
    /**
     * @stability stable
     */
    set database(value: string | undefined | undefined);
    /**
     * @stability stable
     */
    resetDatabase(): void;
    /**
     * @stability stable
     */
    get databaseInput(): string | undefined;
    private _databaseUsername?;
    /**
     * @stability stable
     */
    get databaseUsername(): string | undefined | undefined;
    /**
     * @stability stable
     */
    set databaseUsername(value: string | undefined | undefined);
    /**
     * @stability stable
     */
    resetDatabaseUsername(): void;
    /**
     * @stability stable
     */
    get databaseUsernameInput(): string | undefined;
    private _expectedVersion?;
    /**
     * @stability stable
     */
    get expectedVersion(): string | undefined | undefined;
    /**
     * @stability stable
     */
    set expectedVersion(value: string | undefined | undefined);
    /**
     * @stability stable
     */
    resetExpectedVersion(): void;
    /**
     * @stability stable
     */
    get expectedVersionInput(): string | undefined;
    private _host?;
    /**
     * @stability stable
     */
    get host(): string | undefined | undefined;
    /**
     * @stability stable
     */
    set host(value: string | undefined | undefined);
    /**
     * @stability stable
     */
    resetHost(): void;
    /**
     * @stability stable
     */
    get hostInput(): string | undefined;
    private _maxConnections?;
    /**
     * @stability stable
     */
    get maxConnections(): number | undefined | undefined;
    /**
     * @stability stable
     */
    set maxConnections(value: number | undefined | undefined);
    /**
     * @stability stable
     */
    resetMaxConnections(): void;
    /**
     * @stability stable
     */
    get maxConnectionsInput(): number | undefined;
    private _password?;
    /**
     * @stability stable
     */
    get password(): string | undefined | undefined;
    /**
     * @stability stable
     */
    set password(value: string | undefined | undefined);
    /**
     * @stability stable
     */
    resetPassword(): void;
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _port?;
    /**
     * @stability stable
     */
    get port(): number | undefined | undefined;
    /**
     * @stability stable
     */
    set port(value: number | undefined | undefined);
    /**
     * @stability stable
     */
    resetPort(): void;
    /**
     * @stability stable
     */
    get portInput(): number | undefined;
    private _scheme?;
    /**
     * @stability stable
     */
    get scheme(): string | undefined | undefined;
    /**
     * @stability stable
     */
    set scheme(value: string | undefined | undefined);
    /**
     * @stability stable
     */
    resetScheme(): void;
    /**
     * @stability stable
     */
    get schemeInput(): string | undefined;
    private _sslMode?;
    /**
     * @stability stable
     */
    get sslMode(): string | undefined | undefined;
    /**
     * @stability stable
     */
    set sslMode(value: string | undefined | undefined);
    /**
     * @stability stable
     */
    resetSslMode(): void;
    /**
     * @stability stable
     */
    get sslModeInput(): string | undefined;
    private _sslmode?;
    /**
     * @stability stable
     */
    get sslmode(): string | undefined | undefined;
    /**
     * @stability stable
     */
    set sslmode(value: string | undefined | undefined);
    /**
     * @stability stable
     */
    resetSslmode(): void;
    /**
     * @stability stable
     */
    get sslmodeInput(): string | undefined;
    private _sslrootcert?;
    /**
     * @stability stable
     */
    get sslrootcert(): string | undefined | undefined;
    /**
     * @stability stable
     */
    set sslrootcert(value: string | undefined | undefined);
    /**
     * @stability stable
     */
    resetSslrootcert(): void;
    /**
     * @stability stable
     */
    get sslrootcertInput(): string | undefined;
    private _superuser?;
    /**
     * @stability stable
     */
    get superuser(): boolean | cdktf.IResolvable | undefined | undefined;
    /**
     * @stability stable
     */
    set superuser(value: boolean | cdktf.IResolvable | undefined | undefined);
    /**
     * @stability stable
     */
    resetSuperuser(): void;
    /**
     * @stability stable
     */
    get superuserInput(): boolean | cdktf.IResolvable | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string | undefined | undefined;
    /**
     * @stability stable
     */
    set username(value: string | undefined | undefined);
    /**
     * @stability stable
     */
    resetUsername(): void;
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
    private _alias?;
    /**
     * @stability stable
     */
    get alias(): string | undefined | undefined;
    /**
     * @stability stable
     */
    set alias(value: string | undefined | undefined);
    /**
     * @stability stable
     */
    resetAlias(): void;
    /**
     * @stability stable
     */
    get aliasInput(): string | undefined;
    private _clientcert?;
    /**
     * @stability stable
     */
    get clientcert(): PostgresqlProviderClientcert | undefined | undefined;
    /**
     * @stability stable
     */
    set clientcert(value: PostgresqlProviderClientcert | undefined | undefined);
    /**
     * @stability stable
     */
    resetClientcert(): void;
    /**
     * @stability stable
     */
    get clientcertInput(): PostgresqlProviderClientcert | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
