/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.client;

import com.simba.googlebigquery.googlebigquery.client.KeyFileType;
import com.simba.googlebigquery.googlebigquery.core.BQDriver;
import com.simba.googlebigquery.googlebigquery.exceptions.BQMessageKey;
import com.simba.googlebigquery.support.exceptions.ErrorException;

public class BQServiceKey {
    private String key;
    private KeyFileType type;
    private static final String JSON_SUFFIX = ".json";
    private static final String P12_SUFFIX = ".p12";

    public BQServiceKey(String string) throws ErrorException {
        this.key = string;
        this.type = this.getKeyFileExtension(string);
    }

    public String getKey() {
        return this.key;
    }

    public KeyFileType getType() {
        return this.type;
    }

    private KeyFileType getKeyFileExtension(String string) throws ErrorException {
        boolean bl = string.endsWith(JSON_SUFFIX);
        boolean bl2 = string.endsWith(P12_SUFFIX);
        if (!bl && !bl2) {
            return KeyFileType.PLAINTEXT;
        }
        if (bl) {
            return KeyFileType.JSON;
        }
        if (bl2) {
            return KeyFileType.P12;
        }
        throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_INVALID_PVT_KEY_FILE.name());
    }
}

