/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.client.metadata;

import com.google.api.client.util.ExponentialBackOff;
import com.simba.googlebigquery.googlebigquery.core.BQDriver;
import com.simba.googlebigquery.googlebigquery.exceptions.BQMessageKey;
import com.simba.googlebigquery.support.ILogger;
import com.simba.googlebigquery.support.LogUtilities;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import java.io.IOException;

public abstract class BQMetadataRetryRequest<T> {
    private final ILogger m_connLogger;
    private static final int MAX_RETRIES = 5;

    public BQMetadataRetryRequest(ILogger iLogger) {
        this.m_connLogger = iLogger;
    }

    public abstract T execute() throws Exception;

    public void throwException(Exception exception) throws ErrorException {
        throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.METADATA_FETCH_ERR.name(), exception.getMessage(), (Throwable)exception);
    }

    public T executeWithRetry() throws ErrorException {
        ExponentialBackOff exponentialBackOff = new ExponentialBackOff.Builder().build();
        int n = 1;
        boolean bl = false;
        T t = null;
        do {
            try {
                if (1 != n) {
                    this.waitToRetryOrStop(exponentialBackOff);
                }
                t = this.execute();
                bl = false;
            }
            catch (Exception exception) {
                if (5 >= n) {
                    LogUtilities.logTrace(exception, this.m_connLogger);
                    bl = true;
                }
                this.throwException(exception);
            }
            ++n;
        } while (bl);
        return t;
    }

    private void waitToRetryOrStop(ExponentialBackOff exponentialBackOff) throws IOException, ErrorException, InterruptedException {
        long l = exponentialBackOff.nextBackOffMillis();
        if (-1L == l) {
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.METADATA_FETCH_ERR.name(), "Call has timed out, maximum number of retries (5) has been reached.");
        }
        Thread.sleep(l);
    }
}

