/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.dataengine;

import com.simba.googlebigquery.googlebigquery.BigQuery;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class BQAbstractReplacer {
    protected static Map<String, String> jdbcToBigQueryIntervalMap;

    public BQAbstractReplacer() {
        if (null == jdbcToBigQueryIntervalMap) {
            jdbcToBigQueryIntervalMap = new HashMap<String, String>();
            jdbcToBigQueryIntervalMap.put(BigQuery.JDBCTimestampInterval.SQL_TSI_FRAC_SECOND.name(), "MICROSECOND");
            jdbcToBigQueryIntervalMap.put(BigQuery.JDBCTimestampInterval.SQL_TSI_SECOND.name(), "SECOND");
            jdbcToBigQueryIntervalMap.put(BigQuery.JDBCTimestampInterval.SQL_TSI_MINUTE.name(), "MINUTE");
            jdbcToBigQueryIntervalMap.put(BigQuery.JDBCTimestampInterval.SQL_TSI_HOUR.name(), "HOUR");
            jdbcToBigQueryIntervalMap.put(BigQuery.JDBCTimestampInterval.SQL_TSI_DAY.name(), "DAY");
            jdbcToBigQueryIntervalMap.put(BigQuery.JDBCTimestampInterval.SQL_TSI_WEEK.name(), "WEEK");
            jdbcToBigQueryIntervalMap.put(BigQuery.JDBCTimestampInterval.SQL_TSI_MONTH.name(), "MONTH");
            jdbcToBigQueryIntervalMap.put(BigQuery.JDBCTimestampInterval.SQL_TSI_QUARTER.name(), "QUARTER");
            jdbcToBigQueryIntervalMap.put(BigQuery.JDBCTimestampInterval.SQL_TSI_YEAR.name(), "YEAR");
        }
    }

    protected String getCastClause(String string, String string2) throws IllegalArgumentException {
        String string3 = null;
        if (string2.equalsIgnoreCase("SQL_BIGINT") || string2.equalsIgnoreCase("BIGINT")) {
            string3 = "INT64";
        } else if (string2.equalsIgnoreCase("SQL_BIT") || string2.equalsIgnoreCase("BIT")) {
            string3 = "BOOL";
        } else if (string2.equalsIgnoreCase("SQL_DOUBLE") || string2.equalsIgnoreCase("DOUBLE")) {
            string3 = "FLOAT64";
        } else if (string2.equalsIgnoreCase("SQL_VARBINARY") || string2.equalsIgnoreCase("VARBINARY")) {
            string3 = "BYTES";
        } else if (string2.equalsIgnoreCase("SQL_VARCHAR") || string2.equalsIgnoreCase("VARCHAR")) {
            string3 = "STRING";
        } else if (string2.equalsIgnoreCase("SQL_DATE") || string2.equalsIgnoreCase("DATE")) {
            string3 = "DATE";
        } else if (string2.equalsIgnoreCase("SQL_TIME") || string2.equalsIgnoreCase("TIME")) {
            string3 = "TIME";
        } else if (string2.equalsIgnoreCase("SQL_TIMESTAMP") || string2.equalsIgnoreCase("TIMESTAMP")) {
            string3 = "TIMESTAMP";
        } else {
            throw new IllegalArgumentException(string2);
        }
        return "CAST(" + string + " AS " + string3 + ")";
    }

    protected StringBuilder originalExpression(ArrayList<StringBuilder> arrayList, StringBuilder stringBuilder) {
        int n = arrayList.size();
        stringBuilder.append((CharSequence)arrayList.get(0)).append("(");
        for (int i = 1; i < n; ++i) {
            stringBuilder.append((CharSequence)arrayList.get(i));
            if (i == n - 1) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.append(")");
    }

    protected void wrapDateExpression(StringBuilder stringBuilder) {
        stringBuilder.insert(0, "CAST(").append(" AS DATE)");
    }

    protected void wrapTimeExpression(StringBuilder stringBuilder) {
        stringBuilder.insert(0, "CAST(").append(" AS TIME)");
    }

    protected void wrapTimestampExpression(StringBuilder stringBuilder) {
        stringBuilder.insert(0, "CAST(").append(" AS TIMESTAMP)");
    }
}

