/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.dataengine;

import com.simba.googlebigquery.googlebigquery.BigQuery;
import com.simba.googlebigquery.googlebigquery.dataengine.BQAbstractReplacer;
import com.simba.googlebigquery.support.EscapeTypes;
import com.simba.googlebigquery.support.IReplacer;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BQLegacyReplacer
extends BQAbstractReplacer
implements IReplacer {
    static final String DATE_PATTERN = "^ (?: \\s* DATE \\s*) (['\"].*['\"])";
    static final String DATE_RESULT = "DATE($1)";
    static final String TIMESTAMP_PATTERN = "^ (?: \\s* TIMESTAMP \\s*) (['\"].*['\"])";
    static final String TIMESTAMP_RESULT = "TIMESTAMP($1)";

    @Override
    public StringBuilder replace(EscapeTypes escapeTypes, ArrayList<StringBuilder> arrayList) {
        StringBuilder stringBuilder = new StringBuilder();
        switch (escapeTypes) {
            case PARAM: {
                return stringBuilder.append("?");
            }
            case LIMIT_OFFSET: {
                if (1 == arrayList.size()) {
                    stringBuilder.append("LIMIT").append(" ").append((CharSequence)arrayList.get(0));
                } else if (2 == arrayList.size()) {
                    stringBuilder.append("LIMIT").append(" ").append((CharSequence)arrayList.get(0)).append(" ").append("OFFSET").append(" ").append((CharSequence)arrayList.get(1));
                }
                return stringBuilder;
            }
            case DATE: 
            case TIME: 
            case TIMESTAMP: {
                int n = arrayList.size();
                stringBuilder.append("CAST (");
                for (int i = 0; i < n; ++i) {
                    stringBuilder.append((CharSequence)arrayList.get(i));
                    if (i == n - 1) continue;
                    stringBuilder.append(" ");
                }
                return stringBuilder.append(" AS ").append(escapeTypes.name()).append(")");
            }
            case OUTERJOIN: {
                int n = arrayList.size();
                stringBuilder.append("(");
                for (int i = 0; i < n; ++i) {
                    stringBuilder.append((CharSequence)arrayList.get(i));
                    if (i == n - 1) continue;
                    stringBuilder.append(" ");
                }
                return stringBuilder.append(")");
            }
            case FN: {
                String string = arrayList.get(0).toString().toUpperCase();
                if (string.equals(BigQuery.JDBCScalarFunctions.INSERT.name()) && 5 == arrayList.size()) {
                    return stringBuilder.append("CONCAT(LEFT(" + arrayList.get(1) + "," + arrayList.get(2) + "-1)," + arrayList.get(4) + ",SUBSTR(" + arrayList.get(1) + "," + arrayList.get(2) + "+" + arrayList.get(3) + "))");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.LCASE.name()) && 2 == arrayList.size()) {
                    return stringBuilder.append("LOWER(" + arrayList.get(1) + ")");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.LOCATE.name()) && 3 == arrayList.size()) {
                    return stringBuilder.append("INSTR(" + arrayList.get(2) + "," + arrayList.get(1) + ")");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.REPEAT.name()) && 3 == arrayList.size()) {
                    return stringBuilder.append("RPAD(" + arrayList.get(1) + ",LENGTH(" + arrayList.get(1) + ")*" + arrayList.get(2) + "," + arrayList.get(1) + ")");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.SPACE.name()) && 2 == arrayList.size()) {
                    return stringBuilder.append("RPAD(\"\"," + arrayList.get(1) + ", \" \")");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.SUBSTRING.name()) && 4 == arrayList.size()) {
                    return stringBuilder.append("SUBSTR(" + arrayList.get(1) + "," + arrayList.get(2) + "," + arrayList.get(3) + ")");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.UCASE.name()) && 2 == arrayList.size()) {
                    return stringBuilder.append("UPPER(" + arrayList.get(1) + ")");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.CURRENT_DATE.name()) || string.equals(BigQuery.JDBCScalarFunctions.CURDATE.name())) {
                    return stringBuilder.append("CAST(CURRENT_DATE() AS DATE)");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.CURRENT_TIME.name())) {
                    return stringBuilder.append("CAST(CURRENT_TIME() AS TIME)");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.CURRENT_TIMESTAMP.name())) {
                    return stringBuilder.append("USEC_TO_TIMESTAMP(NOW())");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.CURTIME.name())) {
                    return stringBuilder.append("CAST(CURRENT_TIME() AS TIME)");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.DAYNAME.name()) && 2 == arrayList.size()) {
                    this.fixDateAndTimestampSyntax(arrayList.get(1));
                    return stringBuilder.append("STRFTIME_UTC_USEC(TIMESTAMP(CAST(" + arrayList.get(1) + " AS STRING)), \"%A\")");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.DAYOFMONTH.name()) && 2 == arrayList.size()) {
                    this.fixDateAndTimestampSyntax(arrayList.get(1));
                    return stringBuilder.append("DAY(TIMESTAMP(CAST(" + arrayList.get(1) + " AS STRING)))");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.DAYOFYEAR.name()) && 2 == arrayList.size()) {
                    this.fixDateAndTimestampSyntax(arrayList.get(1));
                    return stringBuilder.append("DAYOFYEAR(TIMESTAMP(CAST(" + arrayList.get(1) + " AS STRING)))");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.DAYOFWEEK.name()) && 2 == arrayList.size()) {
                    this.fixDateAndTimestampSyntax(arrayList.get(1));
                    return stringBuilder.append("DAYOFWEEK(TIMESTAMP(CAST(" + arrayList.get(1) + " AS STRING)))");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.MONTH.name()) && 2 == arrayList.size()) {
                    this.fixDateAndTimestampSyntax(arrayList.get(1));
                    return stringBuilder.append("MONTH(TIMESTAMP(CAST(" + arrayList.get(1) + " AS STRING)))");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.MONTHNAME.name()) && 2 == arrayList.size()) {
                    this.fixDateAndTimestampSyntax(arrayList.get(1));
                    return stringBuilder.append("STRFTIME_UTC_USEC(TIMESTAMP(CAST(" + arrayList.get(1) + " AS STRING)), \"%B\")");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.NOW.name())) {
                    return stringBuilder.append("USEC_TO_TIMESTAMP(NOW())");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.QUARTER.name()) && 2 == arrayList.size()) {
                    this.fixDateAndTimestampSyntax(arrayList.get(1));
                    return stringBuilder.append("QUARTER(TIMESTAMP(CAST(" + arrayList.get(1) + " AS STRING)))");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.TIMESTAMPDIFF.name()) && 4 == arrayList.size()) {
                    if (arrayList.get(1).toString().equals(BigQuery.JDBCTimestampInterval.SQL_TSI_DAY.name())) {
                        this.fixDateAndTimestampSyntax(arrayList.get(2));
                        this.fixDateAndTimestampSyntax(arrayList.get(3));
                        this.wrapTimestampExpression(arrayList.get(2));
                        this.wrapTimestampExpression(arrayList.get(3));
                        return stringBuilder.append("DATEDIFF(" + arrayList.get(3) + "," + arrayList.get(2) + ")");
                    }
                    return this.originalExpression(arrayList, stringBuilder);
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.TIMESTAMPADD.name()) && 4 == arrayList.size()) {
                    this.fixDateAndTimestampSyntax(arrayList.get(3));
                    this.wrapTimestampExpression(arrayList.get(3));
                    String string2 = arrayList.get(1).toString().toUpperCase();
                    if (string2.equals(BigQuery.JDBCTimestampInterval.SQL_TSI_SECOND.name()) || string2.equals(BigQuery.JDBCTimestampInterval.SQL_TSI_MINUTE.name()) || string2.equals(BigQuery.JDBCTimestampInterval.SQL_TSI_HOUR.name()) || string2.equals(BigQuery.JDBCTimestampInterval.SQL_TSI_DAY.name()) || string2.equals(BigQuery.JDBCTimestampInterval.SQL_TSI_MONTH.name()) || string2.equals(BigQuery.JDBCTimestampInterval.SQL_TSI_YEAR.name())) {
                        return stringBuilder.append("DATE_ADD(" + arrayList.get(3) + "," + arrayList.get(2) + ",\"" + (String)jdbcToBigQueryIntervalMap.get(string2) + "\")");
                    }
                    if (string2.equals(BigQuery.JDBCTimestampInterval.SQL_TSI_WEEK.name())) {
                        return stringBuilder.append("DATE_ADD(" + arrayList.get(3) + "," + arrayList.get(2) + "*7,\"DAY\")");
                    }
                    if (string2.equals(BigQuery.JDBCTimestampInterval.SQL_TSI_QUARTER.name())) {
                        return stringBuilder.append("DATE_ADD(" + arrayList.get(3) + "," + arrayList.get(2) + "*3,\"MONTH\")");
                    }
                    return this.originalExpression(arrayList, stringBuilder);
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.WEEK.name()) && 2 == arrayList.size()) {
                    this.fixDateAndTimestampSyntax(arrayList.get(1));
                    return stringBuilder.append("WEEK(TIMESTAMP(CAST( " + arrayList.get(1) + " AS STRING)))");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.YEAR.name()) && 2 == arrayList.size()) {
                    this.fixDateAndTimestampSyntax(arrayList.get(1));
                    return stringBuilder.append("YEAR(TIMESTAMP(CAST(" + arrayList.get(1) + " AS STRING)))");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.ATAN2.name()) && 3 == arrayList.size()) {
                    return stringBuilder.append("ATAN2(" + arrayList.get(2) + "," + arrayList.get(1) + ")");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.CEILING.name()) && 2 == arrayList.size()) {
                    return stringBuilder.append("CEIL(" + arrayList.get(1) + ")");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.COT.name()) && 2 == arrayList.size()) {
                    return stringBuilder.append("1/TAN(" + arrayList.get(1) + ")");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.MOD.name()) && 3 == arrayList.size()) {
                    return stringBuilder.append(arrayList.get(1) + " % " + arrayList.get(2));
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.POWER.name()) && 3 == arrayList.size()) {
                    return stringBuilder.append("POW(" + arrayList.get(1) + "," + arrayList.get(2) + ")");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.RAND.name())) {
                    return stringBuilder.append("RAND()");
                }
                return this.originalExpression(arrayList, stringBuilder);
            }
        }
        return stringBuilder.append("NOT IMPLEMENTED: ").append(escapeTypes.toString());
    }

    protected void fixDateAndTimestampSyntax(StringBuilder stringBuilder) {
        Pattern pattern = Pattern.compile(TIMESTAMP_PATTERN, 6);
        Matcher matcher = pattern.matcher(stringBuilder);
        String string = matcher.replaceAll(TIMESTAMP_RESULT);
        pattern = Pattern.compile(DATE_PATTERN, 6);
        matcher = pattern.matcher(string);
        string = matcher.replaceAll(DATE_RESULT);
        stringBuilder.setLength(0);
        stringBuilder.append(string);
    }
}

