/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.dataengine;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.services.bigquery.model.GetQueryResultsResponse;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobList;
import com.google.api.services.bigquery.model.QueryParameter;
import com.google.api.services.bigquery.model.QueryParameterType;
import com.google.api.services.bigquery.model.QueryParameterValue;
import com.simba.googlebigquery.dsi.dataengine.impl.DSIEmptyResultSet;
import com.simba.googlebigquery.dsi.dataengine.utilities.ExecutionContext;
import com.simba.googlebigquery.dsi.dataengine.utilities.ExecutionContexts;
import com.simba.googlebigquery.dsi.dataengine.utilities.ParameterInputValue;
import com.simba.googlebigquery.dsi.dataengine.utilities.ParameterMetadata;
import com.simba.googlebigquery.dsi.dataengine.utilities.ParameterType;
import com.simba.googlebigquery.dsi.dataengine.utilities.TypeMetadata;
import com.simba.googlebigquery.dsi.exceptions.BadDefaultParamException;
import com.simba.googlebigquery.dsi.exceptions.ExecutingException;
import com.simba.googlebigquery.dsi.exceptions.OperationCanceledException;
import com.simba.googlebigquery.dsi.exceptions.ParsingException;
import com.simba.googlebigquery.googlebigquery.client.BQGetQueryResultsResponse;
import com.simba.googlebigquery.googlebigquery.client.IBQResponse;
import com.simba.googlebigquery.googlebigquery.core.BQConnection;
import com.simba.googlebigquery.googlebigquery.core.BQDriver;
import com.simba.googlebigquery.googlebigquery.dataengine.BQAbstractExecutor;
import com.simba.googlebigquery.googlebigquery.dataengine.BQBufferManager;
import com.simba.googlebigquery.googlebigquery.dataengine.BQResultSet;
import com.simba.googlebigquery.googlebigquery.dataengine.BQRowCountResult;
import com.simba.googlebigquery.googlebigquery.exceptions.BQMessageKey;
import com.simba.googlebigquery.googlebigquery.utils.BQCoreUtils;
import com.simba.googlebigquery.googlebigquery.utils.BQRegexUtils;
import com.simba.googlebigquery.support.ILogger;
import com.simba.googlebigquery.support.IWarningListener;
import com.simba.googlebigquery.support.LogUtilities;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BQSQLExecutor
extends BQAbstractExecutor {
    private static final String REGEX_DML_PATTERN = BQRegexUtils.buildDmlRegex();
    private static final String REGEX_DDL_PATTERN = BQRegexUtils.buildDdlRegex();
    private static final String REGEX_SCRIPT_PATTERN = BQRegexUtils.buildScriptRegex();
    private static Pattern m_dmlPattern = Pattern.compile(REGEX_DML_PATTERN);
    private static Pattern m_ddlPattern = Pattern.compile(REGEX_DDL_PATTERN);
    private static Pattern m_scriptPattern = Pattern.compile(REGEX_SCRIPT_PATTERN);
    private static final String SCRIPT_JOB_ID = "script";
    private static final String SCRIPT_JOB_TYPE_EXPRESSION = "EXPRESSION";
    private static final String SCRIPT_JOB_TYPE_BEGIN_TRANSACTION = "BEGIN_TRANSACTION";
    private static final String SCRIPT_JOB_TYPE_COMMIT_TRANSACTION = "COMMIT_TRANSACTION";
    private static final String SCRIPT_JOB_TYPE_ROLLBACK_TRANSACTION = "ROLLBACK_TRANSACTION";
    private Map<Integer, String> m_queryParamType = new HashMap<Integer, String>();
    private ArrayList<Boolean> m_DMLQueryFlags = new ArrayList();
    private ArrayList<Boolean> m_scriptFlags = new ArrayList();
    private boolean m_isBatch;

    public BQSQLExecutor(ILogger iLogger, BQConnection bQConnection, List<String> list, boolean bl, boolean bl2) throws ErrorException {
        super(iLogger, bQConnection, list);
        LogUtilities.logFunctionEntrance(iLogger, bQConnection, list.get(0), bl, bl2);
        if (1 == this.m_queries.size()) {
            this.m_isBatch = false;
        } else {
            this.m_isBatch = true;
            this.m_isRowCount = true;
        }
        this.m_isDirectExecute = bl;
        if (!bl) {
            this.internalPrepare();
        }
        list.forEach(new Consumer<String>(){

            @Override
            public void accept(String string) {
                Matcher matcher = m_dmlPattern.matcher(string);
                Matcher matcher2 = m_scriptPattern.matcher(string);
                BQSQLExecutor.this.m_DMLQueryFlags.add(matcher.find());
                BQSQLExecutor.this.m_scriptFlags.add(matcher2.find());
            }
        });
        if (1 == this.m_queries.size()) {
            Matcher matcher = m_ddlPattern.matcher((CharSequence)this.m_queries.get(0));
            if (this.m_scriptFlags.contains(true)) {
                this.m_results.addResultSet(new DSIEmptyResultSet());
            } else if (this.m_DMLQueryFlags.contains(true) || matcher.find()) {
                this.m_isRowCount = true;
            } else if (bl) {
                this.m_results.addResultSet(new DSIEmptyResultSet());
            } else if (!this.m_isRowCount) {
                BQResultSet bQResultSet = new BQResultSet(this.m_logger, this.m_connection, ((IBQResponse)this.m_preparedQueryInfoList.get(0)).getExecutedJob());
                this.m_results.addResultSet(bQResultSet);
            }
        }
        if (this.m_isRowCount) {
            this.m_results.addRowCountResult(new BQRowCountResult());
        }
    }

    @Override
    public void execute(ExecutionContexts executionContexts, IWarningListener iWarningListener) throws BadDefaultParamException, ParsingException, ExecutingException, OperationCanceledException, ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, executionContexts, iWarningListener);
        Iterator<ExecutionContext> iterator = executionContexts.contextIterator();
        this.m_results.getResults().clear();
        while (iterator.hasNext()) {
            long l;
            int n;
            ExecutionContext executionContext = iterator.next();
            if (null != executionContext.getInputs() && !executionContext.getInputs().isEmpty()) {
                for (n = 0; n < executionContext.getInputs().size(); ++n) {
                    ParameterInputValue parameterInputValue = executionContext.getInputs().get(n);
                    QueryParameter queryParameter = new QueryParameter();
                    QueryParameterType queryParameterType = new QueryParameterType();
                    QueryParameterValue queryParameterValue = new QueryParameterValue();
                    String string = this.m_queryParamType.get(n);
                    queryParameterType.setType(string);
                    queryParameter.setParameterType(queryParameterType);
                    queryParameterValue.setValue(BQCoreUtils.getParamValueAsText(parameterInputValue));
                    queryParameter.setParameterValue(queryParameterValue);
                    this.m_executionContext.bqParameters.add(queryParameter);
                }
            }
            this.m_executedQueryInfoList = new Vector();
            for (n = 0; n < this.m_queries.size(); ++n) {
                this.m_executionContext.useDestinationTable = this.m_connectionOptions.m_largeResultsEnabled && !this.m_isRowCount && this.m_scriptFlags.get(n) == false;
                this.m_executionContext.useJobsQuery = !this.m_isParameterized && this.m_scriptFlags.get(n) == false && !this.m_executionContext.useDestinationTable;
                this.m_executionContext.query = (String)this.m_queries.get(n);
                super.execute();
            }
            if (this.m_isBatch) {
                n = 0;
                while (n < this.m_executedQueryInfoList.size()) {
                    if (!((IBQResponse)this.m_executedQueryInfoList.get(n)).hasChildJobs()) {
                        l = 0L;
                        if (this.m_DMLQueryFlags.get(n).booleanValue()) {
                            l = ((IBQResponse)this.m_executedQueryInfoList.get(n)).getNumDmlAffectedRows();
                        }
                        this.m_results.addRowCountResult(new BQRowCountResult(l));
                        ++n;
                        continue;
                    }
                    this.processChildJobs(n);
                    ++n;
                }
            } else if (((IBQResponse)this.m_executedQueryInfoList.get(0)).hasChildJobs()) {
                this.processChildJobs(0);
            } else {
                IBQResponse iBQResponse = (IBQResponse)this.m_executedQueryInfoList.get(0);
                if (this.m_isRowCount) {
                    l = 0L;
                    if (this.m_DMLQueryFlags.get(0).booleanValue()) {
                        l = iBQResponse.getNumDmlAffectedRows();
                    }
                    this.m_results.addRowCountResult(new BQRowCountResult(l));
                } else {
                    this.m_results.addResultSet(new BQResultSet(this.m_logger, this.m_connection, iBQResponse, false));
                }
            }
            this.m_executionContext.bqParameters.clear();
        }
    }

    @Override
    public ArrayList<ParameterMetadata> getMetadataForParameters() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_parameters;
    }

    @Override
    public void internalPrepare() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        Job job = this.m_client.prepare((String)this.m_queries.get(0), this.m_connectionOptions.m_projectId, this.m_connectionOptions.m_defaultDataSet);
        List list = job.getStatistics().getQuery().getUndeclaredQueryParameters();
        if (null != list) {
            int n = list.size();
            int n2 = 1;
            for (int i = 0; i < n; ++i) {
                String string = ((QueryParameter)list.get(i)).getParameterType().getType();
                ParameterMetadata parameterMetadata = new ParameterMetadata(n2++, ParameterType.INPUT, BQCoreUtils.bigqueryToSqlTypeConverter(string));
                this.m_parameters.add(parameterMetadata);
                String string2 = ((QueryParameter)list.get(i)).getParameterType().getType();
                this.m_queryParamType.put(i, string2);
            }
            this.m_isParameterized = true;
        }
        this.m_preparedQueryInfoList = new Vector();
        this.m_preparedQueryInfoList.add(new BQGetQueryResultsResponse(job, null));
    }

    @Override
    public void pushMappedParamTypes(Map<Integer, TypeMetadata> map) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, map);
        Integer n = null;
        for (Map.Entry<Integer, TypeMetadata> entry : map.entrySet()) {
            n = entry.getKey();
            int n2 = entry.getValue().getType();
            if (2 == n2) {
                n2 = 12;
            }
            ParameterMetadata parameterMetadata = new ParameterMetadata(n + 1, ParameterType.INPUT, n2);
            this.m_parameters.set(n, parameterMetadata);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processChildJobs(int n) throws ErrorException {
        Object object;
        Object object2;
        Object object3;
        String string;
        if (this.m_executedQueryInfoList.size() < n) {
            LogUtilities.logDebug("Error processing child jobs, aborting.", this.m_logger);
            return;
        }
        String string2 = ((IBQResponse)this.m_executedQueryInfoList.get(n)).getJobReference().getLocation();
        ArrayList<Job> arrayList = new ArrayList<Job>();
        BQGetQueryResultsResponse bQGetQueryResultsResponse = (BQGetQueryResultsResponse)this.m_executedQueryInfoList.get(n);
        for (JobList.Jobs jobs : bQGetQueryResultsResponse.getChildJobs()) {
            string = jobs.getId();
            object3 = this.getChildJob(string, string2);
            object2 = object3.getStatistics().getQuery().getStatementType();
            object = object3.getStatistics().getScriptStatistics();
            if (this.isTransactionType((String)object2) || object != null && object.getEvaluationKind().equals(SCRIPT_JOB_TYPE_EXPRESSION)) continue;
            arrayList.add((Job)object3);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            boolean bl;
            long l;
            JobList.Jobs jobs;
            jobs = (Job)arrayList.get(i);
            string = this.parseChildJobId(jobs.getId());
            object3 = null;
            object2 = null;
            try {
                object3 = new BQBufferManager(this.m_logger, this.m_connection, string, ((IBQResponse)this.m_executedQueryInfoList.get(n)).getJobReference().getLocation(), null);
                object = this.m_client.getQueryResults(string, this.m_connectionOptions.m_projectId, ((IBQResponse)this.m_executedQueryInfoList.get(n)).getJobReference().getLocation(), null, this.m_connectionOptions.m_timeout, this.m_connectionOptions.m_maxResults, (BQBufferManager)object3);
                object2 = new BQGetQueryResultsResponse((Job)jobs, (GetQueryResultsResponse)object, null);
            }
            catch (ErrorException errorException) {
                if (arrayList.size() - 1 != i) continue;
                throw errorException;
            }
            finally {
                if (object3 != null) {
                    ((BQBufferManager)object3).cleanUp();
                }
            }
            object = ((BQGetQueryResultsResponse)object2).getNumDmlAffectedRows();
            long l2 = l = null != object ? (Long)object : 0L;
            if (this.m_isBatch) {
                this.m_results.addRowCountResult(new BQRowCountResult(l));
                continue;
            }
            BigInteger bigInteger = ((BQGetQueryResultsResponse)object2).getTotalRows();
            boolean bl2 = bl = null != object || null == bigInteger;
            if (bl) {
                this.m_results.addRowCountResult(new BQRowCountResult(l));
                continue;
            }
            BQResultSet bQResultSet = new BQResultSet(this.m_logger, this.m_connection, (IBQResponse)object2, false);
            this.m_results.addResultSet(bQResultSet);
        }
    }

    private Job getChildJob(String string, String string2) throws ErrorException {
        Job job = null;
        try {
            job = this.m_client.getJob(this.m_connectionOptions.m_projectId, this.parseChildJobId(string), string2, this.m_connectionOptions.m_timeout);
        }
        catch (GoogleJsonResponseException googleJsonResponseException) {
            googleJsonResponseException.printStackTrace();
        }
        return job;
    }

    private String parseChildJobId(String string) throws ErrorException {
        int n = string.indexOf(SCRIPT_JOB_ID);
        if (0 > n) {
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.EXEC_GET_CHILD_JOB_ID_ERR.name(), string);
        }
        return string.substring(n);
    }

    private boolean isTransactionType(String string) {
        return string.equals(SCRIPT_JOB_TYPE_BEGIN_TRANSACTION) || string.equals(SCRIPT_JOB_TYPE_COMMIT_TRANSACTION) || string.equals(SCRIPT_JOB_TYPE_ROLLBACK_TRANSACTION);
    }
}

