/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.dataengine.metadata;

import com.google.api.services.bigquery.model.DatasetReference;
import com.simba.googlebigquery.dsi.dataengine.filters.IFilter;
import com.simba.googlebigquery.dsi.dataengine.utilities.DataWrapper;
import com.simba.googlebigquery.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.simba.googlebigquery.googlebigquery.client.metadata.BQMetadataExecutor;
import com.simba.googlebigquery.googlebigquery.client.metadata.BQMetadataResult;
import com.simba.googlebigquery.googlebigquery.core.BQConnection;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQColumnMetadata;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQFunction;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQFunctionColumn;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQMetadataUtils;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQTable;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.IFilterableMetadataSource;
import com.simba.googlebigquery.support.ILogger;
import com.simba.googlebigquery.support.LogUtilities;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class BQMetadataSource
implements IFilterableMetadataSource {
    public static final int CATALOG_FILTER_IDX = 0;
    public static final int SCHEMA_FILTER_IDX = 1;
    public static final int TABLE_FILTER_IDX = 2;
    public static final int COLUMN_FILTER_IDX = 3;
    public static final int FUNCTION_FILTER_IDX = 4;
    protected final BQMetadataUtils m_bqMetadataUtils;
    protected ErrorException m_cachedException;
    protected final BQConnection m_connection;
    protected IFilter[] m_filters;
    protected final ILogger m_logger;
    protected final Map<MetadataSourceColumnTag, String> m_restrictions;
    protected List<String> m_catalogs = new ArrayList<String>();
    protected List<BQColumnMetadata> m_columns;
    protected List<DatasetReference> m_schemas;
    protected List<BQTable> m_tables;
    protected List<BQFunction> m_functions;
    protected List<BQFunctionColumn> m_functionColumns;
    protected int m_catalogIdx = 0;
    protected int m_columnIdx = 0;
    protected int m_schemaIdx = 0;
    protected int m_tableIdx = 0;
    protected int m_functionIdx = 0;
    protected int m_functionColumnIdx = 0;
    protected boolean m_hasStartedMetadataFetch = false;
    protected boolean m_hasStartedCatalogsFetch = false;
    protected boolean m_hasStartedColumnsFetch = false;
    protected boolean m_hasStartedSchemasFetch = false;
    protected boolean m_hasStartedTablesFetch = false;
    protected boolean m_hasStartedFunctionsFetch = false;
    protected boolean m_hasStartedFunctionColumnsFetch = false;
    protected boolean m_haveAllRestrictions = false;
    private int m_fetchThreadCount = 0;
    private BQMetadataResult m_metadataResult;

    public BQMetadataSource(ILogger iLogger, BQConnection bQConnection, Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, iLogger);
        this.m_logger = iLogger;
        this.m_connection = bQConnection;
        this.m_restrictions = map;
        this.m_bqMetadataUtils = new BQMetadataUtils(iLogger, bQConnection);
        this.m_schemas = new ArrayList<DatasetReference>();
        this.m_tables = new ArrayList<BQTable>();
        this.m_functions = new ArrayList<BQFunction>();
        this.m_fetchThreadCount = bQConnection.getSettings().m_metadataFetchThreadCount;
        this.m_metadataResult = new BQMetadataResult();
    }

    public static boolean doesMetadataPassFilter(String string, IFilter iFilter) {
        assert (null != iFilter);
        DataWrapper dataWrapper = new DataWrapper();
        dataWrapper.setVarChar(string);
        return iFilter.filter(dataWrapper);
    }

    @Override
    public void passdownFilters(List<IFilter> list) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        for (IFilter iFilter : list) {
            switch (iFilter.getColumnTag()) {
                case CATALOG_NAME: {
                    this.m_filters[0] = iFilter;
                    break;
                }
                case SCHEMA_NAME: {
                    this.m_filters[1] = iFilter;
                    break;
                }
                case TABLE_NAME: {
                    this.m_filters[2] = iFilter;
                    break;
                }
                case COLUMN_NAME: {
                    this.m_filters[3] = iFilter;
                    break;
                }
                case PROCEDURE_NAME: {
                    this.m_filters[4] = iFilter;
                }
            }
        }
    }

    protected boolean moveToNextCatalog() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (!this.m_hasStartedMetadataFetch) {
            this.m_metadataResult = this.executeFetch(BQMetadataExecutor.FetchType.PROJECT);
            this.m_catalogs = this.m_metadataResult.getProjects();
            this.m_catalogIdx = 0;
        } else {
            ++this.m_catalogIdx;
        }
        return this.m_catalogIdx < this.m_catalogs.size();
    }

    protected boolean moveToNextColumn() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (!this.m_hasStartedMetadataFetch) {
            this.m_metadataResult = this.executeFetch(BQMetadataExecutor.FetchType.COLUMN);
        }
        if (!this.m_hasStartedColumnsFetch) {
            this.m_columns = new ArrayList<BQColumnMetadata>();
            this.m_columnIdx = 0;
            this.m_hasStartedColumnsFetch = true;
            this.m_columns = this.m_metadataResult.getColumns();
        } else {
            ++this.m_columnIdx;
        }
        return !this.m_columns.isEmpty() && this.m_columnIdx != this.m_columns.size();
    }

    protected boolean moveToNextSchema() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (!this.m_hasStartedMetadataFetch) {
            this.m_metadataResult = this.executeFetch(BQMetadataExecutor.FetchType.DATASET);
        }
        if (!this.m_hasStartedSchemasFetch) {
            this.m_schemas = new ArrayList<DatasetReference>();
            this.m_schemaIdx = 0;
            this.m_hasStartedSchemasFetch = true;
            this.m_schemas = this.m_metadataResult.getDatasets();
        } else {
            ++this.m_schemaIdx;
        }
        return !this.m_schemas.isEmpty() && this.m_schemaIdx < this.m_schemas.size();
    }

    protected boolean moveToNextTable() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (!this.m_hasStartedMetadataFetch) {
            this.m_metadataResult = this.executeFetch(BQMetadataExecutor.FetchType.TABLE);
        }
        if (!this.m_hasStartedTablesFetch) {
            this.m_tableIdx = 0;
            this.m_hasStartedTablesFetch = true;
            this.m_tables = this.m_metadataResult.getTables();
        } else {
            ++this.m_tableIdx;
        }
        return !this.m_tables.isEmpty() && this.m_tableIdx < this.m_tables.size();
    }

    protected boolean moveToNextFunction(boolean bl) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (!this.m_hasStartedMetadataFetch) {
            BQMetadataExecutor.FetchType fetchType = bl ? BQMetadataExecutor.FetchType.FUNCTION : BQMetadataExecutor.FetchType.PROCEDURE;
            this.m_metadataResult = this.executeFetch(fetchType);
        }
        if (!this.m_hasStartedFunctionsFetch) {
            this.m_functions = new ArrayList<BQFunction>();
            this.m_functionIdx = 0;
            this.m_hasStartedFunctionsFetch = true;
            this.m_functions = this.m_metadataResult.getFunctions();
        } else {
            ++this.m_functionIdx;
        }
        return !this.m_functions.isEmpty() && this.m_functionIdx < this.m_functions.size();
    }

    protected boolean moveToNextFunctionColumn(boolean bl) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (!this.m_hasStartedMetadataFetch) {
            BQMetadataExecutor.FetchType fetchType = bl ? BQMetadataExecutor.FetchType.FUNCTIONCOLUMN : BQMetadataExecutor.FetchType.PROCEDURECOLUMN;
            this.m_metadataResult = this.executeFetch(fetchType);
        }
        if (!this.m_hasStartedFunctionColumnsFetch) {
            this.m_functionColumns = new ArrayList<BQFunctionColumn>();
            this.m_functionColumnIdx = 0;
            this.m_functionColumns = this.m_metadataResult.getFunctionColumns();
            this.m_hasStartedFunctionColumnsFetch = true;
        } else {
            ++this.m_functionColumnIdx;
        }
        return !this.m_functionColumns.isEmpty() && this.m_functionColumnIdx < this.m_functionColumns.size();
    }

    private BQMetadataResult executeFetch(BQMetadataExecutor.FetchType fetchType) throws ErrorException {
        BQMetadataExecutor bQMetadataExecutor = new BQMetadataExecutor(this.m_logger, this.m_connection.getClient(), this.m_bqMetadataUtils, this.m_filters, this.m_restrictions, this.m_fetchThreadCount);
        BQMetadataResult bQMetadataResult = bQMetadataExecutor.execute(fetchType);
        this.m_hasStartedMetadataFetch = true;
        return bQMetadataResult;
    }
}

