/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.dataengine.metadata;

import com.google.api.services.bigquery.model.Argument;
import com.google.api.services.bigquery.model.DatasetList;
import com.google.api.services.bigquery.model.DatasetReference;
import com.google.api.services.bigquery.model.ListRoutinesResponse;
import com.google.api.services.bigquery.model.Routine;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableList;
import com.google.api.services.bigquery.model.TableReference;
import com.simba.googlebigquery.googlebigquery.client.BQClient;
import com.simba.googlebigquery.googlebigquery.core.BQConnection;
import com.simba.googlebigquery.googlebigquery.core.BQConnectionOptions;
import com.simba.googlebigquery.googlebigquery.core.BQDriver;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQColumnMetadata;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQFunction;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQFunctionColumn;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQTable;
import com.simba.googlebigquery.googlebigquery.exceptions.BQMessageKey;
import com.simba.googlebigquery.support.ILogger;
import com.simba.googlebigquery.support.LogUtilities;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class BQMetadataUtils {
    private static final String S_FUNCTION = "SCALAR_FUNCTION";
    private static final String S_PROCEDURE = "PROCEDURE";
    private final BQClient m_bqClient;
    private final ILogger m_stmt_logger;
    private final BQConnectionOptions m_connectionSettings;

    public BQMetadataUtils(ILogger iLogger, BQConnection bQConnection) {
        this.m_stmt_logger = iLogger;
        this.m_bqClient = bQConnection.getClient();
        this.m_connectionSettings = bQConnection.getSettings();
    }

    private static List<BQTable> filterByType(List<BQTable> list, String string) throws NullPointerException {
        if (null == list) {
            throw new NullPointerException();
        }
        if (BQMetadataUtils.isNullOrEmpty(string)) {
            return list;
        }
        ArrayList<BQTable> arrayList = new ArrayList<BQTable>();
        for (BQTable bQTable : list) {
            if (!string.equals(bQTable.getTableType())) continue;
            arrayList.add(bQTable);
        }
        return arrayList;
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    private List<BQColumnMetadata> convertColumns(String string, String string2, String string3, List<TableFieldSchema> list) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_stmt_logger, new Object[0]);
        ArrayList<BQColumnMetadata> arrayList = new ArrayList<BQColumnMetadata>();
        for (TableFieldSchema tableFieldSchema : list) {
            BQColumnMetadata bQColumnMetadata = new BQColumnMetadata(this.m_stmt_logger, string, string2, string3, tableFieldSchema, this.m_connectionSettings);
            arrayList.add(bQColumnMetadata);
        }
        return arrayList;
    }

    public static List<DatasetReference> convertDatasetListToDatasetReferences(List<DatasetList> list) throws ErrorException {
        ArrayList<DatasetReference> arrayList = new ArrayList<DatasetReference>();
        try {
            for (DatasetList datasetList : list) {
                List list2 = datasetList.getDatasets();
                if (null == list2) continue;
                for (DatasetList.Datasets datasets : list2) {
                    DatasetReference datasetReference = datasets.getDatasetReference();
                    if (datasetReference != null) {
                        arrayList.add(datasetReference);
                        continue;
                    }
                    throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.METADATA_CATALOG_SCHEMA_ERR.name());
                }
            }
        }
        catch (ErrorException errorException) {
            throw errorException;
        }
        catch (Exception exception) {
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.METADATA_CATALOG_SCHEMA_ERR.name(), new String[]{exception.toString()});
        }
        return arrayList;
    }

    private List<BQTable> convertTables(List<TableList> list) {
        LogUtilities.logFunctionEntrance(this.m_stmt_logger, new Object[0]);
        ArrayList<BQTable> arrayList = new ArrayList<BQTable>();
        HashMap<String, ArrayList> hashMap = new HashMap<String, ArrayList>();
        for (TableList tableList : list) {
            List list2 = tableList.getTables();
            if (list2 == null) continue;
            for (TableList.Tables tables : list2) {
                ArrayList arrayList2;
                boolean bl = true;
                if (null != tables.getView()) {
                    bl = this.verifyViewMatchesSelectedDialect(tables.getView().getUseLegacySql());
                }
                if (!bl) continue;
                TableReference tableReference = tables.getTableReference();
                BQTable bQTable = new BQTable(tableReference != null ? tableReference.getProjectId() : null, tableReference != null ? tableReference.getDatasetId() : null, tableReference != null ? tableReference.getTableId() : null, tables.getType());
                arrayList.add(bQTable);
                if (null == hashMap.get(bQTable.getTableName())) {
                    arrayList2 = new ArrayList();
                    arrayList2.add(bQTable);
                } else {
                    arrayList2 = (ArrayList)hashMap.get(bQTable.getTableName());
                    arrayList2.add(bQTable);
                }
                hashMap.put(bQTable.getTableName(), arrayList2);
            }
        }
        return arrayList;
    }

    private List<BQFunction> convertRoutines(List<ListRoutinesResponse> list, HashMap<String, ArrayList<BQFunction>> hashMap, boolean bl) {
        LogUtilities.logFunctionEntrance(this.m_stmt_logger, new Object[0]);
        ArrayList<BQFunction> arrayList = new ArrayList<BQFunction>();
        hashMap = new HashMap();
        for (ListRoutinesResponse listRoutinesResponse : list) {
            List list2 = listRoutinesResponse.getRoutines();
            if (list2 == null) continue;
            for (Routine routine : list2) {
                ArrayList<Object> arrayList2;
                BQFunction bQFunction = new BQFunction(routine, bl);
                arrayList.add(bQFunction);
                if (null == hashMap.get(bQFunction.getFunctionName())) {
                    arrayList2 = new ArrayList<BQFunction>();
                    arrayList2.add(bQFunction);
                } else {
                    arrayList2 = hashMap.get(bQFunction.getFunctionName());
                    arrayList2.add(bQFunction);
                }
                hashMap.put(bQFunction.getFunctionName(), arrayList2);
            }
        }
        return arrayList;
    }

    public void fillColumnPositions(List<BQColumnMetadata> list) {
        int n = 1;
        list.get(0).setPosition(n);
        for (int i = 1; i < list.size(); ++i) {
            BQColumnMetadata bQColumnMetadata = list.get(i);
            BQColumnMetadata bQColumnMetadata2 = list.get(i - 1);
            if (bQColumnMetadata.getTableName().equals(bQColumnMetadata2.getTableName())) {
                bQColumnMetadata.setPosition(++n);
                continue;
            }
            n = 1;
        }
    }

    public void fillFunctionColumnPositions(List<BQFunctionColumn> list) {
        int n = 1;
        list.get(0).setColumnPosition(n);
        for (int i = 1; i < list.size(); ++i) {
            BQFunctionColumn bQFunctionColumn = list.get(i);
            BQFunctionColumn bQFunctionColumn2 = list.get(i - 1);
            if (bQFunctionColumn.getFunctionName().equals(bQFunctionColumn2.getFunctionName())) {
                bQFunctionColumn.setColumnPosition(++n);
                continue;
            }
            n = 1;
        }
    }

    public List<BQColumnMetadata> getColumns(BQTable bQTable) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_stmt_logger, new Object[0]);
        ArrayList<BQColumnMetadata> arrayList = new ArrayList<BQColumnMetadata>();
        List<TableFieldSchema> list = this.m_bqClient.getColumns(bQTable.getCatalogName(), bQTable.getSchemaName(), bQTable.getTableName());
        if (null != list) {
            List<BQColumnMetadata> list2 = this.convertColumns(bQTable.getCatalogName(), bQTable.getSchemaName(), bQTable.getTableName(), list);
            arrayList.addAll(list2);
        }
        if (!arrayList.isEmpty()) {
            this.fillColumnPositions(arrayList);
        }
        return arrayList;
    }

    public List<BQTable> getTables(String string, String string2, String string3, String string4) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_stmt_logger, new Object[0]);
        List<Object> list = new ArrayList();
        HashMap<String, ArrayList> hashMap = null;
        if (!BQMetadataUtils.isNullOrEmpty(string2) && !BQMetadataUtils.isNullOrEmpty(string3)) {
            list = new ArrayList();
            hashMap = new HashMap<String, ArrayList>();
            Table table = this.m_bqClient.getTable(string, string2, string3);
            boolean bl = true;
            if (null != table.getView()) {
                bl = this.verifyViewMatchesSelectedDialect(table.getView().getUseLegacySql());
            }
            if (bl) {
                ArrayList arrayList;
                TableReference tableReference = table.getTableReference();
                BQTable bQTable = new BQTable(tableReference != null ? tableReference.getProjectId() : null, tableReference != null ? tableReference.getDatasetId() : null, tableReference != null ? tableReference.getTableId() : null, table.getType());
                list.add(bQTable);
                if (null == hashMap.get(bQTable.getTableName())) {
                    arrayList = new ArrayList();
                    arrayList.add(bQTable);
                } else {
                    arrayList = (ArrayList)hashMap.get(bQTable.getTableName());
                    arrayList.add(bQTable);
                }
                hashMap.put(bQTable.getTableName(), arrayList);
            }
        } else {
            List<TableList> list2 = this.m_bqClient.getTableList(string, string2);
            list = this.convertTables(list2);
        }
        if (!BQMetadataUtils.isNullOrEmpty(string3)) {
            list = null != hashMap && null != hashMap.get(string3) ? (List)hashMap.get(string3) : new ArrayList();
        }
        if (!BQMetadataUtils.isNullOrEmpty(string4)) {
            list = BQMetadataUtils.filterByType(list, string4);
        }
        return list;
    }

    public List<BQFunction> getFunctions(String string, String string2, String string3, boolean bl) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_stmt_logger, new Object[0]);
        List<BQFunction> list = new ArrayList<BQFunction>();
        HashMap<String, ArrayList<BQFunction>> hashMap = null;
        if (!BQMetadataUtils.isNullOrEmpty(string2) && !BQMetadataUtils.isNullOrEmpty(string3)) {
            ArrayList<Object> arrayList;
            hashMap = new HashMap<String, ArrayList<BQFunction>>();
            Routine routine = this.m_bqClient.getFunction(string, string2, string3);
            BQFunction bQFunction = new BQFunction(routine, bl);
            list.add(bQFunction);
            if (null == hashMap.get(bQFunction.getFunctionName())) {
                arrayList = new ArrayList<BQFunction>();
                arrayList.add(bQFunction);
            } else {
                arrayList = hashMap.get(bQFunction.getFunctionName());
                arrayList.add(bQFunction);
            }
            hashMap.put(bQFunction.getFunctionName(), arrayList);
        } else {
            StringBuilder stringBuilder = new StringBuilder("routineType:");
            if (bl) {
                stringBuilder.append(S_FUNCTION);
            } else {
                stringBuilder.append(S_PROCEDURE);
            }
            List<ListRoutinesResponse> list2 = this.m_bqClient.getFunctionList(string, string2, stringBuilder.toString());
            list = this.convertRoutines(list2, hashMap, bl);
        }
        if (!BQMetadataUtils.isNullOrEmpty(string3)) {
            list = null != hashMap && null != hashMap.get(string3) ? (List)hashMap.get(string3) : new ArrayList();
        }
        return list;
    }

    public List<BQFunctionColumn> getFunctionColumns(BQFunction bQFunction, boolean bl) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_stmt_logger, new Object[0]);
        ArrayList<BQFunctionColumn> arrayList = new ArrayList<BQFunctionColumn>();
        List<Argument> list = bQFunction.getArguments();
        if (null != list) {
            for (Argument argument : list) {
                arrayList.add(new BQFunctionColumn(argument, bQFunction.getRoutine(), this.m_connectionSettings.m_stringColumnLength));
            }
        }
        if (!arrayList.isEmpty()) {
            this.fillFunctionColumnPositions(arrayList);
        }
        return arrayList;
    }

    private boolean verifyViewMatchesSelectedDialect(boolean bl) {
        boolean bl2 = true;
        BQConnectionOptions.QueryDialect queryDialect = this.m_connectionSettings.m_queryDialect;
        if (bl && queryDialect == BQConnectionOptions.QueryDialect.SQL || !bl && queryDialect == BQConnectionOptions.QueryDialect.BIG_QUERY) {
            bl2 = false;
        }
        return bl2;
    }
}

