/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.dataengine.metadata;

import com.simba.googlebigquery.dsi.dataengine.interfaces.IMetadataSource;
import com.simba.googlebigquery.dsi.dataengine.utilities.DSITypeUtilities;
import com.simba.googlebigquery.dsi.dataengine.utilities.DataWrapper;
import com.simba.googlebigquery.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.simba.googlebigquery.dsi.dataengine.utilities.Nullable;
import com.simba.googlebigquery.dsi.dataengine.utilities.Searchable;
import com.simba.googlebigquery.dsi.dataengine.utilities.TypeUtilities;
import com.simba.googlebigquery.googlebigquery.core.BQConnectionOptions;
import com.simba.googlebigquery.googlebigquery.core.BQDriver;
import com.simba.googlebigquery.googlebigquery.exceptions.BQMessageKey;
import com.simba.googlebigquery.support.ILogger;
import com.simba.googlebigquery.support.LogUtilities;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import java.util.ArrayList;

public class BQTypeInfoMetadataSource
implements IMetadataSource {
    private static final String S_CHAR_TYPE_LITERAL_PREFIX_SUFFIX = "'";
    ArrayList<TypeInfo> m_dataTypes = new ArrayList();
    private int m_currentIndex = 0;
    private boolean m_isFetching = false;
    private final ILogger m_logger;
    private final BQConnectionOptions m_settings;

    public BQTypeInfoMetadataSource(ILogger iLogger, BQConnectionOptions bQConnectionOptions) {
        LogUtilities.logFunctionEntrance(iLogger, iLogger);
        this.m_logger = iLogger;
        this.m_settings = bQConnectionOptions;
        this.initializeDataTypes();
    }

    private void initializeDataTypes() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        TypeInfo typeInfo = new TypeInfo(12, "STRING", (int)this.m_settings.m_stringColumnLength);
        typeInfo.m_literalPrefix = S_CHAR_TYPE_LITERAL_PREFIX_SUFFIX;
        typeInfo.m_literalSuffix = S_CHAR_TYPE_LITERAL_PREFIX_SUFFIX;
        typeInfo.m_caseSensitive = true;
        this.m_dataTypes.add(typeInfo);
        if (BQConnectionOptions.QueryDialect.SQL == this.m_settings.m_queryDialect) {
            typeInfo = new TypeInfo(12, "ARRAY", (int)this.m_settings.m_stringColumnLength);
            typeInfo.m_literalPrefix = S_CHAR_TYPE_LITERAL_PREFIX_SUFFIX;
            typeInfo.m_literalSuffix = S_CHAR_TYPE_LITERAL_PREFIX_SUFFIX;
            typeInfo.m_caseSensitive = true;
            this.m_dataTypes.add(typeInfo);
            typeInfo = new TypeInfo(12, "STRUCT", (int)this.m_settings.m_stringColumnLength);
            typeInfo.m_literalPrefix = S_CHAR_TYPE_LITERAL_PREFIX_SUFFIX;
            typeInfo.m_literalSuffix = S_CHAR_TYPE_LITERAL_PREFIX_SUFFIX;
            typeInfo.m_caseSensitive = true;
            this.m_dataTypes.add(typeInfo);
        }
        String string = BQConnectionOptions.QueryDialect.SQL == this.m_settings.m_queryDialect ? "BOOL" : "BOOLEAN";
        typeInfo = new TypeInfo(16, string, 1);
        typeInfo.m_searchable = Searchable.PREDICATE_BASIC;
        this.m_dataTypes.add(typeInfo);
        string = BQConnectionOptions.QueryDialect.SQL == this.m_settings.m_queryDialect ? "FLOAT64" : "FLOAT";
        typeInfo = new TypeInfo(8, string, 15);
        typeInfo.m_searchable = Searchable.PREDICATE_BASIC;
        this.m_dataTypes.add(typeInfo);
        string = BQConnectionOptions.QueryDialect.SQL == this.m_settings.m_queryDialect ? "INT64" : "INTEGER";
        typeInfo = new TypeInfo(-5, string, 19);
        typeInfo.m_searchable = Searchable.PREDICATE_BASIC;
        this.m_dataTypes.add(typeInfo);
        typeInfo = new TypeInfo(91, "DATE", 10);
        typeInfo.m_literalPrefix = S_CHAR_TYPE_LITERAL_PREFIX_SUFFIX;
        typeInfo.m_literalSuffix = S_CHAR_TYPE_LITERAL_PREFIX_SUFFIX;
        this.m_dataTypes.add(typeInfo);
        typeInfo = new TypeInfo(92, "TIME", 15);
        typeInfo.m_literalPrefix = S_CHAR_TYPE_LITERAL_PREFIX_SUFFIX;
        typeInfo.m_literalSuffix = S_CHAR_TYPE_LITERAL_PREFIX_SUFFIX;
        typeInfo.m_maxScale = (short)6;
        this.m_dataTypes.add(typeInfo);
        typeInfo = new TypeInfo(93, "DATETIME", 26);
        typeInfo.m_literalPrefix = S_CHAR_TYPE_LITERAL_PREFIX_SUFFIX;
        typeInfo.m_literalSuffix = S_CHAR_TYPE_LITERAL_PREFIX_SUFFIX;
        this.m_dataTypes.add(typeInfo);
        typeInfo = new TypeInfo(93, "TIMESTAMP", 26);
        typeInfo.m_literalPrefix = S_CHAR_TYPE_LITERAL_PREFIX_SUFFIX;
        typeInfo.m_literalSuffix = S_CHAR_TYPE_LITERAL_PREFIX_SUFFIX;
        this.m_dataTypes.add(typeInfo);
        typeInfo = new TypeInfo(-3, "BYTES", 65535);
        typeInfo.m_literalPrefix = S_CHAR_TYPE_LITERAL_PREFIX_SUFFIX;
        typeInfo.m_literalSuffix = S_CHAR_TYPE_LITERAL_PREFIX_SUFFIX;
        this.m_dataTypes.add(typeInfo);
        typeInfo = new TypeInfo(2, "NUMERIC", 38);
        typeInfo.m_createParams = "PRECISION,SCALE";
        typeInfo.m_searchable = Searchable.PREDICATE_BASIC;
        typeInfo.m_minScale = (short)9;
        typeInfo.m_maxScale = (short)38;
        typeInfo.m_fixedPrecScale = true;
        this.m_dataTypes.add(typeInfo);
        typeInfo = new TypeInfo(12, "GEOGRAPHY", (int)this.m_settings.m_stringColumnLength);
        typeInfo.m_searchable = Searchable.PREDICATE_NONE;
        this.m_dataTypes.add(typeInfo);
        typeInfo = new TypeInfo(2, "BIGNUMERIC", 77);
        typeInfo.m_createParams = "PRECISION,SCALE";
        typeInfo.m_searchable = Searchable.PREDICATE_BASIC;
        typeInfo.m_minScale = (short)38;
        typeInfo.m_maxScale = (short)77;
        typeInfo.m_fixedPrecScale = true;
        this.m_dataTypes.add(typeInfo);
        typeInfo = new TypeInfo(12, "INTERVAL", (int)this.m_settings.m_stringColumnLength);
        typeInfo.m_searchable = Searchable.PREDICATE_NONE;
        this.m_dataTypes.add(typeInfo);
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.closeCursor();
    }

    @Override
    public void closeCursor() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_isFetching = false;
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{metadataSourceColumnTag, l, l2});
        switch (metadataSourceColumnTag) {
            case DATA_TYPE_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_dataTypes.get((int)this.m_currentIndex).m_typeName, dataWrapper, l, l2);
            }
            case DATA_TYPE: {
                dataWrapper.setSmallInt(this.m_dataTypes.get((int)this.m_currentIndex).m_sqlType);
                return false;
            }
            case COLUMN_SIZE: {
                dataWrapper.setInteger(this.m_dataTypes.get((int)this.m_currentIndex).m_columnSize);
                return false;
            }
            case LITERAL_PREFIX: {
                return DSITypeUtilities.outputVarCharStringData(this.m_dataTypes.get((int)this.m_currentIndex).m_literalPrefix, dataWrapper, l, l2);
            }
            case LITERAL_SUFFIX: {
                return DSITypeUtilities.outputVarCharStringData(this.m_dataTypes.get((int)this.m_currentIndex).m_literalSuffix, dataWrapper, l, l2);
            }
            case CREATE_PARAM: {
                return DSITypeUtilities.outputVarCharStringData(this.m_dataTypes.get((int)this.m_currentIndex).m_createParams, dataWrapper, l, l2);
            }
            case NULLABLE: {
                dataWrapper.setSmallInt(this.m_dataTypes.get((int)this.m_currentIndex).m_nullable.ordinal());
                return false;
            }
            case CASE_SENSITIVE: {
                if (this.m_dataTypes.get((int)this.m_currentIndex).m_caseSensitive) {
                    dataWrapper.setSmallInt(1);
                } else {
                    dataWrapper.setSmallInt(0);
                }
                return false;
            }
            case SEARCHABLE: {
                dataWrapper.setSmallInt(this.m_dataTypes.get((int)this.m_currentIndex).m_searchable.ordinal());
                return false;
            }
            case UNSIGNED_ATTRIBUTE: {
                TypeInfo typeInfo = this.m_dataTypes.get(this.m_currentIndex);
                if (!(TypeUtilities.isApproximateNumericType(typeInfo.m_sqlType) || TypeUtilities.isExactNumericType(typeInfo.m_sqlType) || TypeUtilities.isIntegerType(typeInfo.m_sqlType))) {
                    dataWrapper.setNull(5);
                } else if (this.m_dataTypes.get((int)this.m_currentIndex).m_unsignedAttr) {
                    dataWrapper.setSmallInt(1);
                } else {
                    dataWrapper.setSmallInt(0);
                }
                return false;
            }
            case FIXED_PREC_SCALE: {
                dataWrapper.setBoolean(this.m_dataTypes.get((int)this.m_currentIndex).m_fixedPrecScale);
                return false;
            }
            case AUTO_UNIQUE: {
                TypeInfo typeInfo = this.m_dataTypes.get(this.m_currentIndex);
                if (!(TypeUtilities.isApproximateNumericType(typeInfo.m_sqlType) || TypeUtilities.isExactNumericType(typeInfo.m_sqlType) || TypeUtilities.isIntegerType(typeInfo.m_sqlType))) {
                    dataWrapper.setNull(5);
                } else if (-1 == this.m_dataTypes.get((int)this.m_currentIndex).m_autoUnique) {
                    dataWrapper.setNull(5);
                } else {
                    dataWrapper.setSmallInt(this.m_dataTypes.get((int)this.m_currentIndex).m_autoUnique);
                }
                return false;
            }
            case LOCAL_TYPE_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_dataTypes.get((int)this.m_currentIndex).m_typeName, dataWrapper, l, l2);
            }
            case MINIMUM_SCALE: {
                TypeInfo typeInfo = this.m_dataTypes.get(this.m_currentIndex);
                if (TypeUtilities.isExactNumericType(typeInfo.m_sqlType) || TypeUtilities.isIntegerType(typeInfo.m_sqlType) || -7 == typeInfo.m_sqlType || 92 == typeInfo.m_sqlType || 93 == typeInfo.m_sqlType) {
                    dataWrapper.setSmallInt(this.m_dataTypes.get((int)this.m_currentIndex).m_minScale);
                } else {
                    dataWrapper.setNull(5);
                }
                return false;
            }
            case MAXIMUM_SCALE: {
                TypeInfo typeInfo = this.m_dataTypes.get(this.m_currentIndex);
                if (TypeUtilities.isExactNumericType(typeInfo.m_sqlType) || TypeUtilities.isIntegerType(typeInfo.m_sqlType) || -7 == typeInfo.m_sqlType || 92 == typeInfo.m_sqlType || 93 == typeInfo.m_sqlType) {
                    dataWrapper.setSmallInt(this.m_dataTypes.get((int)this.m_currentIndex).m_maxScale);
                } else {
                    dataWrapper.setNull(5);
                }
                return false;
            }
            case SQL_DATA_TYPE: {
                int n = this.m_dataTypes.get((int)this.m_currentIndex).m_sqlType;
                dataWrapper.setSmallInt(TypeUtilities.getVerboseTypeFromConciseType(n));
                return false;
            }
            case SQL_DATETIME_SUB: {
                TypeInfo typeInfo = this.m_dataTypes.get(this.m_currentIndex);
                short s = TypeUtilities.getIntervalCodeFromConciseType(typeInfo.m_sqlType);
                if (0 == s) {
                    dataWrapper.setNull(5);
                } else {
                    dataWrapper.setSmallInt(s);
                }
                return false;
            }
            case NUM_PREC_RADIX: {
                TypeInfo typeInfo = this.m_dataTypes.get(this.m_currentIndex);
                if (TypeUtilities.isApproximateNumericType(typeInfo.m_sqlType)) {
                    dataWrapper.setInteger(2L);
                } else if (TypeUtilities.isExactNumericType(typeInfo.m_sqlType) || TypeUtilities.isIntegerType(typeInfo.m_sqlType)) {
                    dataWrapper.setInteger(10L);
                } else {
                    dataWrapper.setNull(4);
                }
                return false;
            }
            case INTERVAL_PRECISION: {
                dataWrapper.setNull(5);
                return false;
            }
            case USER_DATA_TYPE: {
                dataWrapper.setSmallInt(0);
                return false;
            }
        }
        throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.METADATA_COLUMN_NOT_FOUND_ERR.name(), new String[]{metadataSourceColumnTag.toString()});
    }

    @Override
    public boolean hasMoreRows() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_currentIndex + 1 < this.m_dataTypes.size();
    }

    @Override
    public boolean moveToNextRow() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_isFetching) {
            ++this.m_currentIndex;
        } else {
            this.m_isFetching = true;
            this.m_currentIndex = 0;
        }
        return this.m_currentIndex < this.m_dataTypes.size();
    }

    private static class TypeInfo {
        public short m_autoUnique;
        public boolean m_caseSensitive;
        public int m_columnSize;
        public String m_createParams;
        public boolean m_fixedPrecScale;
        public String m_literalPrefix;
        public String m_literalSuffix;
        public short m_maxScale;
        public short m_minScale;
        public Nullable m_nullable;
        public Searchable m_searchable;
        public int m_sqlType;
        public String m_typeName;
        public boolean m_unsignedAttr;

        public TypeInfo(int n, String string, int n2) {
            this.m_sqlType = n;
            this.m_typeName = string;
            this.m_columnSize = n2;
            this.m_literalPrefix = null;
            this.m_literalSuffix = null;
            this.m_createParams = null;
            this.m_nullable = Nullable.NULLABLE;
            this.m_caseSensitive = false;
            this.m_searchable = Searchable.SEARCHABLE;
            this.m_unsignedAttr = false;
            this.m_fixedPrecScale = false;
            this.m_autoUnique = (short)-1;
            this.m_minScale = 0;
            this.m_maxScale = 0;
        }
    }
}

