/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.utils;

public class BQRegexUtils {
    public static final String REGEX_ALTER_PATTERN = "ALTER";
    public static final String REGEX_BEGIN_PATTERN = "BEGIN";
    public static final String REGEX_CALL_PATTERN = "CALL";
    public static final String REGEX_CREATE_PATTERN = "CREATE";
    public static final String REGEX_COMMIT_PATTERN = "COMMIT";
    public static final String REGEX_DECLARE_PATTERN = "DECLARE";
    public static final String REGEX_DELETE_PATTERN = "DELETE";
    public static final String REGEX_DROP_PATTERN = "DROP";
    public static final String REGEX_EXECUTE_PATTERN = "EXECUTE";
    public static final String REGEX_EXPORT_PATTERN = "EXPORT";
    public static final String REGEX_EXTERNAL_PATTERN = "EXTERNAL";
    public static final String REGEX_GRANT_PATTERN = "GRANT";
    public static final String REGEX_IF_PATTERN = "IF";
    public static final String REGEX_INSERT_PATTERN = "INSERT";
    public static final String REGEX_LOOP_PATTERN = "LOOP";
    public static final String REGEX_LOOPBREAK_PATTERN = "BREAK";
    public static final String REGEX_LOOPCONTINUE_PATTERN = "CONTINUE";
    public static final String REGEX_LOOPITERATE_PATTERN = "ITERATE";
    public static final String REGEX_LOOPLEAVE_PATTERN = "LEAVE";
    public static final String REGEX_LOOPWHILE_PATTERN = "WHILE";
    public static final String REGEX_MERGE_PATTERN = "MERGE";
    public static final String REGEX_PROCEDURE_PATTERN = "PROCEDURE";
    public static final String REGEX_RAISE_PATTERN = "RAISE";
    public static final String REGEX_RETURN_PATTERN = "RETURN";
    public static final String REGEX_REVOKE_PATTERN = "REVOKE";
    public static final String REGEX_ROLLBACK_PATTERN = "ROLLBACK";
    public static final String REGEX_SELECT_PATTERN = "SELECT";
    public static final String REGEX_SET_PATTERN = "SET";
    public static final String REGEX_TRUNCATE_PATTERN = "TRUNCATE";
    public static final String REGEX_UPDATE_PATTERN = "UPDATE";
    public static final String REGEX_WITH_PATTERN = "WITH";
    public static final String REGEX_WHITESPACESTAR_PATTERN = "(\\s)*";
    public static final String REGEX_COMMENT_PATTERN = "((\\s)*((--.*\\n)|(#.*\\n)|(?:\\/\\*(?s).*?\\*\\/))*(\\s)*)";
    public static final String REGEX_PREFIX = "(^|;)((\\s)*((--.*\\n)|(#.*\\n)|(?:\\/\\*(?s).*?\\*\\/))*(\\s)*)(?i)";
    public static final String REGEX_SCRIPT_PREFIX = ";(((\\s)*((--.*\\n)|(#.*\\n)|(?:\\/\\*(?s).*?\\*\\/))*(\\s)*))?(?i)";
    public static final String REGEX_COMMENTORWHITESPACE_PATTERN = "((\\s)*|((\\s)*((--.*\\n)|(#.*\\n)|(?:\\/\\*(?s).*?\\*\\/))*(\\s)*))";
    public static final String[] ddlRegex = new String[]{"ALTER", "CREATE", "DROP", "EXPORT", "GRANT", "REVOKE"};
    public static final String[] dmlRegex = new String[]{"DELETE", "INSERT", "MERGE", "TRUNCATE", "UPDATE"};
    public static final String[] queryRegex = new String[]{"SELECT", "WITH"};
    public static final String[] scriptRegex = new String[]{"BEGIN", "CALL", "COMMIT", "DECLARE", "EXECUTE", "IF", "LOOP", "BREAK", "CONTINUE", "ITERATE", "LEAVE", "WHILE", "RAISE", "RETURN", "ROLLBACK", "SET"};

    public static String buildDdlRegex() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(REGEX_PREFIX);
        BQRegexUtils.buildOrBlock(stringBuilder, ddlRegex);
        stringBuilder.append(REGEX_COMMENTORWHITESPACE_PATTERN);
        return stringBuilder.toString();
    }

    public static String buildDmlRegex() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(REGEX_PREFIX);
        BQRegexUtils.buildOrBlock(stringBuilder, dmlRegex);
        stringBuilder.append(REGEX_COMMENTORWHITESPACE_PATTERN);
        return stringBuilder.toString();
    }

    public static void buildOrBlock(StringBuilder stringBuilder, String[] stringArray) {
        assert (stringArray.length >= 2);
        stringBuilder.append('(' + stringArray[0]);
        for (int i = 1; stringArray.length > i; ++i) {
            stringBuilder.append('|' + stringArray[i]);
        }
        stringBuilder.append(')');
    }

    public static String buildScriptRegex() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        stringBuilder.append(REGEX_PREFIX);
        BQRegexUtils.buildOrBlock(stringBuilder, scriptRegex);
        stringBuilder.append(")");
        stringBuilder.append("|");
        stringBuilder.append(REGEX_SCRIPT_PREFIX);
        stringBuilder.append("(");
        BQRegexUtils.buildOrBlock(stringBuilder, queryRegex);
        stringBuilder.append("|");
        BQRegexUtils.buildOrBlock(stringBuilder, ddlRegex);
        stringBuilder.append("|");
        BQRegexUtils.buildOrBlock(stringBuilder, dmlRegex);
        stringBuilder.append("|");
        BQRegexUtils.buildOrBlock(stringBuilder, scriptRegex);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

