/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.jdbc.common;

import com.simba.googlebigquery.dsi.core.impl.DSIDriverSingleton;
import com.simba.googlebigquery.dsi.core.interfaces.IStatement;
import com.simba.googlebigquery.dsi.dataengine.interfaces.IDataEngine;
import com.simba.googlebigquery.dsi.dataengine.interfaces.IErrorResult;
import com.simba.googlebigquery.dsi.dataengine.interfaces.IQueryExecutor;
import com.simba.googlebigquery.dsi.dataengine.interfaces.IResultSet;
import com.simba.googlebigquery.dsi.dataengine.interfaces.IResults;
import com.simba.googlebigquery.dsi.dataengine.interfaces.IRowCountResult;
import com.simba.googlebigquery.dsi.dataengine.utilities.ExecutionContexts;
import com.simba.googlebigquery.dsi.dataengine.utilities.ExecutionResult;
import com.simba.googlebigquery.dsi.dataengine.utilities.ExecutionResultType;
import com.simba.googlebigquery.dsi.dataengine.utilities.ParameterGeneratedValues;
import com.simba.googlebigquery.dsi.dataengine.utilities.ParameterInputValue;
import com.simba.googlebigquery.dsi.dataengine.utilities.ParameterMetadata;
import com.simba.googlebigquery.exceptions.ExceptionConverter;
import com.simba.googlebigquery.exceptions.JDBCMessageKey;
import com.simba.googlebigquery.jdbc.common.BaseStatement;
import com.simba.googlebigquery.jdbc.common.SConnection;
import com.simba.googlebigquery.support.IWarningListener;
import com.simba.googlebigquery.support.LogUtilities;
import com.simba.googlebigquery.support.Pair;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import com.simba.googlebigquery.support.exceptions.ExceptionType;
import com.simba.googlebigquery.utilities.FunctionID;
import java.sql.BatchUpdateException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class SStatement
extends BaseStatement<IResultSet> {
    protected Iterator<ExecutionResult> m_resultIterator = null;
    protected IQueryExecutor m_queryExecutor = null;
    private IDataEngine m_dataEngine = null;
    protected SConnection m_parentConnection = null;
    protected List<ResultContext> m_resultSets = new ArrayList<ResultContext>();

    protected SStatement(IStatement iStatement, SConnection sConnection, int n) throws SQLException {
        super(sConnection, iStatement, n);
        this.m_parentConnection = sConnection;
    }

    protected void addResultPair(ResultContext resultContext) {
        if (null != this.m_resultSets && !this.m_resultSets.contains(resultContext)) {
            this.m_resultSets.add(resultContext);
        }
    }

    @Override
    protected void addResultPair(ExecutionResult executionResult) {
        try {
            this.addResultPair(this.createResultPair(executionResult));
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
    }

    @Override
    protected void addResultSet(ResultSet resultSet) {
        this.addResultPair(new ResultContext(resultSet));
    }

    @Deprecated
    protected ExecutionResult checkAndMoveToNextResult(String string, IResults iResults, ThrowCondition throwCondition) throws SQLException {
        return this.checkAndMoveToNextResult(string, throwCondition);
    }

    protected ExecutionResult checkAndMoveToNextResult(String string, ThrowCondition throwCondition) throws SQLException {
        return this.checkAndMoveToNextResult(string, throwCondition.toBaseThrowCondition());
    }

    @Deprecated
    protected void checkCondition(String string, ThrowCondition throwCondition) throws ErrorException, SQLException {
    }

    protected ResultContext createResultPair(ExecutionResult executionResult) throws SQLException {
        if (ExecutionResultType.ROW_COUNT == executionResult.getType()) {
            IRowCountResult iRowCountResult = (IRowCountResult)executionResult.getResult();
            return new ResultContext(iRowCountResult);
        }
        if (ExecutionResultType.RESULT_SET == executionResult.getType()) {
            ResultSet resultSet = this.createResultSet(executionResult);
            return new ResultContext(resultSet);
        }
        if (ExecutionResultType.ERROR_RESULT_SET == executionResult.getType()) {
            IErrorResult iErrorResult = (IErrorResult)executionResult.getResult();
            return new ResultContext(iErrorResult, true);
        }
        IErrorResult iErrorResult = (IErrorResult)executionResult.getResult();
        return new ResultContext(iErrorResult, false);
    }

    @Override
    protected void doCancel() throws ErrorException {
        IQueryExecutor iQueryExecutor = this.m_queryExecutor;
        if (null != iQueryExecutor) {
            iQueryExecutor.cancelExecute();
        }
    }

    @Override
    protected void doClose() {
        this.replaceQueryExecutor(null, null);
        this.m_parentConnection = null;
    }

    @Override
    protected List<ResultContext> getResultsets() {
        return this.m_resultSets;
    }

    protected static ThrowCondition GetConditionForAfterExecute(long l, boolean bl) {
        return ThrowCondition.fromBaseThrowCondition(SStatement.GetThrowConditionForAfterExecute(l, bl));
    }

    protected static ThrowCondition GetConditionForAfterPrepare(long l, boolean bl) {
        return ThrowCondition.fromBaseThrowCondition(SStatement.GetThrowConditionForAfterPrepare(l, bl));
    }

    @Override
    protected boolean hasNextResult() {
        return this.m_resultIterator != null && this.m_resultIterator.hasNext();
    }

    @Override
    protected Iterator<ExecutionResult> getResultsIterator() throws ErrorException {
        return this.m_resultIterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void executeAnyBatch() throws SQLException, BatchUpdateException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            Object object = this.m_cancelLock;
            synchronized (object) {
                this.m_isInCancelableFunction = true;
            }
            this.m_parentConnection.beginTransaction();
            object = this.m_statement.createDataEngine();
            object.setDirectExecute();
            object.setMetadataNeeded(false);
            this.m_warningListener.clearAndSetFunction(FunctionID.STATEMENT_PREPARE);
            this.replaceQueryExecutor((IDataEngine)object, object.prepareBatch(this.getBatchSqlStatements()));
            ArrayList<ArrayList<ParameterInputValue>> arrayList = new ArrayList<ArrayList<ParameterInputValue>>();
            ArrayList<ParameterMetadata> arrayList2 = new ArrayList<ParameterMetadata>();
            arrayList.add(new ArrayList());
            ExecutionContexts executionContexts = new ExecutionContexts(arrayList2, arrayList);
            this.clearResults();
            Object object2 = this.m_cancelLock;
            synchronized (object2) {
                if (this.m_isCanceled) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.OPERATION_CANCELED, (IWarningListener)this.m_warningListener, ExceptionType.TRANSIENT, new Object[0]);
                }
            }
            this.m_warningListener.setCurrentFunction(FunctionID.STATEMENT_EXECUTE);
            this.m_queryExecutor.execute(executionContexts, this.m_warningListener);
            this.m_resultIterator = this.m_queryExecutor.getResults().getResultItr();
        }
        catch (Exception exception) {
            try {
                this.replaceQueryExecutor(null, null);
            }
            catch (Exception exception2) {
                LogUtilities.logError(exception2, this.m_logger);
            }
            finally {
                throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
            }
        }
        finally {
            this.clearBatchSqlStatements();
            Object object = this.m_cancelLock;
            synchronized (object) {
                this.m_isCanceled = false;
                this.m_isInCancelableFunction = false;
            }
        }
    }

    @Override
    public SConnection getParentConnection() {
        return this.m_parentConnection;
    }

    public IQueryExecutor getQueryExecutor() {
        return this.m_queryExecutor;
    }

    @Override
    protected void doClearResults() {
        if (null != this.m_resultIterator) {
            while (this.m_resultIterator.hasNext()) {
                ExecutionResult executionResult = this.m_resultIterator.next();
                if (ExecutionResultType.RESULT_SET == executionResult.getType()) {
                    ((IResultSet)executionResult.getResult()).close();
                }
                executionResult.getGeneratedResult().close();
            }
            this.m_resultIterator = null;
        }
    }

    @Override
    protected ExecutionResult getNextResult() throws SQLException {
        return this.m_resultIterator.next();
    }

    protected void executeNoParams(String string, ParameterGeneratedValues parameterGeneratedValues, ThrowCondition throwCondition) throws SQLException {
        this.executeNoParams(string, parameterGeneratedValues, throwCondition.toBaseThrowCondition());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void executeNoParams(String string, ParameterGeneratedValues parameterGeneratedValues, BaseStatement.BaseThrowCondition baseThrowCondition) throws SQLException {
        try {
            Object object = this.m_cancelLock;
            synchronized (object) {
                this.m_isInCancelableFunction = true;
            }
            this.m_parentConnection.beginTransaction();
            object = this.m_statement.createDataEngine();
            object.setDirectExecute();
            if (BaseStatement.BaseThrowCondition.None == baseThrowCondition) {
                object.setMetadataNeeded(false);
            }
            this.m_warningListener.clearAndSetFunction(FunctionID.STATEMENT_PREPARE);
            if (this.m_escapeProcessingEnabled && DSIDriverSingleton.getInstance().getProperty(10).getInt() == 1) {
                string = this.m_parentConnection.nativeSQL(string);
            }
            this.replaceQueryExecutor((IDataEngine)object, object.prepare(string));
            if (this.m_queryExecutor.getNumParams() != 0) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_PARAM, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            }
            this.checkCondition(string, baseThrowCondition);
            ArrayList<ArrayList<ParameterInputValue>> arrayList = new ArrayList<ArrayList<ParameterInputValue>>();
            ArrayList<ParameterMetadata> arrayList2 = new ArrayList<ParameterMetadata>();
            arrayList.add(new ArrayList());
            ExecutionContexts executionContexts = new ExecutionContexts(arrayList2, arrayList, parameterGeneratedValues);
            Object object2 = this.m_cancelLock;
            synchronized (object2) {
                if (this.m_isCanceled) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.OPERATION_CANCELED, (IWarningListener)this.m_warningListener, ExceptionType.TRANSIENT, new Object[0]);
                }
            }
            this.m_warningListener.setCurrentFunction(FunctionID.STATEMENT_EXECUTE);
            this.m_queryExecutor.execute(executionContexts, this.m_warningListener);
            this.m_resultIterator = this.m_queryExecutor.getResults().getResultItr();
        }
        catch (Exception exception) {
            try {
                this.replaceQueryExecutor(null, null);
            }
            catch (Exception exception2) {
                LogUtilities.logError(exception2, this.m_logger);
            }
            finally {
                throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
            }
        }
        finally {
            Object object = this.m_cancelLock;
            synchronized (object) {
                this.m_isInCancelableFunction = false;
            }
        }
    }

    protected int[] processBatchResults(IResults iResults, List<Pair<Integer, SQLException>> list, BatchType batchType) throws ErrorException, SQLException {
        return this.processBatchResults(iResults.getResultItr(), list, batchType.toBaseBatchType());
    }

    @Deprecated
    protected int[] processBatchResults(IResults iResults) throws ErrorException, SQLException {
        return this.processBatchResults(iResults, Collections.emptyList());
    }

    @Deprecated
    protected int[] processBatchResults(IResults iResults, List<Pair<Integer, SQLException>> list) throws ErrorException, SQLException {
        return this.processBatchResults(iResults, list, BatchType.UNKNOWN);
    }

    @Deprecated
    protected long[] processLargeBatchResults(IResults iResults) throws ErrorException, SQLException {
        return this.processLargeBatchResults(iResults, Collections.emptyList());
    }

    @Deprecated
    protected long[] processLargeBatchResults(IResults iResults, List<Pair<Integer, SQLException>> list) throws ErrorException, SQLException {
        return this.processLargeBatchResults(iResults, list, BatchType.UNKNOWN);
    }

    protected long[] processLargeBatchResults(IResults iResults, List<Pair<Integer, SQLException>> list, BatchType batchType) throws ErrorException, SQLException {
        return this.processLargeBatchResults(iResults.getResultItr(), list, batchType.toBaseBatchType());
    }

    protected void replaceQueryExecutor(IDataEngine iDataEngine, IQueryExecutor iQueryExecutor) {
        IQueryExecutor iQueryExecutor2 = this.m_queryExecutor;
        if (iQueryExecutor2 != null) {
            iQueryExecutor2.close();
        }
        this.m_queryExecutor = iQueryExecutor;
        IDataEngine iDataEngine2 = this.m_dataEngine;
        if (iDataEngine2 != null) {
            iDataEngine2.close();
        }
        this.m_dataEngine = iDataEngine;
    }

    protected static enum ThrowCondition {
        None(BaseStatement.BaseThrowCondition.None),
        SingleResult(BaseStatement.BaseThrowCondition.SingleResult),
        SingleRowCount(BaseStatement.BaseThrowCondition.SingleRowCount),
        FirstResult(BaseStatement.BaseThrowCondition.FirstResult),
        FirstRowCount(BaseStatement.BaseThrowCondition.FirstRowCount);

        private final BaseStatement.BaseThrowCondition m_associatedBaseThrowCondition;

        public BaseStatement.BaseThrowCondition toBaseThrowCondition() {
            return this.m_associatedBaseThrowCondition;
        }

        public static ThrowCondition fromBaseThrowCondition(BaseStatement.BaseThrowCondition baseThrowCondition) {
            switch (baseThrowCondition) {
                case None: {
                    return None;
                }
                case SingleResult: {
                    return SingleResult;
                }
                case SingleRowCount: {
                    return SingleRowCount;
                }
                case FirstResult: {
                    return FirstResult;
                }
                case FirstRowCount: {
                    return FirstRowCount;
                }
            }
            return null;
        }

        private ThrowCondition(BaseStatement.BaseThrowCondition baseThrowCondition) {
            this.m_associatedBaseThrowCondition = baseThrowCondition;
        }
    }

    public static enum BatchType {
        MULTI_STATEMENT(BaseStatement.BaseBatchType.MULTI_STATEMENT),
        MULTI_PARAM_SET(BaseStatement.BaseBatchType.MULTI_PARAM_SET),
        UNKNOWN(BaseStatement.BaseBatchType.UNKNOWN);

        private final BaseStatement.BaseBatchType m_associatedBaseBatchType;

        public BaseStatement.BaseBatchType toBaseBatchType() {
            return this.m_associatedBaseBatchType;
        }

        private BatchType(BaseStatement.BaseBatchType baseBatchType) {
            this.m_associatedBaseBatchType = baseBatchType;
        }
    }

    protected static class ResultContext
    extends BaseStatement.BaseResultContext {
        ResultContext(IRowCountResult iRowCountResult) {
            super(iRowCountResult);
        }

        ResultContext(ResultSet resultSet) {
            super(resultSet);
        }

        ResultContext(IErrorResult iErrorResult, boolean bl) {
            super(iErrorResult, bl);
        }
    }
}

