/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.jdbc.jdbc42;

import com.simba.googlebigquery.dsi.core.interfaces.IStatement;
import com.simba.googlebigquery.dsi.core.utilities.Variant;
import com.simba.googlebigquery.dsi.dataengine.interfaces.IResultSet;
import com.simba.googlebigquery.exceptions.ExceptionConverter;
import com.simba.googlebigquery.exceptions.JDBCMessageKey;
import com.simba.googlebigquery.jdbc.common.SConnection;
import com.simba.googlebigquery.jdbc.common.SForwardResultSet;
import com.simba.googlebigquery.jdbc.common.SStatement;
import com.simba.googlebigquery.jdbc.jdbc41.S41Statement;
import com.simba.googlebigquery.jdbc.jdbc42.S42ForwardResultSet;
import com.simba.googlebigquery.jdbc.jdbc42.S42UpdatableForwardResultSet;
import com.simba.googlebigquery.support.IWarningListener;
import com.simba.googlebigquery.support.LogUtilities;
import com.simba.googlebigquery.support.exceptions.ExceptionType;
import com.simba.googlebigquery.utilities.JDBCVersion;
import java.sql.BatchUpdateException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;

public class S42Statement
extends S41Statement {
    private long m_longTotal = Long.MAX_VALUE;

    public S42Statement(IStatement iStatement, SConnection sConnection, int n) throws SQLException {
        super(iStatement, sConnection, n);
        this.m_jdbcVersion = JDBCVersion.JDBC42;
    }

    @Override
    protected ResultSet createResultSet(IResultSet iResultSet, boolean bl, int n) throws SQLException {
        SForwardResultSet sForwardResultSet = bl ? new S42UpdatableForwardResultSet(this, iResultSet, this.getLogger()) : new S42ForwardResultSet(this, iResultSet, this.getLogger());
        sForwardResultSet.setFetchSize(n);
        return sForwardResultSet;
    }

    @Override
    public synchronized long[] executeLargeBatch() throws SQLException, BatchUpdateException {
        try {
            this.executeAnyBatch();
            return this.processLargeBatchResults(this.m_queryExecutor.getResults(), Collections.emptyList(), SStatement.BatchType.MULTI_STATEMENT);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    protected static BatchUpdateException largeBatchException(List<SQLException> list, long[] lArray) {
        return SStatement.largeBatchException(list, lArray);
    }

    @Override
    public synchronized long executeLargeUpdate(String string) throws SQLException {
        try {
            return this.executeAnyUpdate(string);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized long executeLargeUpdate(String string, int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, n);
            this.checkIfOpen();
            if (n == 2 || !S42Statement.isInsertStatement(string)) {
                return this.executeLargeUpdate(string);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized long executeLargeUpdate(String string, int[] nArray) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, nArray);
            this.checkIfOpen();
            if (!S42Statement.isInsertStatement(string)) {
                return this.executeLargeUpdate(string);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized long executeLargeUpdate(String string, String[] stringArray) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, stringArray);
            this.checkIfOpen();
            if (!S42Statement.isInsertStatement(string)) {
                return this.executeLargeUpdate(string);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized long getLargeMaxRows() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            Variant variant = this.m_statement.getProperty(2);
            long l = variant.getLong();
            if (Long.MAX_VALUE < l || Long.MIN_VALUE > l) {
                return 0L;
            }
            return l;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized long getLargeUpdateCount() throws SQLException {
        return this.getAnyUpdateCount();
    }

    @Override
    public synchronized void setLargeMaxRows(long l) throws SQLException {
        this.setAnyMaxRows(l);
    }
}

