/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core;

import com.amazon.redshift.core.IamHelper;
import com.amazon.redshift.core.RedshiftJDBCSettings;
import com.amazon.redshift.logger.RedshiftLogger;
import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.redshiftarcadiainternal.RedshiftArcadiaInternalClient;
import com.amazonaws.services.redshiftarcadiainternal.RedshiftArcadiaInternalClientBuilder;
import com.amazonaws.services.redshiftarcadiainternal.model.DescribeConfigurationRequest;
import com.amazonaws.services.redshiftarcadiainternal.model.DescribeConfigurationResult;
import com.amazonaws.services.redshiftarcadiainternal.model.Endpoint;
import com.amazonaws.services.redshiftarcadiainternal.model.GetCredentialsRequest;
import com.amazonaws.services.redshiftarcadiainternal.model.GetCredentialsResult;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public final class ServerlessIamHelper {
    private RedshiftLogger log;
    private RedshiftArcadiaInternalClient client;
    private static Map<String, GetCredentialsResult> credentialsCache = new HashMap<String, GetCredentialsResult>();

    ServerlessIamHelper(RedshiftJDBCSettings settings, RedshiftLogger log, AWSCredentialsProvider credProvider) {
        this.log = log;
        RedshiftArcadiaInternalClientBuilder builder = RedshiftArcadiaInternalClientBuilder.standard();
        builder = (RedshiftArcadiaInternalClientBuilder)IamHelper.setBuilderConfiguration(settings, log, (AwsClientBuilder)builder);
        this.client = (RedshiftArcadiaInternalClient)((RedshiftArcadiaInternalClientBuilder)builder.withCredentials(credProvider)).build();
    }

    synchronized void describeConfiguration(RedshiftJDBCSettings settings) {
        DescribeConfigurationRequest req = new DescribeConfigurationRequest();
        DescribeConfigurationResult resp = this.client.describeConfiguration(req);
        Endpoint endpoint = resp.getEndpoint();
        if (null == endpoint) {
            throw new AmazonClientException("Serverless endpoint is not available yet.");
        }
        settings.m_host = endpoint.getAddress();
        settings.m_port = endpoint.getPort();
    }

    synchronized void getCredentialsResult(RedshiftJDBCSettings settings, IamHelper.CredentialProviderType providerType, boolean idpCredentialsRefresh) throws AmazonClientException {
        String key = null;
        GetCredentialsResult credentials = null;
        if (!settings.m_iamDisableCache) {
            key = IamHelper.getCredentialsCacheKey(settings, providerType, true);
            credentials = credentialsCache.get(key);
        }
        if (credentials == null || providerType == IamHelper.CredentialProviderType.PLUGIN && idpCredentialsRefresh || credentials.getExpiration().before(new Date(System.currentTimeMillis() - 300000L))) {
            if (RedshiftLogger.isEnable()) {
                this.log.logInfo("GetCredentials NOT from cache", new Object[0]);
            }
            if (!settings.m_iamDisableCache) {
                credentialsCache.remove(key);
            }
            GetCredentialsRequest request = new GetCredentialsRequest();
            if (settings.m_iamDuration > 0) {
                request.setDurationSeconds(Integer.valueOf(settings.m_iamDuration));
            }
            request.setDbName(settings.m_Schema);
            if (RedshiftLogger.isEnable()) {
                this.log.logInfo(request.toString(), new Object[0]);
            }
            for (int i = 0; i < 5; ++i) {
                try {
                    credentials = this.client.getCredentials(request);
                    break;
                }
                catch (AmazonClientException ace) {
                    IamHelper.checkForApiCallRateExceedError(ace, i, "getCredentialsResult", this.log);
                    continue;
                }
            }
            if (!settings.m_iamDisableCache) {
                credentialsCache.put(key, credentials);
            }
        } else if (RedshiftLogger.isEnable()) {
            this.log.logInfo("GetCredentials from cache", new Object[0]);
        }
        settings.m_username = credentials.getDbUser();
        settings.m_password = credentials.getDbPassword();
        if (RedshiftLogger.isEnable()) {
            Date now = new Date();
            this.log.logInfo(now + ": Using GetCredentialsResult with expiration " + credentials.getExpiration(), new Object[0]);
            this.log.logInfo(now + ": Using GetCredentialsResultV2 with TimeToRefresh " + credentials.getNextRefreshTime(), new Object[0]);
        }
    }
}

