# Generated by Django 3.2.9 on 2021-12-27 15:14

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="Customer",
            fields=[
                (
                    "customer_id",
                    models.CharField(max_length=64, primary_key=True, serialize=False),
                ),
                (
                    "user",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="customer",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Subscription",
            fields=[
                (
                    "appname",
                    models.CharField(
                        choices=[
                            ("ACCOUNTS", "Accounts"),
                            ("DRAGONFLY", "Dragonfly"),
                            ("INTELOWL", "Intelowl"),
                        ],
                        max_length=32,
                    ),
                ),
                (
                    "subscription_id",
                    models.CharField(max_length=64, primary_key=True, serialize=False),
                ),
                (
                    "customer",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="subscriptions",
                        to="certego_saas_payments.customer",
                    ),
                ),
            ],
            options={
                "unique_together": {("customer", "appname")},
            },
        ),
    ]
