# This file is part of Tryton.  The COPYRIGHT file at the top level of
# this repository contains the full copyright notices and license terms.
import doctest
import os
import unittest

from trytond.tests.test_tryton import ModuleTestCase
from trytond.tests.test_tryton import suite as test_suite
from trytond.tests.test_tryton import doctest_teardown
from trytond.tests.test_tryton import doctest_checker


class AccountPaymentStripeTestCase(ModuleTestCase):
    'Test Account Payment Stripe module'
    module = 'account_payment_stripe'


def suite():
    suite = test_suite()
    suite.addTests(unittest.TestLoader().loadTestsFromTestCase(
            AccountPaymentStripeTestCase))
    if (os.getenv('STRIPE_SECRET_KEY')
            and os.getenv('STRIPE_PUBLISHABLE_KEY')):
        suite.addTests(doctest.DocFileSuite(
                'scenario_account_payment_stripe.rst',
                tearDown=doctest_teardown, encoding='utf-8',
                checker=doctest_checker,
                optionflags=doctest.REPORT_ONLY_FIRST_FAILURE))
        suite.addTests(doctest.DocFileSuite(
                'scenario_account_payment_stripe_dispute.rst',
                tearDown=doctest_teardown, encoding='utf-8',
                checker=doctest_checker,
                optionflags=doctest.REPORT_ONLY_FIRST_FAILURE))
    return suite
