# The COPYRIGHT file at the top level of this repository contains
# the full copyright notices and license terms.
import unittest
import doctest

from trytond.tests.test_tryton import ModuleTestCase
from trytond.tests.test_tryton import suite as test_suite
from trytond.tests.test_tryton import doctest_teardown, doctest_checker

import interlude

class SaleKitTestCase(ModuleTestCase):
    'Test Sale Kit module'
    module = 'sale_kit'
    extras = ['purchase']


def suite():
    suite = test_suite()
    #suite.addTests(unittest.TestLoader().loadTestsFromTestCase(
    #        SaleKitTestCase))
    suite.addTests(doctest.DocFileSuite('scenario_sale_kit.rst',
            tearDown=doctest_teardown, encoding='utf-8',
            optionflags=doctest.REPORT_ONLY_FIRST_FAILURE,
            checker=doctest_checker,
            globs=dict(interact=interlude.interact)))
    return suite
