# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("d3d12.dll")
prototypes = \
    {
        # 
        'D3D12SerializeRootSignature': SimTypeFunction([SimTypePointer(SimStruct({"NumParameters": SimTypeInt(signed=False, label="UInt32"), "pParameters": SimTypePointer(SimStruct({"ParameterType": SimTypeInt(signed=False, label="D3D12_ROOT_PARAMETER_TYPE"), "Anonymous": SimUnion({"DescriptorTable": SimStruct({"NumDescriptorRanges": SimTypeInt(signed=False, label="UInt32"), "pDescriptorRanges": SimTypePointer(SimStruct({"RangeType": SimTypeInt(signed=False, label="D3D12_DESCRIPTOR_RANGE_TYPE"), "NumDescriptors": SimTypeInt(signed=False, label="UInt32"), "BaseShaderRegister": SimTypeInt(signed=False, label="UInt32"), "RegisterSpace": SimTypeInt(signed=False, label="UInt32"), "OffsetInDescriptorsFromTableStart": SimTypeInt(signed=False, label="UInt32")}, name="D3D12_DESCRIPTOR_RANGE", pack=False, align=None), offset=0)}, name="D3D12_ROOT_DESCRIPTOR_TABLE", pack=False, align=None), "Constants": SimStruct({"ShaderRegister": SimTypeInt(signed=False, label="UInt32"), "RegisterSpace": SimTypeInt(signed=False, label="UInt32"), "Num32BitValues": SimTypeInt(signed=False, label="UInt32")}, name="D3D12_ROOT_CONSTANTS", pack=False, align=None), "Descriptor": SimStruct({"ShaderRegister": SimTypeInt(signed=False, label="UInt32"), "RegisterSpace": SimTypeInt(signed=False, label="UInt32")}, name="D3D12_ROOT_DESCRIPTOR", pack=False, align=None)}, name="<anon>", label="None"), "ShaderVisibility": SimTypeInt(signed=False, label="D3D12_SHADER_VISIBILITY")}, name="D3D12_ROOT_PARAMETER", pack=False, align=None), offset=0), "NumStaticSamplers": SimTypeInt(signed=False, label="UInt32"), "pStaticSamplers": SimTypePointer(SimStruct({"Filter": SimTypeInt(signed=False, label="D3D12_FILTER"), "AddressU": SimTypeInt(signed=False, label="D3D12_TEXTURE_ADDRESS_MODE"), "AddressV": SimTypeInt(signed=False, label="D3D12_TEXTURE_ADDRESS_MODE"), "AddressW": SimTypeInt(signed=False, label="D3D12_TEXTURE_ADDRESS_MODE"), "MipLODBias": SimTypeFloat(size=32), "MaxAnisotropy": SimTypeInt(signed=False, label="UInt32"), "ComparisonFunc": SimTypeInt(signed=False, label="D3D12_COMPARISON_FUNC"), "BorderColor": SimTypeInt(signed=False, label="D3D12_STATIC_BORDER_COLOR"), "MinLOD": SimTypeFloat(size=32), "MaxLOD": SimTypeFloat(size=32), "ShaderRegister": SimTypeInt(signed=False, label="UInt32"), "RegisterSpace": SimTypeInt(signed=False, label="UInt32"), "ShaderVisibility": SimTypeInt(signed=False, label="D3D12_SHADER_VISIBILITY")}, name="D3D12_STATIC_SAMPLER_DESC", pack=False, align=None), offset=0), "Flags": SimTypeInt(signed=False, label="D3D12_ROOT_SIGNATURE_FLAGS")}, name="D3D12_ROOT_SIGNATURE_DESC", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="D3D_ROOT_SIGNATURE_VERSION"), SimTypePointer(SimTypeBottom(label="ID3DBlob"), offset=0), SimTypePointer(SimTypeBottom(label="ID3DBlob"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pRootSignature", "Version", "ppBlob", "ppErrorBlob"]),
        # 
        'D3D12CreateRootSignatureDeserializer': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSrcData", "SrcDataSizeInBytes", "pRootSignatureDeserializerInterface", "ppRootSignatureDeserializer"]),
        # 
        'D3D12SerializeVersionedRootSignature': SimTypeFunction([SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="D3D_ROOT_SIGNATURE_VERSION"), "Anonymous": SimUnion({"Desc_1_0": SimStruct({"NumParameters": SimTypeInt(signed=False, label="UInt32"), "pParameters": SimTypePointer(SimStruct({"ParameterType": SimTypeInt(signed=False, label="D3D12_ROOT_PARAMETER_TYPE"), "Anonymous": SimUnion({"DescriptorTable": SimStruct({"NumDescriptorRanges": SimTypeInt(signed=False, label="UInt32"), "pDescriptorRanges": SimTypePointer(SimStruct({"RangeType": SimTypeInt(signed=False, label="D3D12_DESCRIPTOR_RANGE_TYPE"), "NumDescriptors": SimTypeInt(signed=False, label="UInt32"), "BaseShaderRegister": SimTypeInt(signed=False, label="UInt32"), "RegisterSpace": SimTypeInt(signed=False, label="UInt32"), "OffsetInDescriptorsFromTableStart": SimTypeInt(signed=False, label="UInt32")}, name="D3D12_DESCRIPTOR_RANGE", pack=False, align=None), offset=0)}, name="D3D12_ROOT_DESCRIPTOR_TABLE", pack=False, align=None), "Constants": SimStruct({"ShaderRegister": SimTypeInt(signed=False, label="UInt32"), "RegisterSpace": SimTypeInt(signed=False, label="UInt32"), "Num32BitValues": SimTypeInt(signed=False, label="UInt32")}, name="D3D12_ROOT_CONSTANTS", pack=False, align=None), "Descriptor": SimStruct({"ShaderRegister": SimTypeInt(signed=False, label="UInt32"), "RegisterSpace": SimTypeInt(signed=False, label="UInt32")}, name="D3D12_ROOT_DESCRIPTOR", pack=False, align=None)}, name="<anon>", label="None"), "ShaderVisibility": SimTypeInt(signed=False, label="D3D12_SHADER_VISIBILITY")}, name="D3D12_ROOT_PARAMETER", pack=False, align=None), offset=0), "NumStaticSamplers": SimTypeInt(signed=False, label="UInt32"), "pStaticSamplers": SimTypePointer(SimStruct({"Filter": SimTypeInt(signed=False, label="D3D12_FILTER"), "AddressU": SimTypeInt(signed=False, label="D3D12_TEXTURE_ADDRESS_MODE"), "AddressV": SimTypeInt(signed=False, label="D3D12_TEXTURE_ADDRESS_MODE"), "AddressW": SimTypeInt(signed=False, label="D3D12_TEXTURE_ADDRESS_MODE"), "MipLODBias": SimTypeFloat(size=32), "MaxAnisotropy": SimTypeInt(signed=False, label="UInt32"), "ComparisonFunc": SimTypeInt(signed=False, label="D3D12_COMPARISON_FUNC"), "BorderColor": SimTypeInt(signed=False, label="D3D12_STATIC_BORDER_COLOR"), "MinLOD": SimTypeFloat(size=32), "MaxLOD": SimTypeFloat(size=32), "ShaderRegister": SimTypeInt(signed=False, label="UInt32"), "RegisterSpace": SimTypeInt(signed=False, label="UInt32"), "ShaderVisibility": SimTypeInt(signed=False, label="D3D12_SHADER_VISIBILITY")}, name="D3D12_STATIC_SAMPLER_DESC", pack=False, align=None), offset=0), "Flags": SimTypeInt(signed=False, label="D3D12_ROOT_SIGNATURE_FLAGS")}, name="D3D12_ROOT_SIGNATURE_DESC", pack=False, align=None), "Desc_1_1": SimStruct({"NumParameters": SimTypeInt(signed=False, label="UInt32"), "pParameters": SimTypePointer(SimStruct({"ParameterType": SimTypeInt(signed=False, label="D3D12_ROOT_PARAMETER_TYPE"), "Anonymous": SimUnion({"DescriptorTable": SimStruct({"NumDescriptorRanges": SimTypeInt(signed=False, label="UInt32"), "pDescriptorRanges": SimTypePointer(SimStruct({"RangeType": SimTypeInt(signed=False, label="D3D12_DESCRIPTOR_RANGE_TYPE"), "NumDescriptors": SimTypeInt(signed=False, label="UInt32"), "BaseShaderRegister": SimTypeInt(signed=False, label="UInt32"), "RegisterSpace": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="D3D12_DESCRIPTOR_RANGE_FLAGS"), "OffsetInDescriptorsFromTableStart": SimTypeInt(signed=False, label="UInt32")}, name="D3D12_DESCRIPTOR_RANGE1", pack=False, align=None), offset=0)}, name="D3D12_ROOT_DESCRIPTOR_TABLE1", pack=False, align=None), "Constants": SimStruct({"ShaderRegister": SimTypeInt(signed=False, label="UInt32"), "RegisterSpace": SimTypeInt(signed=False, label="UInt32"), "Num32BitValues": SimTypeInt(signed=False, label="UInt32")}, name="D3D12_ROOT_CONSTANTS", pack=False, align=None), "Descriptor": SimStruct({"ShaderRegister": SimTypeInt(signed=False, label="UInt32"), "RegisterSpace": SimTypeInt(signed=False, label="UInt32"), "Flags": SimTypeInt(signed=False, label="D3D12_ROOT_DESCRIPTOR_FLAGS")}, name="D3D12_ROOT_DESCRIPTOR1", pack=False, align=None)}, name="<anon>", label="None"), "ShaderVisibility": SimTypeInt(signed=False, label="D3D12_SHADER_VISIBILITY")}, name="D3D12_ROOT_PARAMETER1", pack=False, align=None), offset=0), "NumStaticSamplers": SimTypeInt(signed=False, label="UInt32"), "pStaticSamplers": SimTypePointer(SimStruct({"Filter": SimTypeInt(signed=False, label="D3D12_FILTER"), "AddressU": SimTypeInt(signed=False, label="D3D12_TEXTURE_ADDRESS_MODE"), "AddressV": SimTypeInt(signed=False, label="D3D12_TEXTURE_ADDRESS_MODE"), "AddressW": SimTypeInt(signed=False, label="D3D12_TEXTURE_ADDRESS_MODE"), "MipLODBias": SimTypeFloat(size=32), "MaxAnisotropy": SimTypeInt(signed=False, label="UInt32"), "ComparisonFunc": SimTypeInt(signed=False, label="D3D12_COMPARISON_FUNC"), "BorderColor": SimTypeInt(signed=False, label="D3D12_STATIC_BORDER_COLOR"), "MinLOD": SimTypeFloat(size=32), "MaxLOD": SimTypeFloat(size=32), "ShaderRegister": SimTypeInt(signed=False, label="UInt32"), "RegisterSpace": SimTypeInt(signed=False, label="UInt32"), "ShaderVisibility": SimTypeInt(signed=False, label="D3D12_SHADER_VISIBILITY")}, name="D3D12_STATIC_SAMPLER_DESC", pack=False, align=None), offset=0), "Flags": SimTypeInt(signed=False, label="D3D12_ROOT_SIGNATURE_FLAGS")}, name="D3D12_ROOT_SIGNATURE_DESC1", pack=False, align=None)}, name="<anon>", label="None")}, name="D3D12_VERSIONED_ROOT_SIGNATURE_DESC", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="ID3DBlob"), offset=0), SimTypePointer(SimTypeBottom(label="ID3DBlob"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pRootSignature", "ppBlob", "ppErrorBlob"]),
        # 
        'D3D12CreateVersionedRootSignatureDeserializer': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pSrcData", "SrcDataSizeInBytes", "pRootSignatureDeserializerInterface", "ppRootSignatureDeserializer"]),
        # 
        'D3D12CreateDevice': SimTypeFunction([SimTypeBottom(label="IUnknown"), SimTypeInt(signed=False, label="D3D_FEATURE_LEVEL"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pAdapter", "MinimumFeatureLevel", "riid", "ppDevice"]),
        # 
        'D3D12GetDebugInterface': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["riid", "ppvDebug"]),
        # 
        'D3D12EnableExperimentalFeatures': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Guid"), label="LPArray", offset=0), SimTypePointer(SimTypeBottom(label="Void"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), label="LPArray", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["NumFeatures", "pIIDs", "pConfigurationStructs", "pConfigurationStructSizes"]),
    }

lib.set_prototypes(prototypes)
