# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("iscsidsc.dll")
prototypes = \
    {
        # 
        'GetIScsiVersionInformation': SimTypeFunction([SimTypePointer(SimStruct({"MajorVersion": SimTypeInt(signed=False, label="UInt32"), "MinorVersion": SimTypeInt(signed=False, label="UInt32"), "BuildNumber": SimTypeInt(signed=False, label="UInt32")}, name="ISCSI_VERSION_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["VersionInfo"]),
        # 
        'GetIScsiTargetInformationW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="TARGET_INFORMATION_CLASS"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["TargetName", "DiscoveryMechanism", "InfoClass", "BufferSize", "Buffer"]),
        # 
        'GetIScsiTargetInformationA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="TARGET_INFORMATION_CLASS"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["TargetName", "DiscoveryMechanism", "InfoClass", "BufferSize", "Buffer"]),
        # 
        'AddIScsiConnectionW': SimTypeFunction([SimTypePointer(SimStruct({"AdapterUnique": SimTypeLongLong(signed=False, label="UInt64"), "AdapterSpecific": SimTypeLongLong(signed=False, label="UInt64")}, name="ISCSI_UNIQUE_SESSION_ID", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"SymbolicName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256), "Socket": SimTypeShort(signed=False, label="UInt16")}, name="ISCSI_TARGET_PORTALW", pack=False, align=None), offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "InformationSpecified": SimTypeInt(signed=False, label="UInt32"), "LoginFlags": SimTypeInt(signed=False, label="UInt32"), "AuthType": SimTypeInt(signed=False, label="ISCSI_AUTH_TYPES"), "HeaderDigest": SimTypeInt(signed=False, label="ISCSI_DIGEST_TYPES"), "DataDigest": SimTypeInt(signed=False, label="ISCSI_DIGEST_TYPES"), "MaximumConnections": SimTypeInt(signed=False, label="UInt32"), "DefaultTime2Wait": SimTypeInt(signed=False, label="UInt32"), "DefaultTime2Retain": SimTypeInt(signed=False, label="UInt32"), "UsernameLength": SimTypeInt(signed=False, label="UInt32"), "PasswordLength": SimTypeInt(signed=False, label="UInt32"), "Username": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Password": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="ISCSI_LOGIN_OPTIONS", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimStruct({"AdapterUnique": SimTypeLongLong(signed=False, label="UInt64"), "AdapterSpecific": SimTypeLongLong(signed=False, label="UInt64")}, name="ISCSI_UNIQUE_SESSION_ID", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["UniqueSessionId", "Reserved", "InitiatorPortNumber", "TargetPortal", "SecurityFlags", "LoginOptions", "KeySize", "Key", "ConnectionId"]),
        # 
        'AddIScsiConnectionA': SimTypeFunction([SimTypePointer(SimStruct({"AdapterUnique": SimTypeLongLong(signed=False, label="UInt64"), "AdapterSpecific": SimTypeLongLong(signed=False, label="UInt64")}, name="ISCSI_UNIQUE_SESSION_ID", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"SymbolicName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256), "Address": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256), "Socket": SimTypeShort(signed=False, label="UInt16")}, name="ISCSI_TARGET_PORTALA", pack=False, align=None), offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "InformationSpecified": SimTypeInt(signed=False, label="UInt32"), "LoginFlags": SimTypeInt(signed=False, label="UInt32"), "AuthType": SimTypeInt(signed=False, label="ISCSI_AUTH_TYPES"), "HeaderDigest": SimTypeInt(signed=False, label="ISCSI_DIGEST_TYPES"), "DataDigest": SimTypeInt(signed=False, label="ISCSI_DIGEST_TYPES"), "MaximumConnections": SimTypeInt(signed=False, label="UInt32"), "DefaultTime2Wait": SimTypeInt(signed=False, label="UInt32"), "DefaultTime2Retain": SimTypeInt(signed=False, label="UInt32"), "UsernameLength": SimTypeInt(signed=False, label="UInt32"), "PasswordLength": SimTypeInt(signed=False, label="UInt32"), "Username": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Password": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="ISCSI_LOGIN_OPTIONS", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimStruct({"AdapterUnique": SimTypeLongLong(signed=False, label="UInt64"), "AdapterSpecific": SimTypeLongLong(signed=False, label="UInt64")}, name="ISCSI_UNIQUE_SESSION_ID", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["UniqueSessionId", "Reserved", "InitiatorPortNumber", "TargetPortal", "SecurityFlags", "LoginOptions", "KeySize", "Key", "ConnectionId"]),
        # 
        'RemoveIScsiConnection': SimTypeFunction([SimTypePointer(SimStruct({"AdapterUnique": SimTypeLongLong(signed=False, label="UInt64"), "AdapterSpecific": SimTypeLongLong(signed=False, label="UInt64")}, name="ISCSI_UNIQUE_SESSION_ID", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"AdapterUnique": SimTypeLongLong(signed=False, label="UInt64"), "AdapterSpecific": SimTypeLongLong(signed=False, label="UInt64")}, name="ISCSI_UNIQUE_SESSION_ID", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["UniqueSessionId", "ConnectionId"]),
        # 
        'ReportIScsiTargetsW': SimTypeFunction([SimTypeChar(label="Byte"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ForceUpdate", "BufferSize", "Buffer"]),
        # 
        'ReportIScsiTargetsA': SimTypeFunction([SimTypeChar(label="Byte"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ForceUpdate", "BufferSize", "Buffer"]),
        # 
        'AddIScsiStaticTargetW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeChar(label="Byte"), SimTypePointer(SimStruct({"InitiatorName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256), "TargetName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 224), "OSDeviceName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 260), "SessionId": SimStruct({"AdapterUnique": SimTypeLongLong(signed=False, label="UInt64"), "AdapterSpecific": SimTypeLongLong(signed=False, label="UInt64")}, name="ISCSI_UNIQUE_SESSION_ID", pack=False, align=None), "OSBusNumber": SimTypeInt(signed=False, label="UInt32"), "OSTargetNumber": SimTypeInt(signed=False, label="UInt32"), "LUNCount": SimTypeInt(signed=False, label="UInt32"), "LUNList": SimTypePointer(SimStruct({"OSLUN": SimTypeInt(signed=False, label="UInt32"), "TargetLUN": SimTypeLongLong(signed=False, label="UInt64")}, name="SCSI_LUN_LIST", pack=False, align=None), offset=0)}, name="ISCSI_TARGET_MAPPINGW", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "InformationSpecified": SimTypeInt(signed=False, label="UInt32"), "LoginFlags": SimTypeInt(signed=False, label="UInt32"), "AuthType": SimTypeInt(signed=False, label="ISCSI_AUTH_TYPES"), "HeaderDigest": SimTypeInt(signed=False, label="ISCSI_DIGEST_TYPES"), "DataDigest": SimTypeInt(signed=False, label="ISCSI_DIGEST_TYPES"), "MaximumConnections": SimTypeInt(signed=False, label="UInt32"), "DefaultTime2Wait": SimTypeInt(signed=False, label="UInt32"), "DefaultTime2Retain": SimTypeInt(signed=False, label="UInt32"), "UsernameLength": SimTypeInt(signed=False, label="UInt32"), "PasswordLength": SimTypeInt(signed=False, label="UInt32"), "Username": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Password": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="ISCSI_LOGIN_OPTIONS", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Count": SimTypeInt(signed=False, label="UInt32"), "Portals": SimTypePointer(SimStruct({"SymbolicName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256), "Socket": SimTypeShort(signed=False, label="UInt16")}, name="ISCSI_TARGET_PORTALW", pack=False, align=None), offset=0)}, name="ISCSI_TARGET_PORTAL_GROUPW", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["TargetName", "TargetAlias", "TargetFlags", "Persist", "Mappings", "LoginOptions", "PortalGroup"]),
        # 
        'AddIScsiStaticTargetA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeChar(label="Byte"), SimTypePointer(SimStruct({"InitiatorName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256), "TargetName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 224), "OSDeviceName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 260), "SessionId": SimStruct({"AdapterUnique": SimTypeLongLong(signed=False, label="UInt64"), "AdapterSpecific": SimTypeLongLong(signed=False, label="UInt64")}, name="ISCSI_UNIQUE_SESSION_ID", pack=False, align=None), "OSBusNumber": SimTypeInt(signed=False, label="UInt32"), "OSTargetNumber": SimTypeInt(signed=False, label="UInt32"), "LUNCount": SimTypeInt(signed=False, label="UInt32"), "LUNList": SimTypePointer(SimStruct({"OSLUN": SimTypeInt(signed=False, label="UInt32"), "TargetLUN": SimTypeLongLong(signed=False, label="UInt64")}, name="SCSI_LUN_LIST", pack=False, align=None), offset=0)}, name="ISCSI_TARGET_MAPPINGA", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "InformationSpecified": SimTypeInt(signed=False, label="UInt32"), "LoginFlags": SimTypeInt(signed=False, label="UInt32"), "AuthType": SimTypeInt(signed=False, label="ISCSI_AUTH_TYPES"), "HeaderDigest": SimTypeInt(signed=False, label="ISCSI_DIGEST_TYPES"), "DataDigest": SimTypeInt(signed=False, label="ISCSI_DIGEST_TYPES"), "MaximumConnections": SimTypeInt(signed=False, label="UInt32"), "DefaultTime2Wait": SimTypeInt(signed=False, label="UInt32"), "DefaultTime2Retain": SimTypeInt(signed=False, label="UInt32"), "UsernameLength": SimTypeInt(signed=False, label="UInt32"), "PasswordLength": SimTypeInt(signed=False, label="UInt32"), "Username": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Password": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="ISCSI_LOGIN_OPTIONS", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Count": SimTypeInt(signed=False, label="UInt32"), "Portals": SimTypePointer(SimStruct({"SymbolicName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256), "Address": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256), "Socket": SimTypeShort(signed=False, label="UInt16")}, name="ISCSI_TARGET_PORTALA", pack=False, align=None), offset=0)}, name="ISCSI_TARGET_PORTAL_GROUPA", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["TargetName", "TargetAlias", "TargetFlags", "Persist", "Mappings", "LoginOptions", "PortalGroup"]),
        # 
        'RemoveIScsiStaticTargetW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["TargetName"]),
        # 
        'RemoveIScsiStaticTargetA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["TargetName"]),
        # 
        'AddIScsiSendTargetPortalW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "InformationSpecified": SimTypeInt(signed=False, label="UInt32"), "LoginFlags": SimTypeInt(signed=False, label="UInt32"), "AuthType": SimTypeInt(signed=False, label="ISCSI_AUTH_TYPES"), "HeaderDigest": SimTypeInt(signed=False, label="ISCSI_DIGEST_TYPES"), "DataDigest": SimTypeInt(signed=False, label="ISCSI_DIGEST_TYPES"), "MaximumConnections": SimTypeInt(signed=False, label="UInt32"), "DefaultTime2Wait": SimTypeInt(signed=False, label="UInt32"), "DefaultTime2Retain": SimTypeInt(signed=False, label="UInt32"), "UsernameLength": SimTypeInt(signed=False, label="UInt32"), "PasswordLength": SimTypeInt(signed=False, label="UInt32"), "Username": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Password": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="ISCSI_LOGIN_OPTIONS", pack=False, align=None), offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimStruct({"SymbolicName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256), "Socket": SimTypeShort(signed=False, label="UInt16")}, name="ISCSI_TARGET_PORTALW", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["InitiatorInstance", "InitiatorPortNumber", "LoginOptions", "SecurityFlags", "Portal"]),
        # 
        'AddIScsiSendTargetPortalA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "InformationSpecified": SimTypeInt(signed=False, label="UInt32"), "LoginFlags": SimTypeInt(signed=False, label="UInt32"), "AuthType": SimTypeInt(signed=False, label="ISCSI_AUTH_TYPES"), "HeaderDigest": SimTypeInt(signed=False, label="ISCSI_DIGEST_TYPES"), "DataDigest": SimTypeInt(signed=False, label="ISCSI_DIGEST_TYPES"), "MaximumConnections": SimTypeInt(signed=False, label="UInt32"), "DefaultTime2Wait": SimTypeInt(signed=False, label="UInt32"), "DefaultTime2Retain": SimTypeInt(signed=False, label="UInt32"), "UsernameLength": SimTypeInt(signed=False, label="UInt32"), "PasswordLength": SimTypeInt(signed=False, label="UInt32"), "Username": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Password": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="ISCSI_LOGIN_OPTIONS", pack=False, align=None), offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimStruct({"SymbolicName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256), "Address": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256), "Socket": SimTypeShort(signed=False, label="UInt16")}, name="ISCSI_TARGET_PORTALA", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["InitiatorInstance", "InitiatorPortNumber", "LoginOptions", "SecurityFlags", "Portal"]),
        # 
        'RemoveIScsiSendTargetPortalW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"SymbolicName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256), "Socket": SimTypeShort(signed=False, label="UInt16")}, name="ISCSI_TARGET_PORTALW", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["InitiatorInstance", "InitiatorPortNumber", "Portal"]),
        # 
        'RemoveIScsiSendTargetPortalA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"SymbolicName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256), "Address": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256), "Socket": SimTypeShort(signed=False, label="UInt16")}, name="ISCSI_TARGET_PORTALA", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["InitiatorInstance", "InitiatorPortNumber", "Portal"]),
        # 
        'RefreshIScsiSendTargetPortalW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"SymbolicName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256), "Socket": SimTypeShort(signed=False, label="UInt16")}, name="ISCSI_TARGET_PORTALW", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["InitiatorInstance", "InitiatorPortNumber", "Portal"]),
        # 
        'RefreshIScsiSendTargetPortalA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"SymbolicName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256), "Address": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256), "Socket": SimTypeShort(signed=False, label="UInt16")}, name="ISCSI_TARGET_PORTALA", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["InitiatorInstance", "InitiatorPortNumber", "Portal"]),
        # 
        'ReportIScsiSendTargetPortalsW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"InitiatorName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256), "InitiatorPortNumber": SimTypeInt(signed=False, label="UInt32"), "SymbolicName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256), "Socket": SimTypeShort(signed=False, label="UInt16")}, name="ISCSI_TARGET_PORTAL_INFOW", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["PortalCount", "PortalInfo"]),
        # 
        'ReportIScsiSendTargetPortalsA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"InitiatorName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256), "InitiatorPortNumber": SimTypeInt(signed=False, label="UInt32"), "SymbolicName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256), "Address": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256), "Socket": SimTypeShort(signed=False, label="UInt16")}, name="ISCSI_TARGET_PORTAL_INFOA", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["PortalCount", "PortalInfo"]),
        # 
        'ReportIScsiSendTargetPortalsExW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"InitiatorName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256), "InitiatorPortNumber": SimTypeInt(signed=False, label="UInt32"), "SymbolicName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256), "Socket": SimTypeShort(signed=False, label="UInt16"), "SecurityFlags": SimTypeLongLong(signed=False, label="UInt64"), "LoginOptions": SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "InformationSpecified": SimTypeInt(signed=False, label="UInt32"), "LoginFlags": SimTypeInt(signed=False, label="UInt32"), "AuthType": SimTypeInt(signed=False, label="ISCSI_AUTH_TYPES"), "HeaderDigest": SimTypeInt(signed=False, label="ISCSI_DIGEST_TYPES"), "DataDigest": SimTypeInt(signed=False, label="ISCSI_DIGEST_TYPES"), "MaximumConnections": SimTypeInt(signed=False, label="UInt32"), "DefaultTime2Wait": SimTypeInt(signed=False, label="UInt32"), "DefaultTime2Retain": SimTypeInt(signed=False, label="UInt32"), "UsernameLength": SimTypeInt(signed=False, label="UInt32"), "PasswordLength": SimTypeInt(signed=False, label="UInt32"), "Username": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Password": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="ISCSI_LOGIN_OPTIONS", pack=False, align=None)}, name="ISCSI_TARGET_PORTAL_INFO_EXW", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["PortalCount", "PortalInfoSize", "PortalInfo"]),
        # 
        'ReportIScsiSendTargetPortalsExA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"InitiatorName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256), "InitiatorPortNumber": SimTypeInt(signed=False, label="UInt32"), "SymbolicName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256), "Address": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256), "Socket": SimTypeShort(signed=False, label="UInt16"), "SecurityFlags": SimTypeLongLong(signed=False, label="UInt64"), "LoginOptions": SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "InformationSpecified": SimTypeInt(signed=False, label="UInt32"), "LoginFlags": SimTypeInt(signed=False, label="UInt32"), "AuthType": SimTypeInt(signed=False, label="ISCSI_AUTH_TYPES"), "HeaderDigest": SimTypeInt(signed=False, label="ISCSI_DIGEST_TYPES"), "DataDigest": SimTypeInt(signed=False, label="ISCSI_DIGEST_TYPES"), "MaximumConnections": SimTypeInt(signed=False, label="UInt32"), "DefaultTime2Wait": SimTypeInt(signed=False, label="UInt32"), "DefaultTime2Retain": SimTypeInt(signed=False, label="UInt32"), "UsernameLength": SimTypeInt(signed=False, label="UInt32"), "PasswordLength": SimTypeInt(signed=False, label="UInt32"), "Username": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Password": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="ISCSI_LOGIN_OPTIONS", pack=False, align=None)}, name="ISCSI_TARGET_PORTAL_INFO_EXA", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["PortalCount", "PortalInfoSize", "PortalInfo"]),
        # 
        'LoginIScsiTargetW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeChar(label="Byte"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"SymbolicName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256), "Socket": SimTypeShort(signed=False, label="UInt16")}, name="ISCSI_TARGET_PORTALW", pack=False, align=None), offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimStruct({"InitiatorName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256), "TargetName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 224), "OSDeviceName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 260), "SessionId": SimStruct({"AdapterUnique": SimTypeLongLong(signed=False, label="UInt64"), "AdapterSpecific": SimTypeLongLong(signed=False, label="UInt64")}, name="ISCSI_UNIQUE_SESSION_ID", pack=False, align=None), "OSBusNumber": SimTypeInt(signed=False, label="UInt32"), "OSTargetNumber": SimTypeInt(signed=False, label="UInt32"), "LUNCount": SimTypeInt(signed=False, label="UInt32"), "LUNList": SimTypePointer(SimStruct({"OSLUN": SimTypeInt(signed=False, label="UInt32"), "TargetLUN": SimTypeLongLong(signed=False, label="UInt64")}, name="SCSI_LUN_LIST", pack=False, align=None), offset=0)}, name="ISCSI_TARGET_MAPPINGW", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "InformationSpecified": SimTypeInt(signed=False, label="UInt32"), "LoginFlags": SimTypeInt(signed=False, label="UInt32"), "AuthType": SimTypeInt(signed=False, label="ISCSI_AUTH_TYPES"), "HeaderDigest": SimTypeInt(signed=False, label="ISCSI_DIGEST_TYPES"), "DataDigest": SimTypeInt(signed=False, label="ISCSI_DIGEST_TYPES"), "MaximumConnections": SimTypeInt(signed=False, label="UInt32"), "DefaultTime2Wait": SimTypeInt(signed=False, label="UInt32"), "DefaultTime2Retain": SimTypeInt(signed=False, label="UInt32"), "UsernameLength": SimTypeInt(signed=False, label="UInt32"), "PasswordLength": SimTypeInt(signed=False, label="UInt32"), "Username": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Password": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="ISCSI_LOGIN_OPTIONS", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeChar(label="Byte"), SimTypePointer(SimStruct({"AdapterUnique": SimTypeLongLong(signed=False, label="UInt64"), "AdapterSpecific": SimTypeLongLong(signed=False, label="UInt64")}, name="ISCSI_UNIQUE_SESSION_ID", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"AdapterUnique": SimTypeLongLong(signed=False, label="UInt64"), "AdapterSpecific": SimTypeLongLong(signed=False, label="UInt64")}, name="ISCSI_UNIQUE_SESSION_ID", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["TargetName", "IsInformationalSession", "InitiatorInstance", "InitiatorPortNumber", "TargetPortal", "SecurityFlags", "Mappings", "LoginOptions", "KeySize", "Key", "IsPersistent", "UniqueSessionId", "UniqueConnectionId"]),
        # 
        'LoginIScsiTargetA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeChar(label="Byte"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"SymbolicName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256), "Address": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256), "Socket": SimTypeShort(signed=False, label="UInt16")}, name="ISCSI_TARGET_PORTALA", pack=False, align=None), offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimStruct({"InitiatorName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256), "TargetName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 224), "OSDeviceName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 260), "SessionId": SimStruct({"AdapterUnique": SimTypeLongLong(signed=False, label="UInt64"), "AdapterSpecific": SimTypeLongLong(signed=False, label="UInt64")}, name="ISCSI_UNIQUE_SESSION_ID", pack=False, align=None), "OSBusNumber": SimTypeInt(signed=False, label="UInt32"), "OSTargetNumber": SimTypeInt(signed=False, label="UInt32"), "LUNCount": SimTypeInt(signed=False, label="UInt32"), "LUNList": SimTypePointer(SimStruct({"OSLUN": SimTypeInt(signed=False, label="UInt32"), "TargetLUN": SimTypeLongLong(signed=False, label="UInt64")}, name="SCSI_LUN_LIST", pack=False, align=None), offset=0)}, name="ISCSI_TARGET_MAPPINGA", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "InformationSpecified": SimTypeInt(signed=False, label="UInt32"), "LoginFlags": SimTypeInt(signed=False, label="UInt32"), "AuthType": SimTypeInt(signed=False, label="ISCSI_AUTH_TYPES"), "HeaderDigest": SimTypeInt(signed=False, label="ISCSI_DIGEST_TYPES"), "DataDigest": SimTypeInt(signed=False, label="ISCSI_DIGEST_TYPES"), "MaximumConnections": SimTypeInt(signed=False, label="UInt32"), "DefaultTime2Wait": SimTypeInt(signed=False, label="UInt32"), "DefaultTime2Retain": SimTypeInt(signed=False, label="UInt32"), "UsernameLength": SimTypeInt(signed=False, label="UInt32"), "PasswordLength": SimTypeInt(signed=False, label="UInt32"), "Username": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Password": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="ISCSI_LOGIN_OPTIONS", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeChar(label="Byte"), SimTypePointer(SimStruct({"AdapterUnique": SimTypeLongLong(signed=False, label="UInt64"), "AdapterSpecific": SimTypeLongLong(signed=False, label="UInt64")}, name="ISCSI_UNIQUE_SESSION_ID", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"AdapterUnique": SimTypeLongLong(signed=False, label="UInt64"), "AdapterSpecific": SimTypeLongLong(signed=False, label="UInt64")}, name="ISCSI_UNIQUE_SESSION_ID", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["TargetName", "IsInformationalSession", "InitiatorInstance", "InitiatorPortNumber", "TargetPortal", "SecurityFlags", "Mappings", "LoginOptions", "KeySize", "Key", "IsPersistent", "UniqueSessionId", "UniqueConnectionId"]),
        # 
        'ReportIScsiPersistentLoginsW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"TargetName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 224), "IsInformationalSession": SimTypeChar(label="Byte"), "InitiatorInstance": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256), "InitiatorPortNumber": SimTypeInt(signed=False, label="UInt32"), "TargetPortal": SimStruct({"SymbolicName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256), "Socket": SimTypeShort(signed=False, label="UInt16")}, name="ISCSI_TARGET_PORTALW", pack=False, align=None), "SecurityFlags": SimTypeLongLong(signed=False, label="UInt64"), "Mappings": SimTypePointer(SimStruct({"InitiatorName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256), "TargetName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 224), "OSDeviceName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 260), "SessionId": SimStruct({"AdapterUnique": SimTypeLongLong(signed=False, label="UInt64"), "AdapterSpecific": SimTypeLongLong(signed=False, label="UInt64")}, name="ISCSI_UNIQUE_SESSION_ID", pack=False, align=None), "OSBusNumber": SimTypeInt(signed=False, label="UInt32"), "OSTargetNumber": SimTypeInt(signed=False, label="UInt32"), "LUNCount": SimTypeInt(signed=False, label="UInt32"), "LUNList": SimTypePointer(SimStruct({"OSLUN": SimTypeInt(signed=False, label="UInt32"), "TargetLUN": SimTypeLongLong(signed=False, label="UInt64")}, name="SCSI_LUN_LIST", pack=False, align=None), offset=0)}, name="ISCSI_TARGET_MAPPINGW", pack=False, align=None), offset=0), "LoginOptions": SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "InformationSpecified": SimTypeInt(signed=False, label="UInt32"), "LoginFlags": SimTypeInt(signed=False, label="UInt32"), "AuthType": SimTypeInt(signed=False, label="ISCSI_AUTH_TYPES"), "HeaderDigest": SimTypeInt(signed=False, label="ISCSI_DIGEST_TYPES"), "DataDigest": SimTypeInt(signed=False, label="ISCSI_DIGEST_TYPES"), "MaximumConnections": SimTypeInt(signed=False, label="UInt32"), "DefaultTime2Wait": SimTypeInt(signed=False, label="UInt32"), "DefaultTime2Retain": SimTypeInt(signed=False, label="UInt32"), "UsernameLength": SimTypeInt(signed=False, label="UInt32"), "PasswordLength": SimTypeInt(signed=False, label="UInt32"), "Username": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Password": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="ISCSI_LOGIN_OPTIONS", pack=False, align=None)}, name="PERSISTENT_ISCSI_LOGIN_INFOW", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Count", "PersistentLoginInfo", "BufferSizeInBytes"]),
        # 
        'ReportIScsiPersistentLoginsA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"TargetName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 224), "IsInformationalSession": SimTypeChar(label="Byte"), "InitiatorInstance": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256), "InitiatorPortNumber": SimTypeInt(signed=False, label="UInt32"), "TargetPortal": SimStruct({"SymbolicName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256), "Address": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256), "Socket": SimTypeShort(signed=False, label="UInt16")}, name="ISCSI_TARGET_PORTALA", pack=False, align=None), "SecurityFlags": SimTypeLongLong(signed=False, label="UInt64"), "Mappings": SimTypePointer(SimStruct({"InitiatorName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256), "TargetName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 224), "OSDeviceName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 260), "SessionId": SimStruct({"AdapterUnique": SimTypeLongLong(signed=False, label="UInt64"), "AdapterSpecific": SimTypeLongLong(signed=False, label="UInt64")}, name="ISCSI_UNIQUE_SESSION_ID", pack=False, align=None), "OSBusNumber": SimTypeInt(signed=False, label="UInt32"), "OSTargetNumber": SimTypeInt(signed=False, label="UInt32"), "LUNCount": SimTypeInt(signed=False, label="UInt32"), "LUNList": SimTypePointer(SimStruct({"OSLUN": SimTypeInt(signed=False, label="UInt32"), "TargetLUN": SimTypeLongLong(signed=False, label="UInt64")}, name="SCSI_LUN_LIST", pack=False, align=None), offset=0)}, name="ISCSI_TARGET_MAPPINGA", pack=False, align=None), offset=0), "LoginOptions": SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "InformationSpecified": SimTypeInt(signed=False, label="UInt32"), "LoginFlags": SimTypeInt(signed=False, label="UInt32"), "AuthType": SimTypeInt(signed=False, label="ISCSI_AUTH_TYPES"), "HeaderDigest": SimTypeInt(signed=False, label="ISCSI_DIGEST_TYPES"), "DataDigest": SimTypeInt(signed=False, label="ISCSI_DIGEST_TYPES"), "MaximumConnections": SimTypeInt(signed=False, label="UInt32"), "DefaultTime2Wait": SimTypeInt(signed=False, label="UInt32"), "DefaultTime2Retain": SimTypeInt(signed=False, label="UInt32"), "UsernameLength": SimTypeInt(signed=False, label="UInt32"), "PasswordLength": SimTypeInt(signed=False, label="UInt32"), "Username": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Password": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="ISCSI_LOGIN_OPTIONS", pack=False, align=None)}, name="PERSISTENT_ISCSI_LOGIN_INFOA", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Count", "PersistentLoginInfo", "BufferSizeInBytes"]),
        # 
        'LogoutIScsiTarget': SimTypeFunction([SimTypePointer(SimStruct({"AdapterUnique": SimTypeLongLong(signed=False, label="UInt64"), "AdapterSpecific": SimTypeLongLong(signed=False, label="UInt64")}, name="ISCSI_UNIQUE_SESSION_ID", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["UniqueSessionId"]),
        # 
        'RemoveIScsiPersistentTargetW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"SymbolicName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256), "Socket": SimTypeShort(signed=False, label="UInt16")}, name="ISCSI_TARGET_PORTALW", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["InitiatorInstance", "InitiatorPortNumber", "TargetName", "Portal"]),
        # 
        'RemoveIScsiPersistentTargetA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"SymbolicName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256), "Address": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256), "Socket": SimTypeShort(signed=False, label="UInt16")}, name="ISCSI_TARGET_PORTALA", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["InitiatorInstance", "InitiatorPortNumber", "TargetName", "Portal"]),
        # 
        'SendScsiInquiry': SimTypeFunction([SimTypePointer(SimStruct({"AdapterUnique": SimTypeLongLong(signed=False, label="UInt64"), "AdapterSpecific": SimTypeLongLong(signed=False, label="UInt64")}, name="ISCSI_UNIQUE_SESSION_ID", pack=False, align=None), offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeChar(label="Byte"), SimTypeChar(label="Byte"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["UniqueSessionId", "Lun", "EvpdCmddt", "PageCode", "ScsiStatus", "ResponseSize", "ResponseBuffer", "SenseSize", "SenseBuffer"]),
        # 
        'SendScsiReadCapacity': SimTypeFunction([SimTypePointer(SimStruct({"AdapterUnique": SimTypeLongLong(signed=False, label="UInt64"), "AdapterSpecific": SimTypeLongLong(signed=False, label="UInt64")}, name="ISCSI_UNIQUE_SESSION_ID", pack=False, align=None), offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["UniqueSessionId", "Lun", "ScsiStatus", "ResponseSize", "ResponseBuffer", "SenseSize", "SenseBuffer"]),
        # 
        'SendScsiReportLuns': SimTypeFunction([SimTypePointer(SimStruct({"AdapterUnique": SimTypeLongLong(signed=False, label="UInt64"), "AdapterSpecific": SimTypeLongLong(signed=False, label="UInt64")}, name="ISCSI_UNIQUE_SESSION_ID", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["UniqueSessionId", "ScsiStatus", "ResponseSize", "ResponseBuffer", "SenseSize", "SenseBuffer"]),
        # 
        'ReportIScsiInitiatorListW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["BufferSize", "Buffer"]),
        # 
        'ReportIScsiInitiatorListA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["BufferSize", "Buffer"]),
        # 
        'ReportActiveIScsiTargetMappingsW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"InitiatorName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256), "TargetName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 224), "OSDeviceName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 260), "SessionId": SimStruct({"AdapterUnique": SimTypeLongLong(signed=False, label="UInt64"), "AdapterSpecific": SimTypeLongLong(signed=False, label="UInt64")}, name="ISCSI_UNIQUE_SESSION_ID", pack=False, align=None), "OSBusNumber": SimTypeInt(signed=False, label="UInt32"), "OSTargetNumber": SimTypeInt(signed=False, label="UInt32"), "LUNCount": SimTypeInt(signed=False, label="UInt32"), "LUNList": SimTypePointer(SimStruct({"OSLUN": SimTypeInt(signed=False, label="UInt32"), "TargetLUN": SimTypeLongLong(signed=False, label="UInt64")}, name="SCSI_LUN_LIST", pack=False, align=None), offset=0)}, name="ISCSI_TARGET_MAPPINGW", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["BufferSize", "MappingCount", "Mappings"]),
        # 
        'ReportActiveIScsiTargetMappingsA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"InitiatorName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256), "TargetName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 224), "OSDeviceName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 260), "SessionId": SimStruct({"AdapterUnique": SimTypeLongLong(signed=False, label="UInt64"), "AdapterSpecific": SimTypeLongLong(signed=False, label="UInt64")}, name="ISCSI_UNIQUE_SESSION_ID", pack=False, align=None), "OSBusNumber": SimTypeInt(signed=False, label="UInt32"), "OSTargetNumber": SimTypeInt(signed=False, label="UInt32"), "LUNCount": SimTypeInt(signed=False, label="UInt32"), "LUNList": SimTypePointer(SimStruct({"OSLUN": SimTypeInt(signed=False, label="UInt32"), "TargetLUN": SimTypeLongLong(signed=False, label="UInt64")}, name="SCSI_LUN_LIST", pack=False, align=None), offset=0)}, name="ISCSI_TARGET_MAPPINGA", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["BufferSize", "MappingCount", "Mappings"]),
        # 
        'SetIScsiTunnelModeOuterAddressW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeChar(label="Byte")], SimTypeInt(signed=False, label="UInt32"), arg_names=["InitiatorName", "InitiatorPortNumber", "DestinationAddress", "OuterModeAddress", "Persist"]),
        # 
        'SetIScsiTunnelModeOuterAddressA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeChar(label="Byte")], SimTypeInt(signed=False, label="UInt32"), arg_names=["InitiatorName", "InitiatorPortNumber", "DestinationAddress", "OuterModeAddress", "Persist"]),
        # 
        'SetIScsiIKEInfoW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"AuthMethod": SimTypeInt(signed=False, label="IKE_AUTHENTICATION_METHOD"), "Anonymous": SimUnion({"PsKey": SimStruct({"SecurityFlags": SimTypeLongLong(signed=False, label="UInt64"), "IdType": SimTypeChar(label="Byte"), "IdLengthInBytes": SimTypeInt(signed=False, label="UInt32"), "Id": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "KeyLengthInBytes": SimTypeInt(signed=False, label="UInt32"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="IKE_AUTHENTICATION_PRESHARED_KEY", pack=False, align=None)}, name="<anon>", label="None")}, name="IKE_AUTHENTICATION_INFORMATION", pack=False, align=None), offset=0), SimTypeChar(label="Byte")], SimTypeInt(signed=False, label="UInt32"), arg_names=["InitiatorName", "InitiatorPortNumber", "AuthInfo", "Persist"]),
        # 
        'SetIScsiIKEInfoA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"AuthMethod": SimTypeInt(signed=False, label="IKE_AUTHENTICATION_METHOD"), "Anonymous": SimUnion({"PsKey": SimStruct({"SecurityFlags": SimTypeLongLong(signed=False, label="UInt64"), "IdType": SimTypeChar(label="Byte"), "IdLengthInBytes": SimTypeInt(signed=False, label="UInt32"), "Id": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "KeyLengthInBytes": SimTypeInt(signed=False, label="UInt32"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="IKE_AUTHENTICATION_PRESHARED_KEY", pack=False, align=None)}, name="<anon>", label="None")}, name="IKE_AUTHENTICATION_INFORMATION", pack=False, align=None), offset=0), SimTypeChar(label="Byte")], SimTypeInt(signed=False, label="UInt32"), arg_names=["InitiatorName", "InitiatorPortNumber", "AuthInfo", "Persist"]),
        # 
        'GetIScsiIKEInfoW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"AuthMethod": SimTypeInt(signed=False, label="IKE_AUTHENTICATION_METHOD"), "Anonymous": SimUnion({"PsKey": SimStruct({"SecurityFlags": SimTypeLongLong(signed=False, label="UInt64"), "IdType": SimTypeChar(label="Byte"), "IdLengthInBytes": SimTypeInt(signed=False, label="UInt32"), "Id": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "KeyLengthInBytes": SimTypeInt(signed=False, label="UInt32"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="IKE_AUTHENTICATION_PRESHARED_KEY", pack=False, align=None)}, name="<anon>", label="None")}, name="IKE_AUTHENTICATION_INFORMATION", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["InitiatorName", "InitiatorPortNumber", "Reserved", "AuthInfo"]),
        # 
        'GetIScsiIKEInfoA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"AuthMethod": SimTypeInt(signed=False, label="IKE_AUTHENTICATION_METHOD"), "Anonymous": SimUnion({"PsKey": SimStruct({"SecurityFlags": SimTypeLongLong(signed=False, label="UInt64"), "IdType": SimTypeChar(label="Byte"), "IdLengthInBytes": SimTypeInt(signed=False, label="UInt32"), "Id": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "KeyLengthInBytes": SimTypeInt(signed=False, label="UInt32"), "Key": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="IKE_AUTHENTICATION_PRESHARED_KEY", pack=False, align=None)}, name="<anon>", label="None")}, name="IKE_AUTHENTICATION_INFORMATION", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["InitiatorName", "InitiatorPortNumber", "Reserved", "AuthInfo"]),
        # 
        'SetIScsiGroupPresharedKey': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeChar(label="Byte")], SimTypeInt(signed=False, label="UInt32"), arg_names=["KeyLength", "Key", "Persist"]),
        # 
        'SetIScsiInitiatorCHAPSharedSecret': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["SharedSecretLength", "SharedSecret"]),
        # 
        'SetIScsiInitiatorRADIUSSharedSecret': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["SharedSecretLength", "SharedSecret"]),
        # 
        'SetIScsiInitiatorNodeNameW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["InitiatorNodeName"]),
        # 
        'SetIScsiInitiatorNodeNameA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["InitiatorNodeName"]),
        # 
        'GetIScsiInitiatorNodeNameW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["InitiatorNodeName"]),
        # 
        'GetIScsiInitiatorNodeNameA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["InitiatorNodeName"]),
        # 
        'AddISNSServerW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Address"]),
        # 
        'AddISNSServerA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Address"]),
        # 
        'RemoveISNSServerW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Address"]),
        # 
        'RemoveISNSServerA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Address"]),
        # 
        'RefreshISNSServerW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Address"]),
        # 
        'RefreshISNSServerA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Address"]),
        # 
        'ReportISNSServerListW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["BufferSizeInChar", "Buffer"]),
        # 
        'ReportISNSServerListA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["BufferSizeInChar", "Buffer"]),
        # 
        'GetIScsiSessionListW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"SessionId": SimStruct({"AdapterUnique": SimTypeLongLong(signed=False, label="UInt64"), "AdapterSpecific": SimTypeLongLong(signed=False, label="UInt64")}, name="ISCSI_UNIQUE_SESSION_ID", pack=False, align=None), "InitiatorName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "TargetNodeName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "TargetName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ISID": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 6), "TSID": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "ConnectionCount": SimTypeInt(signed=False, label="UInt32"), "Connections": SimTypePointer(SimStruct({"ConnectionId": SimStruct({"AdapterUnique": SimTypeLongLong(signed=False, label="UInt64"), "AdapterSpecific": SimTypeLongLong(signed=False, label="UInt64")}, name="ISCSI_UNIQUE_SESSION_ID", pack=False, align=None), "InitiatorAddress": SimTypePointer(SimTypeChar(label="Char"), offset=0), "TargetAddress": SimTypePointer(SimTypeChar(label="Char"), offset=0), "InitiatorSocket": SimTypeShort(signed=False, label="UInt16"), "TargetSocket": SimTypeShort(signed=False, label="UInt16"), "CID": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2)}, name="ISCSI_CONNECTION_INFOW", pack=False, align=None), offset=0)}, name="ISCSI_SESSION_INFOW", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["BufferSize", "SessionCount", "SessionInfo"]),
        # 
        'GetIScsiSessionListA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"SessionId": SimStruct({"AdapterUnique": SimTypeLongLong(signed=False, label="UInt64"), "AdapterSpecific": SimTypeLongLong(signed=False, label="UInt64")}, name="ISCSI_UNIQUE_SESSION_ID", pack=False, align=None), "InitiatorName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "TargetNodeName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "TargetName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "ISID": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 6), "TSID": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "ConnectionCount": SimTypeInt(signed=False, label="UInt32"), "Connections": SimTypePointer(SimStruct({"ConnectionId": SimStruct({"AdapterUnique": SimTypeLongLong(signed=False, label="UInt64"), "AdapterSpecific": SimTypeLongLong(signed=False, label="UInt64")}, name="ISCSI_UNIQUE_SESSION_ID", pack=False, align=None), "InitiatorAddress": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "TargetAddress": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "InitiatorSocket": SimTypeShort(signed=False, label="UInt16"), "TargetSocket": SimTypeShort(signed=False, label="UInt16"), "CID": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2)}, name="ISCSI_CONNECTION_INFOA", pack=False, align=None), offset=0)}, name="ISCSI_SESSION_INFOA", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["BufferSize", "SessionCount", "SessionInfo"]),
        # 
        'GetIScsiSessionListEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"SessionId": SimStruct({"AdapterUnique": SimTypeLongLong(signed=False, label="UInt64"), "AdapterSpecific": SimTypeLongLong(signed=False, label="UInt64")}, name="ISCSI_UNIQUE_SESSION_ID", pack=False, align=None), "InitialR2t": SimTypeChar(label="Byte"), "ImmediateData": SimTypeChar(label="Byte"), "Type": SimTypeChar(label="Byte"), "DataSequenceInOrder": SimTypeChar(label="Byte"), "DataPduInOrder": SimTypeChar(label="Byte"), "ErrorRecoveryLevel": SimTypeChar(label="Byte"), "MaxOutstandingR2t": SimTypeInt(signed=False, label="UInt32"), "FirstBurstLength": SimTypeInt(signed=False, label="UInt32"), "MaxBurstLength": SimTypeInt(signed=False, label="UInt32"), "MaximumConnections": SimTypeInt(signed=False, label="UInt32"), "ConnectionCount": SimTypeInt(signed=False, label="UInt32"), "Connections": SimTypePointer(SimStruct({"ConnectionId": SimStruct({"AdapterUnique": SimTypeLongLong(signed=False, label="UInt64"), "AdapterSpecific": SimTypeLongLong(signed=False, label="UInt64")}, name="ISCSI_UNIQUE_SESSION_ID", pack=False, align=None), "State": SimTypeChar(label="Byte"), "Protocol": SimTypeChar(label="Byte"), "HeaderDigest": SimTypeChar(label="Byte"), "DataDigest": SimTypeChar(label="Byte"), "MaxRecvDataSegmentLength": SimTypeInt(signed=False, label="UInt32"), "AuthType": SimTypeInt(signed=False, label="ISCSI_AUTH_TYPES"), "EstimatedThroughput": SimTypeLongLong(signed=False, label="UInt64"), "MaxDatagramSize": SimTypeInt(signed=False, label="UInt32")}, name="ISCSI_CONNECTION_INFO_EX", pack=False, align=None), offset=0)}, name="ISCSI_SESSION_INFO_EX", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["BufferSize", "SessionCountPtr", "SessionInfo"]),
        # 
        'GetDevicesForIScsiSessionW': SimTypeFunction([SimTypePointer(SimStruct({"AdapterUnique": SimTypeLongLong(signed=False, label="UInt64"), "AdapterSpecific": SimTypeLongLong(signed=False, label="UInt64")}, name="ISCSI_UNIQUE_SESSION_ID", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"InitiatorName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256), "TargetName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 224), "ScsiAddress": SimStruct({"Length": SimTypeInt(signed=False, label="UInt32"), "PortNumber": SimTypeChar(label="Byte"), "PathId": SimTypeChar(label="Byte"), "TargetId": SimTypeChar(label="Byte"), "Lun": SimTypeChar(label="Byte")}, name="SCSI_ADDRESS", pack=False, align=None), "DeviceInterfaceType": SimTypeBottom(label="Guid"), "DeviceInterfaceName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 260), "LegacyName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 260), "StorageDeviceNumber": SimTypeBottom(label="STORAGE_DEVICE_NUMBER"), "DeviceInstance": SimTypeInt(signed=False, label="UInt32")}, name="ISCSI_DEVICE_ON_SESSIONW", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["UniqueSessionId", "DeviceCount", "Devices"]),
        # 
        'GetDevicesForIScsiSessionA': SimTypeFunction([SimTypePointer(SimStruct({"AdapterUnique": SimTypeLongLong(signed=False, label="UInt64"), "AdapterSpecific": SimTypeLongLong(signed=False, label="UInt64")}, name="ISCSI_UNIQUE_SESSION_ID", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"InitiatorName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256), "TargetName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 224), "ScsiAddress": SimStruct({"Length": SimTypeInt(signed=False, label="UInt32"), "PortNumber": SimTypeChar(label="Byte"), "PathId": SimTypeChar(label="Byte"), "TargetId": SimTypeChar(label="Byte"), "Lun": SimTypeChar(label="Byte")}, name="SCSI_ADDRESS", pack=False, align=None), "DeviceInterfaceType": SimTypeBottom(label="Guid"), "DeviceInterfaceName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 260), "LegacyName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 260), "StorageDeviceNumber": SimTypeBottom(label="STORAGE_DEVICE_NUMBER"), "DeviceInstance": SimTypeInt(signed=False, label="UInt32")}, name="ISCSI_DEVICE_ON_SESSIONA", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["UniqueSessionId", "DeviceCount", "Devices"]),
        # 
        'SetupPersistentIScsiVolumes': SimTypeFunction([], SimTypeInt(signed=False, label="UInt32")),
        # 
        'SetupPersistentIScsiDevices': SimTypeFunction([], SimTypeInt(signed=False, label="UInt32")),
        # 
        'AddPersistentIScsiDeviceW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["DevicePath"]),
        # 
        'AddPersistentIScsiDeviceA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["DevicePath"]),
        # 
        'RemovePersistentIScsiDeviceW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["DevicePath"]),
        # 
        'RemovePersistentIScsiDeviceA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["DevicePath"]),
        # 
        'ClearPersistentIScsiDevices': SimTypeFunction([], SimTypeInt(signed=False, label="UInt32")),
        # 
        'ReportPersistentIScsiDevicesW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["BufferSizeInChar", "Buffer"]),
        # 
        'ReportPersistentIScsiDevicesA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["BufferSizeInChar", "Buffer"]),
        # 
        'ReportIScsiTargetPortalsW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"SymbolicName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256), "Address": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256), "Socket": SimTypeShort(signed=False, label="UInt16")}, name="ISCSI_TARGET_PORTALW", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["InitiatorName", "TargetName", "TargetPortalTag", "ElementCount", "Portals"]),
        # 
        'ReportIScsiTargetPortalsA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"SymbolicName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256), "Address": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256), "Socket": SimTypeShort(signed=False, label="UInt16")}, name="ISCSI_TARGET_PORTALA", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["InitiatorName", "TargetName", "TargetPortalTag", "ElementCount", "Portals"]),
        # 
        'AddRadiusServerW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Address"]),
        # 
        'AddRadiusServerA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Address"]),
        # 
        'RemoveRadiusServerW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Address"]),
        # 
        'RemoveRadiusServerA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Address"]),
        # 
        'ReportRadiusServerListW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["BufferSizeInChar", "Buffer"]),
        # 
        'ReportRadiusServerListA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["BufferSizeInChar", "Buffer"]),
    }

lib.set_prototypes(prototypes)
