/*
THIS IS A GENERATED/BUNDLED FILE BY ROLLUP
if you want to view the source visit the plugins github repository

'Shell commands' plugin for Obsidian.
Copyright (C) 2021 - 2023 Jarkko Linnanvirta

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, version 3 of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program. If not, see <https://www.gnu.org/licenses/>.

Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
*/

'use strict';

var obsidian = require('obsidian');
var child_process = require('child_process');
var os = require('os');
var path = require('path');
var electron = require('electron');
var fs = require('fs');

function _interopNamespace(e) {
    if (e && e.__esModule) return e;
    var n = Object.create(null);
    if (e) {
        Object.keys(e).forEach(function (k) {
            if (k !== 'default') {
                var d = Object.getOwnPropertyDescriptor(e, k);
                Object.defineProperty(n, k, d.get ? d : {
                    enumerable: true,
                    get: function () { return e[k]; }
                });
            }
        });
    }
    n["default"] = e;
    return Object.freeze(n);
}

var path__namespace = /*#__PURE__*/_interopNamespace(path);
var fs__namespace = /*#__PURE__*/_interopNamespace(fs);

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class SC_Modal extends obsidian.Modal {
    constructor(plugin) {
        super(plugin.app);
        this.plugin = plugin;
        this._isOpen = false;
    }
    onOpen() {
        this._isOpen = true;
        // Make the modal scrollable if it has more content than what fits in the screen.
        this.modalEl.addClass("SC-modal", "SC-scrollable");
        // Approve the modal by pressing the enter key (if enabled).
        if (this.plugin.settings.approve_modals_by_pressing_enter_key) {
            this.scope.register([], "enter", (event) => {
                // Check that no textarea is focused and no autocomplete menu is open.
                if (0 === document.querySelectorAll("textarea:focus").length &&
                    0 === document.querySelectorAll("div.SC-autocomplete").length) {
                    // No textareas with focus and no open autocomplete menus were found.
                    this.approve();
                    event.preventDefault();
                    event.stopPropagation();
                }
            });
        }
    }
    isOpen() {
        return this._isOpen;
    }
    setTitle(title) {
        this.titleEl.innerText = title;
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class ConfirmationModal extends SC_Modal {
    constructor(plugin, title, question, yes_button_text) {
        super(plugin);
        this.question = question;
        this.yes_button_text = yes_button_text;
        this.approved = false;
        this.setTitle(title);
        this.promise = new Promise((resolve) => {
            this.resolve_promise = resolve;
        });
    }
    onOpen() {
        super.onOpen();
        // Display the question
        this.modalEl.createEl("p", { text: this.question });
        // Display the yes button
        new obsidian.Setting(this.modalEl)
            .addButton(button => button
            .setButtonText(this.yes_button_text)
            .onClick(() => this.approve()));
    }
    approve() {
        // Got a confirmation from a user
        this.resolve_promise(true);
        this.approved = true;
        this.close();
    }
    onClose() {
        super.onClose();
        if (!this.approved) { // TODO: Find out if there is a way to not use this kind of flag property. Can the status be checked from the promise itself?
            this.resolve_promise(false);
        }
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
/**
 * If true, logging stuff to console.log() will be enabled.
 * Might also enable some testing {{variables}} in the future, perhaps.
 */
let DEBUG_ON = false;
function setDEBUG_ON(value) {
    DEBUG_ON = value;
}
/**
 * Calls console.log(), but only if debugging is enabled.
 * @param messages
 */
function debugLog(...messages) {
    if (DEBUG_ON) {
        console.log(...messages);
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class IDGenerator {
    constructor(reserved_ids = [], min_length = 10, characters = "abcdefghijklmnopqrstuvwxyz0123456789") {
        this.reserved_ids = reserved_ids;
        this.min_length = min_length;
        this.characters = characters;
    }
    addReservedID(id) {
        debugLog(IDGenerator.name + ": Adding id " + id + " to the list of reserved ids.");
        this.reserved_ids.push(id);
    }
    generateID() {
        let generated_id = "";
        while (generated_id.length < this.min_length || this.isIDReserved(generated_id)) {
            generated_id += this.generateCharacter();
        }
        this.reserved_ids.push(generated_id);
        debugLog(IDGenerator.name + ": Generated id " + generated_id);
        return generated_id;
    }
    getReservedIDs() {
        return this.reserved_ids;
    }
    generateCharacter() {
        return this.characters.charAt(Math.floor(Math.random() * this.characters.length));
    }
    isIDReserved(id) {
        return this.reserved_ids.contains(id);
    }
}
const id_generator = new IDGenerator();
function getIDGenerator() {
    return id_generator;
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
function getVaultAbsolutePath(app) {
    // Original code was copied 2021-08-22 from https://github.com/phibr0/obsidian-open-with/blob/84f0e25ba8e8355ff83b22f4050adde4cc6763ea/main.ts#L66-L67
    // But the code has been rewritten 2021-08-27 as per https://github.com/obsidianmd/obsidian-releases/pull/433#issuecomment-906087095
    const adapter = app.vault.adapter;
    if (adapter instanceof obsidian.FileSystemAdapter) {
        return adapter.getBasePath();
    }
    throw new Error("Could not retrieve vault path. No DataAdapter was found from app.vault.adapter.");
}
function getPluginAbsolutePath(plugin) {
    return normalizePath2(path__namespace.join(getVaultAbsolutePath(plugin.app), plugin.app.vault.configDir, "plugins", plugin.getPluginId()));
}
/**
 * For some reason there is no Platform.isWindows .
 */
function isWindows() {
    return process.platform === "win32";
}
/**
 * This is just a wrapper around platform() in order to cast the type to PlatformId.
 * TODO: Consider renaming this to getPlatformId().
 */
function getOperatingSystem() {
    // @ts-ignore In theory, platform() can return an OS name not included in OperatingSystemName. But as Obsidian
    // currently does not support anything else than Windows, Mac and Linux (except mobile platforms, but they are
    // ruled out by the manifest of this plugin), it should be safe to assume that the current OS is one of those
    // three.
    return os.platform();
}
function getView(app) {
    const view = app.workspace.getActiveViewOfType(obsidian.MarkdownView);
    if (!view) {
        debugLog("getView(): Could not get a view. Will return null.");
        return null;
    }
    return view;
}
function getEditor(app) {
    const view = getView(app);
    if (null === view) {
        // Could not get a view.
        return null;
    }
    // Ensure that view.editor exists! It exists at least if this is a MarkDownView.
    if ("editor" in view) {
        // Good, it exists.
        // @ts-ignore We already know that view.editor exists.
        return view.editor;
    }
    // Did not find an editor.
    debugLog("getEditor(): 'view' does not have a property named 'editor'. Will return null.");
    return null;
}
// eslint-disable-next-line @typescript-eslint/ban-types
function cloneObject(object) {
    return Object.assign({}, object);
}
/**
 * Merges two or more objects together. If they have same property names, former objects' properties get overwritten by later objects' properties.
 *
 * @param objects
 */
// eslint-disable-next-line @typescript-eslint/ban-types
function combineObjects(...objects) {
    return Object.assign({}, ...objects);
}
function mergeSets(set1, set2) {
    return new Set([...set1, ...set2]);
}
/**
 * Returns a new Set cloned from 'from_set', with all items presented in 'remove' removed from it.
 *
 * @param from_set
 * @param remove Can be either a Set of removable items, or a single item.
 */
function removeFromSet(from_set, remove) {
    const reduced_set = new Set(from_set);
    if (remove instanceof Set) {
        for (const removable of remove) {
            reduced_set.delete(removable);
        }
    }
    else {
        reduced_set.delete(remove);
    }
    return reduced_set;
}
/**
 * Same as normalizePath(), but fixes these glitches:
 * - Leading forward slashes / backward slashes should not be removed.
 * - \ should not be converted to / if platform is Windows. In other words, / should be converted to \ if platform is Windows.
 *
 * TODO: I've opened a discussion about this on Obsidian's forums. If anything new comes up in the discussion, make changes accordingly. https://forum.obsidian.md/t/normalizepath-removes-a-leading/24713
 */
function normalizePath2(path) {
    // 1. Preparations
    path = path.trim();
    const leading_slashes_regexp = /^[/\\]*/gu; // Get as many / or \ slashes as there are in the very beginning of path. Can also be "" (an empty string).
    const leading_slashes_array = leading_slashes_regexp.exec(path); // An array with only one item.
    if (null === leading_slashes_array) {
        // It should always match. This exception should never happen, but have it just in case.
        throw new Error("normalizePath2(): leading_slashes_regexp did not match.");
    }
    let leading_slashes = leading_slashes_array[0];
    // 2. Run the original normalizePath()
    path = obsidian.normalizePath(path);
    // 3. Fixes
    // Check that correct slashes are used.
    if (isWindows()) {
        // The platform is Windows.
        // Convert / to \
        path = path.replace(/\//gu, "\\"); // Need to use a regexp instead of a normal "/" -> "\\" replace because the normal replace would only replace first occurrence of /.
        leading_slashes = leading_slashes.replace(/\//gu, "\\"); // Same here.
    }
    // Now ensure that path still contains leading slashes (if there were any before calling normalizePath()).
    // Check that the path should have a similar set of leading slashes at the beginning. It can be at least "/" (on linux/Mac), or "\\" (on Windows when it's a network path), in theory even "///" or "\\\\\" whatever.
    // normalizePath() seems to remove leading slashes (and they are needed to be re-added), but it's needed to check first, otherwise the path would have double leading slashes if normalizePath() gets fixed in the future.
    if (leading_slashes.length && path.slice(0, leading_slashes.length) !== leading_slashes) {
        // The path does not contain the required set of leading slashes, so add them.
        path = leading_slashes + path;
    }
    // 4. Done
    return path;
}
function extractFileName(file_path, with_extension = true) {
    if (with_extension) {
        return path__namespace.parse(file_path).base;
    }
    else {
        return path__namespace.parse(file_path).name;
    }
}
function extractFileParentPath(file_path) {
    return path__namespace.parse(file_path).dir;
}
// eslint-disable-next-line @typescript-eslint/ban-types
function joinObjectProperties(object, glue) {
    let result = "";
    for (const property_name in object) {
        if (result.length) {
            result += glue;
        }
        // @ts-ignore
        result += object[property_name];
    }
    return result;
}
/**
 * Removes all duplicates from an array.
 *
 * Idea is copied 2021-10-06 from https://stackoverflow.com/a/33121880/2754026
 */
function uniqueArray(array) {
    return [...new Set(array)];
}
/**
 * Opens a web browser in the specified URL.
 * @param url
 */
function gotoURL(url) {
    electron.shell.openExternal(url); // This returns a promise, but it can be ignored as there's nothing to do after opening the browser.
}
function generateObsidianCommandName(plugin, shell_command, alias) {
    const prefix = plugin.settings.obsidian_command_palette_prefix;
    if (alias) {
        // If an alias is set for the command, Obsidian's command palette should display the alias text instead of the actual command.
        return prefix + alias;
    }
    return prefix + shell_command;
}
function isInteger(value, allow_minus) {
    if (allow_minus) {
        return !!value.match(/^-?\d+$/u);
    }
    else {
        return !!value.match(/^\d+$/u);
    }
}
/**
 * Translates 1-indexed caret line and column to a 0-indexed EditorPosition object. Also translates a possibly negative line
 * to a positive line from the end of the file, and a possibly negative column to a positive column from the end of the line.
 * @param editor
 * @param caret_line
 * @param caret_column
 */
function prepareEditorPosition(editor, caret_line, caret_column) {
    // Determine line
    if (caret_line < 0) {
        // Negative line means to calculate it from the end of the file.
        caret_line = Math.max(0, editor.lastLine() + caret_line + 1);
    }
    else {
        // Positive line needs just a small adjustment.
        // Editor line is zero-indexed, line numbers are 1-indexed.
        caret_line -= 1;
    }
    // Determine column
    if (caret_column < 0) {
        // Negative column means to calculate it from the end of the line.
        caret_column = Math.max(0, editor.getLine(caret_line).length + caret_column + 1);
    }
    else {
        // Positive column needs just a small adjustment.
        // Editor column is zero-indexed, column numbers are 1-indexed.
        caret_column -= 1;
    }
    return {
        line: caret_line,
        ch: caret_column,
    };
}
function getSelectionFromTextarea(textarea_element, return_null_if_empty) {
    const selected_text = textarea_element.value.substring(textarea_element.selectionStart, textarea_element.selectionEnd);
    return "" === selected_text && return_null_if_empty ? null : selected_text;
}
/**
 * Creates an HTMLElement (with freely decidable tag) and adds the given content into it as normal text. No HTML formatting
 * is supported, i.e. possible HTML special characters are shown as-is. Newline characters are converted to <br> elements.
 *
 * @param tag
 * @param content
 * @param parent_element
 */
function createMultilineTextElement(tag, content, parent_element) {
    const content_element = parent_element.createEl(tag);
    // Insert content line-by-line
    const content_lines = content.split(/\r\n|\r|\n/g); // Don't use ( ) with | because .split() would then include the newline characters in the resulting array.
    content_lines.forEach((content_line, content_line_index) => {
        // Insert the line.
        content_element.insertAdjacentText("beforeend", content_line);
        // Insert a linebreak <br> if needed.
        if (content_line_index < content_lines.length - 1) {
            content_element.insertAdjacentHTML("beforeend", "<br>");
        }
    });
    return content_element;
}
function randomInteger(min, max) {
    const range = max - min + 1;
    return min + Math.floor(Math.random() * range);
}
/**
 * Does the following prefixings:
 *   \ will become \\
 *   [ will become \[
 *   ] will become \]
 *   ( will become \(
 *   ) will become \)
 *
 * @param content
 */
function escapeMarkdownLinkCharacters(content) {
    // TODO: \[ can be replaced with [ as eslint suggests and ten remove the ignore line below. I'm not doing it now because it would be outside of the scope of this commit/issue #70.
    // eslint-disable-next-line no-useless-escape
    return content.replace(/[\\()\[\]]/gu, "\\$&");
}
function copyToClipboard(text) {
    return electron.clipboard.writeText(text);
}
async function getFileContentWithoutYAML(app, file) {
    return new Promise((resolve) => {
        // The logic is borrowed 2022-09-01 from https://forum.obsidian.md/t/how-to-get-current-file-content-without-yaml-frontmatter/26197/2
        // Thank you, endorama! <3
        const file_content = app.vault.read(file);
        file_content.then((file_content) => {
            const frontmatter_cache = app.metadataCache.getFileCache(file)?.frontmatter;
            if (frontmatter_cache) {
                // A YAML frontmatter is present in the file.
                const frontmatter_end_line_number = frontmatter_cache.position.end.line + 1; // + 1: Take the last --- line into account, too.
                const file_content_without_frontmatter = file_content.split("\n").slice(frontmatter_end_line_number).join("\n");
                return resolve(file_content_without_frontmatter);
            }
            else {
                // No YAML frontmatter is present in the file.
                // Return the whole file content, because there's nothing to remove.
                return resolve(file_content);
            }
        });
    });
}
async function getFileYAML(app, file, withDashes) {
    return new Promise((resolve) => {
        // The logic is borrowed 2022-09-01 from https://forum.obsidian.md/t/how-to-get-current-file-content-without-yaml-frontmatter/26197/2
        // Thank you, endorama! <3
        const fileContent = app.vault.read(file);
        fileContent.then((file_content) => {
            const frontmatterCache = app.metadataCache.getFileCache(file)?.frontmatter;
            if (frontmatterCache) {
                // A YAML frontmatter is present in the file.
                const frontmatterEndLineNumber = frontmatterCache.position.end.line + 1; // + 1: Take the last --- line into account, too.
                let firstLine;
                let lastLine;
                if (withDashes) {
                    // Take full YAML content, including --- lines at the top and bottom.
                    firstLine = 0;
                    lastLine = frontmatterEndLineNumber;
                }
                else {
                    // Exclude --- lines.
                    firstLine = 1;
                    lastLine = frontmatterEndLineNumber - 1;
                }
                const frontmatterContent = file_content.split("\n").slice(firstLine, lastLine).join("\n");
                return resolve(frontmatterContent);
            }
            else {
                // No YAML frontmatter is present in the file.
                return resolve(null);
            }
        });
    });
}

/**
 * Escapes a string that will be used as a pattern in a regular expression.
 *
 * Note that this does not escape minus: - . It's probably ok as long as you won't wrap the result of this function in square brackets [ ] . For more information, read a comment by coolaj86 on Nov 29, 2019 at 2:44 in this Stack Overflow answer: https://stackoverflow.com/a/6969486/2754026
 *
 * Copied 2022-03-10 from https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Regular_Expressions#escaping
 * Modifications:
 *  - Added TypeScript data type hints for the parameter and return value.
 *  - Added 'export' keyword.
 *  - Added this JSDoc.
 *  - No other changes.
 *
 * @param string
 * @return string
 */
function escapeRegExp(string) {
    return string.replace(/[.*+?^${}()|[\]\\]/g, '\\$&'); // $& means the whole matched string
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
const DocumentationMainLink = "https://publish.obsidian.md/shellcommands";
const DocumentationBuiltInVariablesBaseLink = "https://publish.obsidian.md/shellcommands/Variables/"; // When used, a variable's name will be appended to the end. Keep the trailing slash!
const DocumentationBuiltInVariablesIndexLink = "https://publish.obsidian.md/shellcommands/Variables/Variables+-+general+principles#All+variables";
const DocumentationCustomVariablesLink = "https://publish.obsidian.md/shellcommands/Variables/Custom+variables";
const DocumentationAutocompleteLink = "https://publish.obsidian.md/shellcommands/Variables/Autocomplete/Autocomplete";
const DocumentationEventsFolderLink = "https://publish.obsidian.md/shellcommands/Events/";
const DocumentationPATHAugmentationsLink = "https://publish.obsidian.md/shellcommands/Environments/Additions+to+the+PATH+environment+variable";
const DocumentationOutputWrappersLink = "https://publish.obsidian.md/shellcommands/Output+handling/Output+wrappers";
const DocumentationOutputHandlingModeLink = "https://publish.obsidian.md/shellcommands/Output+handling/Realtime+output+handling";
const DocumentationStdinContentLink = "https://publish.obsidian.md/shellcommands/Variables/Pass+variables+to+stdin";
const GitHubLink = "https://github.com/Taitava/obsidian-shellcommands";
const ChangelogLink = "https://github.com/Taitava/obsidian-shellcommands/blob/main/CHANGELOG.md";
const LicenseLink = "https://github.com/Taitava/obsidian-shellcommands/blob/main/LICENSE";

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
/**
 * Variables that can be used to inject values to shell commands using {{variable:argument}} syntax.
 */
class Variable {
    constructor(plugin) {
        this.plugin = plugin;
        /**
         * If this is false, the variable can be assigned a default value that can be used in situations where the variable is unavailable.
         * TODO: Set to false, as most Variables are not always available. Then remove all 'always_available = false' lines from subclasses, and add 'always_available = true' to those subclasses that need it.
         * @protected
         */
        this.always_available = true;
        this.app = plugin.app;
    }
    getValue(t_shell_command = null, sc_event = null, variableArguments = {}, 
    /**
     * Will parse variables in a default value (only used if this variable is not available this time). The callback
     * is only used, if t_shell_command is given. Set to null, if no variable parsing is needed for default values.
     * */
    default_value_parser = null) {
        return new Promise((resolve) => {
            // Cast arguments (if any) to their correct data types
            const castedArguments = this.castArguments(variableArguments);
            // Generate a value, or catch an exception if one occurs.
            this.generateValue(castedArguments, sc_event).then((value) => {
                // Value generation succeeded.
                return resolve({
                    value: value,
                    error_messages: [],
                    succeeded: true,
                });
            }).catch((error) => {
                // Caught a VariableError or an Error.
                if (error instanceof VariableError) {
                    // The variable is not available in this situation.
                    debugLog(this.constructor.name + ".getValue(): Caught a VariableError and will determine how to handle it: " + error.message);
                    // Check what should be done.
                    const default_value_configuration = t_shell_command?.getDefaultValueConfigurationForVariable(this); // The method can return undefined, and t_shell_command can be null.
                    const default_value_type = default_value_configuration ? default_value_configuration.type : "show-errors";
                    const debug_message_base = "Variable " + this.getFullName() + " is not available. ";
                    switch (default_value_type) {
                        case "show-errors":
                            // Generate error messages by calling generateValue().
                            debugLog(debug_message_base + "Will prevent shell command execution and show visible error messages.");
                            return resolve({
                                value: null,
                                error_messages: [error.message],
                                succeeded: false,
                            });
                        case "cancel-silently":
                            // Prevent execution, but do not show any errors
                            debugLog(debug_message_base + "Will prevent shell command execution silently without visible error messages.");
                            return resolve({
                                value: null,
                                error_messages: [],
                                succeeded: false,
                            });
                        case "value":
                            // Return a default value.
                            if (!default_value_configuration) {
                                // This should not happen, because default_value_type is never "value" when default_value_configuration is undefined or null.
                                // This check is just for TypeScript compiler to understand that default_value_configuration is defined when it's accessed below.
                                throw new Error("Default value configuration is undefined.");
                            }
                            debugLog(debug_message_base + "Will use a default value: " + default_value_configuration.value);
                            if (default_value_parser) {
                                // Parse possible variables in the default value.
                                default_value_parser(default_value_configuration.value).then((default_value_parsing_result) => {
                                    return resolve({
                                        value: default_value_parsing_result.succeeded
                                            ? default_value_parsing_result.parsed_content
                                            : default_value_parsing_result.original_content,
                                        error_messages: default_value_parsing_result.error_messages,
                                        succeeded: default_value_parsing_result.succeeded,
                                    });
                                });
                            }
                            else {
                                // No variable parsing is wanted.
                                return resolve({
                                    value: default_value_configuration.value,
                                    error_messages: [],
                                    succeeded: true,
                                });
                            }
                            break;
                        default:
                            throw new Error("Unrecognised default value type: " + default_value_type);
                    }
                }
                else {
                    // A program logic error has happened.
                    debugLog(this.constructor.name + ".getValue(): Caught an unrecognised error of class: " + error.constructor.name + ". Will rethrow it.");
                    throw error;
                }
            });
        });
    }
    getParameters() {
        const child_class = this.constructor;
        return child_class.parameters;
    }
    getParameterSeparator() {
        const child_class = this.constructor;
        return child_class.parameter_separator;
    }
    getPattern() {
        const error_prefix = this.variable_name + ".getPattern(): ";
        let pattern = '\\{\\{!?' + escapeRegExp(this.variable_name);
        for (const parameter_name in this.getParameters()) {
            const parameter = this.getParameters()[parameter_name];
            let parameter_type_pattern = this.getParameterSeparator(); // Here this.parameter_separator (= : ) is included in the parameter value just so that it's not needed to do nested parenthesis to accomplish possible optionality: (:())?. parseShellCommandVariables() will remove the leading : .
            // Check should we use parameter.options or parameter.type.
            if (undefined === parameter.options &&
                undefined === parameter.type) {
                // Neither is defined :(
                throw Error(error_prefix + "Parameter '" + parameter_name + "' should define either 'type' or 'options', neither is defined!");
            }
            else if (undefined !== parameter.options &&
                undefined !== parameter.type) {
                // Both are defined :(
                throw Error(error_prefix + "Parameter '" + parameter_name + "' should define either 'type' or 'options', not both!");
            }
            else if (undefined !== parameter.options) {
                // Use parameter.options
                parameter_type_pattern += parameter.options.join("|" + this.getParameterSeparator()); // E.g. "absolute|:relative" for {{file_path:mode}} variable's 'mode' parameter.
            }
            else {
                // Use parameter.type
                switch (parameter.type) {
                    case "string":
                        parameter_type_pattern += ".*?";
                        break;
                    case "integer":
                        parameter_type_pattern += "\\d+";
                        break;
                    default:
                        throw Error(error_prefix + "Parameter '" + parameter_name + "' has an unrecognised type: " + parameter.type);
                }
            }
            // Add the subpattern to 'pattern'.
            pattern += "(" + parameter_type_pattern + ")";
            if (!parameter.required) {
                // Make the parameter optional.
                pattern += "?";
            }
        }
        pattern += '\\}\\}';
        return pattern;
    }
    getParameterNames() {
        return Object.getOwnPropertyNames(this.getParameters());
    }
    /**
     * @param variableArguments String typed arguments. Arguments that should be typed otherly, will be cast to other types. Then all arguments are returned.
     */
    castArguments(variableArguments) {
        const castedArguments = {};
        for (const parameterName of Object.getOwnPropertyNames(variableArguments)) {
            const parameter_type = this.getParameters()[parameterName].type ?? "string"; // If the variable uses "options" instead of "type", then the type is always "string".
            const argument = variableArguments[parameterName];
            switch (parameter_type) {
                case "string":
                    castedArguments[parameterName] = argument;
                    break;
                case "integer":
                    castedArguments[parameterName] = parseInt(argument);
                    break;
            }
        }
        return castedArguments;
    }
    /**
     * Creates a VariableError and passes it to a rejector function, which will pass the VariableError to Variable.getValue().
     * Then it will be handled there according to user preferences.
     *
     * @param message
     * @param rejector
     * @protected
     */
    reject(message, rejector) {
        rejector(this.newVariableError(message));
    }
    /**
     * Similar to Variable.reject(), but uses a traditional throw. Can be used in async methods. For methods that create
     * Promises manually, Variable.reject() should be used, because errors thrown in manually created Promises are not caught
     * by Variable.getValue()'s Promise.catch() callback.
     *
     * @param message
     * @protected
     */
    throw(message) {
        throw this.newVariableError(message);
    }
    newVariableError(message) {
        const prefix = this.getFullName() + ": ";
        return new VariableError(prefix + message);
    }
    getAutocompleteItems() {
        // Check if the variable has at least one _mandatory_ parameter.
        let parameter_indicator = "";
        const parameter_names = Object.getOwnPropertyNames(this.getParameters())
            .filter(parameter_name => this.getParameters()[parameter_name].required === true) // Only include mandatory parameters
        ;
        if (parameter_names.length > 0) {
            parameter_indicator = Variable.parameter_separator; // When the variable name ends with a parameter separator character, it indicates to a user that an argument should be supplied.
        }
        return [
            // Normal variable
            {
                value: "{{" + this.variable_name + parameter_indicator + "}}",
                help_text: (this.help_text + " " + this.getAvailabilityText()).trim(),
                group: "Variables",
                type: "normal-variable",
                documentationLink: this.getDocumentationLink(),
            },
            // Unescaped version of the variable
            {
                value: "{{!" + this.variable_name + parameter_indicator + "}}",
                help_text: (this.help_text + " " + this.getAvailabilityText()).trim(),
                group: "Variables",
                type: "unescaped-variable",
                documentationLink: this.getDocumentationLink(),
            },
        ];
    }
    getHelpName() {
        return "<strong>" + this.getFullName() + "</strong>";
    }
    /**
     * Returns the Variable's name wrapped in {{ and }}.
     *
     * TODO: Change hardcoded {{ }} entries to use this method all around the code.
     */
    getFullName() {
        return "{{" + this.variable_name + "}}";
    }
    /**
     * TODO: Create a class BuiltinVariable and move this method there. This should not be present for CustomVariables.
     */
    getDocumentationLink() {
        return DocumentationBuiltInVariablesBaseLink + encodeURI(this.getFullName());
    }
    /**
     * TODO: Create a class BuiltinVariable and move this method there. This should not be present for CustomVariables.
     */
    createDocumentationLinkElement(container) {
        const description = this.getFullName() + ": " + this.help_text
            + os.EOL + os.EOL +
            "Click for external documentation.";
        container.createEl("a", {
            text: this.getFullName(),
            href: this.getDocumentationLink(),
            attr: { "aria-label": description },
        });
    }
    /**
     * Returns a unique string that can be used in default value configurations.
     * @return Normal variable name, if this is a built-in variable; or an ID string if this is a CustomVariable.
     */
    getIdentifier() {
        return this.getFullName();
    }
    /**
     * This can be used to determine if the variable can sometimes be unavailable. Used in settings to allow a user to define
     * default values for variables that are not always available, filtering out always available variables for which default
     * values would not make sense.
     */
    isAlwaysAvailable() {
        return this.always_available;
    }
    /**
     * For variables that are always available, returns an empty string.
     */
    getAvailabilityText() {
        return "";
    }
    /**
     * Same as getAvailabilityText(), but removes HTML from the result.
     */
    getAvailabilityTextPlain() {
        return this.getAvailabilityText().replace(/<\/?strong>/ig, ""); // Remove <strong> and </strong> markings from the help text
    }
    /**
     * Returns a default value configuration object that should be used if a shell command does not define its own
     * default value configuration object.
     */
    getGlobalDefaultValueConfiguration() {
        // Works for built-in variables only. CustomVariable class needs to override this method and not call the parent!
        return this.plugin.settings.builtin_variables[this.getIdentifier()]?.default_value; // Can return null
    }
}
Variable.parameter_separator = ":";
/**
 * A definition for what parameters this variables takes.
 * @protected
 */
Variable.parameters = {};
/**
 * Thrown when Variables encounter errors that users should solve. Variable.getValue() will catch these and show to user
 * (unless errors are ignored).
 */
class VariableError extends Error {
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class Variable_Output extends Variable {
    constructor(plugin, output_content) {
        super(plugin);
        this.output_content = output_content;
        this.variable_name = "output";
        this.help_text = "Gives text outputted by a shell command after it's executed.";
    }
    async generateValue() {
        return this.output_content;
    }
    getAvailabilityText() {
        return "<strong>Only available</strong> in <em>output wrappers</em>, cannot be used as input for shell commands.";
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class Escaper {
    constructor(raw_value) {
        this.raw_value = raw_value;
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
/**
 * Prefixes all characters that are not letters, numbers or underscores with a prefix character that can be defined by child classes.
 */
class AllSpecialCharactersEscaper extends Escaper {
    escape() {
        return this.raw_value.replace(/[^\w\d]/gu, (special_character) => {
            // Do the replacing in a function in order to avoid a possible $ character to be interpreted by JavaScript to interact with the regex.
            // More information: https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/replace#specifying_a_string_as_a_parameter (referenced 2021-11-02.
            return this.prefix + special_character;
        });
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class ShEscaper extends AllSpecialCharactersEscaper {
    constructor() {
        super(...arguments);
        this.prefix = "\\"; // In *sh, escaping should use a backslash, e.g. "Hello, world!" becomes \"Hello\,\ world\!\"
    }
    escape() {
        return this.replace_newlines(super.escape());
    }
    /**
     * Converts escaped newline characters to a form that the Bourne family shells will interpret as literal newlines,
     * not as ignorable characters.
     *
     * @param escaped_value
     * @private
     */
    replace_newlines(escaped_value) {
        return escaped_value
            .replaceAll(this.prefix + "\r", this.prefix + this.prefix + "r") // Replace a real linefeed with a literal "\\r".
            .replaceAll(this.prefix + "\n", this.prefix + this.prefix + "n") // Replace a real newline with a literal "\\n".
        ;
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class PowerShellEscaper extends AllSpecialCharactersEscaper {
    constructor() {
        super(...arguments);
        this.prefix = "`"; // In PowerShell, escaping should use a ` character, e.g. "Hello, world!" becomes `"Hello`,` world`!`"
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
function escapeValue(shell, raw_value) {
    shell = extractFileName(shell.toLowerCase());
    let escaper;
    switch (shell) {
        case "bash":
        case "dash":
        case "zsh":
        case "sh": // May sometimes appear when using the "Use system default (sh)" option as a default shell.
            escaper = new ShEscaper(raw_value);
            break;
        case "powershell.exe": // PowerShell 5 is only available for Windows.
        case "pwsh.exe": // In Windows.
        case "pwsh": // In Linux and Mac. (SC does not actually support using PowerShell on Linux/Mac just yet, but support can be added).
            escaper = new PowerShellEscaper(raw_value);
            break;
        case "cmd.exe":
            // Exception: There is no escaping support for CMD, so all values will be left unescaped when CMD is used. :(
            return raw_value;
        default:
            // Shell was not recognised.
            new obsidian.Notice("EscapeValue(): Unrecognised shell: " + shell);
            throw new Error("EscapeValue(): Unrecognised shell: " + shell);
    }
    return escaper.escape();
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class Variable_Clipboard extends Variable {
    constructor() {
        super(...arguments);
        this.variable_name = "clipboard";
        this.help_text = "Gives the content you last copied to your clipboard.";
    }
    async generateValue() {
        return electron.clipboard.readText();
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class EditorVariable extends Variable {
    constructor() {
        super(...arguments);
        this.always_available = false;
    }
    getEditorOrThrow() {
        const editor = getEditor(this.app);
        if (null === editor) {
            // No editor.
            this.throw("Could not get an editor instance! Please create a discussion in GitHub.");
        }
        return editor;
    }
    /**
     * Can be made protected if needed to be accessed by subclasses.
     * @private
     */
    getViewOrThrow() {
        const view = getView(this.app);
        if (null === view) {
            // No view.
            this.throw("Could not get a view instance! Please create a discussion in GitHub.");
        }
        return view;
    }
    requireViewModeSource() {
        const view = this.getViewOrThrow();
        const view_mode = view.getMode(); // "preview" or "source" ("live" was removed from Obsidian API in 0.13.8 on 2021-12-10).
        switch (view_mode) {
            case "preview":
                // The leaf is in preview mode, which makes things difficult.
                // FIXME: Make it possible to use this feature also in preview mode.
                debugLog("EditorVariable: 'view' is in preview mode, and the poor guy who wrote this code, does not know how to return an editor instance that could be used for getting text selection.");
                this.throw("You need to turn editing mode on, unfortunately this variable does not work in preview mode.");
                break;
            case "source":
                // Good, the editor is in "source" mode, so it's possible to get a selection, caret position or other editing related information.
                return;
            default:
                this.throw("Unrecognised view mode: " + view_mode);
                break;
        }
    }
    getAvailabilityText() {
        return "<strong>Only available</strong> when a note pane is open, not in graph view, nor when viewing non-text files.";
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact:
 *  - Vinay Rajur: https://github.com/vrajur
 *  - Jarkko Linnanvirta: https://github.com/Taitava/
 */
class Variable_CaretPosition extends EditorVariable {
    constructor() {
        super(...arguments);
        this.variable_name = "caret_position";
        this.help_text = "Gives the line number and column position of the current caret position as 'line:column'. Get only the line number using {{caret_position:line}}, and only the column with {{caret_position:column}}. Line and column numbers are 1-indexed.";
    }
    async generateValue(castedArguments) {
        // Check that we are able to get an editor
        const editor = this.getEditorOrThrow();
        const position = editor.getCursor('to');
        const line = position.line + 1; // editor position is zero-indexed, line numbers are 1-indexed
        const column = position.ch + 1; // editor position is zero-indexed, column positions are 1-indexed
        if (undefined !== castedArguments.mode) {
            switch (castedArguments.mode.toLowerCase()) {
                case "line":
                    return `${line}`;
                case "column":
                    return `${column}`;
                default:
                    this.throw("Unrecognised argument: " + castedArguments.mode);
            }
        }
        else {
            // default case when no args provided
            return `${line}:${column}`;
        }
    }
    getAutocompleteItems() {
        return [
            // Normal variables
            {
                value: "{{" + this.variable_name + "}}",
                help_text: "Gives the line number and column position of the current caret position as 'line:column'. " + this.getAvailabilityText(),
                group: "Variables",
                type: "normal-variable",
                documentationLink: this.getDocumentationLink(),
            },
            {
                value: "{{" + this.variable_name + ":line}}",
                help_text: "Gives the line number of the current caret position. " + this.getAvailabilityText(),
                group: "Variables",
                type: "normal-variable",
                documentationLink: this.getDocumentationLink(),
            },
            {
                value: "{{" + this.variable_name + ":column}}",
                help_text: "Gives the column number of the current caret position. " + this.getAvailabilityText(),
                group: "Variables",
                type: "normal-variable",
                documentationLink: this.getDocumentationLink(),
            },
            // Unescaped variables
            {
                value: "{{!" + this.variable_name + "}}",
                help_text: "Gives the line number and column position of the current caret position as 'line:column'. " + this.getAvailabilityText(),
                group: "Variables",
                type: "unescaped-variable",
                documentationLink: this.getDocumentationLink(),
            },
            {
                value: "{{!" + this.variable_name + ":line}}",
                help_text: "Gives the line number of the current caret position. " + this.getAvailabilityText(),
                group: "Variables",
                type: "unescaped-variable",
                documentationLink: this.getDocumentationLink(),
            },
            {
                value: "{{!" + this.variable_name + ":column}}",
                help_text: "Gives the column number of the current caret position. " + this.getAvailabilityText(),
                group: "Variables",
                type: "unescaped-variable",
                documentationLink: this.getDocumentationLink(),
            },
        ];
    }
    getHelpName() {
        return "<strong>{{caret_position}}</strong>, <strong>{{caret_position:line}}</strong> or <strong>{{caret_position:column}}</strong>";
    }
    getAvailabilityText() {
        return super.getAvailabilityText() + " Not available in preview mode.";
    }
}
Variable_CaretPosition.parameters = {
    mode: {
        options: ["line", "column"],
        required: false,
    },
};

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class Variable_Date extends Variable {
    constructor() {
        super(...arguments);
        this.variable_name = "date";
        this.help_text = "Gives a date/time stamp as per your liking. The \"format\" part can be customized and is mandatory. Formatting options: https://momentjs.com/docs/#/displaying/format/";
    }
    async generateValue(castedArguments) {
        return obsidian.moment().format(castedArguments.format);
    }
}
Variable_Date.parameters = {
    format: {
        type: "string",
        required: true,
    },
};

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
/**
 * TODO: Consider creating a decorator class for TFolder and moving this function to be a method in it.
 *
 * @param app
 * @param folder
 * @param mode
 */
function getFolderPath(app, folder, mode) {
    switch (mode.toLowerCase()) {
        case "absolute":
            return normalizePath2(getVaultAbsolutePath(app) + "/" + folder.path);
        case "relative":
            if (folder.isRoot()) {
                // Obsidian API does not give a correct folder.path value for the vault's root folder.
                // TODO: See this discussion and apply possible changes if something will come up: https://forum.obsidian.md/t/vault-root-folders-relative-path-gives/24857
                return ".";
            }
            else {
                // This is a normal subfolder
                return normalizePath2(folder.path); // Normalize to get a correct slash between directories depending on platform. On Windows it should be \ .
            }
    }
}
/**
 * TODO: Consider creating a decorator class for TFile and moving this function to be a method in it.
 *
 * @param app
 * @param file
 * @param mode
 */
function getFilePath(app, file, mode) {
    switch (mode.toLowerCase()) {
        case "absolute":
            return normalizePath2(getVaultAbsolutePath(app) + "/" + file.path);
        case "relative":
            return normalizePath2(file.path); // Normalize to get a correct slash depending on platform. On Windows it should be \ .
    }
}
/**
 * TODO: Consider creating a decorator class for TFile and moving this function to be a method in it.
 * @param file
 * @param with_dot
 */
function getFileExtension(file, with_dot) {
    const file_extension = file.extension;
    // Should the extension be given with or without a dot?
    if (with_dot) {
        // A preceding dot must be included.
        if (file_extension.length > 0) {
            // But only if the extension is not empty.
            return "." + file_extension;
        }
    }
    // No dot should be included, or the extension is empty
    return file_extension;
}
function getFileTags(app, file) {
    const cache = app.metadataCache.getFileCache(file);
    if (!cache) {
        throw new Error("Could not get metadata cache.");
    }
    // Get tags. May include duplicates, if a tag is defined multiple times in the same file.
    const tagsIncludingDuplicates = obsidian.getAllTags(cache) ?? []; // ?? [] = in case null is returned, convert it to an empty array. I have no clue in which situation this might happen. Maybe if the file does not contain any tags?
    // Iron out possible duplicates.
    const tagsWithoutDuplicates = uniqueArray(tagsIncludingDuplicates);
    // Remove preceding hash characters. E.g. #tag becomes tag
    tagsWithoutDuplicates.forEach((tag, index) => {
        tagsWithoutDuplicates[index] = tag.replace("#", "");
    });
    return tagsWithoutDuplicates;
}
/**
 * @param app
 * @param file
 * @param property_path
 * @return string|string[] Either a result string, or an array of error messages.
 */
function getFileYAMLValue(app, file, property_path) {
    const error_messages = [];
    const property_parts = property_path.split(".");
    // Validate all property names along the path
    property_parts.forEach((property_name) => {
        if (0 === property_name.length) {
            error_messages.push("YAML property '" + property_path + "' has an empty property name. Remove possible double dots or a preceding/trailing dot.");
        }
    });
    if (error_messages.length > 0) {
        // Failure in property name(s).
        return error_messages;
    }
    const frontmatter = app.metadataCache.getFileCache(file)?.frontmatter;
    // Check that a YAML section is available in the file
    if (undefined === frontmatter) {
        // No it ain't.
        error_messages.push("No YAML frontmatter section is defined for the current file.");
        return error_messages;
    }
    else {
        // A YAML section is available.
        // Read the property's value.
        return nested_read(property_parts, property_path, frontmatter);
    }
    /**
     * @param property_parts Property path split into parts (= property names). The deeper the nesting goes, the fewer values will be left in this array. This should always contain at least one part! If not, an Error is thrown.
     * @param property_path The original, whole property path string.
     * @param yaml_object
     * @return string|string[] Either a result string, or an array of error messages.
     */
    function nested_read(property_parts, property_path, yaml_object) {
        // Check that property_parts contains at least one part.
        if (property_parts.length === 0) {
            throw new Error("No more property parts to read!");
        }
        let property_name = property_parts.shift(); // as string: Tell TypeScript that the result is not undefined, because the array is not empty.
        // Check if the property name is a negative numeric index.
        if (property_name.match(/^-\d+$/u)) {
            // The property name is a negative number.
            // Check that yaml_object contains at least one element.
            const yaml_object_keys = Object.getOwnPropertyNames(yaml_object).filter(key => key !== "length"); // All _really custom_ yaml keys, not .length
            if (yaml_object_keys.length > 0) {
                // Check if yaml_object happens to be an indexed list.
                let is_indexed_list = true;
                yaml_object_keys.forEach((key) => {
                    if (!key.match(/^\d+$/u)) {
                        // At least one non-numeric key was found, so consider the object not to be an indexed list.
                        is_indexed_list = false;
                    }
                });
                if (is_indexed_list) {
                    // The object is an indexed list and property_name is a negative index number.
                    // Translate property_name to a positive index from the end of the list.
                    property_name = Math.max(0, // If a greatly negative index is used (e.g. -999), don't allow the new index to be negative again.
                    yaml_object_keys.length
                        + parseInt(property_name) // Although + is used, this will be a subtraction, because property_name is prefixed with a minus.
                    ).toString();
                }
            }
        }
        // Get a value
        const property_value = yaml_object[property_name];
        // Check if the value is either: not found, object, or literal.
        if (undefined === property_value) {
            // Property was not found.
            error_messages.push("YAML property '" + property_name + "' is not found.");
            return error_messages;
        }
        else if (null === property_value) {
            // Property is found, but has an empty value. Example:
            //   ---
            //   itemA: valueA
            //   itemB:
            //   itemC: valueC
            //   ---
            // Here `itemB` would have a null value.
            error_messages.push("YAML property '" + property_name + "' has a null value. Make sure the property is not accidentally left empty.");
            return error_messages;
        }
        else if ("object" === typeof property_value) {
            // The value is an object.
            // Check if we have still dot notation parts left in the property path.
            if (0 === property_parts.length) {
                // No dot notation parts are left.
                // Freak out.
                const nested_elements_keys = Object.getOwnPropertyNames(property_value);
                if (nested_elements_keys.length > 0) {
                    error_messages.push("YAML property '" + property_name + "' contains a nested element with keys: " + nested_elements_keys.join(", ") + ". Use e.g. '" + property_path + "." + nested_elements_keys[0] + "' to get its value.");
                }
                else {
                    error_messages.push("YAML property '" + property_name + "' contains a nested element. Use a property name that points to a literal value instead.");
                }
                return error_messages;
            }
            else {
                // Dot notation path still has another property name left, so continue the hunt.
                return nested_read(property_parts, property_path, property_value);
            }
        }
        else {
            // The value is literal, i.e. a string or number.
            if (property_parts.length > 0) {
                error_messages.push("YAML property '" + property_name + "' gives already a literal value '" + property_value.toString() + "', but the argument '" + property_path + "' assumes the property would contain a nested element with the key '" + property_parts[0] + "'.");
                return error_messages;
            }
            else {
                return property_value.toString();
            }
        }
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class FileVariable extends Variable {
    constructor() {
        super(...arguments);
        this.always_available = false;
    }
    getFileOrThrow() {
        const currentFile = this.app.workspace.getActiveFile();
        if (!currentFile) {
            this.throw("No file is active at the moment. Open a file or click a pane that has a file open.");
        }
        return currentFile;
    }
    getAvailabilityText() {
        return "<strong>Only available</strong> when the active pane contains a file, not in graph view or other non-file view.";
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class Variable_FileExtension extends FileVariable {
    constructor() {
        super(...arguments);
        this.variable_name = "file_extension";
        this.help_text = "Gives the current file name's ending. Use {{file_extension:with-dot}} to include a preceding dot. If the extension is empty, no dot is added. {{file_extension:no-dot}} never includes a dot.";
    }
    async generateValue(castedArguments) {
        return getFileExtension(this.getFileOrThrow(), castedArguments.dot === "with-dot");
    }
    getAutocompleteItems() {
        return [
            // Normal variables
            {
                value: "{{" + this.variable_name + ":no-dot}}",
                help_text: "Gives the current file name's ending without a preceding dot. " + this.getAvailabilityText(),
                group: "Variables",
                type: "normal-variable",
                documentationLink: this.getDocumentationLink(),
            },
            {
                value: "{{" + this.variable_name + ":with-dot}}",
                help_text: "Gives the current file name's ending with a preceding dot. If the extension is empty, no dot is included. " + this.getAvailabilityText(),
                group: "Variables",
                type: "normal-variable",
                documentationLink: this.getDocumentationLink(),
            },
            // Unescaped variables
            {
                value: "{{!" + this.variable_name + ":no-dot}}",
                help_text: "Gives the current file name's ending without a preceding dot. " + this.getAvailabilityText(),
                group: "Variables",
                type: "unescaped-variable",
                documentationLink: this.getDocumentationLink(),
            },
            {
                value: "{{!" + this.variable_name + ":with-dot}}",
                help_text: "Gives the current file name's ending with a preceding dot. If the extension is empty, no dot is included. " + this.getAvailabilityText(),
                group: "Variables",
                type: "unescaped-variable",
                documentationLink: this.getDocumentationLink(),
            },
        ];
    }
    getHelpName() {
        return "<strong>{{file_extension:with-dot}}</strong> or <strong>{{file_extension:no-dot}}</strong>";
    }
}
Variable_FileExtension.parameters = {
    "dot": {
        options: ["with-dot", "no-dot"],
        required: true,
    },
};

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class Variable_FileName extends FileVariable {
    constructor() {
        super(...arguments);
        this.variable_name = "file_name";
        this.help_text = "Gives the current file name with a file extension. If you need it without the extension, use {{title}} instead.";
    }
    async generateValue() {
        return this.getFileOrThrow().name;
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class Variable_FilePath extends FileVariable {
    constructor() {
        super(...arguments);
        this.variable_name = "file_path";
        this.help_text = "Gives path to the current file, either as absolute from the root of the file system, or as relative from the root of the Obsidian vault.";
    }
    async generateValue(castedArguments) {
        return getFilePath(this.app, this.getFileOrThrow(), castedArguments.mode);
    }
    getAutocompleteItems() {
        return [
            // Normal variables
            {
                value: "{{" + this.variable_name + ":absolute}}",
                help_text: "Gives path to the current file, absolute from the root of the file system. " + this.getAvailabilityText(),
                group: "Variables",
                type: "normal-variable",
                documentationLink: this.getDocumentationLink(),
            },
            {
                value: "{{" + this.variable_name + ":relative}}",
                help_text: "Gives path to the current file, relative from the root of the Obsidian vault. " + this.getAvailabilityText(),
                group: "Variables",
                type: "normal-variable",
                documentationLink: this.getDocumentationLink(),
            },
            // Unescaped variables
            {
                value: "{{!" + this.variable_name + ":absolute}}",
                help_text: "Gives path to the current file, absolute from the root of the file system. " + this.getAvailabilityText(),
                group: "Variables",
                type: "unescaped-variable",
                documentationLink: this.getDocumentationLink(),
            },
            {
                value: "{{!" + this.variable_name + ":relative}}",
                help_text: "Gives path to the current file, relative from the root of the Obsidian vault. " + this.getAvailabilityText(),
                group: "Variables",
                type: "unescaped-variable",
                documentationLink: this.getDocumentationLink(),
            },
        ];
    }
    getHelpName() {
        return "<strong>{{file_path:relative}}</strong> or <strong>{{file_path:absolute}}</strong>";
    }
}
Variable_FilePath.parameters = {
    mode: {
        options: ["absolute", "relative"],
        required: true,
    },
};

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class FolderVariable extends FileVariable {
    getFolderOrThrow() {
        // Get current file's parent folder.
        const file = this.getFileOrThrow();
        const currentFolder = file.parent;
        if (!currentFolder) {
            // No parent folder.
            this.throw("The current file does not have a parent for some strange reason.");
        }
        return currentFolder;
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class Variable_FolderName extends FolderVariable {
    constructor() {
        super(...arguments);
        this.variable_name = "folder_name";
        this.help_text = "Gives the current file's parent folder name, or a dot if the folder is the vault's root. No ancestor folders are included.";
    }
    async generateValue() {
        const folder = this.getFolderOrThrow();
        return folder.isRoot()
            ? "." // Return a dot instead of an empty string.
            : folder.name;
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class Variable_FolderPath extends FolderVariable {
    constructor() {
        super(...arguments);
        this.variable_name = "folder_path";
        this.help_text = "Gives path to the current file's parent folder, either as absolute from the root of the file system, or as relative from the root of the Obsidian vault.";
    }
    async generateValue(castedArguments) {
        return getFolderPath(this.app, this.getFolderOrThrow(), castedArguments.mode);
    }
    getAutocompleteItems() {
        return [
            // Normal variables
            {
                value: "{{" + this.variable_name + ":absolute}}",
                help_text: "Gives path to the current file's parent folder, absolute from the root of the file system. " + this.getAvailabilityText(),
                group: "Variables",
                type: "normal-variable",
                documentationLink: this.getDocumentationLink(),
            },
            {
                value: "{{" + this.variable_name + ":relative}}",
                help_text: "Gives path to the current file's parent folder, relative from the root of the Obsidian vault. " + this.getAvailabilityText(),
                group: "Variables",
                type: "normal-variable",
                documentationLink: this.getDocumentationLink(),
            },
            // Unescaped variables
            {
                value: "{{!" + this.variable_name + ":absolute}}",
                help_text: "Gives path to the current file's parent folder, absolute from the root of the file system. " + this.getAvailabilityText(),
                group: "Variables",
                type: "unescaped-variable",
                documentationLink: this.getDocumentationLink(),
            },
            {
                value: "{{!" + this.variable_name + ":relative}}",
                help_text: "Gives path to the current file's parent folder, relative from the root of the Obsidian vault. " + this.getAvailabilityText(),
                group: "Variables",
                type: "unescaped-variable",
                documentationLink: this.getDocumentationLink(),
            },
        ];
    }
    getHelpName() {
        return "<strong>{{folder_path:relative}}</strong> or <strong>{{folder_path:absolute}}</strong>";
    }
}
Variable_FolderPath.parameters = {
    mode: {
        options: ["absolute", "relative"],
        required: true,
    }
};

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class Variable_Selection extends EditorVariable {
    constructor() {
        super(...arguments);
        this.variable_name = "selection";
        this.help_text = "Gives the currently selected text.";
    }
    async generateValue() {
        // Check that we are able to get an editor
        const editor = this.getEditorOrThrow();
        // Check the view mode
        this.requireViewModeSource();
        // Good, the editor is in "source" mode, so it's possible to get a selection.
        if (editor.somethingSelected()) {
            return editor.getSelection();
        }
        this.throw("Nothing is selected. " + os.EOL + os.EOL + "(This error message was added in SC 0.18.0. Earlier the variable gave an empty text in this situation. If you want to restore the old behavior, go to SC settings, then to Variables tab, and define a default value for {{selection}}.)");
    }
    getAvailabilityText() {
        return "<strong>Only available</strong> when something is selected in <em>Editing</em>/<em>Live preview</em> mode, <strong>not</strong> in <em>Reading</em> mode.";
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class Variable_Tags extends FileVariable {
    constructor() {
        super(...arguments);
        this.variable_name = "tags";
        this.help_text = "Gives all tags defined in the current note. Replace the \"separator\" part with a comma, space or whatever characters you want to use as a separator between tags. A separator is always needed to be defined.";
    }
    async generateValue(castedArguments) {
        return getFileTags(this.app, this.getFileOrThrow()).join(castedArguments.separator);
    }
}
Variable_Tags.parameters = {
    separator: {
        type: "string",
        required: true,
    }
};

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class Variable_Title extends FileVariable {
    constructor() {
        super(...arguments);
        this.variable_name = "title";
        this.help_text = "Gives the current file name without a file extension. If you need it with the extension, use {{file_name}} instead.";
    }
    async generateValue() {
        return this.getFileOrThrow().basename;
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class Variable_VaultPath extends Variable {
    constructor() {
        super(...arguments);
        this.variable_name = "vault_path";
        this.help_text = "Gives the Obsidian vault's absolute path from the root of the filesystem. This is the same that is used as a default working directory if you do not define one manually. If you define a working directory manually, this variable won't give you your manually defined directory, it always gives the vault's root directory.";
    }
    async generateValue() {
        return getVaultAbsolutePath(this.app);
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class Variable_Workspace extends Variable {
    constructor() {
        super(...arguments);
        this.variable_name = "workspace";
        this.help_text = "Gives the current workspace's name.";
        this.always_available = false;
    }
    async generateValue() {
        // Idea how to access the workspaces plugin is copied 2021-09-15 from https://github.com/Vinzent03/obsidian-advanced-uri/blob/f7ef80d5252481242e69496208e925874209f4aa/main.ts#L168-L179
        // @ts-ignore internalPlugins exists, although it's not in obsidian.d.ts.
        const workspaces_plugin = this.app.internalPlugins?.plugins?.workspaces;
        if (!workspaces_plugin) {
            this.throw("Workspaces core plugin is not found for some reason. Please create a discussion in GitHub.");
        }
        else if (!workspaces_plugin.enabled) {
            this.throw("Workspaces core plugin is not enabled.");
        }
        const workspace_name = workspaces_plugin.instance?.activeWorkspace;
        if (!workspace_name) {
            this.throw("Could not figure out the current workspace's name. Probably you have not loaded a workspace. You can do it e.g. via \"Manage workspaces\" from the left side panel.");
        }
        // All ok
        return workspace_name;
    }
    getAvailabilityText() {
        return "<strong>Only available</strong> when the Workspaces core plugin is enabled.";
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class Variable_Passthrough extends Variable {
    constructor() {
        super(...arguments);
        this.variable_name = "passthrough";
        this.help_text = "Gives the same value that is passed as an argument. Used for testing special characters' escaping.";
    }
    async generateValue(castedArguments) {
        // Simply return the argument that was received.
        return castedArguments.value;
    }
    getAvailabilityText() {
        return "<strong>Only available</strong> in debug mode.";
    }
}
Variable_Passthrough.parameters = {
    value: {
        type: "string",
        required: true,
    }
};

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class Variable_YAMLValue extends FileVariable {
    constructor() {
        super(...arguments);
        this.variable_name = "yaml_value";
        this.help_text = "Reads a single value from the current file's frontmatter. Takes a property name as an argument. You can access nested properties with dot notation: property1.property2";
    }
    async generateValue(castedArguments) {
        // We do have an active file
        const result = getFileYAMLValue(this.app, this.getFileOrThrow(), castedArguments.property_name);
        if (Array.isArray(result)) {
            // The result contains error message(s).
            this.throw(result.join(" "));
        }
        else {
            // The result is ok, it's a string.
            return result;
        }
    }
    getAvailabilityText() {
        return super.getAvailabilityText() + " Also, the given YAML property must exist in the file's frontmatter.";
    }
    getHelpName() {
        return "<strong>{{yaml_value:property}}</strong>";
    }
}
Variable_YAMLValue.parameters = {
    property_name: {
        type: "string",
        required: true,
    },
};

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class EventVariable extends Variable {
    constructor() {
        super(...arguments);
        this.always_available = false;
    }
    /**
     * Every subclass should call this method in their generateValue() before generating a value. This method will throw
     * a VariableError if an incompatible SC_Event is tried to be used with this {{variable}}.
     *
     * @protected
     */
    requireCorrectEvent(sc_event) {
        // 1. Check generally that an event is happening.
        // (Maybe this check is not so important anymore, as sc_event is now received as a parameter instead of from a property, but check just in case.)
        if (!sc_event) {
            this.throw("This variable can only be used during events: " + this.getSummaryOfSupportedEvents());
        }
        // 2. Check particularly which event it is.
        if (!this.supportsSC_Event(sc_event.getClass())) {
            this.throw("This variable does not support event '" + sc_event.static().getTitle() + "'. Supported events: " + this.getSummaryOfSupportedEvents());
        }
    }
    supportsSC_Event(sc_event_class) {
        return this.supported_sc_events.contains(sc_event_class);
    }
    getSummaryOfSupportedEvents() {
        const sc_event_titles = [];
        this.supported_sc_events.forEach((sc_event_class) => {
            sc_event_titles.push(sc_event_class.getTitle());
        });
        return sc_event_titles.join(", ");
    }
    getAvailabilityText() {
        return "<strong>Only available</strong> in events: " + this.getSummaryOfSupportedEvents() + ".";
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
/**
 * Named SC_Event instead of just Event, because Event is a class in JavaScript.
 */
class SC_Event {
    constructor(plugin) {
        /**
         * If true, changing the enabled/disabled status of the event permits registering the event immediately, so it can activate
         * anytime. Usually true, but can be set to false if immediate registering tends to trigger the event unnecessarily.
         *
         * Events are always registered when loading the plugin, regardless of this property.
         * @protected
         */
        this.register_after_changing_settings = true;
        this.event_registrations = {};
        this.default_configuration = {
            enabled: false,
        };
        this.plugin = plugin;
        this.app = plugin.app;
        this.subclass_instance = this; // Stores a subclass reference, not a base class reference.
    }
    getClass() {
        return this.subclass_instance.constructor;
    }
    canRegisterAfterChangingSettings() {
        return this.register_after_changing_settings;
    }
    register(t_shell_command) {
        const event_reference = this._register(t_shell_command);
        if (event_reference) {
            this.plugin.registerEvent(event_reference);
            this.event_registrations[t_shell_command.getId()] = event_reference;
        }
    }
    unregister(t_shell_command) {
        // Check if an EventRef is available.
        if (undefined === this.event_registrations[t_shell_command.getId()]) {
            // The event was registered without an EventRef object.
            // Provide a TShellCommand to _unregister() so it can do a custom unregistering.
            this._unregister(t_shell_command);
        }
        else {
            // The event registration had created an EventRef object.
            // Provide the EventRef to _unregister() and forget it afterwards.
            this._unregister(this.event_registrations[t_shell_command.getId()]);
            delete this.event_registrations[t_shell_command.getId()];
        }
    }
    /**
     * Executes a shell command.
     * @param t_shell_command
     * @param parsing_process SC_MenuEvent can use this to pass an already started ParsingProcess instance. If omitted, a new ParsingProcess will be created.
     */
    async trigger(t_shell_command, parsing_process) {
        debugLog(this.constructor.name + ": Event triggers executing shell command id " + t_shell_command.getId());
        // Execute the shell command.
        const executor = new ShellCommandExecutor(this.plugin, t_shell_command, this);
        await executor.doPreactionsAndExecuteShellCommand(parsing_process);
    }
    static getCode() {
        return this.event_code;
    }
    static getTitle() {
        return this.event_title;
    }
    /**
     * Creates a list of variables to the given container element. Each variable is a link to its documentation.
     *
     * @param container
     * @return A boolean indicating whether anything was created or not. Not all SC_Events utilise event variables.
     */
    createSummaryOfEventVariables(container) {
        let hasCreatedElements = false;
        this.getEventVariables().forEach((variable) => {
            if (hasCreatedElements) {
                container.insertAdjacentText("beforeend", ", ");
            }
            hasCreatedElements = true;
            variable.createDocumentationLinkElement(container);
        });
        return hasCreatedElements;
    }
    getEventVariables() {
        const event_variables = [];
        this.plugin.getVariables().forEach((variable) => {
            // Check if the variable is an EventVariable
            if (variable instanceof EventVariable) {
                // Yes it is.
                // Check if the variable supports this particular event.
                if (variable.supportsSC_Event(this.getClass())) {
                    // Yes it supports.
                    event_variables.push(variable);
                }
            }
        });
        return event_variables;
    }
    /**
     * Can be overridden in child classes that need custom settings fields.
     *
     * @param enabled
     */
    getDefaultConfiguration(enabled) {
        const configuration = cloneObject(this.default_configuration);
        configuration.enabled = enabled;
        return configuration;
    }
    getConfiguration(t_shell_command) {
        return t_shell_command.getEventConfiguration(this);
    }
    /**
     * Can be overridden in child classes to provide custom configuration fields for ShellCommandsExtraOptionsModal.
     *
     * @param extra_settings_container
     */
    createExtraSettingsFields(extra_settings_container, t_shell_command) {
        // Most classes do not define custom settings, so for those classes this method does not need to do anything.
    }
    /**
     * Returns all the TShellCommand instances that have enabled this event.
     */
    getTShellCommands() {
        const enabled_t_shell_commands = [];
        Object.values(this.plugin.getTShellCommands()).forEach((t_shell_command) => {
            // Check if this event has been enabled for the shell command.
            if (t_shell_command.isSC_EventEnabled(this.static().event_code)) {
                // Yes, it's enabled.
                enabled_t_shell_commands.push(t_shell_command);
            }
        });
        return enabled_t_shell_commands;
    }
    static() {
        return this.constructor;
    }
    /**
     * Child classes can override this to hook into a situation where a user has enabled an event in settings.
     *
     * @param t_shell_command The TShellCommand instance for which this SC_Event was enabled for.
     */
    onAfterEnabling(t_shell_command) {
        // If an SC_Event does not override this hook method, do nothing.
    }
    static getDocumentationLink() {
        return DocumentationEventsFolderLink + encodeURIComponent(this.event_title);
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class SC_WorkspaceEvent extends SC_Event {
    _register(t_shell_command) {
        // @ts-ignore TODO: Find a way to get a dynamic type for this.workspace_event .
        return this.app.workspace.on(this.workspace_event, this.getTrigger(t_shell_command));
    }
    _unregister(event_reference) {
        this.app.workspace.offref(event_reference);
    }
    getTrigger(t_shell_command) {
        return async (...parameters /* Need to have this ugly parameter thing so that subclasses can define their own parameters. */) => await this.trigger(t_shell_command);
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class SC_MenuEvent extends SC_WorkspaceEvent {
    async addTShellCommandToMenu(t_shell_command, menu) {
        const debugLogBaseMessage = this.constructor.name + ".addTShellCommandToMenu(): ";
        // Create the menu item as soon as possible. (If it's created after 'await parsing_process.process()' below, it won't be shown in the menu for some reason, at least in Obsidian 0.16.1).
        debugLog(debugLogBaseMessage + "Creating a menu item. Container menu: " + menu.constructor.name);
        menu.addItem((menuItem) => {
            let parsing_process;
            // Menu item creation has to happen synchronously - at least on macOS, so:
            // 1. Set first all menu item properties that can be set already:
            //    - A preliminary title: Use shell command alias WITHOUT parsing any possible variables.
            //    - Icon (if defined for the shell command)
            //    - A click handler
            // 2. Then call an asynchronous function that will parse possible variables in the menu title and UPDATE the title. The updating only works on some systems. Systems that will not support the delayed update, will show the first, unparsed title. It's better than nothing.
            // 1. Set properties early.
            let title = t_shell_command.getAliasOrShellCommand(); // May contain unparsed variables.
            debugLog(debugLogBaseMessage + "Setting a preliminary menu title (possible variables are not parsed yet): ", title);
            menuItem.setTitle(title);
            menuItem.setIcon(t_shell_command.getIconId()); // Icon id can be null.
            menuItem.onClick(async () => {
                debugLog(debugLogBaseMessage + "Menu item '" + title + "' is clicked. Will execute shell command id " + t_shell_command.getId() + ".");
                await this.trigger(t_shell_command, parsing_process);
            });
            // 2. Parse variables asynchronously.
            if (this.plugin.settings.preview_variables_in_command_palette) {
                // Start a parsing process ASYNCHRONOUSLY.
                debugLog(debugLogBaseMessage + "Will parse menu title: " + title);
                (async () => {
                    parsing_process = t_shell_command.createParsingProcess(this);
                    if (await parsing_process.process()) {
                        // Parsing succeeded.
                        const parsing_results = parsing_process.getParsingResults();
                        const aliasParsingResult = parsing_results["alias"]; // as ParsingResult: Tells TypeScript that the object exists.
                        const shellCommandParsingResult = parsing_results["shell_command"]; // as ParsingResult: Tells TypeScript that the object exists.
                        title = aliasParsingResult.parsed_content || shellCommandParsingResult.parsed_content; // Try to use a parsed alias, but if no alias is available, use a parsed shell command instead. as string = parsed shell command always exist when the parsing itself has succeeded.
                        debugLog(debugLogBaseMessage + "Menu title parsing succeeded. Will use title: " + title);
                        menuItem.setTitle(title);
                    }
                    else {
                        // If parsing process fails, the failed process can be passed to this.trigger(). The execution will eventually be cancelled and error messages displayed (assuming user clicks the menu item to execute the shell command, AND if displaying errors is allowed in the shell command's settings).
                        // Keep the title set in phase 1 as-is. I.e. the title shows unparsed variables.
                        debugLog(debugLogBaseMessage + "Menu title parsing failed. Error message(s): ", ...parsing_process.getErrorMessages());
                    }
                })().then(); // Note: no waiting. If you add code below, it will evaluate before the above variable parsing finishes.
                // For the future: If Obsidian will make Menu.addItem() support async callback functions, remove the above '.then()' and use an 'await' instead to make this function properly signal Obsidian when the menu title generation process has finished. Follow this discussion: https://forum.obsidian.md/t/menu-additem-support-asynchronous-callback-functions/52870
            }
            else {
                debugLog(debugLogBaseMessage + "Alias parsing is disabled in settings.");
            }
        });
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class SC_AbstractFileMenuEvent extends SC_MenuEvent {
    constructor() {
        super(...arguments);
        this.workspace_event = "file-menu";
    }
    getTrigger(t_shell_command) {
        return async (menu, file, source, leaf) => {
            // Check that it's the correct menu: if the SC_Event requires a file menu, 'file' needs to be a TFile, otherwise it needs to be a TFolder.
            if ((this.file_or_folder === "folder" && file instanceof obsidian.TFolder) || (this.file_or_folder === "file" && file instanceof obsidian.TFile)) {
                // The menu is correct.
                // File/folder for declareExtraVariables()
                switch (this.file_or_folder) {
                    case "file":
                        this.file = file;
                        break;
                    case "folder":
                        this.folder = file;
                        break;
                }
                await this.addTShellCommandToMenu(t_shell_command, menu);
            }
        };
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class SC_Event_FileMenu extends SC_AbstractFileMenuEvent {
    constructor() {
        super(...arguments);
        this.file_or_folder = "file";
    }
    getFile() {
        return this.file;
    }
    getFolder() {
        return this.file.parent;
    }
}
SC_Event_FileMenu.event_code = "file-menu";
SC_Event_FileMenu.event_title = "File menu";

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class SC_VaultEvent extends SC_Event {
    _register(t_shell_command) {
        // @ts-ignore TODO: Find a way to get a dynamic type for this.vault_event .
        return this.app.vault.on(this.vault_event, this.getTrigger(t_shell_command));
    }
    _unregister(event_reference) {
        this.app.vault.offref(event_reference);
    }
    getTrigger(t_shell_command) {
        return async (file, ...extra_arguments /* Needed for SC_Event_FileRenamed and SC_Event_FolderRenamed to be able to define an additional parameter.*/) => {
            // Check that it's the correct type of file: if the SC_Event requires a file, 'file' needs to be a TFile, otherwise it needs to be a TFolder.
            if ((this.file_or_folder === "folder" && file instanceof obsidian.TFolder) || (this.file_or_folder === "file" && file instanceof obsidian.TFile)) {
                // The file type is correct.
                // File/folder for declareExtraVariables()
                switch (this.file_or_folder) {
                    case "file":
                        this.file = file;
                        break;
                    case "folder":
                        this.folder = file;
                        break;
                }
                await this.trigger(t_shell_command);
            }
        };
    }
    /**
     * This should only be called if file_or_folder is "file"!
     */
    getFile() {
        return this.file;
    }
    /**
     * This can be called whether file_or_folder is "file" or "folder".
     */
    getFolder() {
        switch (this.file_or_folder) {
            case "file":
                return this.file.parent;
            case "folder":
                return this.folder;
        }
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class SC_Event_FileCreated extends SC_VaultEvent {
    constructor() {
        super(...arguments);
        this.vault_event = "create";
        this.file_or_folder = "file";
    }
}
SC_Event_FileCreated.event_code = "file-created";
SC_Event_FileCreated.event_title = "File created";

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class SC_Event_FileContentModified extends SC_VaultEvent {
    constructor() {
        super(...arguments);
        this.vault_event = "modify";
        this.file_or_folder = "file";
    }
}
SC_Event_FileContentModified.event_code = "file-content-modified";
SC_Event_FileContentModified.event_title = "File content modified";

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class SC_Event_FileDeleted extends SC_VaultEvent {
    constructor() {
        super(...arguments);
        this.vault_event = "delete";
        this.file_or_folder = "file";
    }
}
SC_Event_FileDeleted.event_code = "file-deleted";
SC_Event_FileDeleted.event_title = "File deleted";

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class SC_VaultMoveOrRenameEvent extends SC_VaultEvent {
    constructor() {
        super(...arguments);
        this.vault_event = "rename";
    }
    getTrigger(t_shell_command) {
        // Get a trigger from the parent class (SC_VaultEvent).
        const trigger = super.getTrigger(t_shell_command);
        return async (abstract_file, old_relative_path) => {
            // Detect if the file/folder was moved or renamed.
            // If the file/folder name has stayed the same, conclude that the file has been MOVED, not renamed. Otherwise, conclude the opposite.
            const old_file_name = extractFileName(old_relative_path);
            const new_file_name = abstract_file.name;
            const event_type = (old_file_name === new_file_name) ? "move" : "rename"; // Tells what really happened. this.move_or_rename tells what is the condition for the event to trigger.
            // Only proceed the triggering, if the determined type equals the one defined by the event class.
            if (event_type === this.move_or_rename) {
                // The event type is correct.
                // File and folder for declareExtraVariables()
                switch (this.file_or_folder) {
                    case "file":
                        this.file_old_relative_path = old_relative_path;
                        this.folder_old_relative_path = extractFileParentPath(old_relative_path);
                        break;
                    case "folder":
                        this.folder_old_relative_path = old_relative_path;
                        break;
                }
                // Call the normal trigger function.
                await trigger(abstract_file);
            }
        };
    }
    getFolderOldRelativePath() {
        return this.folder_old_relative_path;
    }
    getFileOldRelativePath() {
        return this.file_old_relative_path;
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class SC_Event_FileRenamed extends SC_VaultMoveOrRenameEvent {
    constructor() {
        super(...arguments);
        this.move_or_rename = "rename";
        this.file_or_folder = "file";
    }
}
SC_Event_FileRenamed.event_code = "file-renamed";
SC_Event_FileRenamed.event_title = "File renamed";

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class SC_Event_FileMoved extends SC_VaultMoveOrRenameEvent {
    constructor() {
        super(...arguments);
        this.move_or_rename = "move";
        this.file_or_folder = "file";
    }
}
SC_Event_FileMoved.event_code = "file-moved";
SC_Event_FileMoved.event_title = "File moved";

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class Variable_EventFileName extends EventVariable {
    constructor() {
        super(...arguments);
        this.variable_name = "event_file_name";
        this.help_text = "Gives the event related file name with a file extension. If you need it without the extension, use {{event_title}} instead.";
        this.supported_sc_events = [
            SC_Event_FileMenu,
            SC_Event_FileCreated,
            SC_Event_FileContentModified,
            SC_Event_FileDeleted,
            SC_Event_FileMoved,
            SC_Event_FileRenamed,
        ];
    }
    async generateValue(argumentsAreNotUsed, sc_event) {
        this.requireCorrectEvent(sc_event);
        return sc_event.getFile().name;
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class Variable_EventFilePath extends EventVariable {
    constructor() {
        super(...arguments);
        this.variable_name = "event_file_path";
        this.help_text = "Gives path to the event related file, either as absolute from the root of the file system, or as relative from the root of the Obsidian vault.";
        this.supported_sc_events = [
            SC_Event_FileMenu,
            SC_Event_FileCreated,
            SC_Event_FileContentModified,
            SC_Event_FileDeleted,
            SC_Event_FileMoved,
            SC_Event_FileRenamed,
        ];
    }
    async generateValue(castedArguments, sc_event) {
        this.requireCorrectEvent(sc_event);
        return getFilePath(this.app, sc_event.getFile(), castedArguments.mode);
    }
    getAutocompleteItems() {
        return [
            // Normal variables
            {
                value: "{{" + this.variable_name + ":absolute}}",
                help_text: "Gives path to the event related file, absolute from the root of the file system. " + this.getAvailabilityText(),
                group: "Variables",
                type: "normal-variable",
                documentationLink: this.getDocumentationLink(),
            },
            {
                value: "{{" + this.variable_name + ":relative}}",
                help_text: "Gives path to the event related file, relative from the root of the Obsidian vault. " + this.getAvailabilityText(),
                group: "Variables",
                type: "normal-variable",
                documentationLink: this.getDocumentationLink(),
            },
            // Unescaped variables
            {
                value: "{{!" + this.variable_name + ":absolute}}",
                help_text: "Gives path to the event related file, absolute from the root of the file system. " + this.getAvailabilityText(),
                group: "Variables",
                type: "unescaped-variable",
                documentationLink: this.getDocumentationLink(),
            },
            {
                value: "{{!" + this.variable_name + ":relative}}",
                help_text: "Gives path to the event related file, relative from the root of the Obsidian vault. " + this.getAvailabilityText(),
                group: "Variables",
                type: "unescaped-variable",
                documentationLink: this.getDocumentationLink(),
            },
        ];
    }
    getHelpName() {
        return "<strong>{{event_file_path:relative}}</strong> or <strong>{{event_file_path:absolute}}</strong>";
    }
}
Variable_EventFilePath.parameters = {
    mode: {
        options: ["absolute", "relative"],
        required: true,
    },
};

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class SC_Event_FolderMenu extends SC_AbstractFileMenuEvent {
    constructor() {
        super(...arguments);
        this.file_or_folder = "folder";
    }
    getFolder() {
        return this.folder;
    }
}
SC_Event_FolderMenu.event_code = "folder-menu";
SC_Event_FolderMenu.event_title = "Folder menu";

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class SC_Event_FolderCreated extends SC_VaultEvent {
    constructor() {
        super(...arguments);
        this.vault_event = "create";
        this.file_or_folder = "folder";
    }
}
SC_Event_FolderCreated.event_code = "folder-created";
SC_Event_FolderCreated.event_title = "Folder created";

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class SC_Event_FolderDeleted extends SC_VaultEvent {
    constructor() {
        super(...arguments);
        this.vault_event = "delete";
        this.file_or_folder = "folder";
    }
}
SC_Event_FolderDeleted.event_code = "folder-deleted";
SC_Event_FolderDeleted.event_title = "Folder deleted";

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class SC_Event_FolderRenamed extends SC_VaultMoveOrRenameEvent {
    constructor() {
        super(...arguments);
        this.move_or_rename = "rename";
        this.file_or_folder = "folder";
    }
}
SC_Event_FolderRenamed.event_code = "folder-renamed";
SC_Event_FolderRenamed.event_title = "Folder renamed";

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class SC_Event_FolderMoved extends SC_VaultMoveOrRenameEvent {
    constructor() {
        super(...arguments);
        this.move_or_rename = "move";
        this.file_or_folder = "folder";
    }
}
SC_Event_FolderMoved.event_code = "folder-moved";
SC_Event_FolderMoved.event_title = "Folder moved";

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class Variable_EventFolderName extends EventVariable {
    constructor() {
        super(...arguments);
        this.variable_name = "event_folder_name";
        this.help_text = "File events: Gives the event related file's parent folder name. Folder events: Gives the selected folder's name. Gives a dot if the folder is the vault's root. No ancestor folders are included.";
        this.supported_sc_events = [
            SC_Event_FileMenu,
            SC_Event_FolderMenu,
            SC_Event_FileCreated,
            SC_Event_FileContentModified,
            SC_Event_FileDeleted,
            SC_Event_FileMoved,
            SC_Event_FileRenamed,
            SC_Event_FolderCreated,
            SC_Event_FolderDeleted,
            SC_Event_FolderMoved,
            SC_Event_FolderRenamed,
        ];
    }
    async generateValue(argumentsAreNotUsed, sc_event) {
        this.requireCorrectEvent(sc_event);
        const folder = sc_event.getFolder();
        return folder.isRoot()
            ? "." // Return a dot instead of an empty string.
            : folder.name;
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class Variable_EventFolderPath extends EventVariable {
    constructor() {
        super(...arguments);
        this.variable_name = "event_folder_path";
        this.help_text = "File events: Gives path to the event related file's parent folder. Folder events: Gives path to the event related folder. The path is either absolute from the root of the file system, or relative from the root of the Obsidian vault.";
        this.supported_sc_events = [
            SC_Event_FileMenu,
            SC_Event_FolderMenu,
            SC_Event_FileCreated,
            SC_Event_FileContentModified,
            SC_Event_FileDeleted,
            SC_Event_FileMoved,
            SC_Event_FileRenamed,
            SC_Event_FolderCreated,
            SC_Event_FolderDeleted,
            SC_Event_FolderMoved,
            SC_Event_FolderRenamed,
        ];
    }
    async generateValue(castedArguments, sc_event) {
        this.requireCorrectEvent(sc_event);
        return getFolderPath(this.app, sc_event.getFolder(), castedArguments.mode);
    }
    getAutocompleteItems() {
        return [
            // Normal variables
            {
                value: "{{" + this.variable_name + ":absolute}}",
                help_text: "File events: Gives path to the event related file's parent folder. Folder events: Gives path to the event related folder. The path is absolute from the root of the file system. " + this.getAvailabilityText(),
                group: "Variables",
                type: "normal-variable",
                documentationLink: this.getDocumentationLink(),
            },
            {
                value: "{{" + this.variable_name + ":relative}}",
                help_text: "File events: Gives path to the event related file's parent folder. Folder events: Gives path to the event related folder. The path is relative from the root of the Obsidian vault. " + this.getAvailabilityText(),
                group: "Variables",
                type: "normal-variable",
                documentationLink: this.getDocumentationLink(),
            },
            // Unescaped variables
            {
                value: "{{!" + this.variable_name + ":absolute}}",
                help_text: "File events: Gives path to the event related file's parent folder. Folder events: Gives path to the event related folder. The path is absolute from the root of the file system. " + this.getAvailabilityText(),
                group: "Variables",
                type: "unescaped-variable",
                documentationLink: this.getDocumentationLink(),
            },
            {
                value: "{{!" + this.variable_name + ":relative}}",
                help_text: "File events: Gives path to the event related file's parent folder. Folder events: Gives path to the event related folder. The path is relative from the root of the Obsidian vault. " + this.getAvailabilityText(),
                group: "Variables",
                type: "unescaped-variable",
                documentationLink: this.getDocumentationLink(),
            },
        ];
    }
    getHelpName() {
        return "<strong>{{event_folder_path:relative}}</strong> or <strong>{{event_folder_path:absolute}}</strong>";
    }
}
Variable_EventFolderPath.parameters = {
    mode: {
        options: ["absolute", "relative"],
        required: true,
    },
};

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class Variable_EventTitle extends EventVariable {
    constructor() {
        super(...arguments);
        this.variable_name = "event_title";
        this.help_text = "Gives the event related file name without a file extension. If you need it with the extension, use {{event_file_name}} instead.";
        this.supported_sc_events = [
            SC_Event_FileMenu,
            SC_Event_FileCreated,
            SC_Event_FileContentModified,
            SC_Event_FileDeleted,
            SC_Event_FileMoved,
            SC_Event_FileRenamed,
        ];
    }
    async generateValue(argumentsAreNotUsed, sc_event) {
        this.requireCorrectEvent(sc_event);
        return sc_event.getFile().basename;
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class Variable_EventFileExtension extends EventVariable {
    constructor() {
        super(...arguments);
        this.variable_name = "event_file_extension";
        this.help_text = "Gives the event related file name's ending. Use {{event_file_extension:with-dot}} to include a preceding dot. If the extension is empty, no dot is added. {{event_file_extension:no-dot}} never includes a dot.";
        this.supported_sc_events = [
            SC_Event_FileMenu,
            SC_Event_FileCreated,
            SC_Event_FileContentModified,
            SC_Event_FileDeleted,
            SC_Event_FileMoved,
            SC_Event_FileRenamed,
        ];
    }
    async generateValue(castedArguments, sc_event) {
        this.requireCorrectEvent(sc_event);
        return getFileExtension(sc_event.getFile(), castedArguments.dot === "with-dot");
    }
    getAutocompleteItems() {
        return [
            // Normal variables
            {
                value: "{{" + this.variable_name + ":no-dot}}",
                help_text: "Gives the event related file name's ending without a preceding dot. " + this.getAvailabilityText(),
                group: "Variables",
                type: "normal-variable",
                documentationLink: this.getDocumentationLink(),
            },
            {
                value: "{{" + this.variable_name + ":with-dot}}",
                help_text: "Gives the event related file name's ending with a preceding dot. If the extension is empty, no dot is included. " + this.getAvailabilityText(),
                group: "Variables",
                type: "normal-variable",
                documentationLink: this.getDocumentationLink(),
            },
            // Unescaped variables
            {
                value: "{{!" + this.variable_name + ":no-dot}}",
                help_text: "Gives the event related file name's ending without a preceding dot. " + this.getAvailabilityText(),
                group: "Variables",
                type: "unescaped-variable",
                documentationLink: this.getDocumentationLink(),
            },
            {
                value: "{{!" + this.variable_name + ":with-dot}}",
                help_text: "Gives the event related file name's ending with a preceding dot. If the extension is empty, no dot is included. " + this.getAvailabilityText(),
                group: "Variables",
                type: "unescaped-variable",
                documentationLink: this.getDocumentationLink(),
            },
        ];
    }
    getHelpName() {
        return "<strong>{{event_file_extension:with-dot}}</strong> or <strong>{{event_file_extension:no-dot}}</strong>";
    }
}
Variable_EventFileExtension.parameters = {
    "dot": {
        options: ["with-dot", "no-dot"],
        required: true,
    },
};

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class Variable_EventTags extends EventVariable {
    constructor() {
        super(...arguments);
        this.variable_name = "event_tags";
        this.help_text = "Gives all tags defined in the event related note. Replace the \"separator\" part with a comma, space or whatever characters you want to use as a separator between tags. A separator is always needed to be defined.";
        this.supported_sc_events = [
            SC_Event_FileMenu,
            SC_Event_FileCreated,
            SC_Event_FileContentModified,
            SC_Event_FileDeleted,
            SC_Event_FileMoved,
            SC_Event_FileRenamed,
        ];
    }
    async generateValue(castedArguments, sc_event) {
        this.requireCorrectEvent(sc_event);
        const file = sc_event.getFile();
        return getFileTags(this.app, file).join(castedArguments.separator);
    }
}
Variable_EventTags.parameters = {
    separator: {
        type: "string",
        required: true,
    }
};

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class Variable_EventYAMLValue extends EventVariable {
    constructor() {
        super(...arguments);
        this.variable_name = "event_yaml_value";
        this.help_text = "Reads a single value from the event related file's frontmatter. Takes a property name as an argument. You can access nested properties with dot notation: property1.property2";
        this.supported_sc_events = [
            SC_Event_FileMenu,
            SC_Event_FileCreated,
            SC_Event_FileContentModified,
            SC_Event_FileDeleted,
            SC_Event_FileMoved,
            SC_Event_FileRenamed,
        ];
    }
    async generateValue(castedArguments, sc_event) {
        this.requireCorrectEvent(sc_event);
        const result = getFileYAMLValue(this.app, sc_event.getFile(), castedArguments.property_name);
        if (Array.isArray(result)) {
            // The result contains error message(s).
            this.throw(result.join(" "));
        }
        else {
            // The result is ok, it's a string.
            return result;
        }
    }
    getAvailabilityText() {
        return super.getAvailabilityText() + " Also, the given YAML property must exist in the file's frontmatter.";
    }
    getHelpName() {
        return "<strong>{{event_yaml_value:property}}</strong>";
    }
}
Variable_EventYAMLValue.parameters = {
    property_name: {
        type: "string",
        required: true,
    },
};

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class Variable_Environment extends Variable {
    constructor() {
        super(...arguments);
        this.variable_name = "environment";
        this.help_text = "Gives an environment variable's value. It's an original value received when Obsidian was started.";
        this.always_available = false;
    }
    async generateValue(castedArguments) {
        // Check that the requested environment variable exists.
        if (undefined !== process.env[castedArguments.variable]) {
            // Yes, it exists.
            return process.env[castedArguments.variable]; // as string: tells TypeScript compiler that the item exists, is not undefined.
        }
        else {
            // It does not exist.
            // Freak out.
            this.throw(`Environment variable named '${castedArguments.variable}' does not exist.`);
        }
    }
    getHelpName() {
        return "<strong>{{environment:variable}}</strong>";
    }
    getAvailabilityText() {
        return "<strong>Only available</strong> if the passed environment variable name exists.";
    }
}
Variable_Environment.parameters = {
    variable: {
        type: "string",
        required: true,
    },
};

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class Variable_EventOldFileName extends EventVariable {
    constructor() {
        super(...arguments);
        this.variable_name = "event_old_file_name";
        this.help_text = "Gives the renamed file's old name with a file extension. If you need it without the extension, use {{event_old_title}} instead.";
        this.supported_sc_events = [
            SC_Event_FileRenamed,
        ];
    }
    async generateValue(argumentsAreNotUsed, sc_event) {
        this.requireCorrectEvent(sc_event);
        return extractFileName(sc_event.getFileOldRelativePath(), true);
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class Variable_EventOldFilePath extends EventVariable {
    constructor() {
        super(...arguments);
        this.variable_name = "event_old_file_path";
        this.help_text = "Gives the renamed/moved file's old path, either as absolute from the root of the file system, or as relative from the root of the Obsidian vault.";
        this.supported_sc_events = [
            SC_Event_FileMoved,
            SC_Event_FileRenamed,
        ];
    }
    async generateValue(castedArguments, sc_event) {
        this.requireCorrectEvent(sc_event);
        const file_old_relative_path = sc_event.getFileOldRelativePath();
        switch (castedArguments.mode.toLowerCase()) {
            case "relative":
                return normalizePath2(file_old_relative_path);
            case "absolute":
                return normalizePath2(getVaultAbsolutePath(this.app) + "/" + file_old_relative_path);
        }
        this.throw("Unrecognized mode parameter: " + castedArguments.mode);
    }
    getAutocompleteItems() {
        return [
            // Normal variables
            {
                value: "{{" + this.variable_name + ":absolute}}",
                help_text: "Gives the renamed/moved file's old path, absolute from the root of the file system. " + this.getAvailabilityText(),
                group: "Variables",
                type: "normal-variable",
                documentationLink: this.getDocumentationLink(),
            },
            {
                value: "{{" + this.variable_name + ":relative}}",
                help_text: "Gives the renamed/moved file's old path, relative from the root of the Obsidian vault. " + this.getAvailabilityText(),
                group: "Variables",
                type: "normal-variable",
                documentationLink: this.getDocumentationLink(),
            },
            // Unescaped variables
            {
                value: "{{!" + this.variable_name + ":absolute}}",
                help_text: "Gives the renamed/moved file's old path, absolute from the root of the file system. " + this.getAvailabilityText(),
                group: "Variables",
                type: "unescaped-variable",
                documentationLink: this.getDocumentationLink(),
            },
            {
                value: "{{!" + this.variable_name + ":relative}}",
                help_text: "Gives the renamed/moved file's old path, relative from the root of the Obsidian vault. " + this.getAvailabilityText(),
                group: "Variables",
                type: "unescaped-variable",
                documentationLink: this.getDocumentationLink(),
            },
        ];
    }
    getHelpName() {
        return "<strong>{{event_file_path:relative}}</strong> or <strong>{{event_file_path:absolute}}</strong>";
    }
}
Variable_EventOldFilePath.parameters = {
    mode: {
        options: ["absolute", "relative"],
        required: true,
    },
};

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class Variable_EventOldFolderName extends EventVariable {
    constructor() {
        super(...arguments);
        this.variable_name = "event_old_folder_name";
        this.help_text = "File events: Gives the moved file's old parent folder's name. Folder events: Gives the renamed folder's old name.";
        this.supported_sc_events = [
            SC_Event_FileMoved,
            SC_Event_FolderRenamed,
        ];
    }
    async generateValue(argumentsAreNotUsed, sc_event) {
        this.requireCorrectEvent(sc_event);
        return extractFileName(sc_event.getFolderOldRelativePath());
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class Variable_EventOldFolderPath extends EventVariable {
    constructor() {
        super(...arguments);
        this.variable_name = "event_old_folder_path";
        this.help_text = "File events: Gives the moved file's old parent folder's path. Folder events: Gives the renamed/moved folder's old path. The path is either as absolute from the root of the file system, or as relative from the root of the Obsidian vault.";
        this.supported_sc_events = [
            SC_Event_FileMoved,
            SC_Event_FolderMoved,
            SC_Event_FolderRenamed,
        ];
    }
    async generateValue(castedArguments, sc_event) {
        this.requireCorrectEvent(sc_event);
        const folder_old_relative_path = sc_event.getFolderOldRelativePath();
        switch (castedArguments.mode.toLowerCase()) {
            case "relative":
                return normalizePath2(folder_old_relative_path);
            case "absolute":
                return normalizePath2(getVaultAbsolutePath(this.app) + "/" + folder_old_relative_path);
        }
        this.throw("Unrecognized mode parameter: " + castedArguments.mode);
    }
    getAutocompleteItems() {
        return [
            // Normal variables
            {
                value: "{{" + this.variable_name + ":absolute}}",
                help_text: "File events: Gives the moved file's old parent folder's path. Folder events: Gives the renamed/moved folder's old path. The path is absolute from the root of the file system. " + this.getAvailabilityText(),
                group: "Variables",
                type: "normal-variable",
                documentationLink: this.getDocumentationLink(),
            },
            {
                value: "{{" + this.variable_name + ":relative}}",
                help_text: "File events: Gives the moved file's old parent folder's path. Folder events: Gives the renamed/moved folder's old path. The path is relative from the root of the Obsidian vault. " + this.getAvailabilityText(),
                group: "Variables",
                type: "normal-variable",
                documentationLink: this.getDocumentationLink(),
            },
            // Unescaped variables
            {
                value: "{{!" + this.variable_name + ":absolute}}",
                help_text: "File events: Gives the moved file's old parent folder's path. Folder events: Gives the renamed/moved folder's old path. The path is absolute from the root of the file system. " + this.getAvailabilityText(),
                group: "Variables",
                type: "unescaped-variable",
                documentationLink: this.getDocumentationLink(),
            },
            {
                value: "{{!" + this.variable_name + ":relative}}",
                help_text: "File events: Gives the moved file's old parent folder's path. Folder events: Gives the renamed/moved folder's old path. The path is relative from the root of the Obsidian vault. " + this.getAvailabilityText(),
                group: "Variables",
                type: "unescaped-variable",
                documentationLink: this.getDocumentationLink(),
            },
        ];
    }
    getHelpName() {
        return "<strong>{{event_file_path:relative}}</strong> or <strong>{{event_file_path:absolute}}</strong>";
    }
}
Variable_EventOldFolderPath.parameters = {
    mode: {
        options: ["absolute", "relative"],
        required: true,
    },
};

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class Variable_EventOldTitle extends EventVariable {
    constructor() {
        super(...arguments);
        this.variable_name = "event_old_title";
        this.help_text = "Gives the renamed file's old name without a file extension. If you need it with the extension, use {{event_old_file_name}} instead.";
        this.supported_sc_events = [
            SC_Event_FileRenamed,
        ];
    }
    async generateValue(argumentsAreNotUsed, sc_event) {
        this.requireCorrectEvent(sc_event);
        return extractFileName(sc_event.getFileOldRelativePath(), false);
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class Variable_NewNoteFolderName extends Variable {
    constructor() {
        super(...arguments);
        this.variable_name = "new_note_folder_name";
        this.help_text = "Gives the folder name for \"Default location for new notes\" (a setting in Obsidian). No ancestor folders are included.";
    }
    async generateValue() {
        const current_file = this.app.workspace.getActiveFile(); // Needed just in case new notes should be created in the same folder as the currently open file.
        const folder = this.app.fileManager.getNewFileParent(current_file ? current_file.path : ""); // If no file is open, use an empty string as instructed in .getNewFileParent()'s documentation.
        if (!folder) {
            this.throw("Cannot determine a folder name for new notes. Please create a discussion in GitHub."); // I guess this never happens.
        }
        // If the folder is the vault's root folder, return "." instead of " " (a space character). I don't know why the name is " " when the folder is root.
        return folder.isRoot()
            ? "."
            : folder.name;
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class Variable_NewNoteFolderPath extends Variable {
    constructor() {
        super(...arguments);
        this.variable_name = "new_note_folder_path";
        this.help_text = "Gives path to the \"Default location for new notes\" folder (a setting in Obsidian), either as absolute from the root of the file system, or as relative from the root of the Obsidian vault.";
    }
    async generateValue(castedArguments) {
        const current_file = this.app.workspace.getActiveFile(); // Needed just in case new notes should be created in the same folder as the currently open file.
        const folder = this.app.fileManager.getNewFileParent(current_file ? current_file.path : ""); // If no file is open, use an empty string as instructed in .getNewFileParent()'s documentation.
        if (folder) {
            return getFolderPath(this.app, folder, castedArguments.mode);
        }
        else {
            this.throw("Cannot determine a folder path for new notes. Please create a discussion in GitHub."); // I guess this never happens.
        }
    }
    getAutocompleteItems() {
        return [
            // Normal variables
            {
                value: "{{" + this.variable_name + ":absolute}}",
                help_text: "Gives path to the \"Default location for new notes\" folder (a setting in Obsidian), absolute from the root of the file system. " + this.getAvailabilityText(),
                group: "Variables",
                type: "normal-variable",
                documentationLink: this.getDocumentationLink(),
            },
            {
                value: "{{" + this.variable_name + ":relative}}",
                help_text: "Gives path to the \"Default location for new notes\" folder (a setting in Obsidian), relative from the root of the Obsidian vault. " + this.getAvailabilityText(),
                group: "Variables",
                type: "normal-variable",
                documentationLink: this.getDocumentationLink(),
            },
            // Unescaped variables
            {
                value: "{{!" + this.variable_name + ":absolute}}",
                help_text: "Gives path to the \"Default location for new notes\" folder (a setting in Obsidian), absolute from the root of the file system. " + this.getAvailabilityText(),
                group: "Variables",
                type: "unescaped-variable",
                documentationLink: this.getDocumentationLink(),
            },
            {
                value: "{{!" + this.variable_name + ":relative}}",
                help_text: "Gives path to the \"Default location for new notes\" folder (a setting in Obsidian), relative from the root of the Obsidian vault. " + this.getAvailabilityText(),
                group: "Variables",
                type: "unescaped-variable",
                documentationLink: this.getDocumentationLink(),
            },
        ];
    }
    getHelpName() {
        return "<strong>{{folder_path:relative}}</strong> or <strong>{{folder_path:absolute}}</strong>";
    }
}
Variable_NewNoteFolderPath.parameters = {
    mode: {
        options: ["absolute", "relative"],
        required: true,
    }
};

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class Variable_FileURI extends FileVariable {
    constructor() {
        super(...arguments);
        this.variable_name = "file_uri";
        this.help_text = "Gives an Obsidian URI that opens the current file.";
    }
    async generateValue() {
        return this.plugin.getObsidianURI("open", {
            file: obsidian.normalizePath(this.getFileOrThrow().path), // Use normalizePath() instead of normalizePath2() because / should not be converted to \ on Windows because this is used as a URI, not as a file system path.
        });
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class Variable_EventFileURI extends EventVariable {
    constructor() {
        super(...arguments);
        this.variable_name = "event_file_uri";
        this.help_text = "Gives an Obsidian URI that opens the event related file.";
        this.supported_sc_events = [
            SC_Event_FileMenu,
            SC_Event_FileCreated,
            SC_Event_FileContentModified,
            SC_Event_FileDeleted,
            SC_Event_FileMoved,
            SC_Event_FileRenamed,
        ];
    }
    async generateValue(argumentsAreNotUsed, sc_event) {
        this.requireCorrectEvent(sc_event);
        const file = sc_event.getFile();
        return this.plugin.getObsidianURI("open", {
            file: obsidian.normalizePath(file.path), // Use normalizePath() instead of normalizePath2() because / should not be converted to \ on Windows because this is used as a URI, not as a file system path.
        });
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class Variable_NoteContent extends FileVariable {
    constructor() {
        super(...arguments);
        this.variable_name = "note_content";
        this.help_text = "Gives the current note's content without YAML frontmatter. If you need YAML included, use {{file_content}} instead.";
    }
    async generateValue() {
        return await getFileContentWithoutYAML(this.app, this.getFileOrThrow());
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class Variable_EventNoteContent extends EventVariable {
    constructor() {
        super(...arguments);
        this.variable_name = "event_note_content";
        this.help_text = "Gives the event related file's content without YAML frontmatter. If you need YAML included, use {{event_file_content}} instead.";
        this.supported_sc_events = [
            SC_Event_FileMenu,
            SC_Event_FileCreated,
            SC_Event_FileContentModified,
            SC_Event_FileDeleted,
            SC_Event_FileMoved,
            SC_Event_FileRenamed,
        ];
    }
    async generateValue(argumentsAreNotUsed, sc_event) {
        this.requireCorrectEvent(sc_event);
        return await getFileContentWithoutYAML(this.app, sc_event.getFile());
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class Variable_FileContent extends FileVariable {
    constructor() {
        super(...arguments);
        this.variable_name = "file_content";
        this.help_text = "Gives the current file's content, including YAML frontmatter. If you need YAML excluded, use {{note_content}} instead.";
    }
    async generateValue() {
        // Retrieve file content.
        return await app.vault.read(this.getFileOrThrow());
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class Variable_EventFileContent extends EventVariable {
    constructor() {
        super(...arguments);
        this.variable_name = "event_file_content";
        this.help_text = "Gives the event related file's content, including YAML frontmatter. If you need YAML excluded, use {{event_note_content}} instead.";
        this.supported_sc_events = [
            SC_Event_FileMenu,
            SC_Event_FileCreated,
            SC_Event_FileContentModified,
            SC_Event_FileDeleted,
            SC_Event_FileMoved,
            SC_Event_FileRenamed,
        ];
    }
    async generateValue(argumentsAreNotUsed, sc_event) {
        this.requireCorrectEvent(sc_event);
        // Retrieve file content.
        return await app.vault.read(sc_event.getFile());
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class Variable_CaretParagraph extends EditorVariable {
    constructor() {
        super(...arguments);
        this.variable_name = "caret_paragraph";
        this.help_text = "Gives a text line at the current caret position.";
    }
    async generateValue() {
        const editor = this.getEditorOrThrow();
        this.requireViewModeSource();
        const caretPosition = editor.getCursor('to');
        return editor.getLine(caretPosition.line);
    }
    getAvailabilityText() {
        return super.getAvailabilityText() + " Not available in preview mode.";
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class Variable_Newline extends Variable {
    constructor() {
        super(...arguments);
        this.variable_name = "newline";
        this.help_text = "Gives a \\n character. Used for testing line break escaping. An optional argument can be used to tell how many newlines are needed.";
    }
    async generateValue(castedArguments) {
        // Return \n, possibly repeating it
        return "\n".repeat(castedArguments.count ?? 1);
    }
    getAvailabilityText() {
        return "<strong>Only available</strong> in debug mode.";
    }
}
Variable_Newline.parameters = {
    count: {
        type: "integer",
        required: false,
    }
};

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class Variable_YAMLContent extends FileVariable {
    constructor() {
        super(...arguments);
        this.variable_name = "yaml_content";
        this.help_text = "Gives the current note's YAML frontmatter. Dashes --- can be included or excluded.";
    }
    generateValue(castedArguments) {
        return new Promise((resolve, reject) => {
            let file;
            try {
                file = this.getFileOrThrow();
            }
            catch (error) {
                // Need to catch here, because Variable.getValue()'s .catch() block won't be able to catch thrown errors,
                // it can only catch errors that were passed to reject().
                reject(error);
                return;
            }
            getFileYAML(this.app, file, "with-dashes" === castedArguments.withDashes).then((yamlContent) => {
                if (null === yamlContent) {
                    // No YAML frontmatter.
                    this.reject("The current file does not contain a YAML frontmatter.", reject);
                }
                else {
                    // Got a YAML frontmatter.
                    resolve(yamlContent);
                }
            });
        });
    }
    getAvailabilityText() {
        return super.getAvailabilityText() + " Also, a YAML frontmatter section needs to be present.";
    }
    getAutocompleteItems() {
        return [
            // Normal variables
            {
                value: "{{" + this.variable_name + ":with-dashes}}",
                help_text: "Gives the current note's YAML frontmatter, wrapped between --- lines. " + this.getAvailabilityText(),
                group: "Variables",
                type: "normal-variable",
                documentationLink: this.getDocumentationLink(),
            },
            {
                value: "{{" + this.variable_name + ":no-dashes}}",
                help_text: "Gives the current note's YAML frontmatter, excluding top and bottom --- lines. " + this.getAvailabilityText(),
                group: "Variables",
                type: "normal-variable",
                documentationLink: this.getDocumentationLink(),
            },
            // Unescaped variables
            {
                value: "{{!" + this.variable_name + ":with-dashes}}",
                help_text: "Gives the current note's YAML frontmatter, wrapped between --- lines." + this.getAvailabilityText(),
                group: "Variables",
                type: "unescaped-variable",
                documentationLink: this.getDocumentationLink(),
            },
            {
                value: "{{!" + this.variable_name + ":no-dashes}}",
                help_text: "Gives the current note's YAML frontmatter, excluding top and bottom --- lines. " + this.getAvailabilityText(),
                group: "Variables",
                type: "unescaped-variable",
                documentationLink: this.getDocumentationLink(),
            },
        ];
    }
    getHelpName() {
        return "<strong>{{yaml_content:with-dashes}}</strong> or <strong>{{yaml_content:no-dashes}}</strong>";
    }
}
Variable_YAMLContent.parameters = {
    withDashes: {
        options: ["with-dashes", "no-dashes"],
        required: true,
    },
};

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class Variable_EventYAMLContent extends EventVariable {
    constructor() {
        super(...arguments);
        this.variable_name = "event_yaml_content";
        this.help_text = "Gives the event related note's YAML frontmatter. Dashes --- can be included or excluded.";
        this.supported_sc_events = [
            SC_Event_FileMenu,
            SC_Event_FileCreated,
            SC_Event_FileContentModified,
            SC_Event_FileDeleted,
            SC_Event_FileMoved,
            SC_Event_FileRenamed,
        ];
    }
    generateValue(castedArguments, sc_event) {
        return new Promise((resolve, reject) => {
            try {
                this.requireCorrectEvent(sc_event);
            }
            catch (error) {
                // Need to catch here, because Variable.getValue()'s .catch() block won't be able to catch thrown errors,
                // it can only catch errors that were passed to reject().
                reject(error);
                return;
            }
            getFileYAML(this.app, sc_event.getFile(), castedArguments.withDashes === "with-dashes").then((yamlContent) => {
                if (null === yamlContent) {
                    // No YAML frontmatter.
                    this.reject("The event related file does not contain a YAML frontmatter.", reject);
                }
                else {
                    // Got a YAML frontmatter.
                    resolve(yamlContent);
                }
            });
        });
    }
    getAvailabilityText() {
        return super.getAvailabilityText() + " Also, a YAML frontmatter section needs to be present.";
    }
    getAutocompleteItems() {
        return [
            // Normal variables
            {
                value: "{{" + this.variable_name + ":with-dashes}}",
                help_text: "Gives the event related note's YAML frontmatter, wrapped between --- lines. " + this.getAvailabilityText(),
                group: "Variables",
                type: "normal-variable",
                documentationLink: this.getDocumentationLink(),
            },
            {
                value: "{{" + this.variable_name + ":no-dashes}}",
                help_text: "Gives the event related note's YAML frontmatter, excluding top and bottom --- lines. " + this.getAvailabilityText(),
                group: "Variables",
                type: "normal-variable",
                documentationLink: this.getDocumentationLink(),
            },
            // Unescaped variables
            {
                value: "{{!" + this.variable_name + ":with-dashes}}",
                help_text: "Gives the event related note's YAML frontmatter, wrapped between --- lines." + this.getAvailabilityText(),
                group: "Variables",
                type: "unescaped-variable",
                documentationLink: this.getDocumentationLink(),
            },
            {
                value: "{{!" + this.variable_name + ":no-dashes}}",
                help_text: "Gives the event related note's YAML frontmatter, excluding top and bottom --- lines. " + this.getAvailabilityText(),
                group: "Variables",
                type: "unescaped-variable",
                documentationLink: this.getDocumentationLink(),
            },
        ];
    }
    getHelpName() {
        return "<strong>{{event_yaml_content:with-dashes}}</strong> or <strong>{{event_yaml_content:no-dashes}}</strong>";
    }
}
Variable_EventYAMLContent.parameters = {
    withDashes: {
        options: ["with-dashes", "no-dashes"],
        required: true,
    },
};

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
function loadVariables(plugin) {
    const variables = new VariableSet([]);
    // Load CustomVariables
    // Do this before loading built-in variables so that these user-defined variables will appear first in all lists containing variables.
    plugin.getCustomVariableInstances().forEach((custom_variable_instance) => {
        variables.add(custom_variable_instance.createCustomVariable());
    });
    // Load built-in variables.
    const built_in_variables = [
        // Normal variables
        new Variable_CaretParagraph(plugin),
        new Variable_CaretPosition(plugin),
        new Variable_Clipboard(plugin),
        new Variable_Date(plugin),
        new Variable_Environment(plugin),
        new Variable_FileContent(plugin),
        new Variable_FileExtension(plugin),
        new Variable_FileName(plugin),
        new Variable_FilePath(plugin),
        new Variable_FileURI(plugin),
        new Variable_FolderName(plugin),
        new Variable_FolderPath(plugin),
        new Variable_NewNoteFolderName(plugin),
        new Variable_NewNoteFolderPath(plugin),
        new Variable_NoteContent(plugin),
        // Variable_Output is not loaded here, because it's only used in OutputWrappers.
        new Variable_Selection(plugin),
        new Variable_Tags(plugin),
        new Variable_Title(plugin),
        new Variable_VaultPath(plugin),
        new Variable_Workspace(plugin),
        new Variable_YAMLContent(plugin),
        new Variable_YAMLValue(plugin),
        // Event variables
        new Variable_EventFileContent(plugin),
        new Variable_EventFileExtension(plugin),
        new Variable_EventFileName(plugin),
        new Variable_EventFilePath(plugin),
        new Variable_EventFileURI(plugin),
        new Variable_EventFolderName(plugin),
        new Variable_EventFolderPath(plugin),
        new Variable_EventNoteContent(plugin),
        new Variable_EventOldFileName(plugin),
        new Variable_EventOldFilePath(plugin),
        new Variable_EventOldFolderName(plugin),
        new Variable_EventOldFolderPath(plugin),
        new Variable_EventOldTitle(plugin),
        new Variable_EventTags(plugin),
        new Variable_EventTitle(plugin),
        new Variable_EventYAMLContent(plugin),
        new Variable_EventYAMLValue(plugin),
    ];
    if (DEBUG_ON) {
        // Variables that are only designed for 'Shell commands test suite'.
        built_in_variables.push(new Variable_Newline(plugin), new Variable_Passthrough(plugin));
    }
    for (const built_in_variable of built_in_variables) {
        // JavaScript's Set does not have a method to add multiple items at once, so need to iterate them and add one-by-one.
        variables.add(built_in_variable);
    }
    return variables;
}
class VariableSet extends Set {
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
/**
 * @param plugin
 * @param content
 * @param shell Used to determine how to escape special characters in variable values. Can be null, if no escaping is wanted.
 * @param t_shell_command Will only be used to read default value configurations. Can be null if no TShellCommand is available, but then no default values can be accessed.
 * @param sc_event Use undefined, if parsing is not happening during an event.
 * @param variables If you want to parse only a certain set of variables, define them in this parameter. If this is omitted, all variables will be parsed.
 * @param raw_value_augmenter A callback that will be called before every substitution. Allows modifying or completely changing the resulted variable values.
 * @param escaped_value_augmenter Same as raw_value_augmenter, but called after escaping the value. Can be used to for example wrap values in html elements for displaying purposes.
 * @return ParsingResult
 */
async function parseVariables(plugin, content, shell, t_shell_command, sc_event, variables = plugin.getVariables(), raw_value_augmenter = null, escaped_value_augmenter = null) {
    debugLog("parseVariables(): Starting to parse " + content + " with " + variables.size + " variables.");
    // Initialize a parsing result object
    const parsing_result = {
        original_content: content,
        parsed_content: content,
        succeeded: false,
        error_messages: [],
        count_parsed_variables: 0,
    };
    for (const variable of variables) {
        const pattern = new RegExp(variable.getPattern(), "igu"); // i: case-insensitive; g: match all occurrences instead of just the first one. u: support 4-byte unicode characters too.
        const parameter_names = variable.getParameterNames();
        let argument_matches;
        while ((argument_matches = pattern.exec(content)) !== null) {
            // Count how many times any variables have appeared.
            parsing_result.count_parsed_variables++;
            // Remove stuff that should not be iterated in a later loop.
            /** Need to prefix with _ because JavaScript reserves the variable name 'arguments'. */
            const _arguments = argument_matches.filter((value /* Won't be used */, key) => {
                return "number" === typeof key;
                // This leaves out for example the following non-numeric keys (and their values):
                // - "groups"
                // - "index"
                // - "input"
                // In the future, there can also come more elements that will be skipped. E.g. "indices". See: https://github.com/nothingislost/obsidian-dynamic-highlights/issues/25#issuecomment-1038563990 (referenced 2022-02-22).
            });
            // Get the {{variable}} string that will be substituted (= replaced with the actual value of the variable).
            const substitute = _arguments.shift(); // '_arguments[0]' contains the whole match, not just an argument. Get it and remove it from '_arguments'. 'as string' is used to tell TypeScript that _arguments[0] is always defined.
            // Iterate all arguments
            const presentArguments = {};
            for (const i in _arguments) {
                // Check that the argument is not omitted. It can be omitted (= undefined), if the parameter is optional.
                if (undefined !== _arguments[i]) {
                    // The argument is present.
                    const argument = _arguments[i].slice(1); // .slice(1): Remove a preceding :
                    const parameter_name = parameter_names[i];
                    presentArguments[parameter_name] = argument;
                }
            }
            // Should the variable's value be escaped? (Usually yes).
            let escape = true;
            if ("{{!" === substitute.slice(0, 3)) { // .slice(0, 3) = get characters 0...2, so stop before 3. The 'end' parameter is confusing.
                // The variable usage begins with {{! instead of {{
                // This means the variable's value should NOT be escaped.
                escape = false;
            }
            if (!shell) {
                // Escaping is forced OFF.
                escape = false;
            }
            // Render the variable
            const variable_value_result = await variable.getValue(t_shell_command, sc_event, presentArguments, 
            // Define a recursive callback that can be used to parse possible variables in a default value of the current variable.
            (raw_default_value) => {
                // Avoid circular references by removing the current variable from the set of parseable variables.
                // This will cumulate in deep nested parsing: Possible deeper parsing rounds will always have narrower
                // and narrower sets of variables to parse.
                const reduced_variables = removeFromSet(variables, variable);
                return parseVariables(plugin, raw_default_value, null, // Disable escaping special characters at this phase to avoid double escaping, as escaping will be done later.
                t_shell_command, sc_event, reduced_variables, raw_value_augmenter, escaped_value_augmenter);
            });
            // Allow custom modification of the raw value.
            if (raw_value_augmenter) {
                // The augmenter can modify the content of the variable_value_result object.
                raw_value_augmenter(variable, variable_value_result);
            }
            const raw_variable_value = variable_value_result.value;
            // Check possible error messages that might have come from rendering.
            if (variable_value_result.succeeded) {
                // Parsing was ok.
                // Escape the value if needed.
                let use_variable_value;
                if (escape) {
                    // Use an escaped value.
                    use_variable_value = escapeValue(shell, // shell is always a string when escape is true.
                    raw_variable_value);
                }
                else {
                    // No escaping is wanted, so use the raw value.
                    use_variable_value = raw_variable_value; // raw_variable_value is always a string when variable_value_result.succeeded is true.
                }
                // Augment the escaped value, if wanted.
                if (escaped_value_augmenter) {
                    use_variable_value = escaped_value_augmenter(variable, use_variable_value);
                }
                // Replace the variable name with the variable value.
                parsing_result.parsed_content = parsing_result.parsed_content /* not null */.replace(substitute, () => {
                    // Do the replacing in a function in order to avoid a possible $ character to be interpreted by JavaScript to interact with the regex.
                    // More information: https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/replace#specifying_a_string_as_a_parameter (referenced 2021-11-02.)
                    return use_variable_value;
                });
            }
            else {
                // There has been problem(s) with this variable.
                debugLog("parseVariables(): Parsing content " + content + " failed.");
                parsing_result.succeeded = false;
                parsing_result.parsed_content = null;
                parsing_result.error_messages = variable_value_result.error_messages; // Returning now prevents parsing rest of the variables.
                return parsing_result;
            }
        }
    }
    debugLog("parseVariables(): Parsing content succeeded: From '" + content + "' to '" + parsing_result.parsed_content + "'");
    parsing_result.succeeded = true;
    return parsing_result;
}
/**
 * Reads all variables from the content string, and returns a VariableSet containing all the found variables.
 *
 * This is needed in situations where variables will not be parsed (= variable values are not needed), but where it's just
 * needed to know what variables e.g. a shell command relies on.
 *
 * @param plugin
 * @param content
 */
function getUsedVariables(plugin, content) {
    const search_for_variables = plugin.getVariables();
    const found_variables = new VariableSet();
    for (const variable of search_for_variables) {
        const pattern = new RegExp(variable.getPattern(), "igu"); // i: case-insensitive; g: match all occurrences instead of just the first one. u: support 4-byte unicode characters too.
        if (pattern.exec(content) !== null) {
            // This variable was found.
            found_variables.add(variable);
        }
    }
    return found_variables;
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class OutputChannel {
    /**
     * @param plugin
     * @param t_shell_command
     * @param shell_command_parsing_result
     * @param outputHandlingMode
     * @param processTerminator Will be called if user decides to end the process. Set to null if the process has already ended.
     */
    constructor(plugin, t_shell_command, shell_command_parsing_result, outputHandlingMode, processTerminator) {
        this.plugin = plugin;
        this.t_shell_command = t_shell_command;
        this.shell_command_parsing_result = shell_command_parsing_result;
        this.outputHandlingMode = outputHandlingMode;
        this.processTerminator = processTerminator;
        this.app = plugin.app;
        this.initialize();
    }
    /**
     * Can be overridden in child classes in order to vary the title depending on output_stream.
     * @param output_stream
     */
    static getTitle(output_stream) {
        return this.title;
    }
    /**
     * Sub classes can do here initializations that are common to both handleBuffered() and handleRealtime().
     *
     * Inits could be done in contructor(), too, but this is cleaner - no need to deal with parameters and no need for a super()
     * call.
     *
     * @protected
     */
    initialize() {
        // Do nothing by default.
    }
    async handleBuffered(output, error_code, enableOutputWrapping = true) {
        this.requireHandlingMode("buffered");
        // Qualify output
        if (OutputChannel.isOutputEmpty(output)) {
            // The output is empty
            if (!this.static().accepts_empty_output) {
                // This OutputChannel does not accept empty output, i.e. empty output should be just ignored.
                debugLog(this.constructor.name + ".handleBuffered(): Ignoring empty output.");
                return;
            }
        }
        debugLog(this.constructor.name + ".handleBuffered(): Handling output...");
        // Output is ok.
        // Handle it.
        await this._handleBuffered(await this.prepare_output(output, enableOutputWrapping), error_code);
        debugLog("Output handling is done.");
    }
    /**
     * @param outputStreamName
     * @param outputContent
     * @param enableOutputWrapping No caller actually sets this to false at the moment, unlike the handleBuffered() method's counterpart. But have this just in case.
     */
    async handleRealtime(outputStreamName, outputContent, enableOutputWrapping = true) {
        this.requireHandlingMode("realtime");
        // Qualify output
        if ("" === outputContent) {
            // The output is empty
            if (!this.static().accepts_empty_output) {
                // This OutputChannel does not accept empty output, i.e. empty output should be just ignored.
                debugLog(this.constructor.name + ".handleRealtime(): Ignoring empty output.");
                return;
            }
        }
        debugLog(this.constructor.name + ".handleRealtime(): Handling output...");
        // Output is ok.
        // If allowed, wrap the output with output wrapper text.
        if (enableOutputWrapping) {
            // Wrap output (but only if a wrapper is defined)
            outputContent = await this.wrapOutput(outputStreamName, outputContent);
        }
        // Handle it.
        await this._handleRealtime(outputContent, outputStreamName);
        debugLog("Output handling is done.");
    }
    _endRealtime(exitCode) {
        // Do nothing by default.
    }
    /**
     * When a shell command is executed in "realtime" mode, a separate ending call should be made in order to pass an
     * exit code to the OutputChannel. Some OutputChannels display the code to user, but most do not.
     *
     * @param exitCode
     */
    endRealtime(exitCode) {
        this.requireHandlingMode("realtime");
        this._endRealtime(exitCode);
    }
    requireHandlingMode(requiredMode) {
        if (this.outputHandlingMode !== requiredMode) {
            throw new Error("this.outputHandlingMode must be '" + requiredMode + "'.");
        }
    }
    static acceptsOutputStream(output_stream) {
        return this.accepted_output_streams.contains(output_stream);
    }
    /**
     * Does the following preparations:
     *  - Combines output streams (if wanted by the OutputChannel).
     *  - Wraps output (if defined in shell command configuration).
     * @param output_streams
     * @param enableOutputWrapping
     * @private
     */
    async prepare_output(output_streams, enableOutputWrapping) {
        const wrapOutputIfEnabled = async (outputStreamName, outputContent) => {
            if (enableOutputWrapping) {
                // Wrap output content.
                return await this.wrapOutput(outputStreamName, outputContent);
            }
            else {
                // Wrapping is disabled, return unmodified output content.
                return outputContent;
            }
        };
        const wrap_outputs_separately = async () => {
            const wrapped_output_streams = {};
            let output_stream_name;
            for (output_stream_name in output_streams) {
                wrapped_output_streams[output_stream_name] = await wrapOutputIfEnabled(output_stream_name, output_streams[output_stream_name]);
            }
            return wrapped_output_streams;
        };
        // Check if outputs should be combined.
        const combineOutputStreams = this.static().combine_output_streams;
        if (combineOutputStreams) {
            // Combine output strings into a single string.
            // Can output wrapping be combined?
            if (this.t_shell_command.isOutputWrapperStdoutSameAsStderr()) {
                // Output wrapping can be combined.
                return await wrapOutputIfEnabled("stdout", joinObjectProperties(output_streams, combineOutputStreams));
            }
            else {
                // Output wrapping needs to be done separately.
                const wrapped_output_streams = await wrap_outputs_separately();
                return joinObjectProperties(wrapped_output_streams, combineOutputStreams); // Use combineOutputStreams as a glue string.
            }
        }
        else {
            // Do not combine, handle each stream separately
            return await wrap_outputs_separately();
        }
    }
    /**
     * Surrounds the given output text with an output wrapper. If no output wrapper is defined, returns the original
     * output text without any modifications.
     */
    async wrapOutput(output_stream, output_content) {
        // Get preparsed output wrapper content. It has all other variables parsed, except {{output}}.
        const parsing_result_key = "output_wrapper_" + output_stream;
        const output_wrapper_content = this.shell_command_parsing_result[parsing_result_key];
        // Check if output wrapper content exists.
        if (undefined === output_wrapper_content) {
            // No OutputWrapper is defined for this shell command.
            // Return the output text without modifications.
            debugLog("Output wrapping: No wrapper is defined for '" + output_stream + "'.");
            return output_content;
        }
        // Parse the {{output}} variable
        const output_variable = new Variable_Output(this.plugin, output_content);
        const parsing_result = await parseVariables(this.plugin, output_wrapper_content, null, // No shell anymore, so no need for escaping.
        this.t_shell_command, null, // No support for {{event_*}} variables is needed, because they are already parsed in output_wrapper_content. This phase only parses {{output}} variable, nothing else.
        new VariableSet([output_variable]));
        // Inspect the parsing result. It should always succeed, as the {{output}} variable should not give any errors.
        if (parsing_result.succeeded) {
            // Succeeded.
            debugLog("Output wrapping: Wrapping " + output_stream + " succeeded.");
            return parsing_result.parsed_content;
        }
        else {
            // Failed for some reason.
            this.plugin.newError("Output wrapping failed, see error(s) below.");
            this.plugin.newErrors(parsing_result.error_messages);
            throw new Error("Output wrapping failed: Parsing {{output}} resulted in error(s): " + parsing_result.error_messages.join(" "));
        }
    }
    /**
     * Can be moved to a global function isOutputStreamEmpty() if needed.
     * @param output
     * @private
     */
    static isOutputEmpty(output) {
        if (undefined !== output.stderr) {
            return false;
        }
        return undefined === output.stdout || "" === output.stdout;
    }
    static() {
        return this.constructor;
    }
}
OutputChannel.accepted_output_streams = ["stdout", "stderr"];
OutputChannel.accepts_empty_output = false;
/**
 * Determines if the output channel wants to handle a unified output or not. If yes, this property should define a
 * delimiter string that will be used as a glue between different output streams.
 *
 * @protected
 */
OutputChannel.combine_output_streams = false;
/**
 * Used in OutputModal to redirect output based on hotkeys. If this is undefined, then the output channel is completely
 * excluded from OutputModal.
 */
OutputChannel.hotkey_letter = undefined;

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class OutputChannel_Notification extends OutputChannel {
    constructor() {
        super(...arguments);
        /**
         * All received output cumulatively. Subsequent handlings will then use the whole output, not just new parts.
         * Only used in "realtime" mode.
         *
         * @private
         */
        this.realtimeContentBuffer = "";
        /**
         * A flag for indicating that if any stderr output has happened, all subsequent handlings should format the output
         * Notice message with error formatting (i.e. show [...] at the beginning of the message).
         * @private
         */
        this.realtimeHasStderrOccurred = false;
    }
    static getTitle(output_stream) {
        switch (output_stream) {
            case "stdout":
                return "Notification balloon";
            case "stderr":
                return "Error balloon";
        }
    }
    async _handleBuffered(output, error_code) {
        // Iterate output streams.
        // There can be both "stdout" and "stderr" present at the same time, or just one of them. If both are present, two
        // notifications will be created.
        let output_stream_name;
        for (output_stream_name in output) {
            const output_message = output[output_stream_name]; // as string = output message is not undefined because of the for loop.
            this.notify(output_stream_name, output_message, error_code);
        }
    }
    async _handleRealtime(outputContent, outputStreamName) {
        // Append new content
        this.realtimeContentBuffer += outputContent;
        // Raise a flag if seeing 'stderr' output.
        if ("stderr" === outputStreamName) {
            this.realtimeHasStderrOccurred = true;
        }
        // Does a Notice exist already?
        if (this.realtimeNotice) {
            // Reuse an existing Notice.
            // Should output be formatted as an error message?
            let updatedMessage;
            if (this.realtimeHasStderrOccurred) {
                // Apply error formatting to output
                updatedMessage = OutputChannel_Notification.formatErrorMessage(this.realtimeContentBuffer, null);
            }
            else {
                // Use output as-is
                updatedMessage = this.realtimeContentBuffer;
            }
            // Use the updated output
            this.realtimeNotice.setMessage(updatedMessage);
            // Update notice hiding timeout
            window.clearTimeout(this.realtimeNoticeTimeout); // Remove old timeout
            this.handleNotificationHiding(outputStreamName); // Add new timeout
        }
        else {
            // Create a new Notice.
            this.realtimeNotice = this.notify(this.realtimeHasStderrOccurred ? "stderr" : "stdout", this.realtimeContentBuffer, null, 0);
            // Create a timeout for hiding the Notice
            this.handleNotificationHiding(outputStreamName);
        }
        // Terminating button
        // @ts-ignore Notice.noticeEl belongs to Obsidian's PRIVATE API, and it may change without a prior notice. Only
        // create the button if noticeEl exists and is an HTMLElement.
        const noticeEl = this.realtimeNotice.noticeEl;
        if (null === this.processTerminator) {
            throw new Error("Process terminator is not set, although it should be set when handling output in realtime mode.");
        }
        if (undefined !== noticeEl && noticeEl instanceof HTMLElement) {
            this.plugin.createRequestTerminatingButton(noticeEl, this.processTerminator);
        }
    }
    _endRealtime(exitCode) {
        if (exitCode !== 0 || this.realtimeHasStderrOccurred) {
            // If a Notice exists, update it with the exitCode
            this.realtimeNotice?.setMessage(OutputChannel_Notification.formatErrorMessage(this.realtimeContentBuffer, exitCode));
        }
        // Remove terminating button
        // @ts-ignore Notice.noticeEl belongs to Obsidian's PRIVATE API, and it may change without a prior notice. Only
        // create the button if noticeEl exists and is an HTMLElement.
        const noticeEl = this.realtimeNotice?.noticeEl;
        if (undefined !== noticeEl && noticeEl instanceof HTMLElement) {
            noticeEl.find(".SC-icon-terminate-process")?.remove(); // ? = Only try to remove if the button exists. It does not exist if .setMessage() was called above as it overwrites all content in the Notice.
        }
    }
    /**
     *
     * @param outputStreamName
     * @param outputContent
     * @param exitCode
     * @param noticeTimeout Allows overriding the notice/error timeout setting.
     * @private
     */
    notify(outputStreamName, outputContent, exitCode, noticeTimeout) {
        switch (outputStreamName) {
            case "stdout":
                // Normal output
                return this.plugin.newNotification(outputContent, noticeTimeout ?? undefined);
            case "stderr":
                // Error output
                return this.plugin.newError(OutputChannel_Notification.formatErrorMessage(outputContent, exitCode), noticeTimeout ?? undefined);
        }
    }
    static formatErrorMessage(outputContent, exitCode) {
        if (null === exitCode) {
            // If a "realtime" process is not finished, there is no exit code yet.
            // @ts-ignore Yea I know "..." is not a number nor null. :)
            exitCode = "...";
        }
        return "[" + exitCode + "]: " + outputContent;
    }
    handleNotificationHiding(outputStreamName) {
        // Hide by timeout
        let normalTimeout;
        switch (outputStreamName) {
            case "stdout":
                normalTimeout = this.plugin.getNotificationMessageDurationMs();
                break;
            case "stderr":
                normalTimeout = this.plugin.getErrorMessageDurationMs();
                break;
        }
        this.realtimeNoticeTimeout = window.setTimeout(() => {
            // Hide the Notice
            this.realtimeNotice?.hide(); // ? = Don't try to hide if a user has closed the notification by clicking. See the 'this.realtimeNotice = undefined;' line in the below click handler.
            this.realtimeNotice = undefined;
            this.realtimeNoticeTimeout = undefined;
        }, normalTimeout);
        // Subscribe to Notice's click event.
        // @ts-ignore Notice.noticeEl belongs to Obsidian's PRIVATE API, and it may change without a prior notice. Only
        // define the click listener if noticeEl exists and is an HTMLElement.
        const noticeEl = this.realtimeNotice.noticeEl;
        if (undefined !== noticeEl && noticeEl instanceof HTMLElement) {
            noticeEl.onClickEvent(() => {
                window.clearTimeout(this.realtimeNoticeTimeout); // Make sure timeout will not accidentally try to later hide an already hidden Notification.
                this.realtimeNoticeTimeout = undefined;
                this.realtimeNotice = undefined; // Give a signal to _handleRealtime() that if new output comes, a new Notice should be created.
            });
        }
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class OutputChannel_CurrentFile extends OutputChannel {
    async _handleBuffered(outputContent) {
        this.handle(outputContent);
    }
    async _handleRealtime(outputContent) {
        this.handle(outputContent);
    }
    handle(output_message) {
        const editor = getEditor(this.app);
        const view = getView(this.app);
        if (null === editor) {
            // For some reason it's not possible to get an editor.
            this.plugin.newError("Could not get an editor instance! Please create a discussion in GitHub. The command output is in the next error box:");
            this.plugin.newError(output_message); // Good to output it at least some way.
            debugLog("OutputChannel_CurrentFile: Could not get an editor instance.");
            return;
        }
        // Check if the view is in source mode
        if (null === view) {
            // For some reason it's not possible to get an editor, but it's not a big problem.
            debugLog("OutputChannel_CurrentFile: Could not get a view instance.");
        }
        else {
            // We do have a view
            if ("source" !== view.getMode()) {
                // Warn that the output might go to an unexpected place in the note file.
                this.plugin.newNotification("Note that your active note is not in 'Edit' mode! The output comes visible when you switch to 'Edit' mode again!");
            }
        }
        // Insert into the current file
        this.insertIntoEditor(editor, output_message);
    }
}
/**
 * There can be both "stdout" and "stderr" present at the same time, or just one of them. If both are present, they
 * will be joined together with " " as a separator.
 * @protected
 */
OutputChannel_CurrentFile.combine_output_streams = " ";

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class OutputChannel_CurrentFileCaret extends OutputChannel_CurrentFile {
    /**
     * Inserts text into the given editor, at caret position.
     *
     * @param editor
     * @param output_message
     * @protected
     */
    insertIntoEditor(editor, output_message) {
        editor.replaceSelection(output_message);
    }
}
OutputChannel_CurrentFileCaret.title = "Current file: caret position";
OutputChannel_CurrentFileCaret.hotkey_letter = "R";

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class OutputChannel_CurrentFileTop extends OutputChannel_CurrentFile {
    /**
     * Inserts text into the given editor, at top.
     *
     * @param editor
     * @param output_message
     * @protected
     */
    insertIntoEditor(editor, output_message) {
        const top_position = editor.offsetToPos(0);
        editor.replaceRange(output_message, top_position);
    }
}
OutputChannel_CurrentFileTop.title = "Current file: top";
OutputChannel_CurrentFileTop.hotkey_letter = "T";

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class OutputChannel_StatusBar extends OutputChannel {
    constructor() {
        super(...arguments);
        /**
         * All received output cumulatively. Subsequent handlings will then use the whole output, not just new parts.
         * Only used in "realtime" mode.
         *
         * @private
         */
        this.realtimeContentBuffer = "";
    }
    async _handleBuffered(outputContent) {
        this.setStatusBarContent(outputContent);
    }
    async _handleRealtime(outputContent) {
        this.realtimeContentBuffer += outputContent;
        this.setStatusBarContent(this.realtimeContentBuffer);
    }
    setStatusBarContent(outputContent) {
        const status_bar_element = this.plugin.getOutputStatusBarElement();
        outputContent = outputContent.trim();
        // Full output (shown when hovering with mouse)
        status_bar_element.setAttr("aria-label", outputContent);
        // Show last line permanently.
        const output_message_lines = outputContent.split(/(\r\n|\r|\n)/u);
        const last_output_line = output_message_lines[output_message_lines.length - 1];
        status_bar_element.setText(last_output_line);
    }
}
OutputChannel_StatusBar.title = "Status bar";
OutputChannel_StatusBar.accepts_empty_output = true;
OutputChannel_StatusBar.hotkey_letter = "S";
/**
 * Combine stdout and stderr (in case both of them happen to be present).
 * @protected
 */
OutputChannel_StatusBar.combine_output_streams = os.EOL + os.EOL;

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class OutputChannel_CurrentFileBottom extends OutputChannel_CurrentFile {
    /**
     * Inserts text into the given editor, at bottom.
     *
     * @param editor
     * @param output_message
     * @protected
     */
    insertIntoEditor(editor, output_message) {
        const bottom_position = {
            ch: editor.getLine(editor.lastLine()).length,
            line: editor.lastLine(), // ... the last line.
        }; // *) But do not subtract 1, because ch is zero-based, so when .length is used without -1, we are pointing AFTER the last character.
        editor.replaceRange(output_message, bottom_position);
    }
}
OutputChannel_CurrentFileBottom.title = "Current file: bottom";
OutputChannel_CurrentFileBottom.hotkey_letter = "B";

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class OutputChannel_Clipboard extends OutputChannel {
    constructor() {
        super(...arguments);
        /**
         * All received output cumulatively. Subsequent handlings will then use the whole output, not just new parts.
         * Only used in "realtime" mode.
         *
         * @private
         */
        this.realtimeContentBuffer = "";
    }
    async _handleBuffered(outputContent) {
        await copyToClipboard(outputContent);
        this.notify(outputContent);
    }
    async _handleRealtime(outputContent) {
        this.realtimeContentBuffer += outputContent;
        await copyToClipboard(this.realtimeContentBuffer);
        this.notify(this.realtimeContentBuffer);
    }
    notify(output_message) {
        if (this.plugin.settings.output_channel_clipboard_also_outputs_to_notification) {
            // Notify the user so they know a) what was copied to clipboard, and b) that their command has finished execution.
            this.plugin.newNotification("Copied to clipboard: " + os.EOL + output_message + os.EOL + os.EOL + "(Notification can be turned off in settings.)");
        }
    }
}
OutputChannel_Clipboard.title = "Clipboard";
OutputChannel_Clipboard.hotkey_letter = "L";
/**
 * There can be both "stdout" and "stderr" present at the same time, or just one of them. If both are present, they
 * will be joined together with " " as a separator.
 * @protected
 */
OutputChannel_Clipboard.combine_output_streams = " "; // TODO: Change to "" as there should be no extra space between stdout and stderr. Compare it to the terminal: AFAIK there is no separation between stdout and stderr outputs, just that typically each output ends with a newline.

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
/**
 * TODO: Move this to TShellCommand.
 */
function getHotkeysForShellCommand(plugin, shell_command_id) {
    // Retrieve all hotkeys set by user.
    // @ts-ignore
    const app_custom_hotkeys = plugin.app.hotkeyManager?.customKeys;
    if (!app_custom_hotkeys) {
        debugLog("getHotkeysForShellCommand() failed, will return an empty array.");
        return [];
    }
    // Get only our hotkeys.
    const hotkey_index = plugin.getPluginId() + ":" + plugin.generateObsidianCommandId(shell_command_id); // E.g. "obsidian-shellcommands:shell-command-0"
    debugLog("getHotkeysForShellCommand() succeeded.");
    return app_custom_hotkeys[hotkey_index] ?? []; // If no hotkey array is set for this command, return an empty array. Although I do believe that all commands do have an array anyway, but have this check just in case.
}
/**
 * TODO: Is there a way to make Obsidian do this conversion for us? Check this: https://github.com/pjeby/hotkey-helper/blob/c8a032e4c52bd9ce08cb909cec15d1ed9d0a3439/src/plugin.js#L4-L6
 *
 * @param hotkey
 * @constructor
 */
function HotkeyToString(hotkey) {
    const keys = [];
    hotkey.modifiers.forEach((modifier) => {
        let modifier_key = modifier.toString(); // This is one of 'Mod' | 'Ctrl' | 'Meta' | 'Shift' | 'Alt'
        if ("Mod" === modifier_key) {
            // Change "Mod" to something more meaningful.
            modifier_key = CmdOrCtrl(); // isMacOS should also be true if the device is iPhone/iPad. Can be handy if this plugin gets mobile support some day.
        }
        keys.push(modifier_key);
    });
    keys.push(hotkey.key); // This is something like a letter ('A', 'B' etc) or space/enter/whatever.
    return keys.join(" + ");
}
function CmdOrCtrl() {
    return obsidian.Platform.isMacOS ? "Cmd" : "Ctrl";
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class OutputChannel_Modal extends OutputChannel {
    initialize() {
        // Initialize a modal (but don't open yet)
        this.modal = new OutputModal(this.plugin, this.t_shell_command, this.shell_command_parsing_result, this.processTerminator);
    }
    async _handleBuffered(outputs, error_code) {
        // Pass outputs to modal
        this.modal.setOutputContents(outputs);
        // Define a possible error code to be shown on the modal.
        if (error_code !== null) {
            this.modal.setExitCode(error_code);
        }
        // Done
        this.modal.open();
    }
    async _handleRealtime(outputContent, outputStreamName) {
        this.modal.addOutputContent(outputStreamName, outputContent);
        if (!this.modal.isOpen()) {
            this.modal.open();
        }
    }
    /**
     * @param exitCode Can be null if user terminated the process by clicking a button. In other places exitCode can be null if process is still running, but here that cannot be the case.
     *
     * @protected
     */
    _endRealtime(exitCode) {
        // Delete terminator button as the process is already ended.
        this.modal.removeProcessTerminatorButton();
        // Pass exitCode to the modal
        this.modal.setExitCode(exitCode);
    }
}
OutputChannel_Modal.title = "Ask after execution";
class OutputModal extends SC_Modal {
    constructor(plugin, t_shell_command, shell_command_parsing_result, processTerminator) {
        super(plugin);
        this.processTerminator = processTerminator;
        this.exit_code = null; // TODO: Think about changing the logic: exit code could be undefined when it's not received, and null when a user has terminated the execution. The change needs to be done in the whole plugin, although I only wrote about it in this OutputModal class.
        this.outputFields = {};
        this.t_shell_command = t_shell_command;
        this.shell_command_parsing_result = shell_command_parsing_result;
        this.createOutputFields();
    }
    /**
     * Called when doing "buffered" output handling.
     *
     * @param outputs
     */
    setOutputContents(outputs) {
        Object.getOwnPropertyNames(outputs).forEach((outputStreamName) => {
            const outputField = this.outputFields[outputStreamName];
            // Set field value
            const textareaComponent = outputField.components.first();
            const outputContent = outputs[outputStreamName];
            textareaComponent.setValue(outputContent); // as string = outputContent is not undefined because of the .forEach() loop.
            // Make field visible (if it's not already)
            outputField.settingEl.matchParent(".SC-hide")?.removeClass("SC-hide");
        });
    }
    /**
     * Called when doing "realtime" output handling.
     *
     * @param outputStreamName
     * @param outputContent
     */
    addOutputContent(outputStreamName, outputContent) {
        const outputField = this.outputFields[outputStreamName];
        // Update field value
        const textareaComponent = outputField.components.first();
        textareaComponent.setValue(textareaComponent.getValue() + outputContent);
        // Make field visible (if it's not already)
        outputField.settingEl.matchParent(".SC-hide")?.removeClass("SC-hide");
    }
    onOpen() {
        super.onOpen();
        this.modalEl.addClass("SC-modal-output");
        // Heading
        const heading = this.shell_command_parsing_result.alias;
        this.titleEl.innerText = heading ? heading : "Shell command output"; // TODO: Use this.setTitle() instead.
        // Shell command preview
        this.modalEl.createEl("pre", { text: this.shell_command_parsing_result.shell_command, attr: { class: "SC-no-margin SC-wrappable" } }); // no margin so that exit code will be close.
        // Container for terminating button and exit code
        const processResultContainer = this.modalEl.createDiv();
        // 'Request to terminate the process' icon button
        if (this.processTerminator) {
            this.processTerminatorButtonContainer = processResultContainer.createEl('span');
            this.plugin.createRequestTerminatingButton(this.processTerminatorButtonContainer, this.processTerminator);
        }
        // Exit code (put on same line with process terminator button, if exists)
        this.exitCodeElement = processResultContainer.createEl("small", { text: "Executing...", attr: { style: "font-weight: bold;" } }); // Show "Executing..." before an actual exit code is received.
        if (this.exit_code !== null) {
            this.displayExitCode();
        }
        // Output fields
        this.modalEl.insertAdjacentElement("beforeend", this.outputFieldsContainer);
        // Focus on the first output field
        this.focusFirstField();
        // A tip about selecting text.
        this.modalEl.createDiv({
            text: "Tip! If you select something, only the selected text will be used.",
            attr: { class: "setting-item-description" /* A CSS class defined by Obsidian. */ },
        });
    }
    createOutputFields() {
        // Create a parent-less container. onOpen() will place it in the correct place.
        this.outputFieldsContainer = document.createElement('div');
        // Create field containers in correct order
        let stdoutFieldContainer;
        let stderrFieldContainer;
        switch (this.t_shell_command.getOutputChannelOrder()) {
            case "stdout-first": {
                stdoutFieldContainer = this.outputFieldsContainer.createDiv();
                stderrFieldContainer = this.outputFieldsContainer.createDiv();
                break;
            }
            case "stderr-first": {
                stderrFieldContainer = this.outputFieldsContainer.createDiv();
                stdoutFieldContainer = this.outputFieldsContainer.createDiv();
                break;
            }
        }
        // Create fields
        this.outputFields.stdout = this.createOutputField("stdout", stdoutFieldContainer);
        this.outputFields.stderr = this.createOutputField("stderr", stderrFieldContainer);
        // Hide the fields' containers at the beginning. They will be shown when content is added.
        stdoutFieldContainer.addClass("SC-hide");
        stderrFieldContainer.addClass("SC-hide");
    }
    createOutputField(output_stream, containerElement) {
        let output_textarea;
        containerElement.createEl("hr", { attr: { class: "SC-no-margin" } });
        // Output stream name
        new obsidian.Setting(containerElement)
            .setName(output_stream)
            .setHeading()
            .setClass("SC-no-bottom-border");
        // Textarea
        const textarea_setting = new obsidian.Setting(containerElement)
            .addTextArea(textarea => output_textarea = textarea);
        textarea_setting.infoEl.addClass("SC-hide"); // Make room for the textarea by hiding the left column.
        textarea_setting.settingEl.addClass("SC-output-channel-modal-textarea-container", "SC-no-top-border");
        // Add controls for redirecting the output to another channel.
        const redirect_setting = new obsidian.Setting(containerElement)
            .setDesc("Redirect:")
            .setClass("SC-no-top-border")
            .setClass("SC-output-channel-modal-redirection-buttons-container") // I think this calls actually HTMLDivElement.addClass(), so it should not override the previous .setClass().
        ;
        const outputChannels = getOutputChannelClasses();
        Object.getOwnPropertyNames(outputChannels).forEach((output_channel_name) => {
            const outputChannelClass = outputChannels[output_channel_name];
            // Ensure this channel is not excluded by checking that is has a hotkey defined.
            if (outputChannelClass.hotkey_letter) {
                // Ensure the output channel accepts this output stream. E.g. OutputChannel_OpenFiles does not accept "stderr".
                if (outputChannelClass.acceptsOutputStream(output_stream)) {
                    const textarea_element = textarea_setting.settingEl.find("textarea");
                    // Define an output handler
                    const handle_output = async () => {
                        // Redirect output to the selected channel
                        const output_streams = {};
                        output_streams[output_stream] =
                            getSelectionFromTextarea(textarea_element, true) // Use the selection, or...
                                ?? output_textarea.getValue() // ...use the whole text, if nothing is selected.
                        ;
                        const outputChannel = initializeOutputChannel(output_channel_name, this.plugin, this.t_shell_command, this.shell_command_parsing_result, "buffered", // Use "buffered" mode even if this modal was opened in "realtime" mode, because at this point the output redirection is a single-time job, not recurring.
                        this.processTerminator);
                        await outputChannel.handleBuffered(output_streams, this.exit_code, false); // false: Disable output wrapping as it's already wrapped before the output content was passed to this modal.
                    };
                    // Create the button
                    redirect_setting.addButton((button) => {
                        button.onClick(async (event) => {
                            // Handle output
                            await handle_output();
                            // Finish
                            if (event.ctrlKey) {
                                // Special click, control/command key is pressed.
                                // Close the modal.
                                this.close();
                            }
                            else {
                                // Normal click, control key is not pressed.
                                // Do not close the modal.
                                textarea_element.focus(); // Bring the focus back to the textarea in order to show a possible highlight (=selection) again.
                            }
                        });
                        // Define button texts and assign hotkeys
                        const output_channel_title = outputChannelClass.getTitle(output_stream);
                        // Button text
                        button.setButtonText(output_channel_title);
                        // Tips about hotkeys
                        button.setTooltip(`Redirect: Normal click OR ${CmdOrCtrl()} + ${outputChannelClass.hotkey_letter}.`
                            + os.EOL + os.EOL +
                            `Redirect and close the modal: ${CmdOrCtrl()} + click OR ${CmdOrCtrl()} + Shift + ${outputChannelClass.hotkey_letter}.`);
                    });
                    // 1. hotkey: Ctrl/Cmd + number: handle output
                    this.scope.register(["Ctrl"], outputChannelClass.hotkey_letter, handle_output);
                    // 2. hotkey: Ctrl/Cmd + Shift + number: handle output and close the modal.
                    this.scope.register(["Ctrl", "Shift"], outputChannelClass.hotkey_letter, () => {
                        handle_output().then(); // then(): No need to wait for output handling to finish before closing the modal.
                        this.close();
                    });
                }
            }
        });
        return textarea_setting;
    }
    removeProcessTerminatorButton() {
        if (this.processTerminatorButtonContainer) {
            this.processTerminatorButtonContainer.remove();
        }
    }
    /**
     * Should be called only if an exit code was received.
     *
     * @param exit_code Can be null if user terminated the process by clicking a button.
     */
    setExitCode(exit_code) {
        this.exit_code = exit_code;
        // Try to show the exit code.
        if (this.isOpen()) {
            if (null === this.exit_code) {
                // User has terminated the process, so there's no exit code even though the process has ended.
                this.exitCodeElement.innerText = "User terminated";
            }
            else {
                // displayExistCode() can only be called if onOpen() has been called before.
                // If onOpen() will be called later, it will call displayExitCode() itself when it sees that this.exit_code is defined.
                this.displayExitCode();
            }
        }
    }
    displayExitCode() {
        if (null === this.exit_code) {
            // Currently there are two callers for this method, and both of them does a null check on the exit code before'
            // the call, so we'll never get here in practise.
            // TODO: Remove this checking/throwing and make this method able to display three texts: a) an exit code, b) Executing..., or c) User terminated.
            throw new Error("Cannot display exit code because it's null");
        }
        this.exitCodeElement.innerText = "Exit code: " + this.exit_code.toString();
    }
    focusFirstField() {
        switch (this.t_shell_command.getOutputChannelOrder()) {
            case "stdout-first": {
                this.outputFields.stdout.controlEl.find("textarea").focus();
                break;
            }
            case "stderr-first": {
                this.outputFields.stderr.controlEl.find("textarea").focus();
                break;
            }
        }
    }
    approve() {
        // No need to perform any action, just close the modal.
        this.close();
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class OutputChannel_OpenFiles extends OutputChannel {
    _handleBuffered(output, error_code) {
        let handlingPipeline = Promise.resolve();
        let output_stream_name;
        for (output_stream_name in output) {
            handlingPipeline = handlingPipeline.finally(() => {
                return this.handle(output[output_stream_name]);
            });
        }
        return handlingPipeline;
    }
    _handleRealtime(outputContent) {
        return this.handle(outputContent);
    }
    handle(outputContent) {
        return new Promise((resolve) => {
            // Read file definitions. Usually there's just one, but there can be many. Definitions are separated by newline
            // characters. Each file definition defines one file to be opened.
            const file_definitions_string = outputContent.trim(); // Contains at least file name(s), and MAYBE: a caret position, new pane option, and view state
            const file_definitions = file_definitions_string.split(/[\r\n]+/u);
            // Iterate all file definitions that should be opened.
            let opening_pipeline = Promise.resolve();
            for (const file_definition of file_definitions) {
                // Chain each file opening to happen one after another. If one file opening fails for whatever reason, it
                // is ok to continue to open the next file. This is why .finally() is used instead of .then().
                opening_pipeline = opening_pipeline.finally(() => {
                    return this.interpretFileOpeningDefinition(file_definition);
                });
            }
            opening_pipeline.finally(() => resolve() /* Tell that all openings have been processed. */);
        });
    }
    interpretFileOpeningDefinition(file_definition) {
        return new Promise((resolve, reject) => {
            debugLog("OutputChannel_OpenFiles: Interpreting file opening definition: " + file_definition);
            // Get parts that define different details about how the file should be opened
            const file_definition_parts = file_definition.split(":"); // If file_definition is "", i.e. an empty string, the result will be [""], i.e. an array with an empty string as its only item.
            // The first part is always the file path
            let open_file_path = file_definition_parts.shift(); // If file_definition is "", this will be "", too. 'as string' is used because file_definition_parts is never empty (it always contains at least one item), so .shift() will never return undefined here.
            // On Windows: Check if an absolute path was split incorrectly. (E.g. a path starting with "C:\...").
            if (isWindows() && file_definition_parts.length > 0) {
                const combined_path = open_file_path + ":" + file_definition_parts[0];
                if (path__namespace.isAbsolute(combined_path)) {
                    // Yes, the first two parts do form an absolute path together, so they should not be split.
                    open_file_path = combined_path;
                    file_definition_parts.shift(); // Remove the second part so that it won't be accidentally processed in the 'Special features' part.
                }
            }
            // Trim the file path, for being able to use cleaner separation between file name and other parts, e.g: MyFile.md : new-pane
            open_file_path = open_file_path.trim();
            // Special features
            const caret_parts = []; // If caret position is present in file_definition_parts, the first item in this array will be the caret line, the second will be the column. If more parts are present, they will be used for making selections.
            let newLeaf = false;
            let can_create_file = false;
            let file_definition_interpreting_failed = false;
            file_definition_parts.forEach((file_definition_part) => {
                file_definition_part = file_definition_part.toLocaleLowerCase().trim(); // .trim() is for being able to use cleaner separation between e.g. different selections: MyFile.md:1:1:1:-1 : 5:1:5:-1
                // Determine the part type
                if (isInteger(file_definition_part, true)) {
                    // This is a number, so consider it as a caret position part.
                    caret_parts.push(parseInt(file_definition_part));
                }
                else {
                    const multipleNewPartsErrorMessage = "Cannot open file: Only one of the following can be defined: new-pane, new-tab, or new-window.";
                    switch (file_definition_part) {
                        case "new-pane":
                            // Ensure no new-* definition is used before.
                            if (newLeaf === false) {
                                newLeaf = "split";
                            }
                            else {
                                this.plugin.newError(multipleNewPartsErrorMessage);
                                file_definition_interpreting_failed = true;
                            }
                            break;
                        case "new-tab":
                            // Ensure no new-* definition is used before.
                            if (newLeaf === false) {
                                newLeaf = "tab";
                            }
                            else {
                                this.plugin.newError(multipleNewPartsErrorMessage);
                                file_definition_interpreting_failed = true;
                            }
                            break;
                        case "new-window":
                            // Ensure no new-* definition is used before.
                            if (newLeaf === false) {
                                newLeaf = "window";
                            }
                            else {
                                this.plugin.newError(multipleNewPartsErrorMessage);
                                file_definition_interpreting_failed = true;
                            }
                            break;
                        case "can-create-file":
                            can_create_file = true;
                            break;
                        default:
                            this.plugin.newError("Cannot open file: Unrecognised definition part: " + file_definition_part + " in " + file_definition);
                            file_definition_interpreting_failed = true;
                    }
                }
            });
            if (file_definition_interpreting_failed) {
                reject();
                return;
            }
            // Ensure the path is relative
            if (path__namespace.isAbsolute(open_file_path)) {
                // The path is absolute.
                // Check if it can be converted to relative.
                const vault_absolute_path = getVaultAbsolutePath(this.app);
                if (open_file_path.toLocaleLowerCase().startsWith(vault_absolute_path.toLocaleLowerCase())) {
                    // Converting to relative is possible
                    open_file_path = open_file_path.substr(vault_absolute_path.length); // Get everything after the point where the vault path ends.
                }
                else {
                    // Cannot convert to relative, because the file does not reside in the vault
                    this.plugin.newError("Cannot open file '" + open_file_path + "' as the path is outside this vault.");
                    reject();
                    return;
                }
            }
            // Clean up the file path
            open_file_path = obsidian.normalizePath(open_file_path); // normalizePath() is used on purpose, instead of normalizePath2(), because backslashes \ should be converted to forward slashes /
            this.openFileInTab(open_file_path, newLeaf, can_create_file).then(() => {
                // The file is now open
                // Check, did we have a caret position available. If not, do nothing.
                const count_caret_parts = caret_parts.length;
                if (count_caret_parts > 0) {
                    // Yes, a caret position was defined in the output.
                    // Ensure the correct amount of caret position parts.
                    // 0 parts: no caret positioning needs to be done (but in this part of code the amount of parts is always greater than 0).
                    // 1 part: caret line is defined, no column.
                    // 2 parts: caret line and column are defined.
                    // 3 parts: NOT ALLOWED.
                    // 4 parts: selection starting position (line, column) and selection end position (line, column) are defined.
                    // 5 parts or more: NOT ALLOWED. Exception: any number of sets of four parts is allowed, i.e. 8 parts, 12 parts, 16 parts etc. are allowed as they can define multiple selections.
                    const error_message_base = "File opened, but caret cannot be positioned due to an incorrect amount (" + count_caret_parts + ") of numeric values in the output: " + file_definition + os.EOL + os.EOL;
                    if (count_caret_parts == 3) {
                        // Incorrect amount of caret parts
                        this.plugin.newError(error_message_base + "Three numeric parts is an incorrect amount, correct would be 1,2 or 4 parts.");
                        reject();
                        return;
                    }
                    else if (count_caret_parts > 4 && count_caret_parts % 4 !== 0) {
                        // Incorrect amount of caret parts
                        this.plugin.newError(error_message_base + "Perhaps too many numeric parts are defined? If more than four parts are defined, make sure to define complete sets of four parts. The amount of numeric parts needs to be dividable by 4.");
                        reject();
                        return;
                    }
                    // Even though the file is already loaded, rendering it may take some time, thus the height of the content may increase.
                    // For this reason, there needs to be a tiny delay before setting the caret position. If the caret position is set immediately,
                    // the caret will be placed in a correct position, but it might be that the editor does not scroll into correct position, so the
                    // caret might be out of the view, even when it's in a correct place. (Obsidian version 0.13.23).
                    window.setTimeout(() => {
                        const editor = getEditor(this.app);
                        if (editor) {
                            if (count_caret_parts >= 4) {
                                // Selection mode
                                // There can be multiple selections defined
                                const selections = [];
                                while (caret_parts.length) {
                                    const fromLine = caret_parts.shift();
                                    const fromColumn = caret_parts.shift();
                                    const toLine = caret_parts.shift();
                                    const toColumn = caret_parts.shift();
                                    if (undefined === fromLine || undefined === fromColumn || undefined === toLine || undefined === toColumn) {
                                        // This should never happen.
                                        throw new Error("Encountered undefined values in fromLine, fromColumn, toLine, and/or toColumn. Strange, because the correct amount of parts in caret_parts was checked beforehand.");
                                    }
                                    selections.push({
                                        anchor: prepareEditorPosition(editor, fromLine, fromColumn),
                                        head: prepareEditorPosition(editor, toLine, toColumn),
                                    });
                                }
                                editor.setSelections(selections);
                            }
                            else {
                                // Simple caret mode
                                const caret_line = caret_parts[0];
                                const caret_column = caret_parts[1] ?? 1;
                                editor.setCursor(prepareEditorPosition(editor, caret_line, caret_column));
                            }
                            // After placing carets / selecting text, have a small delay after allowing to open another file (in case multiple files are opened in a row). This allows the selection to be remembered in the pane's history.
                            window.setTimeout(resolve, 300); // If you change this ADDITIONAL delay, remember to change it in the documentation, too.
                        }
                        else {
                            // No editor
                            this.plugin.newError("File opened, but caret cannot be positioned because no editor was found.");
                            reject();
                        }
                    }, 500); // 500ms is probably long enough even if a new tab is opened (takes more time than opening a file into an existing tab). This can be made into a setting sometime. If you change this, remember to change it in the documentation, too.
                }
                else {
                    // No caret parts exist. All is done now.
                    resolve();
                }
            }, (error_message) => {
                if (typeof error_message === "string") {
                    // Opening the file has failed.
                    this.plugin.newError(error_message);
                }
                else {
                    // Some other runtime error has occurred.
                    throw error_message;
                }
                reject();
            });
        });
    }
    openFileInTab(file_path, newLeaf, can_create_file) {
        // Ensure that the file exists (or can be created)
        const source_path = ""; // TODO: When adding an option for creating new files, read this documentation from Obsidian API's getNewFileParent(): "sourcePath – The path to the current open/focused file, used when the user wants new files to be created “in the same folder”. Use an empty string if there is no active file."
        const file_exists_or_can_be_created = can_create_file || null !== this.app.metadataCache.getFirstLinkpathDest(file_path, source_path);
        if (file_exists_or_can_be_created) {
            // Yes, the file exists (or can be created)
            return this.app.workspace.openLinkText(file_path, source_path, newLeaf);
        }
        else {
            // No, the file does not exist, and it may not be created.
            return Promise.reject("Cannot open file '" + file_path + "', as it does not exist. (If you want to allow file creation, add :can-create-file to the shell command output.)");
        }
    }
}
OutputChannel_OpenFiles.title = "Open files";
OutputChannel_OpenFiles.hotkey_letter = "O";
/**
 * This output channel is not suitable for stderr, as stderr can contain unexpected messages.
 * @protected
 */
OutputChannel_OpenFiles.accepted_output_streams = ["stdout"];

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
const outputChannelClasses = {};
// Register output channels
registerOutputChannel("notification", OutputChannel_Notification);
registerOutputChannel("current-file-caret", OutputChannel_CurrentFileCaret);
registerOutputChannel("current-file-top", OutputChannel_CurrentFileTop);
registerOutputChannel("current-file-bottom", OutputChannel_CurrentFileBottom);
registerOutputChannel("open-files", OutputChannel_OpenFiles);
registerOutputChannel("status-bar", OutputChannel_StatusBar);
registerOutputChannel("clipboard", OutputChannel_Clipboard);
registerOutputChannel("modal", OutputChannel_Modal);
/**
 * This function is designed to be called after a 'Wait until finished' type of shell command finishes its execution.
 *
 * @param plugin
 * @param t_shell_command
 * @param shell_command_parsing_result
 * @param stdout
 * @param stderr
 * @param error_code TODO: Rename to exitCode everywhere in the codebase.
 * @param output_channels
 */
function handleBufferedOutput(plugin, t_shell_command, shell_command_parsing_result, stdout, stderr, error_code, output_channels) {
    // Terminology: Stream = outputs stream from a command, can be "stdout" or "stderr". Channel = a method for this application to present the output ot user, e.g. "notification".
    const shell_command_configuration = t_shell_command.getConfiguration(); // TODO: Refactor OutputChannels to use TShellCommand instead of the configuration objects directly.
    // Insert stdout and stderr to an object in a correct order
    let output = {};
    if (stdout.length && stderr.length) {
        // Both stdout and stderr have content
        // Decide the output order == Find out which data stream should be processed first, stdout or stderr.
        switch (shell_command_configuration.output_channel_order) {
            case "stdout-first":
                output = {
                    stdout: stdout,
                    stderr: stderr,
                };
                break;
            case "stderr-first":
                output = {
                    stderr: stderr,
                    stdout: stdout,
                };
                break;
        }
    }
    else if (stdout.length) {
        // Only stdout has content
        output = {
            stdout: stdout,
        };
    }
    else if (stderr.length) {
        // Only stderr has content
        output = {
            stderr: stderr,
        };
    }
    else {
        // Neither stdout nor stderr have content
        // Provide empty output, some output channels will process it, while other will just ignore it.
        output = {
            "stdout": "",
        };
    }
    // Should stderr be processed same time with stdout?
    if (output_channels.stdout === output_channels.stderr) {
        // Stdout and stderr use the same channel.
        // Make one handling call.
        handle_stream(plugin, t_shell_command, shell_command_parsing_result, output_channels.stdout, output, error_code);
    }
    else {
        // Stdout and stderr use different channels.
        // Make two handling calls.
        let output_stream_name;
        for (output_stream_name in output) {
            const output_channel_name = output_channels[output_stream_name];
            const output_message = output[output_stream_name];
            const separated_output = {};
            separated_output[output_stream_name] = output_message;
            handle_stream(plugin, t_shell_command, shell_command_parsing_result, output_channel_name, separated_output, error_code);
        }
    }
}
async function handle_stream(plugin, t_shell_command, shell_command_parsing_result, output_channel_name, output, error_code) {
    // Check if the output should be ignored
    if ("ignore" !== output_channel_name) {
        // The output should not be ignored.
        // Check that an output channel class exists
        if (undefined === outputChannelClasses[output_channel_name]) {
            throw new Error("No output channel class found for channel '" + output_channel_name + "'.");
        }
        // Instantiate the channel
        const outputChannel = initializeOutputChannel(output_channel_name, plugin, t_shell_command, shell_command_parsing_result, "buffered", null);
        // Perform handling the output
        await outputChannel.handleBuffered(output, error_code);
    }
}
function startRealtimeOutputHandling(plugin, tShellCommand, shellCommandParsingResult, outputChannelCodes, processTerminator) {
    const outputChannels = {};
    // stdout
    if ("ignore" !== outputChannelCodes.stdout) {
        outputChannels.stdout = initializeOutputChannel(outputChannelCodes.stdout, plugin, tShellCommand, shellCommandParsingResult, "realtime", processTerminator);
    }
    // stderr
    if ("ignore" !== outputChannelCodes.stderr) {
        if (outputChannelCodes.stderr === outputChannelCodes.stdout) {
            // stderr should use the same channel instance as stdout.
            outputChannels.stderr = outputChannels.stdout;
        }
        else {
            // stderr uses a different channel than stdout.
            outputChannels.stderr = initializeOutputChannel(outputChannelCodes.stderr, plugin, tShellCommand, shellCommandParsingResult, "realtime", processTerminator);
        }
    }
    return outputChannels;
}
function getOutputChannelsOptionList(output_stream) {
    const list = { ignore: "Ignore" };
    for (const name in outputChannelClasses) {
        const channelClass = outputChannelClasses[name];
        // Check that the stream is suitable for the channel
        if (channelClass.acceptsOutputStream(output_stream)) {
            list[name] = channelClass.getTitle(output_stream);
        }
    }
    return list;
}
function getOutputChannelClasses() {
    return outputChannelClasses;
}
function initializeOutputChannel(channelCode, plugin, tShellCommand, shellCommandParsingResult, outputHandlingMode, processTerminator) {
    // @ts-ignore TODO: Find out how to tell TypeScript that a subclass is being instatiated instead of the abstract base class:
    return new outputChannelClasses[channelCode](plugin, tShellCommand, shellCommandParsingResult, outputHandlingMode, processTerminator);
}
function registerOutputChannel(channelCode, channelClass) {
    if (undefined !== outputChannelClasses[channelCode]) {
        throw new Error("OutputChannel named '" + channelCode + "' is already registered!");
    }
    outputChannelClasses[channelCode] = channelClass;
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
const PlatformShells = {
    darwin: {
        "/bin/bash": "Bash",
        "/bin/dash": "Dash",
        "/bin/zsh": "Zsh (Z shell)",
    },
    linux: {
        "/bin/bash": "Bash",
        "/bin/dash": "Dash",
        "/bin/zsh": "Zsh (Z shell)",
    },
    win32: {
        "pwsh.exe": "PowerShell Core",
        "PowerShell.exe": "PowerShell 5",
        "CMD.EXE": "cmd.exe",
    },
};
function getUsersDefaultShell() {
    if (isWindows()) {
        if (undefined === process.env.ComSpec) {
            throw new Error("process.env.ComSpec is not a string.");
        }
        return process.env.ComSpec;
    }
    else {
        if (undefined === process.env.SHELL) {
            throw new Error("process.env.SHELL is not a string.");
        }
        return process.env.SHELL;
    }
}
function isShellSupported(shell) {
    const shell_file_name = extractFileName(shell);
    const supported_shells = Object.getOwnPropertyNames(PlatformShells[getOperatingSystem()]);
    // Linux and macOS: Add the ambiguous 'sh' as a supported shell. It's not present in PlatformShells, because it's
    // not desired to be an explicitly selectable shell as it's uncertain, which shell it actually points to. But have
    // it supported when it comes from the "Use system default (sh)" option.
    if (!isWindows()) {
        // The platform is either Linux or macOS.
        // Add 'sh' support.
        supported_shells.push("sh");
    }
    for (const supported_shell_path of supported_shells) {
        // Check that the shell file names match. It doesn't matter in which directory the shell is located in.
        if (extractFileName(supported_shell_path).toLowerCase() === shell_file_name.toLowerCase()) {
            // The shell can be considered to be supported.
            return true;
        }
    }
    return false;
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
function getDefaultSettings(is_new_installation) {
    return {
        // Common:
        settings_version: is_new_installation
            ? SC_Plugin.SettingsVersion // For new installations, a specific settings version number can be used, as migrations do not need to be taken into account.
            : "prior-to-0.7.0" // This will be substituted by ShellCommandsPlugin.saveSettings() when the settings are saved.
        ,
        // Hidden settings (no UI controls in the settings panel)
        debug: false,
        obsidian_command_palette_prefix: "Execute: ",
        // Variables:
        preview_variables_in_command_palette: true,
        show_autocomplete_menu: true,
        // Environments:
        working_directory: "",
        default_shells: {},
        environment_variable_path_augmentations: {},
        // Output:
        error_message_duration: 20,
        notification_message_duration: 10,
        execution_notification_mode: "disabled",
        output_channel_clipboard_also_outputs_to_notification: true,
        // Events:
        enable_events: true,
        // Modals:
        approve_modals_by_pressing_enter_key: true,
        // Shell commands:
        max_visible_lines_in_shell_command_fields: false,
        shell_commands: [],
        // Prompts:
        prompts: [],
        // Additional configuration for built-in variables:
        builtin_variables: {},
        // Custom variables
        custom_variables: [],
        // Output wrappers
        output_wrappers: [],
    };
}
const PlatformNames = {
    darwin: "Macintosh",
    linux: "Linux",
    win32: "Windows",
};
const CommandPaletteOptions = {
    enabled: "Command palette & hotkeys",
    unlisted: "Hotkeys only",
    disabled: "Excluded",
};

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class ShellCommandExecutor {
    constructor(plugin, t_shell_command, 
    /** Needed for Preactions to be able to access all variables, in case any variables are used by a Preaction. Use null, if the shell command execution happens outside of any event context. */
    sc_event) {
        this.plugin = plugin;
        this.t_shell_command = t_shell_command;
        this.sc_event = sc_event;
    }
    /**
     * Performs preactions, and if they all give resolved Promises, executes the shell command.
     */
    async doPreactionsAndExecuteShellCommand(parsing_process, overriding_output_channel) {
        const preactions = this.t_shell_command.getPreactions();
        // Does an already started ParsingProcess exist?
        if (!parsing_process) {
            // No ParsingProcess yet.
            // Create one and parse all variables that are safe to parse before preactions.
            debugLog("Going to prepare possible Preactions, but will first start a variable parsing process. Depending on possible Preactions, this might not yet parse all variables.");
            parsing_process = this.t_shell_command.createParsingProcess(this.sc_event);
            // Parse the first set of variables, not all sets.
            if (!await parsing_process.process()) {
                // Some errors happened.
                debugLog("Will not prepare possible Preactions, because the parsing process failed. Will cancel shell command execution.");
                parsing_process.displayErrorMessages();
                return;
            }
        }
        else {
            debugLog("Going to prepare possible Preactions with an already started variable parsing process.");
        }
        // Create a pipeline for preactions.
        let preaction_pipeline = Promise.resolve(true); // Will contain a series of preaction performs.
        // Confirm execution from a user, if needed.
        // I haven't decided yet if I want to move this to be its own Preaction subclass. Might make sense, but requires configuration migration.
        if (this.t_shell_command.getConfiguration().confirm_execution) {
            preaction_pipeline = preaction_pipeline.then(() => {
                debugLog("Asking a confirmation from a user to execute shell command #" + this.t_shell_command.getId());
                return new Promise((resolve, reject) => {
                    const confirmation_modal = new ConfirmationModal(this.plugin, this.t_shell_command.getAliasOrShellCommand(), "Execute this shell command?", "Yes, execute");
                    confirmation_modal.open();
                    confirmation_modal.promise.then((execution_confirmed) => {
                        if (execution_confirmed) {
                            // The PromptModal has been closed.
                            // Check if user wanted to execute the shell command or cancel.
                            if (execution_confirmed) {
                                // User wants to execute.
                                debugLog("User confirmed to execute shell command #" + this.t_shell_command.getId());
                                resolve(true);
                            }
                            else {
                                // User wants to cancel.
                                debugLog("User cancelled execution of shell command #" + this.t_shell_command.getId());
                                resolve(false);
                            }
                        }
                    });
                });
            });
        }
        // Perform preactions
        preactions.forEach((preaction) => {
            debugLog(`Adding Preaction of type '${preaction.configuration.type}' to pipeline.`);
            preaction_pipeline = preaction_pipeline.then(() => {
                debugLog(`Calling Preaction of type '${preaction.configuration.type}'.`);
                if (!parsing_process) {
                    // Should have a ParsingProcess at this point.
                    throw new Error("No parsing process. Cannot do preaction.");
                }
                return preaction.perform(parsing_process, this.sc_event);
            });
        });
        if (0 === preactions.length) {
            debugLog("No Preactions to perform. This is ok.");
        }
        preaction_pipeline.then(async (can_execute) => {
            if (can_execute) {
                // Parse either all variables, or if some variables are already parsed, then just the rest. Might also be that
                // all variables are already parsed.
                debugLog("Parsing all the rest of the variables (if there are any left).");
                if (!parsing_process) {
                    // Should have a ParsingProcess at this point.
                    throw new Error("No parsing process. Cannot execute shell command.");
                }
                if (await parsing_process.processRest()) {
                    // Parsing the rest of the variables succeeded
                    // Execute the shell command.
                    const parsing_results = parsing_process.getParsingResults();
                    const shell_command_parsing_result = {
                        shell_command: parsing_results["shell_command"].parsed_content,
                        alias: parsing_results["alias"].parsed_content,
                        environment_variable_path_augmentation: parsing_results.environment_variable_path_augmentation.parsed_content,
                        stdinContent: parsing_results.stdinContent?.parsed_content,
                        output_wrapper_stdout: parsing_results.output_wrapper_stdout?.parsed_content,
                        output_wrapper_stderr: parsing_results.output_wrapper_stderr?.parsed_content,
                        succeeded: true,
                        error_messages: [],
                    };
                    debugLog("Will call ShellCommandExecutor.executeShellCommand().");
                    this.executeShellCommand(shell_command_parsing_result, overriding_output_channel);
                }
                else {
                    // Parsing has failed.
                    debugLog("Parsing the rest of the variables failed.");
                    parsing_process.displayErrorMessages();
                }
            }
            else {
                // Cancel execution
                debugLog("Shell command execution cancelled.");
            }
        });
    }
    /**
     * Does not ask for confirmation before execution. This should only be called if: a) a confirmation is already asked from a user, or b) this command is defined not to need a confirmation.
     * Use confirmAndExecuteShellCommand() instead to have a confirmation asked before the execution.
     *
     * @param shell_command_parsing_result The actual shell command that will be executed is taken from this object's '.shell_command' property.
     * @param overriding_output_channel Optional. If specified, all output streams will be directed to this output channel. Otherwise, output channels are determined from this.t_shell_command.
     */
    executeShellCommand(shell_command_parsing_result, overriding_output_channel) {
        const working_directory = this.getWorkingDirectory();
        // Define output channels
        let outputChannels = this.t_shell_command.getOutputChannels();
        if (overriding_output_channel) {
            // Ignore the shell command's normal channels and use temporarily something else.
            outputChannels = {
                'stdout': overriding_output_channel,
                'stderr': overriding_output_channel,
            };
        }
        // Check that the shell command is not empty
        const shell_command = shell_command_parsing_result.shell_command.trim();
        if (!shell_command.length) {
            // It is empty
            const error_message = this.getErrorMessageForEmptyShellCommand();
            debugLog(error_message);
            this.plugin.newError(error_message);
            return;
        }
        // Check that the currently defined shell is supported by this plugin. If using system default shell, it's possible
        // that the shell is something that is not supported. Also, the settings file can be edited manually, and incorrect
        // shell can be written there.
        const shell = this.t_shell_command.getShell();
        if (!isShellSupported(shell)) {
            debugLog("Shell is not supported: " + shell);
            this.plugin.newError("This plugin does not support the following shell: " + shell);
            return;
        }
        // Define an object for environment variables.
        const environment_variables = cloneObject(process.env); // Need to clone process.env, otherwise the modifications below will be stored permanently until Obsidian is hard-restarted (= closed and launched again).
        // Augment the PATH environment variable (if wanted)
        const augmented_path = this.augmentPATHEnvironmentVariable(shell_command_parsing_result.environment_variable_path_augmentation);
        if (augmented_path.length > 0) {
            environment_variables[getPATHEnvironmentVariableName()] = augmented_path;
        }
        // Check that the working directory exists and is a folder
        if (!fs__namespace.existsSync(working_directory)) {
            // Working directory does not exist
            // Prevent execution
            debugLog("Working directory does not exist: " + working_directory);
            this.plugin.newError("Working directory does not exist: " + working_directory);
        }
        else if (!fs__namespace.lstatSync(working_directory).isDirectory()) {
            // Working directory is not a directory.
            // Prevent execution
            debugLog("Working directory exists but is not a folder: " + working_directory);
            this.plugin.newError("Working directory exists but is not a folder: " + working_directory);
        }
        else {
            // Working directory is OK
            // Prepare execution options
            const options = {
                "cwd": working_directory,
                "shell": shell,
                "env": environment_variables,
            };
            // Execute the shell command
            debugLog("Executing command " + shell_command + " in " + working_directory + "...");
            try {
                const child_process$1 = child_process.spawn(shell_command, options);
                // Pass stdin content (if defined)
                if (undefined !== shell_command_parsing_result.stdinContent) {
                    // Stdin content is defined
                    debugLog("Stdin content is present in parsing result. Will write it to the process.");
                    if (null === child_process$1.stdin) {
                        // noinspection ExceptionCaughtLocallyJS: The exception is caught locally below, but it's ok because it's then rethrown as the error message does not match '/spawn\s+ENAMETOOLONG/i'.
                        throw new Error("Shell command execution process does not have a standard input stream (stdin).");
                    }
                    child_process$1.stdin.write(shell_command_parsing_result.stdinContent);
                    child_process$1.stdin.end();
                }
                else {
                    debugLog("No stdin content is present in parsing result.");
                }
                // Common error handling regardless of output handling mode
                child_process$1.on("error", (error) => {
                    // Probably most errors will NOT end up here, I guess this event occurs for some rare errors.
                    //
                    // A quote from https://nodejs.org/api/child_process.html#event-error (read 2022-10-29):
                    // > The 'error' event is emitted whenever:
                    // > - The process could not be spawned, or
                    // > - The process could not be killed, or
                    // > - Sending a message to the child process failed.
                    debugLog("Shell command failed to execute: Received a non-stderr error message: " + error.message);
                    this.plugin.newError("Shell command failed to execute. Error: " + error.message);
                });
                // Define output encoding
                if (null === child_process$1.stdout || null == child_process$1.stderr) {
                    // The exception is caught locally below, but it's ok because it's then rethrown as the error message does not match '/spawn\s+ENAMETOOLONG/i'.
                    throw new Error("Child process's stdout and/or stderr stream is null.");
                }
                child_process$1.stdout.setEncoding("utf8"); // Receive stdout and ...
                child_process$1.stderr.setEncoding("utf8"); // ... stderr as strings, not as Buffer objects.
                // Define a terminator
                const processTerminator = () => {
                    child_process$1.kill("SIGTERM");
                };
                // Hook into child_process for output handling
                switch (this.t_shell_command.getOutputHandlingMode()) {
                    case "buffered": {
                        // Output will be buffered and handled as a single batch.
                        this.handleBufferedOutput(child_process$1, shell_command_parsing_result, outputChannels);
                        break;
                    }
                    case "realtime": {
                        // Output will be handled on-the-go.
                        this.handleRealtimeOutput(child_process$1, shell_command_parsing_result, outputChannels, processTerminator);
                    }
                }
                // Display a notification of the execution (if wanted).
                if ("disabled" !== this.plugin.settings.execution_notification_mode) {
                    this.showExecutionNotification(child_process$1, shell_command, this.plugin.settings.execution_notification_mode, processTerminator);
                }
            }
            catch (exception) {
                // An exception has happened.
                // Check if the shell command was too long.
                if (exception.message.match(/spawn\s+ENAMETOOLONG/i)) {
                    // It was too long. Show an error message.
                    this.plugin.newError("Shell command execution failed because it's too long: " + shell_command.length + " characters. (Unfortunately the max limit is unknown).");
                }
                else {
                    // The shell command was not too long, this exception is about something else.
                    // Rethrow the exception.
                    throw exception;
                }
            }
        }
    }
    handleBufferedOutput(child_process, shell_command_parsing_result, outputChannels) {
        child_process.on("exit", (exitCode) => {
            // exitCode is null if user terminated the process. Reference: https://nodejs.org/api/child_process.html#event-exit (read on 2022-11-27).
            // Get outputs
            if (null === child_process.stdout || null == child_process.stderr) {
                // The exception is caught locally below, but it's ok because it's then rethrown as the error message does not match '/spawn\s+ENAMETOOLONG/i'.
                throw new Error("Child process's stdout and/or stderr stream is null.");
            }
            const stdout = child_process.stdout.read() ?? "";
            let stderr = child_process.stderr.read() ?? ""; // let instead of const: stderr can be emptied later due to ignoring.
            // Did the shell command execute successfully?
            if (exitCode === null || exitCode > 0) {
                // Some error occurred
                debugLog("Command executed and failed. Error number: " + exitCode + ". Stderr: " + stderr);
                // Check if this error should be displayed to the user or not
                if (null !== exitCode && this.t_shell_command.getIgnoreErrorCodes().contains(exitCode)) {
                    // The user has ignored this error.
                    debugLog("User has ignored this error, so won't display it.");
                    // Handle only stdout output stream
                    stderr = "";
                    exitCode = null; // TODO: consider if exitCode should just be left untouched. It could be informative to 'Ask after execution' output channel that shows exit code to user.
                }
                else {
                    // The error can be shown.
                    debugLog("Will display the error to user.");
                }
                // Handle at least stdout (and maybe stderr) output stream
                handleBufferedOutput(this.plugin, this.t_shell_command, shell_command_parsing_result, stdout, stderr, exitCode, outputChannels);
            }
            else {
                // Probably no errors, but do one more check.
                // Even when 'error' is null and everything should be ok, there may still be error messages outputted in stderr.
                if (stderr.length > 0) {
                    // Check a special case: should error code 0 be ignored?
                    if (this.t_shell_command.getIgnoreErrorCodes().contains(0)) {
                        // Exit code 0 is on the ignore list, so suppress stderr output.
                        stderr = "";
                        debugLog("Shell command executed: Encountered error code 0, but stderr is ignored.");
                    }
                    else {
                        debugLog("Shell command executed: Encountered error code 0, and stderr will be relayed to an output handler.");
                    }
                }
                else {
                    debugLog("Shell command executed: No errors.");
                }
                // Handle output
                handleBufferedOutput(this.plugin, this.t_shell_command, shell_command_parsing_result, stdout, stderr, 0, outputChannels); // Use zero as an error code instead of null (0 means no error). If stderr happens to contain something, exit code 0 gets displayed in an error balloon (if that is selected as a channel for stderr).
            }
        });
    }
    handleRealtimeOutput(childProcess, shell_command_parsing_result, outputChannelCodes, processTerminator) {
        // Prepare output channels
        const outputChannels = startRealtimeOutputHandling(this.plugin, this.t_shell_command, shell_command_parsing_result, outputChannelCodes, processTerminator);
        // Define an output handler
        const handleNewOutputContent = async (outputStreamName, readableStream) => {
            if (null === childProcess.stdout || null == childProcess.stderr) {
                throw new Error("Child process's stdout and/or stderr stream is null.");
            }
            // Don't emit new events while the current handling is in progress. (I think) it might cause a race condition where a simultaneous handling could overwrite another handling's data. Pause both streams, not just the current one, to maintain correct handling order also between the two streams.
            childProcess.stdout.pause();
            childProcess.stderr.pause();
            const outputContent = readableStream.read() ?? "";
            const outputChannel = outputChannels[outputStreamName];
            if (undefined === outputChannel) {
                throw new Error("Output channel is undefined.");
            }
            await outputChannel.handleRealtime(outputStreamName, outputContent);
            // Can emit new events again.
            childProcess.stdout.resume();
            childProcess.stderr.resume();
        };
        // Hook into output streams' (such as stdout and stderr) output retrieving events.
        // Note that there might be just one stream, e.g. only stderr, if stdout is ignored. In the future, there might also be more than two streams, when custom streams are implemented.
        for (const outputStreamName of Object.getOwnPropertyNames(outputChannels)) {
            const readableStream = childProcess[outputStreamName];
            if (null === readableStream) {
                throw new Error("Child process's readable stream '" + outputStreamName + "' is null.");
            }
            readableStream.on("readable", () => handleNewOutputContent(outputStreamName, readableStream));
        }
        // Hook into exit events
        childProcess.on("exit", (exitCode, signal /* TODO: Pass signal to channels so it can be shown to users in the future */) => {
            // Call all OutputChannels' endRealtime().
            const alreadyCalledChannelCodes = [];
            for (const outputStreamName of Object.getOwnPropertyNames(outputChannels)) {
                const outputChannel = outputChannels[outputStreamName];
                if (undefined === outputChannel) {
                    throw new Error("Output channel is undefined.");
                }
                const outputChannelCode = outputChannelCodes[outputStreamName];
                // Ensure this OutputChannel has not yet been called.
                if (!alreadyCalledChannelCodes.includes(outputChannelCode)) {
                    // Not yet called, so do the call.
                    outputChannel.endRealtime(exitCode);
                    // Mark that this channel's endRealtime() has already been called. Solves a situation where stderr and stdout uses the same channel, in which case endRealtime() should not be accidentally called twice.
                    alreadyCalledChannelCodes.push(outputChannelCode);
                }
            }
        });
    }
    getWorkingDirectory() {
        // Returns either a user defined working directory, or an automatically detected one.
        const working_directory = this.plugin.settings.working_directory;
        if (working_directory.length == 0) {
            // No working directory specified, so use the vault directory.
            return getVaultAbsolutePath(this.plugin.app);
        }
        else if (!path__namespace.isAbsolute(working_directory)) {
            // The working directory is relative.
            // Help to make it refer to the vault's directory. Without this, the relative path would refer to Obsidian's installation directory (at least on Windows).
            return path__namespace.join(getVaultAbsolutePath(this.plugin.app), working_directory);
        }
        return working_directory;
    }
    augmentPATHEnvironmentVariable(path_augmentation) {
        path_augmentation = convertNewlinesToPATHSeparators(path_augmentation, getOperatingSystem());
        // Check if there's anything to augment.
        if (path_augmentation.length > 0) {
            // Augment.
            const original_path = process.env[getPATHEnvironmentVariableName()];
            if (undefined === original_path) {
                throw new Error("process.env does not contain '" + getPATHEnvironmentVariableName() + "'.");
            }
            let augmented_path;
            if (path_augmentation.contains(original_path)) {
                // The augmentation contains the original PATH.
                // Simply replace the whole original PATH with the augmented one, as there's no need to care about including
                // the original content.
                debugLog("Augmenting environment variable PATH so it will become " + path_augmentation);
                augmented_path = path_augmentation;
            }
            else {
                // The augmentation does not contain the original PATH.
                // Instead of simply replacing the original PATH, append the augmentation after it.
                const separator = getPATHSeparator(getOperatingSystem());
                debugLog("Augmenting environment variable PATH by adding " + separator + path_augmentation + " after it.");
                augmented_path = original_path + separator + path_augmentation;
            }
            debugLog("PATH augmentation result: " + augmented_path);
            return augmented_path;
        }
        else {
            // No augmenting is needed.
            debugLog("No augmentation is defined for environment variable PATH. This is completely ok.");
            return "";
        }
    }
    /**
     * This method should only be called if it's first checked that neither shell command version for the current platform nor a 'default' version exists.
     *
     * @private
     */
    getErrorMessageForEmptyShellCommand() {
        if (this.t_shell_command.getNonEmptyPlatformIds().length > 0) {
            // The shell command contains versions for other platforms, but not for the current one.
            const current_platform_name = PlatformNames[getOperatingSystem()];
            const version_word = this.t_shell_command.getNonEmptyPlatformIds().length > 1 ? "versions" : "a version";
            const other_platform_names = this.t_shell_command.getNonEmptyPlatformIds().map(platform_id => PlatformNames[platform_id]).join(" and ");
            return `The shell command does not have a version for ${current_platform_name}, it only has ${version_word} for ${other_platform_names}.`;
        }
        else {
            // The shell command doesn't contain a version for any platforms, it's completely empty.
            return "The shell command is empty. :(";
        }
    }
    /**
     * Displays a notification balloon indicating a user that a shell command is being executed.
     *
     * @param child_process
     * @param shell_command
     * @param execution_notification_mode
     * @param processTerminator Will be called if user clicks 'Request to terminate the process' icon.
     * @private
     */
    showExecutionNotification(child_process, shell_command, execution_notification_mode, processTerminator) {
        const createRequestTerminatingButton = (notice) => {
            // @ts-ignore Notice.noticeEl belongs to Obsidian's PRIVATE API, and it may change without a prior notice. Only
            // create the button if noticeEl exists and is an HTMLElement.
            const noticeEl = notice.noticeEl;
            if (undefined !== noticeEl && noticeEl instanceof HTMLElement) {
                this.plugin.createRequestTerminatingButton(noticeEl, processTerminator);
            }
        };
        const execution_notification_message = "Executing: " + (this.t_shell_command.getAlias() || shell_command);
        switch (execution_notification_mode) {
            case "quick": {
                // Retrieve the timeout from settings defined by a user.
                const processNotification = this.plugin.newNotification(execution_notification_message, undefined);
                createRequestTerminatingButton(processNotification);
                break;
            }
            case "permanent": {
                // Show the notification until the process ends.
                const processNotification = this.plugin.newNotification(execution_notification_message, 0);
                createRequestTerminatingButton(processNotification);
                // Hide the notification when the process finishes.
                child_process.on("exit", () => processNotification.hide());
                break;
            }
            case "if-long": {
                // Only show the notification if the process runs for an extended period of time (defined below).
                window.setTimeout(() => {
                    // Check if the process is still running.
                    if (null === child_process.exitCode && !child_process.killed) {
                        // The process is still running.
                        // Display notification.
                        const processNotification = this.plugin.newNotification(execution_notification_message, 0);
                        createRequestTerminatingButton(processNotification);
                        // Hide the notification when the process finishes.
                        child_process.on("exit", () => processNotification.hide());
                    }
                }, 2000); // If you change the timeout, change documentation, too!
                break;
            }
        }
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class Instance {
    constructor(model, configuration, parent_instance_or_configuration) {
        this.model = model;
        this.configuration = configuration;
        debugLog(this.constructor.name + ": Creating a new instance.");
        // Determine parent type
        if (parent_instance_or_configuration instanceof Instance) {
            // It's an instance object
            this.parent_instance = parent_instance_or_configuration;
            this.parent_configuration = this.parent_instance.configuration;
        }
        else {
            // It's a configuration object.
            // No parent instance is available, so probably this is about SC_MainSettings object, as it does not have Model/Instance classes (at least yet).
            this.parent_instance = null; // It's null already, but do this just to make a statement.
            this.parent_configuration = parent_instance_or_configuration;
        }
    }
    setIfValid(field, value) {
        return this.model.validateValue(this, field, value).then(() => {
            this.configuration[field] = value;
        });
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class Model {
    constructor(plugin) {
        this.plugin = plugin;
    }
    createSettingFields(instance, parent_element, with_deletion = true) {
        debugLog(this.constructor.name + ": Creating setting fields.");
        // Create a container
        const setting_fields_container = parent_element.createDiv(); // Create a nested container that can be easily deleted if the instance is deleted.
        const main_setting_field = this._createSettingFields(instance, setting_fields_container);
        if (with_deletion) {
            main_setting_field.addExtraButton(button => button
                .setIcon("trash")
                .setTooltip("Delete this " + this.getSingularName().toLocaleLowerCase())
                .onClick(() => {
                // The trash icon has been clicked
                // Open up a modal asking for confirmation if the instance can be deleted from this.parent_configuration.
                const confirmation_modal = new ConfirmationModal(this.plugin, "Delete " + this.getSingularName().toLocaleLowerCase() + ": " + instance.getTitle(), "Are you sure you want to delete this " + this.getSingularName().toLocaleLowerCase() + "?", "Yes, delete");
                confirmation_modal.open();
                confirmation_modal.promise.then(async (deletion_confirmed) => {
                    if (deletion_confirmed) {
                        // User has confirmed the deletion.
                        // Delete the configuration and remove the instance from custom collections.
                        this.deleteInstance(instance);
                        // Delete setting fields.
                        setting_fields_container.remove();
                        // Save settings
                        await this.plugin.saveSettings();
                    }
                });
            }));
        }
        return main_setting_field;
    }
    /**
     * Deletes the instance from configuration, and calls _deleteChild() which will delete the instance from custom collections.
     *
     * Can be made public if needed.
     */
    deleteInstance(instance) {
        debugLog(this.constructor.name + ": Deleting an instance.");
        this._deleteInstance(instance);
        const relation = this.defineParentConfigurationRelation(instance);
        switch (relation.type) {
            // case "one-to-one": // TODO: Uncomment when first model that needs this is implemented.
            // This is a relation where 'key' points directly to the instance's configuration.
            // delete this.parent_configuration[this.relation.key];
            // break;
            case "one-to-many-index": {
                // This is a relation where 'key' points to an indexed array of instance configurations. Use 'index' to pick the correct instance configuration.
                instance.parent_configuration[relation.key].splice(relation.index, 1); // Do not use delete, as it would place null in the list.
                break;
            }
            case "one-to-many-id": {
                // This is a relation where 'key' points to an indexed array of instance configurations. Use 'id' to determine the correct index.
                const index = this.idToIndex(instance.parent_configuration[relation.key], relation.id);
                if (null === index) {
                    // Something went wrong
                    throw new Error(`${this.constructor.name}.deleteInstance(): Could not find an index for id ${relation.id}.`);
                }
                instance.parent_configuration[relation.key].splice(index, 1); // Do not use delete, as it would place null in the list.
                break;
            }
        }
    }
    idToIndex(configurations, id) {
        let result_index = null;
        configurations.forEach((instance_configuration, index) => {
            if (instance_configuration.id === id) {
                // This is the correct configuration.
                result_index = index;
            }
        });
        return result_index;
    }
    /**
     * This should delete the instance from custom collections. It should be overridden by all Instance classes that have deletable children.
     */
    _deleteInstance(instance) {
        throw new Error(this.constructor.name + ".deleteInstance(): This class does not override _deleteInstance() method. Maybe the class is not supposed to have children?");
    }
}
// Model class collection
const model_classes = new Map();
function introduceModelClass(model_class) {
    model_classes.set(model_class.constructor.name, model_class);
}
function getModel(model_class_name) {
    return model_classes.get(model_class_name);
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class OutputWrapper extends Instance {
    constructor(model, plugin, configuration, parent_configuration) {
        super(model, configuration, parent_configuration);
        this.model = model;
        this.plugin = plugin;
        this.configuration = configuration;
        this.parent_configuration = parent_configuration;
        // Introduce the ID to an ID generator so that it won't accidentally generate the same ID again when creating new OutputWrappers.
        getIDGenerator().addReservedID(configuration.id);
    }
    getID() {
        return this.configuration.id;
    }
    getTitle() {
        return this.configuration.title;
    }
    getContent() {
        return this.configuration.content;
    }
    getConfiguration() {
        return this.configuration;
    }
}

var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

function createCommonjsModule(fn) {
  var module = { exports: {} };
	return fn(module, module.exports), module.exports;
}

var autocomplete = createCommonjsModule(function (module, exports) {
(function (global, factory) {
  module.exports = factory() ;
}(commonjsGlobal, (function () {
  /*
   * https://github.com/kraaden/autocomplete
   * Copyright (c) 2016 Denys Krasnoshchok
   * MIT License
   */
  function autocomplete(settings) {
      // just an alias to minimize JS file size
      var doc = document;
      var container = settings.container || doc.createElement("div");
      var containerStyle = container.style;
      var userAgent = navigator.userAgent;
      var mobileFirefox = ~userAgent.indexOf("Firefox") && ~userAgent.indexOf("Mobile");
      var debounceWaitMs = settings.debounceWaitMs || 0;
      var preventSubmit = settings.preventSubmit || false;
      var disableAutoSelect = settings.disableAutoSelect || false;
      // 'keyup' event will not be fired on Mobile Firefox, so we have to use 'input' event instead
      var keyUpEventName = mobileFirefox ? "input" : "keyup";
      var items = [];
      var inputValue = "";
      var minLen = 2;
      var showOnFocus = settings.showOnFocus;
      var selected;
      var keypressCounter = 0;
      var debounceTimer;
      if (settings.minLength !== undefined) {
          minLen = settings.minLength;
      }
      if (!settings.input) {
          throw new Error("input undefined");
      }
      var input = settings.input;
      container.className = "autocomplete " + (settings.className || "");
      // IOS implementation for fixed positioning has many bugs, so we will use absolute positioning
      containerStyle.position = "absolute";
      /**
       * Detach the container from DOM
       */
      function detach() {
          var parent = container.parentNode;
          if (parent) {
              parent.removeChild(container);
          }
      }
      /**
       * Clear debouncing timer if assigned
       */
      function clearDebounceTimer() {
          if (debounceTimer) {
              window.clearTimeout(debounceTimer);
          }
      }
      /**
       * Attach the container to DOM
       */
      function attach() {
          if (!container.parentNode) {
              doc.body.appendChild(container);
          }
      }
      /**
       * Check if container for autocomplete is displayed
       */
      function containerDisplayed() {
          return !!container.parentNode;
      }
      /**
       * Clear autocomplete state and hide container
       */
      function clear() {
          // prevent the update call if there are pending AJAX requests
          keypressCounter++;
          items = [];
          inputValue = "";
          selected = undefined;
          detach();
      }
      /**
       * Update autocomplete position
       */
      function updatePosition() {
          if (!containerDisplayed()) {
              return;
          }
          containerStyle.height = "auto";
          containerStyle.width = input.offsetWidth + "px";
          var maxHeight = 0;
          var inputRect;
          function calc() {
              var docEl = doc.documentElement;
              var clientTop = docEl.clientTop || doc.body.clientTop || 0;
              var clientLeft = docEl.clientLeft || doc.body.clientLeft || 0;
              var scrollTop = window.pageYOffset || docEl.scrollTop;
              var scrollLeft = window.pageXOffset || docEl.scrollLeft;
              inputRect = input.getBoundingClientRect();
              var top = inputRect.top + input.offsetHeight + scrollTop - clientTop;
              var left = inputRect.left + scrollLeft - clientLeft;
              containerStyle.top = top + "px";
              containerStyle.left = left + "px";
              maxHeight = window.innerHeight - (inputRect.top + input.offsetHeight);
              if (maxHeight < 0) {
                  maxHeight = 0;
              }
              containerStyle.top = top + "px";
              containerStyle.bottom = "";
              containerStyle.left = left + "px";
              containerStyle.maxHeight = maxHeight + "px";
          }
          // the calc method must be called twice, otherwise the calculation may be wrong on resize event (chrome browser)
          calc();
          calc();
          if (settings.customize && inputRect) {
              settings.customize(input, inputRect, container, maxHeight);
          }
      }
      /**
       * Redraw the autocomplete div element with suggestions
       */
      function update() {
          // delete all children from autocomplete DOM container
          while (container.firstChild) {
              container.removeChild(container.firstChild);
          }
          // function for rendering autocomplete suggestions
          var render = function (item, currentValue) {
              var itemElement = doc.createElement("div");
              itemElement.textContent = item.label || "";
              return itemElement;
          };
          if (settings.render) {
              render = settings.render;
          }
          // function to render autocomplete groups
          var renderGroup = function (groupName, currentValue) {
              var groupDiv = doc.createElement("div");
              groupDiv.textContent = groupName;
              return groupDiv;
          };
          if (settings.renderGroup) {
              renderGroup = settings.renderGroup;
          }
          var fragment = doc.createDocumentFragment();
          var prevGroup = "#9?$";
          items.forEach(function (item) {
              if (item.group && item.group !== prevGroup) {
                  prevGroup = item.group;
                  var groupDiv = renderGroup(item.group, inputValue);
                  if (groupDiv) {
                      groupDiv.className += " group";
                      fragment.appendChild(groupDiv);
                  }
              }
              var div = render(item, inputValue);
              if (div) {
                  div.addEventListener("click", function (ev) {
                      settings.onSelect(item, input);
                      clear();
                      ev.preventDefault();
                      ev.stopPropagation();
                  });
                  if (item === selected) {
                      div.className += " selected";
                  }
                  fragment.appendChild(div);
              }
          });
          container.appendChild(fragment);
          if (items.length < 1) {
              if (settings.emptyMsg) {
                  var empty = doc.createElement("div");
                  empty.className = "empty";
                  empty.textContent = settings.emptyMsg;
                  container.appendChild(empty);
              }
              else {
                  clear();
                  return;
              }
          }
          attach();
          updatePosition();
          updateScroll();
      }
      function updateIfDisplayed() {
          if (containerDisplayed()) {
              update();
          }
      }
      function resizeEventHandler() {
          updateIfDisplayed();
      }
      function scrollEventHandler(e) {
          if (e.target !== container) {
              updateIfDisplayed();
          }
          else {
              e.preventDefault();
          }
      }
      function keyupEventHandler(ev) {
          var keyCode = ev.which || ev.keyCode || 0;
          var ignore = settings.keysToIgnore || [38 /* Up */, 13 /* Enter */, 27 /* Esc */, 39 /* Right */, 37 /* Left */, 16 /* Shift */, 17 /* Ctrl */, 18 /* Alt */, 20 /* CapsLock */, 91 /* WindowsKey */, 9 /* Tab */];
          for (var _i = 0, ignore_1 = ignore; _i < ignore_1.length; _i++) {
              var key = ignore_1[_i];
              if (keyCode === key) {
                  return;
              }
          }
          if (keyCode >= 112 /* F1 */ && keyCode <= 123 /* F12 */ && !settings.keysToIgnore) {
              return;
          }
          // the down key is used to open autocomplete
          if (keyCode === 40 /* Down */ && containerDisplayed()) {
              return;
          }
          startFetch(0 /* Keyboard */);
      }
      /**
       * Automatically move scroll bar if selected item is not visible
       */
      function updateScroll() {
          var elements = container.getElementsByClassName("selected");
          if (elements.length > 0) {
              var element = elements[0];
              // make group visible
              var previous = element.previousElementSibling;
              if (previous && previous.className.indexOf("group") !== -1 && !previous.previousElementSibling) {
                  element = previous;
              }
              if (element.offsetTop < container.scrollTop) {
                  container.scrollTop = element.offsetTop;
              }
              else {
                  var selectBottom = element.offsetTop + element.offsetHeight;
                  var containerBottom = container.scrollTop + container.offsetHeight;
                  if (selectBottom > containerBottom) {
                      container.scrollTop += selectBottom - containerBottom;
                  }
              }
          }
      }
      /**
       * Select the previous item in suggestions
       */
      function selectPrev() {
          if (items.length < 1) {
              selected = undefined;
          }
          else {
              if (selected === items[0]) {
                  selected = items[items.length - 1];
              }
              else {
                  for (var i = items.length - 1; i > 0; i--) {
                      if (selected === items[i] || i === 1) {
                          selected = items[i - 1];
                          break;
                      }
                  }
              }
          }
      }
      /**
       * Select the next item in suggestions
       */
      function selectNext() {
          if (items.length < 1) {
              selected = undefined;
          }
          if (!selected || selected === items[items.length - 1]) {
              selected = items[0];
              return;
          }
          for (var i = 0; i < (items.length - 1); i++) {
              if (selected === items[i]) {
                  selected = items[i + 1];
                  break;
              }
          }
      }
      function keydownEventHandler(ev) {
          var keyCode = ev.which || ev.keyCode || 0;
          if (keyCode === 38 /* Up */ || keyCode === 40 /* Down */ || keyCode === 27 /* Esc */) {
              var containerIsDisplayed = containerDisplayed();
              if (keyCode === 27 /* Esc */) {
                  clear();
              }
              else {
                  if (!containerIsDisplayed || items.length < 1) {
                      return;
                  }
                  keyCode === 38 /* Up */
                      ? selectPrev()
                      : selectNext();
                  update();
              }
              ev.preventDefault();
              if (containerIsDisplayed) {
                  ev.stopPropagation();
              }
              return;
          }
          if (keyCode === 13 /* Enter */) {
              if (selected) {
                  if (preventSubmit) {
                      ev.preventDefault();
                  }
                  settings.onSelect(selected, input);
                  clear();
              }
          }
      }
      function focusEventHandler() {
          if (showOnFocus) {
              startFetch(1 /* Focus */);
          }
      }
      function startFetch(trigger) {
          // If multiple keys were pressed, before we get an update from server,
          // this may cause redrawing autocomplete multiple times after the last key was pressed.
          // To avoid this, the number of times keyboard was pressed will be saved and checked before redraw.
          var savedKeypressCounter = ++keypressCounter;
          var inputText = input.value;
          var cursorPos = input.selectionStart || 0;
          if (inputText.length >= minLen || trigger === 1 /* Focus */) {
              clearDebounceTimer();
              debounceTimer = window.setTimeout(function () {
                  settings.fetch(inputText, function (elements) {
                      if (keypressCounter === savedKeypressCounter && elements) {
                          items = elements;
                          inputValue = inputText;
                          selected = (items.length < 1 || disableAutoSelect) ? undefined : items[0];
                          update();
                      }
                  }, trigger, cursorPos);
              }, trigger === 0 /* Keyboard */ ? debounceWaitMs : 0);
          }
          else {
              clear();
          }
      }
      function blurEventHandler() {
          // we need to delay clear, because when we click on an item, blur will be called before click and remove items from DOM
          setTimeout(function () {
              if (doc.activeElement !== input) {
                  clear();
              }
          }, 200);
      }
      /**
       * Fixes #26: on long clicks focus will be lost and onSelect method will not be called
       */
      container.addEventListener("mousedown", function (evt) {
          evt.stopPropagation();
          evt.preventDefault();
      });
      /**
       * Fixes #30: autocomplete closes when scrollbar is clicked in IE
       * See: https://stackoverflow.com/a/9210267/13172349
       */
      container.addEventListener("focus", function () { return input.focus(); });
      /**
       * This function will remove DOM elements and clear event handlers
       */
      function destroy() {
          input.removeEventListener("focus", focusEventHandler);
          input.removeEventListener("keydown", keydownEventHandler);
          input.removeEventListener(keyUpEventName, keyupEventHandler);
          input.removeEventListener("blur", blurEventHandler);
          window.removeEventListener("resize", resizeEventHandler);
          doc.removeEventListener("scroll", scrollEventHandler, true);
          clearDebounceTimer();
          clear();
      }
      // setup event handlers
      input.addEventListener("keydown", keydownEventHandler);
      input.addEventListener(keyUpEventName, keyupEventHandler);
      input.addEventListener("blur", blurEventHandler);
      input.addEventListener("focus", focusEventHandler);
      window.addEventListener("resize", resizeEventHandler);
      doc.addEventListener("scroll", scrollEventHandler, true);
      return {
          destroy: destroy
      };
  }

  return autocomplete;

})));

});

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
function getVariableAutocompleteItems(plugin) {
    if (0 === autocomplete_items.length) {
        plugin.getVariables().forEach((variable) => {
            autocomplete_items.push(...variable.getAutocompleteItems());
        });
    }
    return autocomplete_items;
}
function resetVariableAutocompleteItems() {
    while (autocomplete_items.length) {
        autocomplete_items.pop();
    }
}
const autocomplete_items = [];

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
/**
 *
 * @param plugin Used for getting a list of Variable autocomplete items.
 * @param input_element
 * @param call_on_completion A function that will be called when a user has selected a suggestion and performed the autocomplete action. onChange event will not be called, because it would trigger opening the autocomplete menu again, so that's why a separate callback is used.
 * @param extra_autocomplete_items
 */
function createAutocomplete(plugin, input_element, call_on_completion, extra_autocomplete_items = []) {
    const autocompleteMenu = autocomplete({
        input: input_element,
        fetch: (input_value_but_not_used, update) => {
            const autocomplete_items = merge_and_sort_autocomplete_items(getVariableAutocompleteItems(plugin), CustomAutocompleteItems, extra_autocomplete_items);
            const max_suggestions = 30;
            // Get the so far typed text - exclude everything that is on the right side of the caret.
            const caret_position = input_element.selectionStart;
            if (null === caret_position) {
                throw new Error("createAutocomplete(): fetch(): caret_position is null.");
            }
            const typed_text = input_element.value.slice(0, caret_position);
            const search_query = get_search_query(typed_text);
            if ("" === search_query.search_text) {
                // No suggestions for empty word.
                update([]);
            }
            else {
                // The word is not empty, so can suggest something.
                let matched_items = autocomplete_items.filter(item => item_match(item, search_query));
                sort_autocomplete_items(matched_items, search_query);
                matched_items = matched_items.slice(0, max_suggestions); // Limit to a reasonable amount of suggestions.
                update(matched_items);
            }
        },
        onSelect: (item) => {
            // A user has selected an item to be autocompleted
            // Get the item text and already typed text
            let supplement = item.value;
            let caret_position = input_element.selectionStart;
            if (null === caret_position) {
                throw new Error("createAutocomplete(): fetch(): caret_position is null.");
            }
            const typed_text = input_element.value.slice(0, caret_position);
            const search_query = get_search_query(typed_text);
            const search_text = search_query.search_text;
            // Special case: Check if }} happens to appear after the caret
            const after_caret = input_element.value.slice(caret_position, caret_position + 2);
            if ("}}" === after_caret) {
                // The replacing will happen in a {{variable}}.
                // Do not accidentally insert another }} pair.
                supplement = supplement.replace(/\}\}$/u, ""); // Only removes a trailing }} if there is one.
            }
            // Try to save part of the beginning, in case it seems like not being part of the search query.
            let replace_start = find_starting_position(search_text, supplement); // The length difference of typed_text and search_text will be added here below.
            if (false === replace_start) {
                // This should never happen, but if it does, do not replace anything, just insert.
                replace_start = caret_position;
            }
            else {
                // Adjust the position
                replace_start += typed_text.length - search_text.length;
            }
            // Choose a method for doing the inserting
            if (undefined !== document.execCommand) {
                // execCommand() is deprecated, but available.
                // Use it to do the insertion, because this way an undo history can be preserved.
                input_element.setSelectionRange(replace_start, caret_position); // First select the part that will be replaced, because execCommand() does not support defining positions. This adds a cumbersome selection step to the undo history, but at least undoing works.
                document.execCommand("insertText", false, supplement);
            }
            else {
                // execCommand() is not available anymore.
                // Use setRangeText() to do the insertion. It will clear undo history, but at least the insertion works.
                input_element.setRangeText(supplement, replace_start, caret_position);
            }
            // Move the caret to a logical continuation point
            caret_position = replace_start + supplement.length;
            if (supplement.match(/:\}\}$/u)) {
                // Place the caret after the colon, instead of after }}.
                caret_position -= 2;
            }
            input_element.setSelectionRange(caret_position, caret_position);
            // Call a hook
            call_on_completion(input_element.value);
        },
        render: (item) => {
            const div_element = document.createElement("div");
            div_element.createSpan({ text: item.value, attr: { class: "SC-autocomplete-value" } });
            if (item.help_text) {
                div_element.createSpan({ text: ": ", attr: { class: "SC-autocomplete-separator" } });
                div_element.createSpan({ attr: { class: "SC-autocomplete-help-text" } }).insertAdjacentHTML("beforeend", item.help_text);
            }
            // Documentation link
            const documentationLink = item.documentationLink;
            if (undefined !== documentationLink) {
                const documentationLinkElement = div_element.createEl("a", { attr: { "title": "Documentation: " + item.value } }); // Use "title" instead of "aria-label", because I don't know how to make "aria-label" show a tooltip box on a custom element.
                obsidian.setIcon(documentationLinkElement, "help");
                documentationLinkElement.addClass("SC-autocomplete-link-icon");
                documentationLinkElement.onClickEvent((event) => {
                    gotoURL(documentationLink);
                    // event.preventDefault(); Not needed, I guess.
                    event.stopImmediatePropagation(); // Do not close the autocomplete menu.
                });
            }
            return div_element;
        },
        minLength: 2,
        className: "SC-autocomplete",
        keysToIgnore: [38 /* Up */, 13 /* Enter */, 27 /* Esc */, 16 /* Shift */, 17 /* Ctrl */, 18 /* Alt */, 20 /* CapsLock */, 91 /* WindowsKey */, 9 /* Tab */],
        preventSubmit: true, // Prevents creating newlines in textareas when enter is pressed in the autocomplete menu.
    });
    // Make the plugin able to close the menu if the plugin is disabled (or restarted).
    plugin.registerAutocompleteMenu(autocompleteMenu);
}
function item_match(item, search_query) {
    const item_value = item.value.toLocaleLowerCase();
    const search_text = search_query.search_text.toLocaleLowerCase();
    // Match query type
    if (item.type !== search_query.search_type) {
        // If the query type is different, do not include this item.
        // This can happen e.g. if {{ is typed, and the item is not a variable, or {{! is typed, and the item is not an unescaped variable.
        return false;
    }
    // Match text
    let search_character;
    let search_position = 0;
    for (let search_character_index = 0; search_character_index < search_text.length; search_character_index++) {
        search_character = search_text[search_character_index];
        if (item_value.includes(search_character, search_position)) {
            // This character was found in item_value.
            search_position = item_value.indexOf(search_character, search_position) + 1;
        }
        else {
            // This character was not found.
            return false;
        }
    }
    return true;
}
function find_starting_position(typed_text, supplement) {
    typed_text = typed_text.toLocaleLowerCase();
    supplement = supplement.toLocaleLowerCase();
    for (let supplement_index = supplement.length; supplement_index >= 0; supplement_index--) {
        const partial_supplement = supplement.slice(0, supplement_index);
        if (typed_text.contains(partial_supplement)) {
            return typed_text.indexOf(partial_supplement);
        }
    }
    return false;
}
/**
 * Sorts in place, does not make a copy.
 * @param autocomplete_items
 * @param search_query
 */
function sort_autocomplete_items(autocomplete_items, search_query) {
    const search_text_excluding_curly_brackets = search_query.search_text.replace(/^{{!?/, "");
    function get_common_beginning_length(autocomplete_item, search_query) {
        const search_text = search_query.search_text.toLocaleLowerCase();
        const item_value = autocomplete_item.value.toLocaleLowerCase();
        const shortest_length = Math.min(search_text.length, item_value.length);
        for (let character_index = 0; character_index < shortest_length; character_index++) {
            const search_character = search_text[character_index];
            const item_character = item_value[character_index];
            if (search_character !== item_character) {
                // The common beginning has ended.
                return character_index;
            }
        }
        return shortest_length;
    }
    autocomplete_items.sort((a, b) => {
        const boost_a = Math.max(get_common_beginning_length(a, search_query), 1); // Boosts are used as multipliers,
        const boost_b = Math.max(get_common_beginning_length(b, search_query), 1); // so they cannot be zero.
        const a_length = a.value.length * boost_b; // boost_b worsens A (= makes it artificially "longer")
        const b_length = b.value.length * boost_a; // boost_a worsens B
        // Determine sorting method. If the search query is just a couple of characters, the matches would be quite vague, sorting by the matched items' length would not tell much, and the list would just look strangely ordered.
        if (search_text_excluding_curly_brackets.length < 2 || a_length === b_length) {
            // Sort alphabetically.
            return a.value > b.value ? 1 : -1;
        }
        else {
            // Sort by lengths. The shortest item is preferred. If an item has a long common beginning with the search query, boost the item up.
            return a_length - b_length;
        }
    });
}
const CustomAutocompleteItems = [];
function addCustomAutocompleteItems(custom_autocomplete_yaml) {
    // Ensure the content is not empty
    if (0 === custom_autocomplete_yaml.trim().length) {
        return "The content is empty.";
    }
    // Try to parse YAML syntax
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    let yaml; // 'any' is defined in obsidian.d.ts for the return type of parseYaml(), so I made ESLint ignore it.
    try {
        yaml = obsidian.parseYaml(custom_autocomplete_yaml);
    }
    catch (error) {
        // A syntax error has appeared.
        return error.message;
    }
    if (null === yaml || typeof yaml !== "object") {
        return "Unable to parse the content due to unknown reason.";
    }
    // Iterate autocomplete item groups
    const group_names = Object.getOwnPropertyNames(yaml);
    const error_messages = [];
    group_names.forEach((group_name) => {
        const group_items = yaml[group_name];
        const group_item_values = Object.getOwnPropertyNames(group_items);
        // Iterate all autocomplete items in the group
        group_item_values.forEach((autocomplete_item_value) => {
            const autocomplete_item_label = group_items[autocomplete_item_value];
            if (typeof autocomplete_item_label !== "string") {
                error_messages.push("Autocomplete item '" + autocomplete_item_value + "' has an incorrect help text type: " + autocomplete_item_label + " is a " + typeof autocomplete_item_label + ", but it should be a string.");
                return;
            }
            // Determine a correct type for the item
            let type = "other";
            if (autocomplete_item_value.startsWith("{{")) {
                // This is a variable
                type = "normal-variable";
            }
            // The item is ok, add it to the list
            CustomAutocompleteItems.push({
                value: autocomplete_item_value,
                help_text: autocomplete_item_label,
                group: group_name,
                type: type,
            });
            if (type === "normal-variable") {
                // Add an unescaped version of the variable, too
                CustomAutocompleteItems.push({
                    value: autocomplete_item_value.replace(/^\{\{/u, "{{!"),
                    help_text: autocomplete_item_label,
                    group: group_name,
                    type: "unescaped-variable",
                });
            }
        });
    });
    if (error_messages.length > 0) {
        // Something failed
        return error_messages.join("; ");
    }
    // All ok
    return true;
}
/**
 * TODO: Can the sorting be removed from here? Now autocomplete items are sorted again every time when filtering, based on the keyword (https://github.com/Taitava/obsidian-shellcommands/issues/249).
 * @param autocomplete_item_sets
 */
function merge_and_sort_autocomplete_items(...autocomplete_item_sets) {
    const merged_autocomplete_items = (new Array()).concat(...autocomplete_item_sets);
    return merged_autocomplete_items.sort((a, b) => {
        // First compare groups
        if (a.group < b.group) {
            // a's group should come before b's group.
            return -1;
        }
        else if (a.group > b.group) {
            // a's group should come after b's group.
            return 1;
        }
        else {
            // The groups are the same.
            // Compare values.
            if (a.value < b.value) {
                // a should come before b.
                return -1;
            }
            else if (a.value > b.value) {
                // a should come after b.
                return 1;
            }
            else {
                // The values are the same.
                // The order does not matter.
                return 0;
            }
        }
    });
}
/**
 * Reduces an input string to the nearest logical word.
 * @param typed_text
 */
function get_search_query(typed_text) {
    const searchTextMatchArray = typed_text.match(/\S*?$/u); // An array, but only one match is expected.
    if (null === searchTextMatchArray) {
        throw new Error("get_search_query(): Regex match failed.");
    }
    let search_text = searchTextMatchArray[0]; // Reduce the text - limit to a single word (= exclude spaces and everything before them).
    let search_type = "other"; // May be overwritten.
    if (search_text.contains("}}")) {
        // The query happens right after a {{variable}}.
        // Make the query string to start after the }} pair, i.e. remove }} and everything before it. This improves the search.
        search_text = search_text.replace(/.+\}\}/u, "");
    }
    if (search_text.contains("{{")) {
        // A {{variable}} is being queried.
        // Make the query string to start from the {{ pair, i.e. remove everything before {{ . This improves the search.
        search_text = search_text.replace(/.+\{\{/u, "{{");
        if (search_text.contains("{{!")) {
            // An _unescaped_ variable is searched for.
            search_type = "unescaped-variable";
        }
        else {
            // A normal variable is searched for.
            search_type = "normal-variable";
        }
    }
    return {
        search_text: search_text,
        search_type: search_type,
    };
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class OutputWrapperSettingsModal extends SC_Modal {
    constructor(plugin, output_wrapper, 
    /** Can be undefined if the output wrapper is created from a place where there is no name element. */
    output_wrapper_name_setting, 
    /** If defined, a button will be added and on_after_approval() / on_after_cancelling() will be called depending on whether the button was clicked or not. */
    ok_button_text, on_after_approval, on_after_cancelling) {
        super(plugin);
        this.output_wrapper = output_wrapper;
        this.output_wrapper_name_setting = output_wrapper_name_setting;
        this.ok_button_text = ok_button_text;
        this.on_after_approval = on_after_approval;
        this.on_after_cancelling = on_after_cancelling;
        this.approved = false;
    }
    onOpen() {
        super.onOpen();
        const container_element = this.modalEl.createDiv();
        container_element.addClass("SC-setting-group"); // Make setting fields wider in this container.
        // Title
        const title_setting = new obsidian.Setting(container_element)
            .setName("Output wrapper title")
            .setDesc("Only used in settings, will not appear in output.")
            .addText(text => text
            .setValue(this.output_wrapper.getTitle())
            .onChange(async (new_title) => {
            this.output_wrapper.getConfiguration().title = new_title;
            await this.plugin.saveSettings();
            // Update the title in a name setting. (Only if the modal was created from a place where an OutputWrapper name element exists).
            this.output_wrapper_name_setting?.setName(new_title);
        }));
        const title_input_element = title_setting.controlEl.find("input");
        // Content
        const output_variable = new Variable_Output(this.plugin, ""); // For getting an autocomplete item.
        new obsidian.Setting(container_element)
            .setName("Content")
            .setDesc("Use {{output}} as a placeholder for text that will be received from a shell command. Other variables are available, too.")
            .addTextArea(textarea_component => textarea_component
            .setValue(this.output_wrapper.configuration.content)
            .onChange(async (new_content) => {
            this.output_wrapper.configuration.content = new_content;
            await this.plugin.saveSettings();
        })
            .then((textarea_component) => {
            // Autocomplete for Content.
            if (this.plugin.settings.show_autocomplete_menu) {
                createAutocomplete(this.plugin, textarea_component.inputEl, () => textarea_component.onChanged(), output_variable.getAutocompleteItems());
            }
        }));
        // Focus on the title field.
        title_input_element.focus();
        // Ok button
        const okButtonText = this.ok_button_text;
        if (okButtonText) {
            new obsidian.Setting(container_element)
                .addButton(button => button
                .setButtonText(okButtonText)
                .onClick(() => this.approve()));
        }
    }
    approve() {
        if (this.on_after_approval) {
            this.approved = true;
            this.on_after_approval();
        }
        this.close();
    }
    onClose() {
        super.onClose();
        // Call a cancelling hook if one is defined (and if the closing happens due to cancelling, i.e. the ok button is NOT clicked).
        if (!this.approved && this.on_after_cancelling) {
            this.on_after_cancelling();
        }
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class OutputWrapperModel extends Model {
    constructor() {
        super(...arguments);
        this.output_wrappers = new OutputWrapperMap();
    }
    _createSettingFields(output_wrapper, container_element) {
        debugLog("Creating setting fields for an OutputWrapper instance.");
        const output_wrapper_name_setting = new obsidian.Setting(container_element)
            // Configuration button
            .setName(output_wrapper.getTitle())
            .addExtraButton(button => button
            .setTooltip("Define output wrapper content")
            .setIcon("gear")
            .onClick(() => {
            this.openSettingsModal(output_wrapper, output_wrapper_name_setting);
        }));
        return output_wrapper_name_setting;
    }
    defineParentConfigurationRelation(output_wrapper) {
        return {
            type: "one-to-many-id",
            key: "output_wrappers",
            id: output_wrapper.getID(),
        };
    }
    getSingularName() {
        return "Output wrapper";
    }
    loadInstances(parent_configuration) {
        debugLog("Loading OutputWrapper instances.");
        this.output_wrappers = new OutputWrapperMap();
        parent_configuration.output_wrappers.forEach((output_wrapper_configuration) => {
            const output_wrapper = new OutputWrapper(this, this.plugin, output_wrapper_configuration, parent_configuration);
            this.output_wrappers.set(output_wrapper_configuration.id, output_wrapper);
        });
        return this.output_wrappers;
    }
    newInstance(parent_configuration) {
        debugLog("Creating a new OutputWrapper instance.");
        // TODO: Move this logic to the base Model class.
        // Setup a default configuration and generate an ID
        const output_wrapper_configuration = this.getDefaultConfiguration();
        // Instantiate an OutputWrapper
        const output_wrapper = new OutputWrapper(this, this.plugin, output_wrapper_configuration, this.plugin.settings);
        this.output_wrappers.set(output_wrapper.getID(), output_wrapper);
        // Store the configuration into plugin's settings
        parent_configuration.output_wrappers.push(output_wrapper_configuration);
        // Return the OutputWrapper
        return output_wrapper;
    }
    validateValue(output_wrapper, field, value) {
        // No validation is needed, I guess. 'Title' and 'content' can both be empty, although an empty title does not make sense.
        return Promise.resolve(undefined);
    }
    openSettingsModal(output_wrapper, output_wrapper_name_setting) {
        debugLog("Opening settings modal for an OutputWrapper instance.");
        const modal = new OutputWrapperSettingsModal(this.plugin, output_wrapper, output_wrapper_name_setting);
        modal.open();
    }
    getDefaultConfiguration() {
        return {
            id: getIDGenerator().generateID(),
            title: "",
            content: "",
        };
    }
    _deleteInstance(deletable_output_wrapper) {
        debugLog("Deleting an OutputWrapper instance.");
        // Remove the OutputWrapper from all TShellCommands that use it.
        const shell_commands = this.plugin.getTShellCommands();
        for (const shell_command_id in shell_commands) {
            const t_shell_command = shell_commands[shell_command_id];
            const output_wrappers = t_shell_command.getConfiguration().output_wrappers;
            Object.each(output_wrappers, (output_wrapper_id, output_stream) => {
                if (output_wrapper_id === deletable_output_wrapper.getID()) {
                    // A shell command uses the output wrapper that is about to be deleted.
                    // Configure the shell command not to use any output wrapper.
                    output_wrappers[output_stream] = null;
                }
            });
        }
        // Remove the OutputWrapper from this class's internal list.
        this.output_wrappers.delete(deletable_output_wrapper.getID());
    }
}
class OutputWrapperMap extends Map {
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
function introduceModels(plugin) {
    debugLog("Introducing models.");
    // Keep in alphabetical order, if possible.
    introduceModelClass(new CustomVariableModel(plugin));
    introduceModelClass(new PromptFieldModel(plugin));
    introduceModelClass(new PromptModel(plugin));
    introduceModelClass(new OutputWrapperModel(plugin));
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
/**
 * This class serves as the actual operational variable class for custom variables. It's paired with the CustomVariableInstance class, which acts
 * as a configuration class to handle settings together with CustomVariableModel class.
 */
class CustomVariable extends Variable {
    constructor(plugin, custom_variable_instance) {
        super(plugin);
        this.custom_variable_instance = custom_variable_instance;
        this.value = null; // TODO: When implementing variable types, make this class abstract and let subclasses define the type of this property.
        this.always_available = false;
        this.on_change_callbacks = new Set();
        this.updateProperties();
        debugLog(`Loaded CustomVariable ${this.variable_name}.`);
    }
    async generateValue() {
        if (null === this.value) {
            debugLog(`Custom variable ${this.variable_name} does not have a value yet, and no default value is defined.`);
            this.throw("This custom variable does not have a value yet, and no default value is defined.");
        }
        return this.value;
    }
    /**
     * TODO: Make it possible to prevent calling onChange callbacks:
     *  - Make it possible to call the callbacks later outside this class.
     *  - This makes it possible to prevent unnecessary CustomVariableView updates when multiple CustomVariables are assigned values in one go (via Shell command URI).
     *  - Store the old value into some kind of history list.
     *  - When calling the callbacks, the current CustomVariable should be passed as a parameter instead of the 'value' and 'old_value' parameters (which can be accessed via the CustomVariable object).
     *
     * @param value
     */
    async setValue(value) {
        const old_value = this.value;
        debugLog(`CustomVariable ${this.variable_name}: Setting value to: ${value} (old was: ${old_value}).`);
        this.value = value;
        // Call the onChange hook.
        await this.callOnChangeCallbacks(value, old_value ?? ""); // Use "" if old_value is null.
    }
    /**
     * Retrieves variable_name and help_text properties from the associated CustomVariableInstance.
     * Called when loading the CustomVariable and when the associated CustomVariableInstance's settings are changed.
     */
    updateProperties() {
        debugLog(`CustomVariable ${this.variable_name}: Updating variable name and help text.`);
        this.variable_name = this.custom_variable_instance.getPrefixedName();
        this.help_text = this.custom_variable_instance.configuration.description;
        resetVariableAutocompleteItems(); // Make autocomplete lists reload their content in order to get the new variable name/help text.
    }
    getIdentifier() {
        return this.custom_variable_instance.getID();
    }
    /**
     * Adds the given callback function to a stack of functions that will be called whenever this CustomVariable's value changes.
     * @param on_change_callback
     */
    onChange(on_change_callback) {
        this.on_change_callbacks.add(on_change_callback);
    }
    async callOnChangeCallbacks(new_value, old_value) {
        debugLog(`CustomVariable ${this.variable_name}: Calling onChange callbacks.`);
        for (const on_change_callback of this.on_change_callbacks) {
            await on_change_callback(this, new_value, old_value);
        }
    }
    getConfiguration() {
        return this.custom_variable_instance.configuration;
    }
    getGlobalDefaultValueConfiguration() {
        return this.custom_variable_instance.configuration.default_value;
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
/**
 * This class serves as an accessor to CustomVariable configurations. It's paired with the CustomVariable class, which acts
 * as an operational class to implement the variable functionality.
 *
 * TODO: Decide a better name for this class. It's too easy to confuse with the CustomVariable class name.
 */
class CustomVariableInstance extends Instance {
    constructor(model, configuration, parent_configuration) {
        super(model, configuration, parent_configuration);
        this.model = model;
        this.custom_variable = null;
        // Introduce the ID to an ID generator so that it won't accidentally generate the same ID again when creating new CustomVariableInstances.
        getIDGenerator().addReservedID(configuration.id);
        debugLog(`Loaded CustomVariableInstance ${this.getID()}.`);
    }
    getID() {
        return this.configuration.id;
    }
    getFullName() {
        return `{{${this.getPrefixedName()}}}`;
    }
    /**
     * Adds an underscore in front of the name.
     */
    getPrefixedName() {
        return "_" + this.configuration.name;
    }
    getTitle() {
        return this.getFullName();
    }
    getCustomVariable() {
        if (!this.custom_variable) {
            debugLog(`CustomVariableInstance ${this.getID()}: Cannot find a CustomVariable. Maybe it's not loaded?`);
            throw new Error(this.constructor.name + ".getVariable(): Cannot find a CustomVariable. Maybe it's not loaded?");
        }
        return this.custom_variable;
    }
    createCustomVariable() {
        debugLog(`CustomVariableInstance ${this.getID()}: Creating an operational CustomVariable.`);
        this.custom_variable = new CustomVariable(this.model.plugin, this);
        this.custom_variable.onChange(async () => await this.model.plugin.updateCustomVariableViews());
        return this.custom_variable;
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class SC_Event_onLayoutReady extends SC_Event {
    constructor() {
        super(...arguments);
        this.register_after_changing_settings = false;
    }
    _register(t_shell_command) {
        this.app.workspace.onLayoutReady(async () => await this.trigger(t_shell_command));
        return false; // The base class does not need to register anything.
    }
    _unregister(t_shell_command) {
        // No need to unregister, because this event happens only once when Obsidian starts. If the event is not enabled for a shell command, next time Obsidian starts, this event won't get registered.
    }
}
SC_Event_onLayoutReady.event_code = "on-layout-ready";
SC_Event_onLayoutReady.event_title = "Obsidian starts";

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class SC_Event_onQuit extends SC_WorkspaceEvent {
    constructor() {
        super(...arguments);
        this.workspace_event = "quit";
    }
}
SC_Event_onQuit.event_code = "on-quit";
SC_Event_onQuit.event_title = "Obsidian quits";

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class SC_Event_onActiveLeafChanged extends SC_WorkspaceEvent {
    constructor() {
        super(...arguments);
        this.workspace_event = "active-leaf-change";
    }
}
SC_Event_onActiveLeafChanged.event_code = "on-active-leaf-changed";
SC_Event_onActiveLeafChanged.event_title = "Switching the active pane";

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class SC_Event_EveryNSeconds extends SC_Event {
    constructor() {
        super(...arguments);
        this.default_configuration = {
            enabled: false,
            seconds: 60,
        };
        this.intervals_ids = {};
    }
    _register(t_shell_command) {
        const milliseconds = this.getConfiguration(t_shell_command).seconds * 1000;
        const interval_id = window.setInterval(async () => await this.trigger(t_shell_command), milliseconds);
        this.plugin.registerInterval(interval_id);
        this.intervals_ids[t_shell_command.getId()] = interval_id;
        return false; // The base class does not need to register anything.
    }
    _unregister(t_shell_command) {
        window.clearInterval(this.intervals_ids[t_shell_command.getId()]);
    }
    /**
     * Overridden only to change the return type.
     * @param t_shell_command
     * @protected
     */
    getConfiguration(t_shell_command) {
        return super.getConfiguration(t_shell_command);
    }
    createExtraSettingsFields(extra_settings_container, t_shell_command) {
        const configuration = this.getConfiguration(t_shell_command);
        let apply_seconds;
        new obsidian.Setting(extra_settings_container)
            .setName("Seconds")
            .setDesc("Needs to be at least 1. Currently supports only integers.")
            .addText(text => text
            .setValue(configuration.seconds.toString())
            .onChange((raw_value) => {
            apply_seconds = parseInt(raw_value);
            // Don't save here, because the user might still be editing the number.
        }))
            .addButton(button => button
            .setButtonText("Apply")
            .onClick(async () => {
            if (undefined == apply_seconds || apply_seconds === this.getConfiguration(t_shell_command).seconds) {
                new obsidian.Notice("You didn't change the seconds!");
            }
            else if (isNaN(apply_seconds)) {
                new obsidian.Notice("The seconds need to be an integer!");
            }
            else if (apply_seconds <= 0) {
                new obsidian.Notice("The seconds need to be at least 1!");
            }
            else {
                // All ok, save.
                this.getConfiguration(t_shell_command).seconds = apply_seconds;
                await this.plugin.saveSettings();
                // Re-register to apply the change
                this.unregister(t_shell_command);
                this.register(t_shell_command);
                // Done
                this.noticeAboutEnabling(t_shell_command);
            }
        }));
    }
    onAfterEnabling(t_shell_command) {
        this.noticeAboutEnabling(t_shell_command);
    }
    noticeAboutEnabling(t_shell_command) {
        new obsidian.Notice("The shell command will run every " + this.getConfiguration(t_shell_command).seconds + " seconds");
    }
}
SC_Event_EveryNSeconds.event_code = "every-n-seconds";
SC_Event_EveryNSeconds.event_title = "Every n seconds";

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class SC_Event_EditorMenu extends SC_MenuEvent {
    constructor() {
        super(...arguments);
        this.workspace_event = "editor-menu";
    }
    getTrigger(t_shell_command) {
        return async (menu, editor, view) => {
            await this.addTShellCommandToMenu(t_shell_command, menu);
        };
    }
}
SC_Event_EditorMenu.event_code = "editor-menu";
SC_Event_EditorMenu.event_title = "Editor menu";

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
function getSC_Events(plugin) {
    if (eventList.length === 0) {
        // Cache the list of SC_Event objects
        eventList.push(new SC_Event_onLayoutReady(plugin), new SC_Event_onQuit(plugin), new SC_Event_onActiveLeafChanged(plugin), new SC_Event_EveryNSeconds(plugin), new SC_Event_FileMenu(plugin), new SC_Event_FolderMenu(plugin), new SC_Event_EditorMenu(plugin), new SC_Event_FileContentModified(plugin), new SC_Event_FileCreated(plugin), new SC_Event_FileDeleted(plugin), new SC_Event_FileMoved(plugin), new SC_Event_FileRenamed(plugin), new SC_Event_FolderCreated(plugin), new SC_Event_FolderDeleted(plugin), new SC_Event_FolderMoved(plugin), new SC_Event_FolderRenamed(plugin));
    }
    return eventList;
}
const eventList = [];

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
/**
 * A wrapper for Obsidian's setIcon(), but with the difference that this one does not need a container as a parameter.
 */
function getIconHTML(icon_id) {
    if (!icon_id) {
        return "";
    }
    const icon_container = document.body.createEl("div"); // A temporary element, will be deleted soon. Not nice to create a temporary element in the body, but I don't know any better way.
    obsidian.setIcon(icon_container, icon_id);
    const icon_html = icon_container.innerHTML;
    icon_container.remove();
    return icon_html;
}
/**
 * @author The list is provided by phibr0.
 * @link https://discord.com/channels/686053708261228577/840286264964022302/968248588641665075
 * @description phibr0: "Updated Icon List for Obsidian v0.14.7+ (lucide icons v0.30.0 + obsidians own)"
 * @copyright The copyright statement at the top of this file does not affect this list of icons.
 * The list seems to miss some icons, so I've made an additional list below.
 * Modifications:
 *  - Removed icons that show up empty: search-large
 */
const ICON_LIST = ["activity", "airplay", "alarm-check", "alarm-clock-off", "alarm-clock", "alarm-minus", "alarm-plus", "album", "alert-circle", "alert-octagon", "alert-triangle", "align-center-horizontal", "align-center-vertical", "align-center", "align-end-horizontal", "align-end-vertical", "align-horizontal-distribute-center", "align-horizontal-distribute-end", "align-horizontal-distribute-start", "align-horizontal-justify-center", "align-horizontal-justify-end", "align-horizontal-justify-start", "align-horizontal-space-around", "align-horizontal-space-between", "align-justify", "align-left", "align-right", "align-start-horizontal", "align-start-vertical", "align-vertical-distribute-center", "align-vertical-distribute-end", "align-vertical-distribute-start", "align-vertical-justify-center", "align-vertical-justify-end", "align-vertical-justify-start", "align-vertical-space-around", "align-vertical-space-between", "anchor", "aperture", "archive", "arrow-big-down", "arrow-big-left", "arrow-big-right", "arrow-big-up", "arrow-down-circle", "arrow-down-left", "arrow-down-right", "arrow-down", "arrow-left-circle", "arrow-left-right", "arrow-left", "arrow-right-circle", "arrow-right", "arrow-up-circle", "arrow-up-left", "arrow-up-right", "arrow-up", "asterisk", "at-sign", "award", "axe", "banknote", "bar-chart-2", "bar-chart", "baseline", "battery-charging", "battery-full", "battery-low", "battery-medium", "battery", "beaker", "bell-minus", "bell-off", "bell-plus", "bell-ring", "bell", "bike", "binary", "bitcoin", "bluetooth-connected", "bluetooth-off", "bluetooth-searching", "bluetooth", "bold", "book-open", "book", "bookmark-minus", "bookmark-plus", "bookmark", "bot", "box-select", "box", "briefcase", "brush", "bug", "building-2", "building", "bus", "calculator", "calendar", "camera-off", "camera", "car", "carrot", "cast", "check-circle-2", "check-circle", "check-square", "check", "chevron-down", "chevron-first", "chevron-last", "chevron-left", "chevron-right", "chevron-up", "chevrons-down-up", "chevrons-down", "chevrons-left", "chevrons-right", "chevrons-up-down", "chevrons-up", "chrome", "circle-slashed", "circle", "clipboard-check", "clipboard-copy", "clipboard-list", "clipboard-x", "clipboard", "clock-1", "clock-10", "clock-11", "clock-12", "clock-2", "clock-3", "clock-4", "clock-5", "clock-6", "clock-7", "clock-8", "clock-9", "clock", "cloud-drizzle", "cloud-fog", "cloud-hail", "cloud-lightning", "cloud-moon", "cloud-off", "cloud-rain-wind", "cloud-rain", "cloud-snow", "cloud-sun", "cloud", "cloudy", "clover", "code-2", "code", "codepen", "codesandbox", "coffee", "coins", "columns", "command", "compass", "contact", "contrast", "cookie", "copy", "copyleft", "copyright", "corner-down-left", "corner-down-right", "corner-left-down", "corner-left-up", "corner-right-down", "corner-right-up", "corner-up-left", "corner-up-right", "cpu", "credit-card", "crop", "cross", "crosshair", "crown", "currency", "database", "delete", "dice-1", "dice-2", "dice-3", "dice-4", "dice-5", "dice-6", "disc", "divide-circle", "divide-square", "divide", "dollar-sign", "download-cloud", "download", "dribbble", "droplet", "droplets", "drumstick", "edit-2", "edit-3", "edit", "egg", "equal-not", "equal", "eraser", "euro", "expand", "external-link", "eye-off", "eye", "facebook", "fast-forward", "feather", "figma", "file-check-2", "file-check", "file-code", "file-digit", "file-input", "file-minus-2", "file-minus", "file-output", "file-plus-2", "file-plus", "file-search", "file-text", "file-x-2", "file-x", "file", "files", "film", "filter", "flag-off", "flag-triangle-left", "flag-triangle-right", "flag", "flame", "flashlight-off", "flashlight", "flask-conical", "flask-round", "folder-minus", "folder-open", "folder-plus", "folder", "form-input", "forward", "frame", "framer", "frown", "function-square", "gamepad-2", "gamepad", "gauge", "gavel", "gem", "ghost", "gift", "git-branch-plus", "git-branch", "git-commit", "git-fork", "git-merge", "git-pull-request", "github", "gitlab", "glasses", "globe-2", "globe", "grab", "graduation-cap", "grid", "grip-horizontal", "grip-vertical", "hammer", "hand-metal", "hand", "hard-drive", "hard-hat", "hash", "haze", "headphones", "heart", "help-circle", "hexagon", "highlighter", "history", "home", "image-minus", "image-off", "image-plus", "image", "import", "inbox", "indent", "indian-rupee", "infinity", "info", "inspect", "instagram", "italic", "japanese-yen", "key", "keyboard", "landmark", "languages", "laptop-2", "laptop", "lasso-select", "lasso", "layers", "layout-dashboard", "layout-grid", "layout-list", "layout-template", "layout", "library", "life-buoy", "lightbulb-off", "lightbulb", "link-2-off", "link-2", "link", "linkedin", "list-checks", "list-minus", "list-ordered", "list-plus", "list-x", "list", "loader-2", "loader", "locate-fixed", "locate-off", "locate", "lock", "log-in", "log-out", "mail", "map-pin", "map", "maximize-2", "maximize", "megaphone", "meh", "menu", "message-circle", "message-square", "mic-off", "mic", "minimize-2", "minimize", "minus-circle", "minus-square", "minus", "monitor-off", "monitor-speaker", "monitor", "moon", "more-horizontal", "more-vertical", "mountain-snow", "mountain", "mouse-pointer-2", "mouse-pointer-click", "mouse-pointer", "mouse", "move-diagonal-2", "move-diagonal", "move-horizontal", "move-vertical", "move", "music", "navigation-2", "navigation", "network", "octagon", "option", "outdent", "package-check", "package-minus", "package-plus", "package-search", "package-x", "package", "palette", "palmtree", "paperclip", "pause-circle", "pause-octagon", "pause", "pen-tool", "pencil", "percent", "person-standing", "phone-call", "phone-forwarded", "phone-incoming", "phone-missed", "phone-off", "phone-outgoing", "phone", "pie-chart", "piggy-bank", "pin", "pipette", "plane", "play-circle", "play", "plug-zap", "plus-circle", "plus-square", "plus", "pocket", "podcast", "pointer", "pound-sterling", "power-off", "power", "printer", "qr-code", "quote", "radio-receiver", "radio", "redo", "refresh-ccw", "refresh-cw", "regex", "repeat-1", "repeat", "reply-all", "reply", "rewind", "rocket", "rocking-chair", "rotate-ccw", "rotate-cw", "rss", "ruler", "russian-ruble", "save", "scale", "scan-line", "scan", "scissors", "screen-share-off", "screen-share", "search", "send", "separator-horizontal", "separator-vertical", "server-crash", "server-off", "server", "settings-2", "settings", "share-2", "share", "sheet", "shield-alert", "shield-check", "shield-close", "shield-off", "shield", "shirt", "shopping-bag", "shopping-cart", "shovel", "shrink", "shuffle", "sidebar-close", "sidebar-open", "sidebar", "sigma", "signal-high", "signal-low", "signal-medium", "signal-zero", "signal", "skip-back", "skip-forward", "skull", "slack", "slash", "sliders", "smartphone-charging", "smartphone", "smile", "snowflake", "sort-asc", "sort-desc", "speaker", "sprout", "square", "star-half", "star", "stop-circle", "stretch-horizontal", "stretch-vertical", "strikethrough", "subscript", "sun", "sunrise", "sunset", "superscript", "swiss-franc", "switch-camera", "table", "tablet", "tag", "target", "tent", "terminal-square", "terminal", "text-cursor-input", "text-cursor", "thermometer-snowflake", "thermometer-sun", "thermometer", "thumbs-down", "thumbs-up", "ticket", "timer-off", "timer-reset", "timer", "toggle-left", "toggle-right", "tornado", "trash-2", "trash", "trello", "trending-down", "trending-up", "triangle", "truck", "tv-2", "tv", "twitch", "twitter", "type", "umbrella", "underline", "undo", "unlink-2", "unlink", "unlock", "upload-cloud", "upload", "user-check", "user-minus", "user-plus", "user-x", "user", "users", "verified", "vibrate", "video-off", "video", "view", "voicemail", "volume-1", "volume-2", "volume-x", "volume", "wallet", "wand", "watch", "waves", "webcam", "wifi-off", "wifi", "wind", "wrap-text", "wrench", "x-circle", "x-octagon", "x-square", "x", "youtube", "zap-off", "zap", "zoom-in", "zoom-out", "search", "activity", "airplay", "alarm-check", "alarm-clock-off", "alarm-clock", "alarm-minus", "alarm-plus", "album", "alert-circle", "alert-octagon", "alert-triangle", "align-center-horizontal", "align-center-vertical", "align-center", "align-end-horizontal", "align-end-vertical", "align-horizontal-distribute-center", "align-horizontal-distribute-end", "align-horizontal-distribute-start", "align-horizontal-justify-center", "align-horizontal-justify-end", "align-horizontal-justify-start", "align-horizontal-space-around", "align-horizontal-space-between", "align-justify", "align-left", "align-right", "align-start-horizontal", "align-start-vertical", "align-vertical-distribute-center", "align-vertical-distribute-end", "align-vertical-distribute-start", "align-vertical-justify-center", "align-vertical-justify-end", "align-vertical-justify-start", "align-vertical-space-around", "align-vertical-space-between", "anchor", "aperture", "archive", "arrow-big-down", "arrow-big-left", "arrow-big-right", "arrow-big-up", "arrow-down-circle", "arrow-down-left", "arrow-down-right", "arrow-down", "arrow-left-circle", "arrow-left-right", "arrow-left", "arrow-right-circle", "arrow-right", "arrow-up-circle", "arrow-up-left", "arrow-up-right", "arrow-up", "asterisk", "at-sign", "award", "axe", "banknote", "bar-chart-2", "bar-chart", "baseline", "battery-charging", "battery-full", "battery-low", "battery-medium", "battery", "beaker", "bell-minus", "bell-off", "bell-plus", "bell-ring", "bell", "bike", "binary", "bitcoin", "bluetooth-connected", "bluetooth-off", "bluetooth-searching", "bluetooth", "bold", "book-open", "book", "bookmark-minus", "bookmark-plus", "bookmark", "bot", "box-select", "box", "briefcase", "brush", "bug", "building-2", "building", "bus", "calculator", "calendar", "camera-off", "camera", "car", "carrot", "cast", "check-circle-2", "check-circle", "check-square", "check", "chevron-down", "chevron-first", "chevron-last", "chevron-left", "chevron-right", "chevron-up", "chevrons-down-up", "chevrons-down", "chevrons-left", "chevrons-right", "chevrons-up-down", "chevrons-up", "chrome", "circle-slashed", "circle", "clipboard-check", "clipboard-copy", "clipboard-list", "clipboard-x", "clipboard", "clock-1", "clock-10", "clock-11", "clock-12", "clock-2", "clock-3", "clock-4", "clock-5", "clock-6", "clock-7", "clock-8", "clock-9", "lucide-clock", "cloud-drizzle", "cloud-fog", "cloud-hail", "cloud-lightning", "cloud-moon", "cloud-off", "cloud-rain-wind", "cloud-rain", "cloud-snow", "cloud-sun", "lucide-cloud", "cloudy", "clover", "code-2", "code", "codepen", "codesandbox", "coffee", "coins", "columns", "command", "compass", "contact", "contrast", "cookie", "copy", "copyleft", "copyright", "corner-down-left", "corner-down-right", "corner-left-down", "corner-left-up", "corner-right-down", "corner-right-up", "corner-up-left", "corner-up-right", "cpu", "credit-card", "crop", "lucide-cross", "crosshair", "crown", "currency", "database", "delete", "dice-1", "dice-2", "dice-3", "dice-4", "dice-5", "dice-6", "disc", "divide-circle", "divide-square", "divide", "dollar-sign", "download-cloud", "download", "dribbble", "droplet", "droplets", "drumstick", "edit-2", "edit-3", "edit", "egg", "equal-not", "equal", "eraser", "euro", "expand", "external-link", "eye-off", "eye", "facebook", "fast-forward", "feather", "figma", "file-check-2", "file-check", "file-code", "file-digit", "file-input", "file-minus-2", "file-minus", "file-output", "file-plus-2", "file-plus", "file-search", "file-text", "file-x-2", "file-x", "file", "files", "film", "filter", "flag-off", "flag-triangle-left", "flag-triangle-right", "flag", "flame", "flashlight-off", "flashlight", "flask-conical", "flask-round", "folder-minus", "folder-open", "folder-plus", "lucide-folder", "form-input", "forward", "frame", "framer", "frown", "function-square", "gamepad-2", "gamepad", "gauge", "gavel", "gem", "ghost", "gift", "git-branch-plus", "git-branch", "git-commit", "git-fork", "git-merge", "git-pull-request", "github", "gitlab", "glasses", "globe-2", "globe", "grab", "graduation-cap", "grid", "grip-horizontal", "grip-vertical", "hammer", "hand-metal", "hand", "hard-drive", "hard-hat", "hash", "haze", "headphones", "heart", "help-circle", "hexagon", "highlighter", "history", "home", "image-minus", "image-off", "image-plus", "image", "import", "inbox", "indent", "indian-rupee", "infinity", "lucide-info", "inspect", "instagram", "italic", "japanese-yen", "key", "keyboard", "landmark", "lucide-languages", "laptop-2", "laptop", "lasso-select", "lasso", "layers", "layout-dashboard", "layout-grid", "layout-list", "layout-template", "layout", "library", "life-buoy", "lightbulb-off", "lightbulb", "link-2-off", "link-2", "lucide-link", "linkedin", "list-checks", "list-minus", "list-ordered", "list-plus", "list-x", "list", "loader-2", "loader", "locate-fixed", "locate-off", "locate", "lock", "log-in", "log-out", "mail", "map-pin", "map", "maximize-2", "maximize", "megaphone", "meh", "menu", "message-circle", "message-square", "mic-off", "mic", "minimize-2", "minimize", "minus-circle", "minus-square", "minus", "monitor-off", "monitor-speaker", "monitor", "moon", "more-horizontal", "more-vertical", "mountain-snow", "mountain", "mouse-pointer-2", "mouse-pointer-click", "mouse-pointer", "mouse", "move-diagonal-2", "move-diagonal", "move-horizontal", "move-vertical", "move", "music", "navigation-2", "navigation", "network", "octagon", "option", "outdent", "package-check", "package-minus", "package-plus", "package-search", "package-x", "package", "palette", "palmtree", "paperclip", "pause-circle", "pause-octagon", "pause", "pen-tool", "lucide-pencil", "percent", "person-standing", "phone-call", "phone-forwarded", "phone-incoming", "phone-missed", "phone-off", "phone-outgoing", "phone", "pie-chart", "piggy-bank", "lucide-pin", "pipette", "plane", "play-circle", "play", "plug-zap", "plus-circle", "plus-square", "plus", "pocket", "podcast", "pointer", "pound-sterling", "power-off", "power", "printer", "qr-code", "quote", "radio-receiver", "radio", "redo", "refresh-ccw", "refresh-cw", "regex", "repeat-1", "repeat", "reply-all", "reply", "rewind", "rocket", "rocking-chair", "rotate-ccw", "rotate-cw", "rss", "ruler", "russian-ruble", "save", "scale", "scan-line", "scan", "scissors", "screen-share-off", "screen-share", "lucide-search", "send", "separator-horizontal", "separator-vertical", "server-crash", "server-off", "server", "settings-2", "settings", "share-2", "share", "sheet", "shield-alert", "shield-check", "shield-close", "shield-off", "shield", "shirt", "shopping-bag", "shopping-cart", "shovel", "shrink", "shuffle", "sidebar-close", "sidebar-open", "sidebar", "sigma", "signal-high", "signal-low", "signal-medium", "signal-zero", "signal", "skip-back", "skip-forward", "skull", "slack", "slash", "sliders", "smartphone-charging", "smartphone", "smile", "snowflake", "sort-asc", "sort-desc", "speaker", "sprout", "square", "star-half", "lucide-star", "stop-circle", "stretch-horizontal", "stretch-vertical", "strikethrough", "subscript", "sun", "sunrise", "sunset", "superscript", "swiss-franc", "switch-camera", "table", "tablet", "tag", "target", "tent", "terminal-square", "terminal", "text-cursor-input", "text-cursor", "thermometer-snowflake", "thermometer-sun", "thermometer", "thumbs-down", "thumbs-up", "ticket", "timer-off", "timer-reset", "timer", "toggle-left", "toggle-right", "tornado", "trash-2", "lucide-trash", "trello", "trending-down", "trending-up", "triangle", "truck", "tv-2", "tv", "twitch", "twitter", "type", "umbrella", "underline", "undo", "unlink-2", "unlink", "unlock", "upload-cloud", "upload", "user-check", "user-minus", "user-plus", "user-x", "user", "users", "verified", "vibrate", "video-off", "video", "view", "voicemail", "volume-1", "volume-2", "volume-x", "volume", "wallet", "wand", "watch", "waves", "webcam", "wifi-off", "wifi", "wind", "wrap-text", "wrench", "x-circle", "x-octagon", "x-square", "x", "youtube", "zap-off", "zap", "zoom-in", "zoom-out", "lucide-search"];
/**
 * The original ICON_LIST lacks some icons, so I've added them to this separate list. Use AUGMENTED_ICON_LIST to access all the icons together.
 * This is copied 2022-07-18 from https://forum.obsidian.md/t/list-of-available-icons-for-component-seticon/16332/4?u=jare (it's the "New list (from 2021.04.11, user SV on Discord)").
 * Modifications:
 * - Formatted into a JavaScript array.
 * - Removed icons that can be found from ICON_LIST: clock, cloud, cross, folder, info, languages, link, pencil, pin, search, star
 * - Removed icons that do not seem to work: csv, deleteColumn, deleteRow, formula, insertColumn, insertRow, moveColumnLeft, moveColumnRight, moveRowDown, moveRowUp, spreadsheet
 */
const MISSING_ICONS = [
    "any-key", "audio-file", "blocks", "bold-glyph", "bracket-glyph", "broken-link", "bullet-list", "bullet-list-glyph", "calendar-with-checkmark", "check-in-circle", "check-small", "checkbox-glyph", "checkmark", "code-glyph", "create-new", "cross-in-box", "crossed-star", "dice", "document", "documents", "dot-network", "double-down-arrow-glyph", "double-up-arrow-glyph", "down-arrow-with-tail", "down-chevron-glyph", "enter", "exit-fullscreen", "expand-vertically", "filled-pin", "forward-arrow", "fullscreen", "gear", "go-to-file", "hashtag", "heading-glyph", "help", "highlight-glyph", "horizontal-split", "image-file", "image-glyph", "indent-glyph", "install", "italic-glyph", "keyboard-glyph", "left-arrow", "left-arrow-with-tail", "left-chevron-glyph", "lines-of-text", "link-glyph", "logo-crystal", "magnifying-glass", "microphone", "microphone-filled", "minus-with-circle", "note-glyph", "number-list-glyph", "open-vault", "pane-layout", "paper-plane", "paused", "pdf-file", "percent-sign-glyph", "plus-with-circle", "popup-open", "presentation", "price-tag-glyph", "quote-glyph", "redo-glyph", "reset", "right-arrow", "right-arrow-with-tail", "right-chevron-glyph", "right-triangle", "run-command", "sheets-in-box", "sortAsc", "sortDesc", "stacked-levels", "star-list", "strikethrough-glyph", "switch", "sync", "sync-small", "tag-glyph", "three-horizontal-bars", "undo-glyph", "unindent-glyph", "up-and-down-arrows", "up-arrow-with-tail", "up-chevron-glyph", "uppercase-lowercase-a", "vault", "vertical-split", "vertical-three-dots", "wrench-screwdriver-glyph",
];
/**
 * The original ICON_LIST contains duplicate entries (e.g. two "activity" items) and is not in alphabetical order. This list improves it.
 * ICON_LIST also doesn't contain all traditional Obsidian icons. This list includes them.
 */
const AUGMENTED_ICON_LIST = uniqueArray(ICON_LIST).concat(MISSING_ICONS).sort();

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
/**
 * TODO: Rename this class. Replace the T prefix with something else. The T stands for Type (kind of like TFile from Obsidian), but this is not a type, this is a class. Maybe ShellCommandInstance? It's not the best name, but I can't come up with a better one now.
 */
class TShellCommand {
    constructor(plugin, configuration) {
        this.plugin = plugin;
        this.configuration = configuration;
        // Introduce the ID to an ID generator so that it won't accidentally generate the same ID again when creating new shell commands.
        getIDGenerator().addReservedID(configuration.id);
    }
    getPlugin() {
        return this.plugin;
    }
    /**
     * Use this when you need to alter the configuration values. if you only need to read configuration values, use get*()
     * methods instead.
     */
    getConfiguration() {
        return this.configuration;
    }
    getId() {
        return this.configuration.id;
    }
    getShell() {
        // Check if the shell command has defined a specific shell.
        const shell = this.configuration.shells[getOperatingSystem()];
        if (undefined === shell) {
            // The shell command does not define an explicit shell.
            // Use a default shell from the plugin's settings.
            return this.plugin.getDefaultShell();
        }
        else {
            // The shell command has an explicit shell defined.
            return shell;
        }
    }
    getShells() {
        return this.configuration.shells;
    }
    /**
     * Returns a shell command string specific for the current operating system, or a generic shell command if this shell
     * command does not have an explicit version for the current OS.
     */
    getShellCommand() {
        // Check if the shell command has defined a specific command for this operating system.
        const platformSpecificShellCommand = this.configuration.platform_specific_commands[getOperatingSystem()];
        if (undefined === platformSpecificShellCommand) {
            // No command is defined specifically for this operating system.
            // Return an "OS agnostic" command.
            return this.configuration.platform_specific_commands.default;
        }
        else {
            // The shell command has defined a specific command for this operating system.
            return platformSpecificShellCommand;
        }
    }
    /**
     * Returns a version of the shell command that should be used if no platform specific command is defined for the
     * current platform. If you plan to use this for execution, consider using getShellCommand() instead, as it takes the
     * current platform into account.
     */
    getDefaultShellCommand() {
        return this.configuration.platform_specific_commands.default;
    }
    getPlatformSpecificShellCommands() {
        return this.configuration.platform_specific_commands;
    }
    /**
     * Returns a list of PlatformIds that have a shell command version defined. 'default' is never included in the list.
     *
     * TODO: Invent a better name for this method.
     */
    getNonEmptyPlatformIds() {
        const platform_specific_shell_commands = this.getPlatformSpecificShellCommands();
        const platform_ids_with_non_empty_shell_commands = [];
        let platform_id;
        for (platform_id in PlatformNames) { // Note that this loop does not iterate 'default' platform id (= the fallback platform id that is used when a shell command does not have a version for the current platform).
            const platform_specific_shell_command = platform_specific_shell_commands[platform_id];
            if (platform_specific_shell_command && "" !== platform_specific_shell_command.trim()) {
                platform_ids_with_non_empty_shell_commands.push(platform_id);
            }
        }
        return platform_ids_with_non_empty_shell_commands;
    }
    getIconId() {
        return this.configuration.icon;
    }
    getIconHTML() {
        if (this.configuration.icon) {
            // An icon is defined.
            return getIconHTML(this.configuration.icon);
        }
        else {
            // No icon is defined.
            return "";
        }
    }
    getAlias() {
        return this.configuration.alias;
    }
    /**
     * TODO: Use this method in all places where similar logic is needed.
     */
    getAliasOrShellCommand() {
        return this.configuration.alias || this.getShellCommand();
    }
    getConfirmExecution() {
        return this.configuration.confirm_execution;
    }
    getIgnoreErrorCodes() {
        return this.configuration.ignore_error_codes;
    }
    getInputChannels() {
        return this.configuration.input_contents;
    }
    getOutputChannelOrder() {
        return this.configuration.output_channel_order;
    }
    getOutputChannels() {
        return this.configuration.output_channels;
    }
    getOutputHandlingMode() {
        return this.configuration.output_handling_mode;
    }
    /**
     * Finds an output wrapper that should be used for the given OutputStream. Returns null, if no OutputWrapper should
     * be used.
     *
     * @param output_stream
     */
    getOutputWrapper(output_stream) {
        const output_wrapper_id = this.configuration.output_wrappers[output_stream];
        if (!output_wrapper_id) {
            // No output wrapper is defined for this output stream in this shell command.
            return null;
        }
        for (const output_wrapper of this.plugin.getOutputWrappers().values()) {
            // Check if this is the output wrapper defined for this shell command.
            if (output_wrapper.getID() === output_wrapper_id) {
                // The correct output wrapper was found.
                return output_wrapper;
            }
        }
        throw new Error("OutputWrapper with ID " + output_wrapper_id + " was not found.");
    }
    /**
     * Checks if different output streams can be wrapped together. In addition to this, combining output streams also
     * requires the OutputChannels to be the same, but that's not checked in this method.
     */
    isOutputWrapperStdoutSameAsStderr() {
        return this.configuration.output_wrappers["stdout"] === this.configuration.output_wrappers["stderr"];
    }
    getEventsConfiguration() {
        return this.configuration.events;
    }
    getEventConfiguration(sc_event) {
        return this.getEventsConfiguration()[sc_event.static().getCode()] || sc_event.getDefaultConfiguration(false);
    }
    isSC_EventEnabled(event_code) {
        const events_configuration = this.getEventsConfiguration();
        if (undefined === events_configuration[event_code]) {
            // Not enabled
            return false;
        }
        else {
            // Maybe enabled
            return events_configuration[event_code].enabled;
        }
    }
    /**
     * Called when changing event settings in ShellCommandExtraOptionsModal.
     * plugin.saveSettings() needs to be called after this!
     *
     * @param sc_event
     */
    enableSC_Event(sc_event) {
        const event_code = sc_event.static().getCode();
        const events_configuration = this.getEventsConfiguration();
        if (undefined === events_configuration[event_code]) {
            // Not enabled
            // Enable
            events_configuration[event_code] = sc_event.getDefaultConfiguration(true);
        }
        else {
            // Maybe enabled
            if (!events_configuration[event_code].enabled) {
                events_configuration[event_code].enabled = true;
            }
        }
        if (sc_event.canRegisterAfterChangingSettings()) {
            this.registerSC_Event(sc_event);
        }
        sc_event.onAfterEnabling(this);
    }
    /**
     * Called when changing event settings in ShellCommandExtraOptionsModal.
     * plugin.saveSettings() needs to be called after this!
     *
     * @param sc_event
     */
    disableSC_Event(sc_event) {
        const event_code = sc_event.static().getCode();
        const events_configuration = this.getEventsConfiguration();
        if (undefined !== events_configuration[event_code]) {
            // Maybe enabled
            if (events_configuration[event_code].enabled) {
                // Is enabled.
                // Disable.
                const configuration_property_names = Object.getOwnPropertyNames(events_configuration[event_code]);
                if (configuration_property_names.length > 1) {
                    // There's more settings than just 'enable'.
                    // Disable by setting 'enable' to false, don't flush the settings, they can be useful if the event gets re-enabled.
                    events_configuration[event_code].enabled = false;
                }
                else {
                    // 'enabled' is the only setting.
                    // Disable by removing the configuration object completely to make the settings file cleaner.
                    delete events_configuration[event_code];
                }
            }
        }
        if (sc_event.canRegisterAfterChangingSettings()) {
            this.unregisterSC_Event(sc_event);
        }
    }
    /**
     * Returns all SC_Events that are enabled fro this shell command.
     *
     * Private as it's currently only used domestically, but can be changed to public if needed.
     */
    getSC_Events() {
        const enabled_sc_events = [];
        getSC_Events(this.plugin).forEach((sc_event) => {
            if (this.isSC_EventEnabled(sc_event.static().getCode())) {
                enabled_sc_events.push(sc_event);
            }
        });
        return enabled_sc_events;
    }
    /**
     * Private, if you need access from outside, use enableSC_Event().
     *
     * @param sc_event
     * @private
     */
    registerSC_Event(sc_event) {
        sc_event.register(this);
    }
    /**
     * Private, if you need access from outside, use disableSC_Event().
     *
     * @param sc_event
     * @private
     */
    unregisterSC_Event(sc_event) {
        sc_event.unregister(this);
    }
    /**
     * Set's up all events that are enabled for this shell command.
     *
     * @param called_after_changing_settings Set to: true, if this happens after changing configuration; false, if this happens during loading the plugin.
     */
    registerSC_Events(called_after_changing_settings) {
        this.getSC_Events().forEach((sc_event) => {
            const can_register = !called_after_changing_settings || sc_event.canRegisterAfterChangingSettings();
            if (can_register) {
                this.registerSC_Event(sc_event);
            }
        });
    }
    unregisterSC_Events() {
        this.getSC_Events().forEach((sc_event) => {
            this.unregisterSC_Event(sc_event);
        });
    }
    registerToCommandPalette() {
        // TODO: Move the logic from plugin.registerShellCommand() to here, but split to multiple methods.
        this.plugin.registerShellCommand(this);
    }
    unregisterFromCommandPalette() {
        // FIXME: I think the unregistering does not work.
        delete this.plugin.obsidian_commands[this.getId()];
    }
    /**
     * Checks the configuration for command_palette_availability and returns:
     *  - true, if the value is "enabled" or "unlisted"
     *  - false, if the value is "disabled"
     *
     * Adding to command palette also enables hotkeys, which is why adding can be permitted, but showing denied, if a shell command should only be available via hotkeys.
     */
    canAddToCommandPalette() {
        return this.getConfiguration().command_palette_availability !== "disabled";
    }
    /**
     * Another name for canAddToCommandPalette().
     */
    canHaveHotkeys() {
        return this.canAddToCommandPalette();
    }
    /**
     * Checks the configuration for command_palette_availability and returns:
     *  - true, if the value is "enabled"
     *  - false, if the value is "disabled" or "unlisted"
     */
    canShowInCommandPalette() {
        return this.getConfiguration().command_palette_availability === "enabled";
    }
    /**
     * Creates a new ParsingProcess instance and defines two sets of variables:
     *  - First set: All variables that are not tied to any preactions.
     *  - Second set: Variables that are tied to preactions. Can be an empty set.
     * You need to still call ParsingProcess.process() to parse the first set. ShellCommandExecutor takes care of calling
     * ParsingProcess.processRest() to process all non-processed sets.
     *
     * @See ParsingProcess class for a description of the process.
     * @param sc_event Needed to get {{event_*}} variables parsed. Can be left out if working outside any SC_Event context, in which case {{event_*}} variables are inaccessible.
     */
    createParsingProcess(sc_event) {
        const stdout_output_wrapper = this.getOutputWrapper("stdout"); // Can be null
        const stderr_output_wrapper = this.getOutputWrapper("stderr"); // Can be null
        return new ParsingProcess(this.plugin, {
            shell_command: this.getShellCommand(),
            alias: this.getAlias(),
            environment_variable_path_augmentation: getPATHAugmentation(this.plugin) ?? "",
            stdinContent: this.configuration.input_contents.stdin ?? undefined,
            output_wrapper_stdout: stdout_output_wrapper ? stdout_output_wrapper.getContent() : undefined,
            output_wrapper_stderr: stderr_output_wrapper ? stderr_output_wrapper.getContent() : undefined,
        }, this, sc_event, [
            this.getNonPreactionsDependentVariables(),
            this.getPreactionsDependentVariables(), // Second set: Variables that are tied to preactions. Can be an empty set.
        ], [
            // Do not escape variables in stdin, because shells won't interpret special characters in stdin. All characters are considered literal.
            "stdinContent",
            // Do not escape variables in output wrappers, because they are not going through a shell and escape characters would be visible in the end result.
            'output_wrapper_stdout',
            'output_wrapper_stderr',
        ]);
    }
    setObsidianCommand(obsidian_command) {
        this.obsidian_command = obsidian_command;
    }
    getObsidianCommand() {
        return this.obsidian_command;
    }
    /**
     * No renaming is done if the shell command is excluded from the command palette.
     */
    renameObsidianCommand(shell_command, alias) {
        // Rename the command in command palette
        const prefix = this.plugin.getPluginName() + ": "; // Normally Obsidian prefixes all commands with the plugin name automatically, but now that we are actually _editing_ a command in the palette (not creating a new one), Obsidian won't do the prefixing for us.
        // Check that the shell command is actually registered to Obsidian's command palette.
        if (undefined !== this.obsidian_command) {
            // Yes, the shell command is registered in Obsidian's command palette.
            // Update the command palette name.
            this.obsidian_command.name = prefix + generateObsidianCommandName(this.plugin, shell_command, alias);
        }
        // If the shell command's "command_palette_availability" settings is set to "disabled", then the shell command is not present in this.obsidian_command and so the command palette name does not need updating.
    }
    /**
     * Clears an internal cache used by .getPreactions().
     * Only needed to be called after creating new PreactionConfigurations or deleting old ones. Should not need to be called
     * when modifying properties in existing PreactionConfigurations.
     */
    resetPreactions() {
        debugLog(`TShellCommand ${this.getId()}: Resetting preactions.`);
        delete this.cached_preactions;
    }
    getPreactions() {
        debugLog(`TShellCommand ${this.getId()}: Getting preactions.`);
        if (!this.cached_preactions) {
            this.cached_preactions = [];
            let preaction_configuration;
            for (preaction_configuration of this.getConfiguration().preactions) {
                // Only create the preaction if it's enabled.
                if (preaction_configuration.enabled) {
                    // Yes, it's enabled.
                    // Instantiate the Preaction.
                    this.cached_preactions.push(createPreaction(this.plugin, preaction_configuration, this));
                }
            }
        }
        return this.cached_preactions;
    }
    /**
     * Returns Variables that are not dependent on any Preaction.
     * @private Can be made public if needed.
     */
    getNonPreactionsDependentVariables() {
        debugLog(`TShellCommand ${this.getId()}: Getting non preactions dependent variables.`);
        const all_variables = this.plugin.getVariables();
        return removeFromSet(all_variables, this.getPreactionsDependentVariables());
    }
    /**
     * @private Can be made public if needed.
     */
    getPreactionsDependentVariables() {
        debugLog(`TShellCommand ${this.getId()}: Getting preactions dependent variables.`);
        let dependent_variables = new VariableSet();
        for (const preaction of this.getPreactions()) {
            dependent_variables = mergeSets(dependent_variables, preaction.getDependentVariables());
        }
        return dependent_variables;
    }
    /**
     * @return Returns undefined, if no configuration is defined for this variable.
     * @param variable
     * @param canInherit If true, can get default value configuration from Variable configuration (= upper level configuration in this case). Can be set to false in situations where it's important to know what the shell command itself has defined or not defined.
     */
    getDefaultValueConfigurationForVariable(variable, canInherit = true) {
        const defaultValueConfiguration = this.configuration.variable_default_values[variable.getIdentifier()];
        if (undefined === defaultValueConfiguration || defaultValueConfiguration.type === "inherit") {
            // This shell command does not specify a default value.
            if (canInherit) {
                // Return a global configuration (but even that can be undefined).
                return variable.getGlobalDefaultValueConfiguration(); // Can return undefined.
            }
            // If inheriting is denied, pass to return the defaultValueConfiguration that were gotten from this.configuration.variable_default_values.
        }
        return defaultValueConfiguration;
    }
    /**
     * Returns an URI that can be used in links (in or outside of Obsidian) to execute this shell command. The URI also
     * contains stubs for any possible CustomVariables that might be used in the shell command (if any).
     */
    getExecutionURI() {
        const execution_uri = this.plugin.getObsidianURI(SC_Plugin.SHELL_COMMANDS_URI_ACTION, { execute: this.getId() });
        // Get a list CustomVariables that the shell command uses.
        const custom_variables = new VariableSet();
        for (const custom_variable of getUsedVariables(this.plugin, this.getShellCommand())) {
            // Check that the variable IS a CustomVariable.
            if (custom_variable instanceof CustomVariable) {
                custom_variables.add(custom_variable);
            }
        }
        // Exclude variables whose values will come from Preactions - they will not probably be needed in the URI.
        const custom_variables_suitable_for_uri = removeFromSet(custom_variables, this.getPreactionsDependentVariables());
        // Append the suitable custom variable names to the uri.
        let execution_uri_with_variables = execution_uri;
        for (const custom_variable of custom_variables_suitable_for_uri) {
            execution_uri_with_variables += "&" + custom_variable.variable_name + "=";
        }
        // Finished.
        return execution_uri_with_variables;
    }
    /**
     * Returns an adjacent TShellCommand that appears next in the configuration list. Returns undefined, if this is the
     * last TShellCommand. Used in settings to switch quickly from one TShellCommand to another.
     */
    nextTShellCommand() {
        const t_shell_commands = Object.values(this.plugin.getTShellCommands());
        const this_index = t_shell_commands.indexOf(this);
        if (this_index === t_shell_commands.length - 1) {
            return undefined;
        }
        return t_shell_commands[this_index + 1];
    }
    /**
     * Returns an adjacent TShellCommand that appears before in the configuration list. Returns undefined, if this is the
     * first TShellCommand. Used in settings to switch quickly from one TShellCommand to another.
     */
    previousTShellCommand() {
        const t_shell_commands = Object.values(this.plugin.getTShellCommands());
        const this_index = t_shell_commands.indexOf(this);
        if (this_index === 0) {
            return undefined;
        }
        return t_shell_commands[this_index - 1];
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
function createVariableDefaultValueFields(plugin, containerElement, targetObject) {
    // Add default value fields for each variable that can have a default value.
    for (const variable of plugin.getVariables()) {
        // Only add fields for variables that are not always accessible.
        if (!variable.isAlwaysAvailable()) {
            const setting = createVariableDefaultValueField(plugin, containerElement, variable.getFullName(), variable, targetObject);
            // Documentation link
            if (!(variable instanceof CustomVariable)) {
                setting.addExtraButton(extraButton => extraButton
                    .setIcon("help")
                    .setTooltip("Documentation: " + variable.getFullName() + " variable")
                    .onClick(() => gotoURL(variable.getDocumentationLink())));
            }
        }
    }
}
/**
 *
 * @param plugin
 * @param containerElement
 * @param settingName
 * @param variable The variable whose default value will be configured by the created setting field.
 * @param targetObject In which object's configuration the default value settings should be stored. Can be a TShellCommand or a Variable (either CustomVariable or a built-in one).
 */
function createVariableDefaultValueField(plugin, containerElement, settingName, variable, targetObject) {
    if (undefined === targetObject) {
        // No configuration target is defined, so use the variable as a target.
        targetObject = variable;
    }
    const targetType = targetObject instanceof TShellCommand
        ? 'tShellCommand'
        : targetObject instanceof CustomVariable
            ? 'customVariable'
            : 'builtinVariable';
    if ("customVariable" === targetType || "builtinVariable" === targetType) {
        if (targetObject !== variable) {
            throw new Error("If defining 'targetObject' argument as a Variable, it should be the same as the 'variable' argument.");
        }
    }
    // Get an identifier for a variable (an id, if it's a CustomVariable, otherwise the variable's name).
    const variableIdentifier = variable.getIdentifier();
    // If a default value has been defined for this variable (and this targetObject), retrieve the configuration.
    let defaultValueConfiguration;
    switch (targetType) {
        case "tShellCommand":
            defaultValueConfiguration = targetObject.getDefaultValueConfigurationForVariable(variable, false);
            break;
        case "builtinVariable": // Both classes have...
        case "customVariable": // ... the getGlobalDefaultValueConfiguration() method.
            defaultValueConfiguration = targetObject.getGlobalDefaultValueConfiguration();
            break;
    }
    // A function for creating configuration in onChange() callbacks if the variable does not yet have one for this configuration.
    const createDefaultValueConfiguration = () => {
        const configuration = {
            type: "show-errors",
            value: "",
        };
        // Store the configuration to the target object's configuration.
        switch (targetType) {
            case "tShellCommand":
                targetObject.getConfiguration().variable_default_values[variableIdentifier] = configuration;
                break;
            case "builtinVariable":
                if (undefined === plugin.settings.builtin_variables[variableIdentifier]) {
                    // Create a config object for this variable if it does not exist yet.
                    plugin.settings.builtin_variables[variableIdentifier] = { default_value: null };
                }
                plugin.settings.builtin_variables[variableIdentifier].default_value = configuration;
                break;
            case "customVariable":
                targetObject.getConfiguration().default_value = configuration;
                break;
        }
        return configuration;
    };
    let textareaComponent;
    // A function for updating textareaComponent visibility.
    const updateTextareaComponentVisibility = (type) => {
        if ("value" === type) {
            textareaComponent.inputEl.removeClass("SC-hide");
        }
        else {
            textareaComponent.inputEl.addClass("SC-hide");
        }
    };
    // Define a set of options for default value type
    const defaultValueTypeOptions = {
        "inherit": "",
        "show-errors": "Cancel execution and show errors",
        "cancel-silently": "Cancel execution silently",
        "value": "Execute with value:",
    };
    switch (targetType) {
        case "tShellCommand": {
            // Shell commands can have the "inherit" type.
            const globalDefaultValueConfiguration = variable.getGlobalDefaultValueConfiguration();
            const globalDefaultValueType = globalDefaultValueConfiguration ? globalDefaultValueConfiguration.type : "show-errors";
            defaultValueTypeOptions.inherit = "Inherit: " + defaultValueTypeOptions[globalDefaultValueType];
            if ("value" === globalDefaultValueType) {
                defaultValueTypeOptions.inherit += " " + globalDefaultValueConfiguration?.value;
            }
            break;
        }
        case "builtinVariable":
        case "customVariable": {
            // Variables do not have the "inherit" type.
            // @ts-ignore Don't yell about removing a non-optional property "inherit".
            delete defaultValueTypeOptions.inherit;
        }
    }
    // Create the default value setting
    const defaultValueSetting = new obsidian.Setting(containerElement)
        .setName(settingName)
        .setDesc("If not available, then:")
        .setTooltip(variable.getAvailabilityTextPlain())
        .addDropdown(dropdown => dropdown
        .addOptions(defaultValueTypeOptions)
        .setValue(defaultValueConfiguration
        ? defaultValueConfiguration.type
        : "tShellCommand" === targetType
            ? "inherit" // If configuring a TShellCommand, then default config type should be "inherit".
            : "show-errors" // If configuring a Variable, then default config type should be "show-errors", because "inherit" is not available.
    )
        .onChange(async (newType) => {
        if (!defaultValueConfiguration) {
            defaultValueConfiguration = createDefaultValueConfiguration();
        }
        // Set the new type
        defaultValueConfiguration.type = newType;
        if (targetType === "tShellCommand") {
            // Shell commands:
            if ("inherit" === newType && defaultValueConfiguration.value === "") {
                // If "inherit" is selected and no text value is typed, the configuration file can be cleaned up by removing this configuration object completely.
                // Prevent deleting, if a text value is present, because the user might want to keep it if they will later change 'type' to 'value'.
                delete targetObject.getConfiguration().variable_default_values[variableIdentifier];
            }
        }
        else {
            // Variables:
            if ("show-errors" === newType && defaultValueConfiguration.value === "") {
                // If "show-errors" is selected and no text value is typed, the configuration file can be cleaned up by removing this configuration object completely.
                // Prevent deleting, if a text value is present, because the user might want to keep it if they will later change 'type' to 'value'.
                switch (targetType) {
                    case "builtinVariable":
                        plugin.settings.builtin_variables[variableIdentifier].default_value = null;
                        break;
                    case "customVariable":
                        targetObject.getConfiguration().default_value = null;
                        break;
                }
            }
        }
        // Show/hide the textarea
        updateTextareaComponentVisibility(newType);
        // Save the settings
        await plugin.saveSettings();
    }))
        .addTextArea(textarea => textareaComponent = textarea
        .setValue(defaultValueConfiguration ? defaultValueConfiguration.value : "")
        .onChange(async (newValue) => {
        if (!defaultValueConfiguration) {
            defaultValueConfiguration = createDefaultValueConfiguration();
        }
        // Set the new text value
        defaultValueConfiguration.value = newValue;
        // Save the settings
        await plugin.saveSettings();
    }).then((textareaComponent) => {
        // Autocomplete for the textarea.
        if (plugin.settings.show_autocomplete_menu) {
            createAutocomplete(plugin, textareaComponent.inputEl, () => textareaComponent.onChanged());
        }
    }));
    updateTextareaComponentVisibility(defaultValueConfiguration
        ? defaultValueConfiguration.type
        : targetType === "tShellCommand"
            ? "show-errors" // It does not really matter if passing "show-errors" ....
            : "inherit");
    return defaultValueSetting;
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class CustomVariableModel extends Model {
    constructor() {
        super(...arguments);
        this.custom_variable_instances = new CustomVariableInstanceMap;
    }
    getSingularName() {
        return "Custom variable";
    }
    defineParentConfigurationRelation(custom_variable_instance) {
        debugLog(`CustomVariableModel: Defining parent configuration relation for CustomVariableInstance ${custom_variable_instance.getID()}.`);
        return {
            type: "one-to-many-id",
            key: "custom_variables",
            id: custom_variable_instance.getID(),
        };
    }
    loadInstances(parent_configuration) {
        debugLog(`CustomVariableModel: Loading CustomVariableInstances.`);
        this.custom_variable_instances.clear();
        parent_configuration.custom_variables.forEach((custom_variable_configuration) => {
            this.custom_variable_instances.set(custom_variable_configuration.id, new CustomVariableInstance(this, custom_variable_configuration, parent_configuration));
        });
        return this.custom_variable_instances;
    }
    newInstance(parent_configuration) {
        debugLog(`CustomVariableModel: Creating a new CustomVariableInstance.`);
        // Create a default configuration object
        const custom_variable_configuration = this.getDefaultConfiguration();
        parent_configuration.custom_variables.push(custom_variable_configuration);
        // Create a CustomVariableInstance for handling the configuration
        const custom_variable_instance = new CustomVariableInstance(this, custom_variable_configuration, parent_configuration);
        this.custom_variable_instances.set(custom_variable_configuration.id, custom_variable_instance);
        // Create an operational variable.
        this.plugin.getVariables().add(custom_variable_instance.createCustomVariable());
        return custom_variable_instance;
        // TODO: Move this logic to the base Model class.
    }
    _createSettingFields(instance, container_element) {
        debugLog(`CustomVariableModel: Creating setting fields for CustomVariableInstance ${instance.getID()}.`);
        // Make the fields appear closer together.
        container_element.addClass("SC-setting-group");
        // Heading setting
        const heading_setting = new obsidian.Setting(container_element)
            .setName(instance.getFullName())
            .setHeading();
        // Name setting
        new obsidian.Setting(container_element)
            .setName("Variable name")
            .setDesc("Must contain at least one character. Allowed characters are letters a-z, numbers 0-9 and an underscore _")
            .setClass("SC-custom-variable-name-setting")
            .addText(text => text
            .setValue(instance.configuration.name)
            .onChange((new_name) => {
            // TODO: Find a way to create this kind of trivial onChange() functions in the Model base class.
            instance.setIfValid("name", new_name).then(async () => {
                // Valid
                heading_setting.setName(instance.getFullName()); // Also removes a possible warning message.
                instance.getCustomVariable().updateProperties(); // Update the name also to the operational variable, not only in configuration.
                await this.plugin.saveSettings();
                await this.plugin.updateCustomVariableViews();
            }, (reason) => {
                // Not valid
                if (typeof reason === "string") {
                    // This is a validation error message.
                    // Display a warning message.
                    heading_setting.setName(reason + " The name was not saved.");
                }
                else {
                    // Some other runtime error has occurred.
                    throw reason;
                }
            });
        }));
        // Description setting
        new obsidian.Setting(container_element)
            .setName("Description")
            .setDesc("Appears in autocomplete lists along with the variable name, and also in the 'Custom variables' pane, if you use it.")
            .addText(text => text
            .setValue(instance.configuration.description)
            .onChange(async (new_description) => {
            // TODO: Find a way to create this kind of trivial onChange() functions in the Model base class.
            instance.configuration.description = new_description;
            instance.getCustomVariable().updateProperties(); // Update the description also to the operational variable, not only in configuration.
            await this.plugin.saveSettings();
            await this.plugin.updateCustomVariableViews();
        }));
        // Default value setting
        createVariableDefaultValueField(this.plugin, container_element, "Default value", instance.getCustomVariable());
        return heading_setting;
    }
    validateValue(custom_variable_instance, field, custom_variable_name) {
        debugLog(`CustomVariableModel: Validating ${field} value ${custom_variable_name} for CustomVariableInstance ${custom_variable_instance.getID()}.`);
        return new Promise((resolve, reject) => {
            switch (field) {
                case "name":
                    // Check that the name contains only characters a-z, 0-9 and/or underline _
                    if (!custom_variable_name.match(/^[\w\d]+$/u)) {
                        // Incorrect format.
                        reject(`The name {{_${custom_variable_name}}} does not meet the naming requirements.`);
                        return;
                    }
                    // Check if the name is a duplicate.
                    if (this.isCustomVariableNameDuplicate(custom_variable_name, custom_variable_instance)) {
                        // It's a duplicate.
                        reject(`The name {{_${custom_variable_name}}} is already reserved.`);
                    }
                    else {
                        // It's unique.
                        resolve();
                    }
                    return;
                default:
                    // Other fields do not need validation.
                    resolve();
                    return;
            }
        });
    }
    getDefaultConfiguration() {
        // Generate a unique name for the variable by using a sequential number.
        let sequential_number = 1;
        while (this.isCustomVariableNameDuplicate(String(sequential_number))) {
            sequential_number++;
        }
        // Create a configuration object.
        return {
            id: getIDGenerator().generateID(),
            name: String(sequential_number),
            description: "",
            default_value: null,
        };
    }
    async _deleteInstance(custom_variable_instance) {
        debugLog(`CustomVariableModel: Deleting CustomVariableInstance ${custom_variable_instance.getID()}.`);
        // Remove the CustomVariableInstance from all PromptFields that use it.
        for (const prompt of this.plugin.getPrompts().values()) {
            for (const prompt_field of prompt.prompt_fields) {
                if (custom_variable_instance.getID() === prompt_field.configuration.target_variable_id) {
                    // This prompt field uses this CustomVariableInstance.
                    // Remove the variable from use.
                    prompt_field.configuration.target_variable_id = "";
                    // Saving is done later, after the _deleteInstance() call.
                }
            }
        }
        // Delete CustomVariable
        try {
            this.plugin.getVariables().delete(custom_variable_instance.getCustomVariable());
        }
        catch (error) {
            // If custom_variable_instance.getCustomVariable() failed, no need to do anything. It just means there is no CustomVariable, so there's nothing to delete.
        }
        // Delete CustomVariableInstance
        this.custom_variable_instances.delete(custom_variable_instance.getID());
        // remove the variable from custom variable side panes.
        await this.plugin.updateCustomVariableViews();
    }
    /**
     * Can be changed to public if needed.
     */
    isCustomVariableNameDuplicate(custom_variable_name, ignore_custom_variable_instance) {
        let is_duplicate = false;
        this.custom_variable_instances.forEach((custom_variable2_instance, custom_variable_id) => {
            // First check can the current custom variable attend to the duplicate test.
            if (ignore_custom_variable_instance && custom_variable_id === ignore_custom_variable_instance.getID()) {
                // Don't check this instance. This skipping is used for the current owner of the name.
                return;
            }
            // Now do the actual duplicate test.
            if (custom_variable_name.toLocaleLowerCase() === custom_variable2_instance.configuration.name.toLocaleLowerCase()) {
                is_duplicate = true;
            }
        });
        return is_duplicate;
    }
}
class CustomVariableInstanceMap extends Map {
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class CustomVariableSettingsModal extends SC_Modal {
    constructor(plugin, custom_variable_instance, on_after_creation, on_after_cancelling) {
        super(plugin);
        this.custom_variable_instance = custom_variable_instance;
        this.on_after_creation = on_after_creation;
        this.on_after_cancelling = on_after_cancelling;
        this.created = false;
    }
    onOpen() {
        super.onOpen();
        const model = getModel(CustomVariableModel.name);
        model.createSettingFields(this.custom_variable_instance, this.modalEl, false);
        new obsidian.Setting(this.modalEl)
            .addButton(button => button
            .setButtonText("Create")
            .onClick(() => this.approve()));
    }
    approve() {
        this.created = true;
        this.on_after_creation();
        this.close();
    }
    onClose() {
        super.onClose();
        if (!this.created) {
            this.on_after_cancelling();
        }
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class CustomVariableView extends obsidian.ItemView {
    constructor(plugin, leaf) {
        super(leaf);
        this.plugin = plugin;
    }
    getDisplayText() {
        return "Custom variables";
    }
    getViewType() {
        return CustomVariableView.ViewType;
    }
    getIcon() {
        return "code-glyph";
    }
    async onOpen() {
        this.container_element = this.containerEl.children[1].createDiv(); // I don't know why I cannot create elements directly under this.containerEl (they wouldn't show up). I did the same thing as was done here: https://marcus.se.net/obsidian-plugin-docs/guides/custom-views (referenced 2022-03-23).
        this.container_element.addClass("container");
        await this.updateContent();
    }
    async updateContent() {
        this.container_element.empty();
        this.container_element.createEl("h3", { text: "Custom variables" });
        const variableListElement = this.container_element.createEl("ul");
        for (const customVariableInstance of this.plugin.getCustomVariableInstances().values()) {
            let customVariableValue = (await customVariableInstance.getCustomVariable().getValue()).value;
            let customVariableState = null;
            if (null === customVariableValue) {
                // The variable has no value yet.
                if ("value" === customVariableInstance.configuration.default_value?.type) {
                    // Indicate that the variable has a default value defined, which will practically be used as long as no overriding value is set.
                    if ("" === customVariableInstance.configuration.default_value.value.trim()) {
                        customVariableState = "No value yet, but defaults to: An empty text.";
                    }
                    else {
                        customVariableState = "No value yet, but defaults to: "; // The value will appear next to the state text later below.
                        customVariableValue = customVariableInstance.configuration.default_value.value;
                    }
                }
                else {
                    // No default value is defined, so no value is accessible.
                    customVariableState = "No value yet.";
                }
            }
            else if ("" === customVariableValue) {
                customVariableState = "An empty text.";
            }
            const variableListItemElement = variableListElement.createEl("li", {
                text: customVariableInstance.getFullName(),
                attr: {
                    "aria-label": customVariableInstance.configuration.description,
                    "class": "SC-custom-variable-view-list-item",
                },
            });
            variableListItemElement.createEl("br");
            if (null !== customVariableState) {
                variableListItemElement.createEl("em").insertAdjacentText("beforeend", customVariableState);
            }
            if (null !== customVariableValue) {
                // Bold normal values to make them more prominent in contrast to variable names and "No value yet."/"An empty text." texts.
                variableListItemElement.createEl("strong").insertAdjacentText("beforeend", customVariableValue);
            }
        }
    }
}
CustomVariableView.ViewType = "SC-custom-variables-view";

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class Preaction {
    constructor(plugin, configuration, t_shell_command) {
        this.plugin = plugin;
        this.configuration = configuration;
        this.t_shell_command = t_shell_command;
    }
    /**
     * Maybe this wrapper method is unneeded, but have it for a while at least.
     */
    perform(parsing_process, sc_event) {
        return this.doPreaction(parsing_process, sc_event);
    }
    /**
     * Returns variables that are dependent of this Preaction, i.e. variables whose value is set by this Preaction.
     * If a variable is READ by a Preaction, it is NOT considered to be _dependent_ of the Preaction, as long as the variable's
     * value is not changed by the Preaction.
     *
     * By default, it returns an empty VariableSet, because not all Preactions will use variables at all.
     */
    getDependentVariables() {
        return new VariableSet();
    }
}
function createPreaction(plugin, preaction_configuration, t_shell_command) {
    switch (preaction_configuration.type) {
        case "prompt":
            return new Preaction_Prompt(plugin, preaction_configuration, t_shell_command);
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class Preaction_Prompt extends Preaction {
    constructor(plugin, configuration, t_shell_command) {
        super(plugin, configuration, t_shell_command);
        this.configuration = configuration;
    }
    doPreaction(parsing_process, sc_event) {
        // TODO: Now that doPreaction() returns a similar Promise as is received from openPrompt(), consider just returning the same Promise instead of creating a new one.
        return new Promise((resolve) => {
            this.getPrompt().openPrompt(this.t_shell_command, parsing_process, sc_event).then((execution_confirmed) => {
                // The PromptModal has been closed.
                // Check if user wanted to execute the shell command or cancel.
                if (execution_confirmed) {
                    // User wants to execute.
                    resolve(true);
                }
                else {
                    // User wants to cancel.
                    resolve(false);
                }
            });
        });
    }
    /**
     * Returns all the CustomVariables whose values this Preaction's Prompt sets.
     */
    getDependentVariables() {
        const variables = new VariableSet();
        for (const prompt_field of this.getPrompt().prompt_fields) {
            // Check that the PromptField has a target variable defined. Otherwise getTargetVariable() would cause a crash.
            if ("" !== prompt_field.configuration.target_variable_id) {
                variables.add(prompt_field.getTargetVariable());
            }
        }
        return variables;
    }
    /**
     * TODO: Remove.
     */
    getDefaultConfiguration() {
        return {
            type: "prompt",
            enabled: false,
            prompt_id: "",
        };
    }
    getPrompt() {
        const promptId = this.configuration.prompt_id;
        if (undefined === promptId) {
            throw new Error("Prompt id is undefined in configuration.");
        }
        const prompt = this.plugin.getPrompts().get(promptId);
        if (undefined === prompt) {
            throw new Error("Prompt with id '" + promptId + "' does not exist");
        }
        return prompt;
    }
}
function getDefaultPreaction_Prompt_Configuration() {
    return {
        type: "prompt",
        enabled: false,
        prompt_id: "",
    };
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class PromptField extends Instance {
    constructor(model, prompt, configuration, prompt_field_index) {
        super(model, configuration, prompt.configuration);
        this.model = model;
        this.prompt = prompt;
        this.configuration = configuration;
        this.prompt_field_index = prompt_field_index;
        this.parsing_errors = [];
    }
    /**
     *
     * @param container_element
     * @param t_shell_command
     * @param sc_event Used when parsing variables for default_value and the inputted value. Needed so that also {{event_*}} variables can be used in prompts.
     */
    async createField(container_element, t_shell_command, sc_event) {
        await this._createField(container_element, t_shell_command, sc_event);
        // Create a preview setting element. It will not contain any actual setting elements, just text.
        this.preview_setting = new obsidian.Setting(container_element);
        // Parse variables in the default value and insert it to the field.
        // Note that this is a different "default value" than what TShellCommand considers as variables' default values! This is about a _field's_ default value, not a variable's default value. t_shell_command is passed in order to allow any possible variables in the field's default value to access the variables' default values (which come from TShellCommand).
        await this.applyDefaultValue(t_shell_command, sc_event);
    }
    getTitle() {
        return this.configuration.label === "" ? "Unlabelled field" : this.configuration.label;
    }
    /**
     * Parses the default value and sets it to the form element.
     * @param t_shell_command
     * @param sc_event
     * @private
     */
    async applyDefaultValue(t_shell_command, sc_event) {
        const default_value = this.configuration.default_value;
        const parsing_result = await parseVariables(this.prompt.model.plugin, default_value, null, t_shell_command, sc_event);
        if (!parsing_result.succeeded) {
            // Parsing failed.
            this.setValue(default_value); // Use the unparsed value. If default value contains a variable that cannot be parsed, a user can see the variable in the prompt modal and either fix it or change it to something else.
        }
        else {
            // Parsing succeeded.
            this.setValue(parsing_result.parsed_content);
        }
        await this.valueHasChanged(t_shell_command, sc_event);
    }
    getParsedValue() {
        return this.parsed_value;
    }
    /**
     * Tries to get a parsed value, but if it's not available (probably due to incorrect usage of variables), returns an
     * unparsed value instead().
     */
    getParsedOrRawValue() {
        return this.parsed_value ?? this.getValue();
    }
    getParsingErrors() {
        return this.parsing_errors;
    }
    /**
     * Updates this.parsed_value, this.parsing_errors and this.preview_setting .
     *
     * @param t_shell_command
     * @param sc_event
     * @protected
     */
    async valueHasChanged(t_shell_command, sc_event) {
        let preview;
        // Parse variables in the value.
        const parsing_result = await parseVariables(this.prompt.model.plugin, this.getValue(), null, t_shell_command, sc_event);
        if (!parsing_result.succeeded) {
            // Parsing failed.
            this.parsed_value = null;
            if (parsing_result.error_messages.length > 0) {
                // Display the first error message. If there are more, others can be omitted.
                preview = parsing_result.error_messages[0];
            }
            else {
                // If there are no error messages, then errors are silently ignored by user's variable configuration, in which case just show the original content.
                preview = parsing_result.original_content;
            }
            this.parsing_errors = parsing_result.error_messages;
        }
        else {
            // Parsing succeeded
            this.parsed_value = parsing_result.parsed_content;
            preview = parsing_result.parsed_content;
            this.parsing_errors = []; // No errors.
        }
        // Update the preview element.
        if (0 === parsing_result.count_parsed_variables) {
            // If no variables were used, hide the description as it's not needed to repeat the value that already shows up in the form field.
            preview = "";
        }
        this.preview_setting.setDesc(preview);
        // Call a possible external callback
        if (this.on_change_callback) {
            this.on_change_callback();
        }
    }
    /**
     * @param on_change_callback A callback that will be called whenever the field's value is changed.
     */
    onChange(on_change_callback) {
        this.on_change_callback = on_change_callback;
    }
    /**
     * @param on_focus_callback A callback that will be called whenever the field is focused.
     */
    onFocus(on_focus_callback) {
        this.on_focus_callback = on_focus_callback;
    }
    /**
     * Should be called by the subclass when the field has gotten focus.
     */
    hasGottenFocus() {
        if (this.on_focus_callback) {
            this.on_focus_callback(this);
        }
    }
    /**
     * Ensures that the field is filled, if it's mandatory. If the field is not mandatory, it's always valid.
     *
     * @return True when valid, false when not valid.
     */
    validate() {
        if (!this.configuration.required) {
            // No need to validate, because the field is not mandatory.
            return true;
        }
        // Ensure the field is filled
        return this.isFilled();
    }
    getTargetVariableInstance() {
        const target_variable_id = this.configuration.target_variable_id;
        const custom_variable_instance = this.prompt.model.plugin.getCustomVariableInstances().get(target_variable_id);
        if (!custom_variable_instance) {
            throw new Error(this.constructor.name + ".getTargetVariableInstance(): CustomVariableInstance with ID '" + target_variable_id + "' was not found");
        }
        return custom_variable_instance;
    }
    getTargetVariable() {
        const custom_variable_instance = this.getTargetVariableInstance();
        return custom_variable_instance.getCustomVariable();
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class PromptFieldModel extends Model {
    getSingularName() {
        return "Field";
    }
    defineParentConfigurationRelation(prompt_field) {
        return {
            type: "one-to-many-index",
            key: "fields",
            index: prompt_field.prompt_field_index,
        };
    }
    loadInstances(prompt) {
        const prompt_fields = new PromptFieldSet;
        prompt.configuration.fields.forEach((field_configuration, index) => {
            prompt_fields.add(this.createInstance(prompt, field_configuration, index));
        });
        return prompt_fields;
    }
    newInstance(prompt) {
        // TODO: Move this logic to the base Model class.
        // Setup a default configuration
        const prompt_field_configuration = this.getDefaultConfiguration();
        // Instantiate a PromptField
        const prompt_field = this.createInstance(prompt, prompt_field_configuration, prompt.configuration.fields.length);
        // Store the configuration into the prompt's configuration
        prompt.configuration.fields.push(prompt_field_configuration);
        // Store the PromptField instance into its parent Prompt's list of fields.
        prompt.prompt_fields.add(prompt_field);
        // Return the PromptField
        return prompt_field;
    }
    createInstance(prompt, prompt_field_configuration, prompt_field_index) {
        // TODO: When the 'type' field gets implemented on PromptFieldConfiguration, implement some kind of switch structure here to create different types of PromptFields.
        return new PromptField_Text(this, prompt, prompt_field_configuration, prompt_field_index);
    }
    _createSettingFields(prompt_field, container_element) {
        const label_placeholders = [
            "What is your name?",
            "How big is the universe?",
            "How long is eternity?",
            "What is your lucky number?",
            "What is your favorite song?",
            "What is your favorite color?",
            "How many books have you read?",
            "What is the purpose of life?",
        ];
        const default_value_placeholders = [
            ["Bond, James Bond", "John Doe", "Jane Doe", "Mr. Bean"],
            ["Very big, and still expanding", "93 billion light-years"],
            ["Infinite", "Too long to wait for"],
            [String(randomInteger(0, 9)), "I don't have one"],
            ["We are the world (USA for Africa)", "Heal the world (Michael Jackson)", "Imagine (John Lennon)", "Circle of life (Elton John)"],
            ["Blue as deep as an ocean", "Red as love", "Grass-green", "Snow-white"],
            ["Thousands", "Many", "Countless", "None"],
            ["Thinking", "Being a being", "42"],
        ];
        const label_placeholder_index = randomInteger(0, label_placeholders.length - 1);
        const default_value_placeholders_subset = default_value_placeholders[label_placeholder_index];
        // Create a list of custom variables
        const custom_variable_options = {};
        this.plugin.getCustomVariableInstances().forEach((custom_variable_instance, custom_variable_id) => {
            custom_variable_options[custom_variable_id] = custom_variable_instance.getFullName();
        });
        const on_default_value_setting_change = async (new_default_value) => {
            prompt_field.configuration.default_value = new_default_value;
            await this.plugin.saveSettings();
        };
        // Create the setting fields
        const setting_group_element = container_element.createDiv({ attr: { class: "SC-setting-group" } });
        let label_setting_component;
        let description_setting_component;
        const setting_group = {
            heading_setting: new obsidian.Setting(setting_group_element)
                .setName("") // This will be set down below.
                .setHeading(),
            label_setting: new obsidian.Setting(setting_group_element)
                .setName("Field label")
                .addText(text => label_setting_component = text
                .setValue(prompt_field.configuration.label)
                .setPlaceholder(label_placeholders[label_placeholder_index])
                .onChange(async (new_label) => {
                prompt_field.configuration.label = new_label;
                _update_heading();
                await this.plugin.saveSettings();
            })),
            default_value_setting: new obsidian.Setting(setting_group_element)
                .setName("Default value")
                .addText(text => text
                .setValue(prompt_field.configuration.default_value)
                .setPlaceholder(prompt_field.configuration.label ? "" // If the label is defined, do not add a placeholder here, as the label's placeholder is not visible, so this placeholder would not make sense.
                : default_value_placeholders_subset[randomInteger(0, default_value_placeholders_subset.length - 1)])
                .onChange(on_default_value_setting_change)),
            description_setting: new obsidian.Setting(setting_group_element)
                .setName("Description")
                .addText(text => description_setting_component = text
                .setValue(prompt_field.configuration.description)
                .onChange(async (new_description) => {
                prompt_field.configuration.description = new_description;
                await this.plugin.saveSettings();
            })),
            target_variable_setting: new obsidian.Setting(setting_group_element)
                .setName("Target variable")
                .setDesc("Where the inputted value will be stored in. You can use the variable in a shell command.")
                .addDropdown(dropdown => dropdown
                .addOption("", "") // An option for a situation when nothing is selected.
                .addOptions(custom_variable_options)
                .addOption("new", "Create a new custom variable")
                .setValue(prompt_field.configuration.target_variable_id)
                .onChange((new_target_variable_id) => {
                if ("new" === new_target_variable_id) {
                    // Create a new custom variable.
                    const model = getModel(CustomVariableModel.name);
                    const custom_variable_instance = model.newInstance(this.plugin.settings);
                    this.plugin.saveSettings().then(() => {
                        const modal = new CustomVariableSettingsModal(this.plugin, custom_variable_instance, async () => {
                            // Variable is created.
                            dropdown.addOption(custom_variable_instance.getID(), custom_variable_instance.getTitle());
                            dropdown.setValue(custom_variable_instance.getID());
                            prompt_field.configuration.target_variable_id = custom_variable_instance.getID();
                            await this.plugin.saveSettings();
                        }, async () => {
                            dropdown.setValue(prompt_field.configuration.target_variable_id); // Reset the dropdown selection.
                            // Variable creation was cancelled.
                            model.deleteInstance(custom_variable_instance);
                            await this.plugin.saveSettings();
                        });
                        modal.open();
                    });
                }
                else {
                    // Use an existing target variable (or an empty id "").
                    // Check that this target variable is not reserved.
                    prompt_field.setIfValid("target_variable_id", new_target_variable_id).then(async () => {
                        // It can be used.
                        await this.plugin.saveSettings();
                    }, (error_message) => {
                        if (typeof error_message === "string") {
                            // This is a validation error message.
                            // The target variable is reserved.
                            dropdown.setValue(prompt_field.configuration.target_variable_id); // Reset the dropdown selection.
                            this.plugin.newNotification(error_message);
                        }
                        else {
                            // Some other runtime error has occurred.
                            throw error_message;
                        }
                    });
                }
            })),
            required_setting: new obsidian.Setting(setting_group_element)
                .setName("Is required")
                .setDesc("If on, the field needs to be filled before the prompt can be submitted.")
                .addToggle(toggle => toggle
                .setValue(prompt_field.configuration.required)
                .onChange(async (new_required) => {
                prompt_field.configuration.required = new_required;
                await this.plugin.saveSettings();
            })),
        };
        _update_heading();
        function _update_heading() {
            setting_group.heading_setting.setName(prompt_field.getTitle());
        }
        // Autocomplete menu
        if (this.plugin.settings.show_autocomplete_menu) {
            // Show autocomplete menu (= a list of available variables).
            const label_input_element = setting_group.label_setting.controlEl.find("input");
            createAutocomplete(this.plugin, label_input_element, () => label_setting_component.onChanged());
            const default_value_input_element = setting_group.default_value_setting.controlEl.find("input");
            createAutocomplete(this.plugin, default_value_input_element, on_default_value_setting_change);
            const description_input_element = setting_group.description_setting.controlEl.find("input");
            createAutocomplete(this.plugin, description_input_element, () => description_setting_component.onChanged());
        }
        return setting_group.heading_setting;
    }
    validateValue(prompt_field, field, value) {
        switch (field) {
            case "target_variable_id": {
                const new_target_variable_id = value; // A more descriptive name for 'value'.
                // Always allow an empty target_variable_id. A Prompt cannot be opened if a field lacks a target_variable_id, but it's allowed to be stored in the configuration, because new Prompts cannot have a default selected target variable.
                if ("" === new_target_variable_id) {
                    return Promise.resolve();
                }
                // Check that the target variable is not used by other fields of the same Prompt.
                for (const other_prompt_field of prompt_field.prompt.prompt_fields) {
                    if (prompt_field !== other_prompt_field) { // Do not check the same field. Only check other fields.
                        // Check if this other field has the same target variable.
                        if (new_target_variable_id === other_prompt_field.configuration.target_variable_id) {
                            // They have the same target_variable_id.
                            // Return an error message.
                            const targetVariableInstance = this.plugin.getCustomVariableInstances().get(new_target_variable_id);
                            if (undefined === targetVariableInstance) {
                                throw new Error("Could not find target variable with id " + new_target_variable_id);
                            }
                            const target_variable_name = targetVariableInstance.getFullName();
                            return Promise.reject(`Target variable ${target_variable_name} is already used by another field in the same prompt. Select another variable.`);
                        }
                    }
                }
                // All fields have been checked and no collisions were found.
                return Promise.resolve();
            }
            default: {
                // No validation for other fields.
                throw new Error(this.constructor.name + ".validateValue(): No validation is implemented for other fields.");
            }
        }
    }
    getDefaultConfiguration() {
        return {
            // type: "text",
            label: "",
            description: "",
            default_value: "",
            //  TODO: Add 'placeholder'.
            target_variable_id: "",
            required: true,
        };
    }
    _deleteInstance(prompt_field) {
        prompt_field.prompt.prompt_fields.delete(prompt_field);
    }
}
class PromptFieldSet extends Set {
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class PromptField_Text extends PromptField {
    async _createField(container_element, t_shell_command, sc_event) {
        const plugin = this.prompt.model.plugin;
        // Create the field
        const on_change = () => this.valueHasChanged(t_shell_command, sc_event);
        const label_parsing_result = await parseVariables(this.prompt.model.plugin, this.configuration.label, null, t_shell_command, sc_event);
        const description_parsing_result = await parseVariables(this.prompt.model.plugin, this.configuration.description, null, t_shell_command, sc_event);
        const setting = new obsidian.Setting(container_element)
            .setName(label_parsing_result.succeeded ? label_parsing_result.parsed_content : label_parsing_result.original_content)
            .setDesc(description_parsing_result.succeeded ? description_parsing_result.parsed_content : description_parsing_result.original_content)
            .addText((text_component) => {
            this.text_component = text_component;
            text_component.onChange(on_change);
        });
        // Set up onFocus hook.
        this.text_component.inputEl.onfocus = () => {
            this.hasGottenFocus();
        };
        // Show autocomplete menu (if enabled)
        if (plugin.settings.show_autocomplete_menu) {
            const input_element = setting.controlEl.find("input");
            createAutocomplete(plugin, input_element, on_change);
        }
    }
    setValue(value) {
        this.text_component.setValue(value);
    }
    getValue() {
        return this.text_component.getValue();
    }
    setFocus() {
        this.text_component.inputEl.focus();
    }
    isFilled() {
        return this.getValue().length > 0;
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class Prompt extends Instance {
    constructor(model, plugin, configuration, parent_configuration) {
        super(model, configuration, parent_configuration);
        this.model = model;
        this.plugin = plugin;
        this.configuration = configuration;
        this.parent_configuration = parent_configuration;
        this.prompt_fields = new PromptFieldSet();
        // Introduce the ID to an ID generator so that it won't accidentally generate the same ID again when creating new Prompts.
        getIDGenerator().addReservedID(configuration.id);
        this.createFields();
    }
    getID() {
        return this.configuration.id;
    }
    getTitle() {
        return this.configuration.title;
    }
    getConfiguration() {
        return this.configuration;
    }
    getCSSClass() {
        return Prompt.getCSSBaseClass() + "-" + this.getID();
    }
    static getCSSBaseClass() {
        return "SC-prompt-modal";
    }
    getCSSClasses() {
        return [
            Prompt.getCSSBaseClass(),
            this.getCSSClass(),
        ];
    }
    /**
     * @param t_shell_command Can be null, if wanted to just preview the Prompt modal without really executing a shell command. Inputted values will still be assigned to target variables.
     * @param parsing_process
     * @param sc_event
     * @return Promise The boolean value tells whether the user wants to execute a shell command (true) or cancel (false).
     */
    openPrompt(t_shell_command, parsing_process, sc_event) {
        const can_open_prompt_result = this.canOpenPrompt();
        if (true !== can_open_prompt_result) {
            // Some error is preventing opening the prompt.
            // A human-readable error message is contained in can_open_prompt_result.
            debugLog("Could not open Prompt " + this.getID() + " because of error: " + can_open_prompt_result);
            this.plugin.newError(can_open_prompt_result);
            return Promise.resolve(false); // false: Cancel execution (pretends that a user cancelled it, but it's ok).
        }
        debugLog("Opening Prompt " + this.getID());
        const modal = new PromptModal(this.plugin, this.prompt_fields, t_shell_command, parsing_process, this, sc_event, () => { return this.validateFields(); });
        modal.open();
        return modal.promise;
    }
    canOpenPrompt() {
        // Check that all PromptFields have a target variable defined.
        for (const prompt_field of this.prompt_fields) {
            if (!prompt_field.configuration.target_variable_id) {
                return `Cannot open prompt '${this.getTitle()}': Field '${prompt_field.getTitle()}' does not have a target variable.`;
            }
            else {
                try {
                    prompt_field.getTargetVariableInstance(); // Just try to get a CustomVariableInstance. No need to use it here, but if this fails, we know the variable is removed.
                }
                catch (error) {
                    return `Cannot open prompt '${this.getTitle()}': Field '${prompt_field.getTitle()}' uses a target variable which does not exist anymore.`;
                }
            }
        }
        // All ok.
        return true;
    }
    /**
     * Creates PromptField instances, NOT setting fields!
     */
    createFields() {
        debugLog("Creating fields for Prompt " + this.getID());
        const prompt_field_model = getModel(PromptFieldModel.name);
        this.prompt_fields = prompt_field_model.loadInstances(this);
    }
    /**
     * Validates values in PromptField instances, NOT setting fields!
     */
    validateFields() {
        debugLog("Validating fields for Prompt " + this.getID());
        // Iterate all fields and check their validity.
        const error_messages = [];
        this.prompt_fields.forEach((prompt_field) => {
            // Check if the field has parsing errors.
            const parsing_errors = prompt_field.getParsingErrors();
            for (const parsing_error of parsing_errors) {
                // This field has parsing error(s).
                error_messages.push(`'${prompt_field.getTitle()}': ` + parsing_error);
            }
            // Check other validity.
            if (!prompt_field.validate()) {
                // This field failed to validate.
                // TODO: Change this so that the message will come from prompt_field.validate().
                error_messages.push(`'${prompt_field.getTitle()}' needs to be filled.`);
            }
        });
        // Return the result.
        if (0 === error_messages.length) {
            return Promise.resolve();
        }
        else {
            return Promise.reject(error_messages);
        }
    }
    /**
     * When previewing a PromptModal, there is no real shell command available (because no shell command has triggered the
     * PromptModal). This method creates just a dummy shell command string that imitates a command that would echo variable values.
     */
    getExampleShellCommand() {
        const variable_names = [];
        for (const prompt_field of this.prompt_fields) {
            variable_names.push(prompt_field.getTargetVariableInstance().getFullName());
        }
        return "echo " + variable_names.join(" ");
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class PromptModal extends SC_Modal {
    constructor(plugin, prompt_fields, 
    /** Can be null, if wanted to just preview the Prompt modal without really executing a shell command. Inputted values will still be assigned to target variables. */
    t_shell_command, parsing_process, prompt, sc_event, 
    /** A function that is called when a user clicks the execution button. This function should check the form elements' validity and return false if there are unfilled fields. */
    validator) {
        super(plugin);
        this.prompt_fields = prompt_fields;
        this.t_shell_command = t_shell_command;
        this.parsing_process = parsing_process;
        this.prompt = prompt;
        this.sc_event = sc_event;
        this.validator = validator;
        this.user_confirmed_ok = false;
        this.promise = new Promise((resolve) => {
            this.resolve_promise = resolve;
        });
    }
    async onOpen() {
        super.onOpen();
        // Parse and display title
        const title_parsing_result = await parseVariables(this.plugin, this.prompt.getTitle(), null, this.t_shell_command, this.sc_event);
        this.setTitle(title_parsing_result.succeeded
            ? title_parsing_result.parsed_content
            : title_parsing_result.original_content);
        // Parse and display description
        if (this.prompt.configuration.description) {
            const description_parsing_result = await parseVariables(this.plugin, this.prompt.configuration.description, null, this.t_shell_command, this.sc_event);
            const description = description_parsing_result.succeeded
                ? description_parsing_result.parsed_content
                : description_parsing_result.original_content;
            const description_element = createMultilineTextElement("p", description, this.modalEl);
            description_element.addClass("setting-item-description"); // A CSS class defined by Obsidian.
        }
        // Preview the shell command (if wanted)
        // TODO: Extract to a separate method, as this is a big block of code.
        let update_shell_command_preview = null; // Stays null if .preview_shell_command is false.
        let focused_prompt_field;
        if (this.prompt.getConfiguration().preview_shell_command) {
            let shell_command_preview_text;
            if (this.t_shell_command?.getAlias()) {
                this.modalEl.createEl("p", { text: this.t_shell_command.getAlias(), attr: { class: "SC-no-margin" } });
            }
            // Create "Show variable values" toggle
            let preview_variable_values = true;
            const variable_names_visible_icon = "code-glyph";
            const variable_values_visible_glyph = "price-tag-glyph";
            const preview_variable_values_setting = new obsidian.Setting(this.modalEl)
                .addExtraButton(button => button
                .setIcon(variable_values_visible_glyph)
                .setTooltip("Toggle showing variable names or values.")
                .onClick(() => {
                preview_variable_values = !preview_variable_values;
                button.setIcon(preview_variable_values
                    ? variable_values_visible_glyph
                    : variable_names_visible_icon);
                if (null === update_shell_command_preview) {
                    throw new Error("Toggle showing variable names or value: update_shell_command_preview function is not defined.");
                }
                update_shell_command_preview();
            }));
            // Decide what text to use in the preview
            const shellCommandParsingResult = this.parsing_process?.getParsingResults().shell_command;
            if (shellCommandParsingResult?.succeeded) {
                // Show a real shell command. Use preparsed content (= content that might have some variables already parsed).
                shell_command_preview_text = shellCommandParsingResult.parsed_content; // as string = if shellCommandParsingResult?.succeeded is true, then .parsed_content is always string.
            }
            else if (this.t_shell_command) {
                // Show a real shell command. No preparsed content is available. This content does not have any variables parsed yet.
                shell_command_preview_text = this.t_shell_command.getShellCommand();
            }
            else {
                // Make up a fake "shell command" for previewing.
                shell_command_preview_text = this.prompt.getExampleShellCommand();
                this.modalEl.createEl("p", { text: "(This is not a real shell command, it's just an example for this preview when no real shell command is available.)", attr: { class: "SC-no-margin SC-small-font" } });
            }
            this.modalEl.createEl("hr");
            // A function for handling preview text updates.
            update_shell_command_preview = async () => {
                let shell_command_preview_text_final = shell_command_preview_text;
                if (preview_variable_values) {
                    // The preview should show the VALUES.
                    // Ensure the form fields do not contain any parsing errors. (If there are errors, an unparsed preview text will be shown).
                    if (this.getPromptFieldsParsingErrors().length === 0) {
                        // All fields are parsed ok (= individual parsing).
                        // Insert the field values into the shell command preview by parsing the preview text.
                        // Get current values from the prompt fields.
                        const fresh_values = this.getPromptFieldsValues(); // These PromptField values are fresh, so not yet stored in the actual variables.
                        // Parse variables in the shell command preview text.
                        const parsing_result = await parseVariables(this.plugin, shell_command_preview_text, this.getShell(), this.t_shell_command, this.sc_event, undefined, // Use all variables.
                        (variable, raw_value) => {
                            if (fresh_values.has(variable.variable_name)) {
                                // Change the value to the one in the prompt field.
                                raw_value.error_messages = []; // Remove any possible error messages.
                                raw_value.succeeded = true; // This needs to reflect that there are no error messages.
                                raw_value.value = fresh_values.get(variable.variable_name); // It's always a string because fresh_values.has() is used above.
                            }
                            // No modifications.
                        }, (variable, escaped_value) => {
                            // Emphasize the value that came from the currently focused field.
                            if (focused_prompt_field) {
                                if (variable.variable_name.toLocaleLowerCase() === focused_prompt_field.getTargetVariableInstance().getPrefixedName().toLocaleLowerCase()) {
                                    // Make the value bold.
                                    return `<strong>${escaped_value}</strong>`;
                                }
                            }
                            // No modifications.
                            return escaped_value;
                        });
                        if (parsing_result.succeeded) {
                            shell_command_preview_text_final = parsing_result.parsed_content;
                        }
                    }
                }
                else {
                    // The preview should show the VARIABLE NAMES.
                    if (focused_prompt_field) {
                        const pattern = new RegExp(focused_prompt_field.getTargetVariable().getPattern(), "igu"); // i: case-insensitive; g: match all occurrences instead of just the first one. u: support 4-byte unicode characters too.
                        shell_command_preview_text_final = shell_command_preview_text_final.replace(pattern, (replaceable_variable_name) => {
                            return "<strong>" + replaceable_variable_name + "</strong>";
                        });
                    }
                }
                preview_variable_values_setting.descEl.innerHTML = shell_command_preview_text_final;
            };
        }
        // Create fields
        let is_first_field = true;
        for (const prompt_field of this.prompt_fields) {
            await prompt_field.createField(this.modalEl.createDiv({ attr: { class: "SC-setting-group" } }), this.t_shell_command, this.sc_event);
            if (update_shell_command_preview) {
                prompt_field.onChange(update_shell_command_preview);
            }
            prompt_field.onFocus((prompt_field) => {
                focused_prompt_field = prompt_field;
                if (update_shell_command_preview) {
                    update_shell_command_preview();
                }
            });
            if (is_first_field) {
                // Focus on the first field.
                is_first_field = false;
                prompt_field.setFocus();
            }
        }
        if (update_shell_command_preview) {
            // Set a preview text. Must be done after fields are created, because their values are accessed.
            update_shell_command_preview();
        }
        // Tip about variables
        let tip = "";
        if (this.prompt_fields.size > 0) {
            // TODO: When implementing different field types, add a check that the tip is only shown when there are text/numeric fields present.
            // Only show the tip if this modal actually contains fields. Prompts can also be used as custom 'confirmation prompts' without any fields.
            tip = "Tip! You can use {{variables}} in text fields.";
        }
        // Execute button
        const execute_button_text_parsing_result = await parseVariables(this.plugin, this.prompt.configuration.execute_button_text, null, this.t_shell_command, this.sc_event);
        const execute_button_text = execute_button_text_parsing_result.succeeded
            ? execute_button_text_parsing_result.parsed_content
            : execute_button_text_parsing_result.original_content;
        new obsidian.Setting(this.modalEl)
            .setDesc(tip)
            .addButton(button => button
            .setButtonText(execute_button_text)
            .onClick(() => this.approve()));
        if (!this.t_shell_command) {
            // Notice that this is a preview only Prompt.
            this.modalEl.createEl("p", { text: `This is a preview prompt. No shell command will be executed, but clicking the '${this.prompt.configuration.execute_button_text}' button will still store the inputted value(s) to variable(s).` }).addClass("SC-prompt-dry-run-notice");
        }
        // Add CSS classes so that custom styling can be done on a per-prompt modal basis (or for all prompt modals via a common class).
        this.modalEl.addClasses(this.prompt.getCSSClasses());
    }
    approve() {
        this.validator().then(async () => {
            // The form fields are filled ok
            await this.assignValuesToVariables();
            this.resolve_promise(true);
            this.user_confirmed_ok = true;
            this.close();
        }, (error_messages) => {
            if (Array.isArray(error_messages)) {
                // There were some problems with the fields.
                this.plugin.newErrors(error_messages);
            }
            else {
                // Some other runtime error has occurred.
                throw error_messages;
            }
        });
    }
    onClose() {
        super.onClose();
        if (!this.user_confirmed_ok) { // TODO: Find out if there is a way to not use this kind of flag property. Can the status be checked from the promise itself?
            this.resolve_promise(false);
        }
    }
    async assignValuesToVariables() {
        let promptField;
        for (promptField of this.prompt_fields) {
            await promptField.getTargetVariable().setValue(promptField.getParsedOrRawValue());
        }
    }
    /**
     * Gathers a Map of variable values typed in the form, but does not store the values into the variables. Called when
     * generating a preview text, so the result of this method will not persist in any way.
     * @private
     */
    getPromptFieldsValues() {
        const values = new Map();
        for (const prompt_field of this.prompt_fields) {
            values.set(prompt_field.getTargetVariable().variable_name, prompt_field.getParsedValue() ?? ""); // TODO: Should getParsedValue() ?? "" be changed to getParsedOrRawValue(), too?
        }
        return values;
    }
    getPromptFieldsParsingErrors() {
        const parsing_errors = [];
        for (const prompt_field of this.prompt_fields) {
            parsing_errors.push(...prompt_field.getParsingErrors());
        }
        return parsing_errors;
    }
    getShell() {
        if (this.t_shell_command) {
            // This is a real usage of the PromptModal, so a TShellCommand is available. Look up the shell from that.
            return this.t_shell_command.getShell();
        }
        else {
            // Just trying the PromptModal. Just use some shell for variable escaping in an example preview.
            return this.plugin.getDefaultShell();
        }
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class PromptModel extends Model {
    constructor() {
        super(...arguments);
        this.prompts = new PromptMap();
    }
    getSingularName() {
        return "Prompt";
    }
    defineParentConfigurationRelation(prompt) {
        return {
            type: "one-to-many-id",
            key: "prompts",
            id: prompt.getID(),
        };
    }
    loadInstances(parent_configuration) {
        debugLog("Loading Prompt instances.");
        this.prompts = new PromptMap();
        parent_configuration.prompts.forEach((prompt_configuration) => {
            const prompt = new Prompt(this, this.plugin, prompt_configuration, parent_configuration);
            this.prompts.set(prompt_configuration.id, prompt);
        });
        return this.prompts;
    }
    newInstance(parent_configuration) {
        debugLog("Creating a new Prompt instance.");
        // TODO: Move this logic to the base Model class.
        // Setup a default configuration and generate an ID
        const prompt_configuration = this.getDefaultConfiguration();
        // Instantiate a Prompt
        const prompt = new Prompt(this, this.plugin, prompt_configuration, this.plugin.settings);
        this.prompts.set(prompt.getID(), prompt);
        // Store the configuration into plugin's settings
        this.plugin.settings.prompts.push(prompt_configuration);
        // Return the Prompt
        return prompt;
    }
    _createSettingFields(prompt, container_element) {
        debugLog("Creating setting fields for a Prompt instance.");
        const prompt_name_setting = new obsidian.Setting(container_element)
            // Configuration button
            .setName(prompt.getTitle())
            .addExtraButton(button => button
            .setTooltip("Define prompt fields")
            .setIcon("gear")
            .onClick(() => {
            this.openSettingsModal(prompt, prompt_name_setting);
        }));
        return prompt_name_setting;
    }
    validateValue(prompt, field, value) {
        // This method is not used, so it can just resolve all the time.
        return Promise.resolve(undefined);
    }
    openSettingsModal(prompt, prompt_name_setting) {
        debugLog("Opening settings modal for a Prompt instance.");
        const modal = new PromptSettingsModal(this.plugin, prompt, prompt_name_setting);
        modal.open();
    }
    getDefaultConfiguration() {
        return {
            id: getIDGenerator().generateID(),
            title: "",
            description: "",
            preview_shell_command: false,
            fields: [],
            execute_button_text: "Execute",
        };
    }
    _deleteInstance(prompt) {
        debugLog("Deleting a Prompt instance.");
        // Remove the Prompt from all TShellCommands that use it.
        const shell_commands = this.plugin.getTShellCommands();
        for (const shell_command_id in shell_commands) {
            const t_shell_command = shell_commands[shell_command_id];
            for (const preaction_configuration of t_shell_command.getConfiguration().preactions) {
                if ("prompt" === preaction_configuration.type) {
                    const preaction_prompt_configuration = preaction_configuration;
                    if (prompt.getID() === preaction_prompt_configuration.prompt_id) {
                        // This TShellCommand uses this Prompt.
                        // Remove the Prompt from use.
                        preaction_prompt_configuration.enabled = false;
                        preaction_prompt_configuration.prompt_id = undefined;
                        t_shell_command.resetPreactions();
                        // Saving is done later, after the _deleteInstance() call.
                    }
                }
            }
        }
        this.prompts.delete(prompt.getID());
    }
}
class PromptMap extends Map {
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
/**
 * @return Promise<InstanceClass> A promise that gets resolved if a user clicks the button. The promise is supplied with the newly created instance.
 */
function createNewModelInstanceButton(plugin, model_class_name, button_container_element, instance_container_element, parent_instance_or_configuration) {
    debugLog("Creating a button for creating a new instance for model " + model_class_name + ".");
    return new Promise((resolve_promise) => {
        const model = getModel(model_class_name);
        new obsidian.Setting(button_container_element)
            .addButton(button => button
            .setButtonText("New " + model.getSingularName().toLocaleLowerCase())
            .onClick(async () => {
            if (null === parent_instance_or_configuration) {
                throw new Error("createNewModelInstanceButton(): Parent instance or configuration is null.");
            }
            const instance = model.newInstance(parent_instance_or_configuration);
            const main_setting = model.createSettingFields(instance, instance_container_element);
            resolve_promise({
                "instance": instance,
                "main_setting": main_setting,
            });
            await plugin.saveSettings();
        }));
    });
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class PromptSettingsModal extends SC_Modal {
    constructor(plugin, prompt, 
    /** Can be undefined if the modal is created from a place where there is no name element. */
    prompt_name_setting, 
    /** If defined, a button will be added and on_after_approval() / on_after_cancelling() will be called depending on whether the button was clicked or not. */
    ok_button_text, on_after_approval, on_after_cancelling) {
        super(plugin);
        this.prompt = prompt;
        this.prompt_name_setting = prompt_name_setting;
        this.ok_button_text = ok_button_text;
        this.on_after_approval = on_after_approval;
        this.on_after_cancelling = on_after_cancelling;
        this.approved = false;
    }
    onOpen() {
        super.onOpen();
        const container_element = this.modalEl;
        const title_and_description_group_element = container_element.createDiv({ attr: { class: "SC-setting-group" } });
        // Title
        const title_setting = new obsidian.Setting(title_and_description_group_element)
            .setName("Prompt title")
            .addExtraButton(icon => icon
            .setTooltip("Try the prompt without executing any shell command.")
            .setIcon("run-command")
            .onClick(() => {
            // "Dry run" the Prompt
            this.prompt.openPrompt(null, null, null).then();
        }))
            .addText(text => text
            .setValue(this.prompt.getTitle())
            .onChange(async (new_title) => {
            this.prompt.getConfiguration().title = new_title;
            await this.plugin.saveSettings();
            // Update the title in a name setting. (Only if the modal was created from a place where a Prompt name element exists).
            this.prompt_name_setting?.setName(new_title);
        })
            .then((title_setting_component) => {
            // Autocomplete for Title.
            if (this.plugin.settings.show_autocomplete_menu) {
                createAutocomplete(this.plugin, title_setting_component.inputEl, () => title_setting_component.onChanged());
            }
        }));
        const title_input_element = title_setting.controlEl.find("input");
        // Focus on the title field.
        title_input_element.focus();
        // Description
        new obsidian.Setting(title_and_description_group_element)
            .setName("Description")
            .setDesc("Displayed between the prompt title and fields. Both Description and Title support {{variables}}.")
            .addTextArea(textarea => textarea
            .setValue(this.prompt.configuration.description)
            .onChange(async (new_description) => {
            this.prompt.getConfiguration().description = new_description;
            await this.plugin.saveSettings();
        })
            .then((description_component) => {
            // Autocomplete for Description.
            if (this.plugin.settings.show_autocomplete_menu) {
                createAutocomplete(this.plugin, description_component.inputEl, () => description_component.onChanged());
            }
        }));
        // Preview shell command
        new obsidian.Setting(container_element)
            .setName("Preview shell command in prompt")
            .setDesc("If this is on, the prompt will display the executable shell command with variable names in it, and highlight the variable(s) that will be affected by the values inputted in the prompt.")
            .addToggle(toggle => toggle
            .setValue(this.prompt.getConfiguration().preview_shell_command)
            .onChange(async (new_value) => {
            this.prompt.getConfiguration().preview_shell_command = new_value;
            await this.plugin.saveSettings();
        }));
        // Fields
        new obsidian.Setting(container_element)
            .setName("Fields")
            .setDesc("Tip! You can use {{variables}} in 'Field label', 'Default value' and 'Description'.");
        const prompt_field_model = getModel(PromptFieldModel.name);
        const fields_container = container_element.createDiv();
        this.prompt.prompt_fields.forEach((prompt_field) => {
            prompt_field_model.createSettingFields(prompt_field, fields_container);
        });
        // New field button
        createNewModelInstanceButton(this.plugin, PromptFieldModel.name, container_element, fields_container, this.prompt).then();
        // Execute button text
        new obsidian.Setting(container_element.createDiv({ attr: { class: "SC-setting-group" } }))
            .setName("Execute button text")
            .addText(text => text
            .setValue(this.prompt.configuration.execute_button_text)
            .onChange(async (new_execute_button_text) => {
            this.prompt.configuration.execute_button_text = new_execute_button_text;
            await this.plugin.saveSettings();
        })
            .then((execute_button_text_component) => {
            // Autocomplete for the Execute button text.
            if (this.plugin.settings.show_autocomplete_menu) {
                createAutocomplete(this.plugin, execute_button_text_component.inputEl, () => execute_button_text_component.onChanged());
            }
        }));
        // Ok button
        const okButtonText = this.ok_button_text;
        if (okButtonText) {
            new obsidian.Setting(container_element)
                .addButton(button => button
                .setButtonText(okButtonText)
                .onClick(() => this.approve()));
        }
        // A tip about CSS styling.
        new obsidian.Setting(container_element)
            .setDesc("Tip! You can customise the style of the prompt modal with CSS by using the class ." + this.prompt.getCSSClass() + " or ." + Prompt.getCSSBaseClass() + " (for all prompt modals).");
    }
    approve() {
        if (this.on_after_approval) {
            this.approved = true;
            this.on_after_approval();
        }
        this.close();
    }
    onClose() {
        super.onClose();
        // Call a cancelling hook if one is defined (and if the closing happens due to cancelling, i.e. the ok button is NOT clicked).
        if (!this.approved && this.on_after_cancelling) {
            this.on_after_cancelling();
        }
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
function createPATHAugmentationFields(plugin, container_element, path_augmentations) {
    const path_variable_name = getPATHEnvironmentVariableName();
    new obsidian.Setting(container_element)
        .setName(`Add directories to the ${path_variable_name} environment variable`)
        .setHeading()
        .setDesc(`This is sometimes needed in order to be able to call some user installed applications. The directories will be appended AFTER the default directories in ${path_variable_name}, unless {{!environment:${path_variable_name}}} is included. Other {{variables}} can be used, too, but they don't affect the appending order.`)
        // An icon for showing the current PATH content.
        .addExtraButton(button => button
        .setIcon("bullet-list")
        .setTooltip(`Show the current ${path_variable_name} content (without any additions).`)
        .onClick(() => {
        if (undefined === process.env.PATH) {
            throw new Error("process.env.PATH is not a string.");
        }
        const modal = new ConfirmationModal(plugin, `Current ${path_variable_name} content`, process.env.PATH, "Close");
        modal.open();
    }))
        // Help link
        .addExtraButton(button => button
        .setIcon("help")
        .setTooltip(`Documentation: Additions to the ${path_variable_name} environment variable`)
        .onClick(() => gotoURL(DocumentationPATHAugmentationsLink)));
    // Create a field for each operating system.
    const sub_container_element = container_element.createDiv();
    sub_container_element.addClass("SC-setting-group");
    Object.getOwnPropertyNames(PlatformNames).forEach((platform_id) => {
        const platform_name = PlatformNames[platform_id];
        new obsidian.Setting(sub_container_element).setName(platform_name + " " + getPATHEnvironmentVariableName(platform_id) + " additions")
            .setDesc("Define each directory on a separate line, or multiple directories on one line, separated by " + getPATHSeparator(platform_id, true))
            .addTextArea(textarea => textarea
            .setValue(path_augmentations[platform_id] ?? "")
            .onChange(async (new_path_augmentation) => {
            // PATH augmentation has been changed.
            // Update the configuration.
            if (new_path_augmentation.length > 0) {
                // The augmentation has content.
                path_augmentations[platform_id] = new_path_augmentation;
            }
            else {
                // The augmentation has been removed.
                delete path_augmentations[platform_id];
            }
            await plugin.saveSettings();
        })
            .then((textarea_component) => {
            // Add an autocomplete menu.
            createAutocomplete(plugin, textarea_component.inputEl, () => textarea_component.onChanged());
        }));
    });
}
function getPATHSeparator(platform_id, verbose = false) {
    switch (platform_id) {
        case "linux":
        case "darwin": // This is macOS.
            return verbose ? "a colon :" : ":";
        case "win32":
            return verbose ? "a semicolon ;" : ";";
    }
}
function convertNewlinesToPATHSeparators(path, platform_id) {
    const separator = getPATHSeparator(platform_id);
    return path.replace(/(\r\n|\r|\n)+/gu, // + means that multiple adjacent newlines can be combined into a single separator character.
    () => separator);
}
/**
 * Retrieves a PATH environment variable augmentation string (specific to the current operating system) from the plugin's
 * configuration. Returns it WITHOUT parsing possible variables in the string. If the current operating system does not
 * have a dedicated PATH augmentation string in the configuration, returns null.
 *
 * @param plugin
 */
function getPATHAugmentation(plugin) {
    return plugin.settings.environment_variable_path_augmentations[getOperatingSystem()] ?? null;
}
/**
 * Returns OS specific name for the PATH environment variable. For Windows its Path, but for macOS and Linux its PATH, so
 * the only difference is casing.
 */
function getPATHEnvironmentVariableName(platform_id = getOperatingSystem()) {
    switch (platform_id) {
        case "darwin":
        case "linux":
            return "PATH";
        case "win32":
            return "Path";
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
/**
 * ParsingProcess instances can be used in situations where it's uncertain can all variables be parsed at the time being,
 * i.e. when parsing shell commands (and aliases), as they can have preactions which require parsing to be done in two phases.
 *
 * Also, shell commands are often parsed in advance for command palette and context menus. Then it's good to store the parsing
 * result by using instances of this class.
 *
 * Then again, if the parsing use-case is simpler, e.g. Prompt description or prompt field values, it's more straightforward
 * to just call parseVariables() without utilising this class. After all, this class is a wrapper for parseVariables().
 *
 * <ParsingMap> is a generalization for defining keys for an object that will be used for submitting the original parseable
 * content. The same keys will then be used to form another object containing the parsing results.
 */
class ParsingProcess {
    constructor(plugin, original_contents, 
    /** Used to get a shell (getShell()) and default values for variables. */
    t_shell_command, sc_event, 
    /**
     * When .process() is called, it will shift and process the first VariableSet present in this array. So, the next call
     * will shift and process the next set.
     */
    variable_sets, 
    /**
     * This can be used to mark certain contents to always avoid escaping special characters in their variable values.
     * This should only be used for content that is never submitted to a shell, i.e. output wrappers at the moment.
     *
     * This is a list of 'content keys'.
     */
    avoid_escaping = []) {
        this.plugin = plugin;
        this.original_contents = original_contents;
        this.t_shell_command = t_shell_command;
        this.sc_event = sc_event;
        this.variable_sets = variable_sets;
        this.avoid_escaping = avoid_escaping;
        this.parsing_results = {};
        this.is_first_call = true;
        debugLog("Parsing process: Count variable sets: " + this.variable_sets.length);
    }
    /**
     * Performs the next step in the parsing process. The step can be the first one, or a subsequent step.
     *
     * @return True if parsing succeeded, false otherwise. Read the results by calling .getParsingResult().
     */
    async process() {
        if (this.variable_sets.length === 0) {
            throw new Error("No variable sets are left for processing.");
        }
        const current_variables = this.variable_sets.shift(); // as VariableSet: Tell TypeScript that there is always a set of variables.
        let success = true;
        debugLog("Parsing process: Count variables in current set: " + current_variables.size);
        // Multiple contents can be parsed in the same call. TShellCommand instances have 'shell_command' and 'alias'
        // contents which are parsed at the same time. This multi-content support can be used for even more situations if
        // needed in the future.
        for (const content_key of this.getContentKeys()) {
            let parse_content;
            if (this.is_first_call) {
                // Use original content.
                parse_content = this.original_contents[content_key];
                debugLog("Starting to parse '" + content_key + "': " + parse_content);
            }
            else {
                // Continue parsing content from previous parsing result. This time parse variables that were not parse back then.
                // FIXME: Problem: variable values that came from an earlier phase are exposed to repetitive parsing. Find a way to limit the parsing to only original parts of the shell command.
                const previousParsingResult = this.parsing_results[content_key];
                if (undefined === previousParsingResult) {
                    // This is just a type guard. this.getContentKeys() should only return keys that exist, so the checks should never throw errors in practise.
                    throw new Error("Parsing results do not contain key: " + content_key);
                }
                // Check that the previous parsing did not fail.
                if (null === previousParsingResult.parsed_content) {
                    // Previous parsing had probably failed.
                    throw new Error("Tried to continue parsing, but previous parsing result is null. Probably previous parsing has failed.");
                }
                // Previous parsing was ok.
                parse_content = previousParsingResult.parsed_content;
                debugLog("Continuing parsing '" + content_key + "': " + parse_content);
            }
            // Parse the variables
            const parsing_result = await parseVariables(this.plugin, parse_content, this.avoidEscaping(content_key) ? null : this.t_shell_command.getShell(), // If no escaping is needed, pass null.
            this.t_shell_command, this.sc_event, current_variables);
            // Check if the parsing succeeded or failed.
            success = success && parsing_result.succeeded; // Flag as failed also if a previous phase has failed.
            // Store the parsing result
            this.mergeToParsingResults(content_key, parsing_result);
        }
        // Finish
        this.is_first_call = false;
        return success;
    }
    /**
     * A wrapper for .process() that processes all the VariableSets that are still left unprocessed.
     *
     * @return True if parsing all sets succeeded, false otherwise.
     */
    async processRest() {
        // 1. Check a previous parsing result (if exists).
        for (const content_key of this.getContentKeys()) {
            const parsingResult = this.parsing_results[content_key];
            if (parsingResult) {
                // A previous parsing result exists.
                // Ensure it has not failed.
                debugLog("Previous parsing succeeded? " + parsingResult.succeeded);
                if (!parsingResult.succeeded) {
                    // The previous parsing result has failed.
                    return false;
                }
            }
        }
        // 2. Process the rest of the VariableSets.
        for (let i = 0; i < this.variable_sets.length; i++) {
            if (!await this.process()) {
                return false;
            }
        }
        return true;
    }
    getParsingResults() {
        return this.parsing_results;
    }
    /**
     * Calls SC_Plugin.newErrors() to create visible error balloons for all the issues encountered during parsing.
     */
    displayErrorMessages() {
        this.plugin.newErrors(this.getErrorMessages());
    }
    getErrorMessages() {
        let error_messages = [];
        for (const content_key of this.getContentKeys()) {
            const parsingResult = this.parsing_results[content_key];
            // Type guard
            if (undefined === parsingResult) {
                // This should never happen, because this.getContentKeys() should only return existing keys.
                throw new Error("Parsing result is undefined.");
            }
            error_messages.push(...parsingResult.error_messages);
        }
        // Remove duplicate error messages. When parsing 'shell_command' and 'alias', they can contain same variables and
        // therefore generate same error messages.
        error_messages = uniqueArray(error_messages);
        return error_messages;
    }
    getContentKeys() {
        return Object.getOwnPropertyNames(this.original_contents);
    }
    /**
     * Merges consecutive parsing results together so that information from both the old and new parsing results can be preserved.
     */
    mergeToParsingResults(content_key, newParsingResult) {
        const originalParsingResult = this.parsing_results[content_key];
        if (undefined === originalParsingResult) {
            // No need to merge. But clone the object so that possible future merges will not mess up the original object
            // in case it's used somewhere else.
            this.parsing_results[content_key] = cloneObject(newParsingResult);
            // Note that originalParsingResult is still undefined. If you continue writing code here or after the if block
            // (near the end of the function), do something like originalParsingResult = this.parsing_results[content_key]
            // but that would require changing originalParsingResult from const to let.
        }
        else {
            // Merge
            // NOTE: originalParsingResult.original_content IS KEPT UNCHANGED! The newer "original" content is not actually original, because it's partly parsed. That's why the old one is preserved.
            originalParsingResult.parsed_content = newParsingResult.parsed_content; // New parsed content overrides the old one.
            originalParsingResult.succeeded &&= newParsingResult.succeeded; // Both the old and new parsing must have succeeded in order to consider the whole process succeeded.
            originalParsingResult.error_messages.push(...newParsingResult.error_messages); // Include both old and new error messages.
            originalParsingResult.count_parsed_variables += newParsingResult.count_parsed_variables; // Sum up the variable usage counts. At the time of writing, the sum is only used for determining if there were any variables parsed or not, so an accurate sum is not used atm.
        }
    }
    /**
     * Tells whether the given content_key has a mark that special characters in the content's variable values should not be escaped.
     *
     * @param content_key
     * @private
     */
    avoidEscaping(content_key) {
        return this.avoid_escaping.contains(content_key);
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
function newShellCommandConfiguration(shell_command_id, shell_command = "") {
    return {
        id: shell_command_id,
        platform_specific_commands: {
            default: shell_command,
        },
        shells: {},
        alias: "",
        icon: null,
        confirm_execution: false,
        ignore_error_codes: [],
        input_contents: {
            stdin: null,
        },
        output_channels: {
            stdout: "ignore",
            stderr: "notification",
        },
        output_wrappers: {
            stdout: null,
            stderr: null,
        },
        output_channel_order: "stdout-first",
        output_handling_mode: "buffered",
        events: {},
        command_palette_availability: "enabled",
        preactions: [],
        variable_default_values: {},
    };
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
async function RunMigrations(plugin) {
    const should_save = [
        EnsureMainFieldsExist(plugin),
        MigrateCommandsToShellCommands(plugin),
        MigrateShellCommandsObjectToArray(plugin),
        MigrateShellCommandToPlatforms(plugin),
        EnsureShellCommandsHaveAllFields(plugin),
        EnsureCustomVariablesHaveAllFields(plugin),
        DeleteEmptyCommandsField(plugin),
    ];
    if (should_save.includes(true)) {
        // Only save if there were changes to configuration.
        debugLog("Saving migrations...");
        backupSettingsFile(plugin); // Make a backup copy of the old file BEFORE writing the new, migrated settings file.
        await plugin.saveSettings();
        debugLog("Migrations saved...");
    }
}
/**
 * Can be removed in the future, but I haven't yet decided will it be done in 1.0 or later.
 */
function MigrateShellCommandsObjectToArray(plugin) {
    // Check if the shell commands' container is an object.
    if (!Array.isArray(plugin.settings.shell_commands)) {
        // It is an object. It needs to be changed to an array in order to allow custom ordering.
        const shell_commands_array = [];
        for (const shell_command_id of Object.getOwnPropertyNames(plugin.settings.shell_commands)) { // Remember that plugin.settings.shell_commands is an object here! Not an array (yet).
            // @ts-ignore I don't know why TypeScript thinks the index is incorrect.
            const shell_command_configuration = plugin.settings.shell_commands[shell_command_id];
            // Assign 'id' to ShellCommandConfiguration because it did not contain it before this migration.
            shell_command_configuration.id = shell_command_id;
            // Add the ShellCommandConfiguration to the new array container.
            shell_commands_array.push(shell_command_configuration);
        }
        // Replace the old object container with the new array container.
        plugin.settings.shell_commands = shell_commands_array; // Now plugin.settings.shell_commands changes to be an array instead of an object.
        return true; // Save the changes.
    }
    else {
        // The container is already migrated.
        return false; // No need to save anything.
    }
}
/**
 * Can be removed in 1.0.0.
 *
 * @param plugin
 * @constructor
 */
function MigrateCommandsToShellCommands(plugin) {
    if (undefined === plugin.settings.commands) {
        return false;
    }
    const count_shell_commands = plugin.settings.commands.length;
    let save = false;
    if (0 < count_shell_commands) {
        let count_empty_commands = 0; // A counter for empty or null commands
        debugLog("settings.commands is not empty, will migrate " + count_shell_commands + " commands to settings.shell_commands.");
        for (const shell_command_id in plugin.settings.commands) {
            const shell_command = plugin.settings.commands[shell_command_id];
            // Ensure that the command is not empty. Just in case.
            if (null === shell_command || 0 === shell_command.length) {
                // The command is empty
                debugLog("Migration failure for shell command #" + shell_command_id + ": The original shell command string is empty, so it cannot be migrated.");
                count_empty_commands++;
            }
            else if (undefined !== plugin.getShellCommandConfigurationIndex(shell_command_id)) {
                // A command with the same id already exists
                debugLog("Migration failure for shell command #" + shell_command_id + ": A shell command with same ID already exists in settings.shell_commands.");
            }
            else {
                // All OK, migrate.
                plugin.settings.shell_commands.push(newShellCommandConfiguration(shell_command_id, shell_command)); // Creates a shell command with default values and defines the command for it.
                delete plugin.settings.commands[shell_command_id]; // Leaves a null in place, but we can deal with it by deleting the whole array if it gets empty.
                count_empty_commands++; // Account the null generated on the previous line.
                save = true;
                debugLog("Migrated shell command #" + shell_command_id + ": " + shell_command);
            }
        }
        if (count_empty_commands === count_shell_commands) {
            // The whole commands array now contains only empty/null commands.
            // Delete it.
            delete plugin.settings.commands;
        }
    }
    else {
        debugLog("settings.commands is empty, so no need to migrate commands. Good thing! :)");
    }
    return save;
}
/**
 * This is a general migrator that adds new, missing properties to ShellCommandConfiguration objects. This is not tied to any specific version update, unlike MigrateCommandsToShellCommands().
 *
 * @param plugin
 * @constructor
 */
function EnsureShellCommandsHaveAllFields(plugin) {
    let save = false;
    const shell_command_default_configuration = newShellCommandConfiguration("no-id"); // Use a dummy id here, because something needs to be used. This id should never end up being used in practice.
    const shell_command_configurations = plugin.settings.shell_commands;
    for (const shell_command_configuration of shell_command_configurations) {
        for (const property_name in shell_command_default_configuration) {
            // @ts-ignore property_default_value can have (almost) whatever datatype
            const property_default_value = shell_command_default_configuration[property_name];
            // @ts-ignore
            if (undefined === shell_command_configuration[property_name] && property_name !== "id") { // The "id" check is just in case that MigrateShellCommandsObjectToArray() would not have added the "id" property, in which case the dummy "no-id" id should not be accidentally assigned to the shell command.
                // This shell command does not have this property.
                // Add the property to the shell command and use a default value.
                debugLog("EnsureShellCommandsHaveAllFields(): Shell command #" + shell_command_configuration.id + " does not have a property '" + property_name + "'. Will create the property and assign a default value '" + property_default_value + "'.");
                // @ts-ignore
                shell_command_configuration[property_name] = property_default_value;
                save = true;
            }
        }
    }
    return save;
}
function EnsureCustomVariablesHaveAllFields(plugin) {
    let save = false;
    const customVariableModel = getModel(CustomVariableModel.name);
    const customVariableDefaultConfiguration = customVariableModel.getDefaultConfiguration();
    let customVariableConfiguration;
    for (customVariableConfiguration of plugin.settings.custom_variables) {
        for (const propertyName in customVariableDefaultConfiguration) {
            // @ts-ignore propertyDefaultValue can have (almost) whatever datatype
            const propertyDefaultValue = customVariableDefaultConfiguration[propertyName];
            // @ts-ignore
            if (undefined === customVariableConfiguration[propertyName]) {
                // This custom variable does not have this property.
                // Add the property to it and use a default value.
                debugLog("EnsureCustomVariablesHaveAllFields(): Custom variable #" + customVariableConfiguration.id + " does not have a property '" + propertyName + "'. Will create the property and assign a default value '" + propertyDefaultValue + "'.");
                // @ts-ignore
                customVariableConfiguration[propertyName] = propertyDefaultValue;
                save = true;
            }
        }
    }
    return save;
}
/**
 * This is a general migrator that adds new, missing properties to the main settings object. This is not tied to any specific version update, unlike MigrateCommandsToShellCommands().
 *
 * @param plugin
 * @constructor
 */
function EnsureMainFieldsExist(plugin) {
    let has_missing_fields = false;
    const settings = plugin.settings;
    const default_settings = getDefaultSettings(false);
    for (const property_name in default_settings) {
        // @ts-ignore
        if (undefined === settings[property_name]) {
            // The settings object does not have this property.
            // @ts-ignore property_default_value can have (almost) whatever datatype
            const property_default_value = default_settings[property_name];
            debugLog("EnsureMainFieldsExist(): Main settings does not have property '" + property_name + "'. Will later create the property and assign a default value '" + property_default_value + "'.");
            has_missing_fields = true;
        }
    }
    if (has_missing_fields) {
        debugLog("EnsureMainFieldsExist(): Doing the above-mentioned new field creations...");
        plugin.settings = combineObjects(default_settings, plugin.settings);
        debugLog("EnsureMainFieldsExist(): Done.");
        return true; // Save the changes
    }
    debugLog("EnsureMainFieldsExist(): No new fields to create, all ok.");
    return false; // Nothing to save.
}
/**
 * Can be removed in 1.0.0.
 *
 * @param plugin
 * @constructor
 */
function MigrateShellCommandToPlatforms(plugin) {
    let save = false;
    for (const shell_command_configuration of plugin.settings.shell_commands) {
        if (undefined !== shell_command_configuration.shell_command) {
            // The shell command should be migrated.
            if (undefined === shell_command_configuration.platform_specific_commands || shell_command_configuration.platform_specific_commands.default === "") {
                debugLog("Migrating shell command #" + shell_command_configuration.id + ": shell_command string will be moved to platforms.default: " + shell_command_configuration.shell_command);
                shell_command_configuration.platform_specific_commands = {
                    default: shell_command_configuration.shell_command,
                };
                delete shell_command_configuration.shell_command;
                save = true;
            }
            else {
                debugLog("Migration failure for shell command #" + shell_command_configuration.id + ": platforms exists already.");
            }
        }
    }
    return save;
}
/**
 * Can be removed in 1.0.0.
 *
 * @param plugin
 * @constructor
 */
function DeleteEmptyCommandsField(plugin) {
    let save = false;
    if (undefined !== plugin.settings.commands) {
        if (plugin.settings.commands.length === 0) {
            delete plugin.settings.commands;
            save = true;
        }
    }
    return save;
}
/**
 * Permanent, do not remove.
 *
 * @param plugin
 */
function backupSettingsFile(plugin) {
    // plugin.app.fileManager.
    // @ts-ignore
    const current_settings_version = (plugin.settings.settings_version === "prior-to-0.7.0") ? "0.x" : plugin.settings.settings_version;
    const plugin_path = getPluginAbsolutePath(plugin);
    const settings_file_path = path__namespace.join(plugin_path, "data.json");
    const backup_file_path_without_extension = path__namespace.join(plugin_path, "data-backup-version-" + current_settings_version + "-before-upgrading-to-" + SC_Plugin.SettingsVersion);
    // Check that the current settings file can be found.
    if (!fs__namespace.existsSync(settings_file_path)) {
        // Not found. Probably the vault uses a different config folder than .obsidian.
        debugLog("backupSettingsFile(): Cannot find data.json");
        plugin.newError("Shell commands: Cannot create a backup of current settings file, because data.json is not found.");
        return;
    }
    let backup_file_path = backup_file_path_without_extension + ".json";
    let running_number = 1;
    while (fs__namespace.existsSync(backup_file_path)) {
        running_number++; // The first number will be 2.
        backup_file_path = backup_file_path_without_extension + "-" + running_number + ".json";
        if (running_number >= 1000) {
            // There is some problem with detecting existing/inexisting files.
            // Prevent hanging the program in an eternal loop.
            throw new Error("backupSettingsFile(): Eternal loop detected.");
        }
    }
    fs__namespace.copyFileSync(settings_file_path, backup_file_path);
}
// TODO: Add migration: shell command variable_default_values: if type is "show-errors", change it to "inherit", but only if old settings version was below 18.

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
function createShellSelectionField(plugin, container_element, shells, is_global_settings) {
    let platform_id;
    for (platform_id in PlatformNames) {
        const platform_name = PlatformNames[platform_id];
        let options;
        if (is_global_settings) {
            const current_system_default = (getOperatingSystem() === platform_id) ? " (" + extractFileName(getUsersDefaultShell()) + ")" : "";
            options = { "default": "Use system default" + current_system_default };
        }
        else {
            options = { "default": "Use default" };
        }
        for (const shell_path in PlatformShells[platform_id]) {
            // @ts-ignore // TODO: Get rid of these two ts-ignores.
            const shell_name = PlatformShells[platform_id][shell_path];
            // @ts-ignore
            options[shell_path] = shell_name;
        }
        new obsidian.Setting(container_element)
            .setName(platform_name + (is_global_settings ? " default shell" : " shell"))
            .setDesc((is_global_settings ? "Can be overridden by each shell command. " : "") + ("win32" === platform_id ? "Powershell is recommended over cmd.exe, because this plugin does not support escaping variables in CMD." : ""))
            .addDropdown(dropdown => dropdown
            .addOptions(options)
            .setValue(shells[platform_id] ?? "default")
            .onChange(((_platform_id) => {
            return async (value) => {
                if ("default" === value) {
                    // When using default shell, the value should be unset.
                    delete shells[_platform_id];
                }
                else {
                    // Normal case: assign the shell value.
                    shells[_platform_id] = value;
                }
                await plugin.saveSettings();
            };
        })(platform_id)));
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
/**
 * Makes a textarea grow and shrink based on the content height, and applies CSS styles on it to make it look more like an <input> element (not so much padding).
 */
function decorateMultilineField(plugin, textareaComponent, extraOnChange) {
    const textareaElement = textareaComponent.inputEl;
    textareaElement.addClass("SC-multiline");
    const updateTextareaHeight = () => {
        // Resize the shell command textarea to match the amount of lines in it.
        const content = textareaElement.value;
        const placeholder = textareaElement.placeholder;
        const newlines_pattern = /\r\n|\r|\n/;
        const count_lines_in_shell_command = content.split(newlines_pattern).length;
        const count_lines_in_shell_command_placeholder = placeholder.split(newlines_pattern).length;
        let count_lines_final = Math.max(count_lines_in_shell_command, count_lines_in_shell_command_placeholder);
        if (plugin.settings.max_visible_lines_in_shell_command_fields) {
            // Limit the height so that the field will not take up too much space.
            count_lines_final = Math.min(plugin.settings.max_visible_lines_in_shell_command_fields, count_lines_final);
        }
        textareaElement.rows = count_lines_final;
    };
    updateTextareaHeight(); // Set a correct initial height.
    textareaComponent.onChange(() => {
        updateTextareaHeight(); // Update the height every time the field's value changes.
        if (extraOnChange) {
            extraOnChange(textareaElement.value);
        }
    });
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
function CreateShellCommandFieldCore(plugin, container_element, setting_icon_and_name, shell_command, shell, t_shell_command, show_autocomplete_menu, extra_on_change, shell_command_placeholder = "Enter your command") {
    async function on_change(shell_command) {
        // Update preview
        setting_group.preview_setting.descEl.innerHTML = ""; // Remove previous content.
        createMultilineTextElement("span", // TODO: Maybe cleaner would be not to create a <span>, but to insert the content directly into descEl.
        await getShellCommandPreview(plugin, shell_command, shell, t_shell_command, null /* No event is available during preview. */), setting_group.preview_setting.descEl);
        // Let the caller extend this onChange, to preform saving the settings:
        extra_on_change(shell_command);
    }
    const setting_group = {
        name_setting: new obsidian.Setting(container_element)
            .setClass("SC-name-setting")
            .then((name_setting) => {
            name_setting.nameEl.innerHTML = setting_icon_and_name;
        }),
        shell_command_setting: new obsidian.Setting(container_element)
            .addTextArea(textareaComponent => {
            textareaComponent
                .setPlaceholder(shell_command_placeholder)
                .setValue(shell_command);
            decorateMultilineField(plugin, textareaComponent, on_change);
        })
            .setClass("SC-shell-command-setting"),
        preview_setting: new obsidian.Setting(container_element)
            .setClass("SC-preview-setting")
            .then(async (setting) => {
            setting.descEl.innerHTML = ""; // Remove previous content. Not actually needed here because it's empty already, but do it just in case.
            createMultilineTextElement("span", // TODO: Maybe cleaner would be not to create a <span>, but to insert the content directly into descEl.
            await getShellCommandPreview(plugin, shell_command, shell, t_shell_command, null /* No event is available during preview. */), setting.descEl);
        }),
    };
    // Autocomplete menu
    if (show_autocomplete_menu) {
        createAutocomplete(plugin, setting_group.shell_command_setting.settingEl.find("textarea"), on_change);
    }
    return setting_group;
}
/**
 *
 * @param plugin
 * @param shell_command
 * @param shell
 * @param t_shell_command
 * @param sc_event
 * @public Exported because createShellCommandField uses this.
 */
async function getShellCommandPreview(plugin, shell_command, shell, t_shell_command, sc_event) {
    const parsing_result = await parseVariables(plugin, shell_command, shell, t_shell_command, sc_event);
    if (!parsing_result.succeeded) {
        // Variable parsing failed.
        if (parsing_result.error_messages.length > 0) {
            // Return all error messages, each in its own line. (Usually there's just one message).
            return parsing_result.error_messages.join(os.EOL); // Newlines are converted to <br>'s by the consumers of this function.
        }
        else {
            // If there are no error messages, then errors are silently ignored by user's variable configuration.
            // The preview can then show the original, unparsed shell command.
            return shell_command;
        }
    }
    // Variable parsing succeeded
    return parsing_result.parsed_content;
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
function createPlatformSpecificShellCommandField(plugin, container_element, t_shell_command, platform_id, show_autocomplete_menu) {
    const platform_name = PlatformNames[platform_id];
    const setting_group = CreateShellCommandFieldCore(plugin, container_element, "Shell command on " + platform_name, t_shell_command.getPlatformSpecificShellCommands()[platform_id] ?? "", t_shell_command.getShell(), t_shell_command, show_autocomplete_menu, async (shell_command) => {
        if (shell_command.length) {
            // shell_command is not empty, so it's a normal command.
            t_shell_command.getPlatformSpecificShellCommands()[platform_id] = shell_command;
        }
        else {
            // shell_command is empty, so the default command should be used.
            delete t_shell_command.getPlatformSpecificShellCommands()[platform_id];
        }
        await plugin.saveSettings();
    }, t_shell_command.getDefaultShellCommand());
    setting_group.name_setting.setDesc("If empty, the default shell command will be used on " + platform_name + ".");
    return setting_group;
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
function createTabs(container_element, tabs) {
    const tab_header = container_element.createEl("div", { attr: { class: "SC-tab-header" } });
    const tab_content_containers = {};
    const tab_buttons = {};
    const tab_structure = {
        header: tab_header,
        active_tab_id: Object.keys(tabs)[0],
        buttons: tab_buttons,
        contentContainers: tab_content_containers,
    };
    let first_button;
    for (const tab_id in tabs) {
        const tab = tabs[tab_id];
        // Create button
        const button = tab_header.createEl("button", {
            attr: {
                class: "SC-tab-header-button",
                activateTab: "SC-tab-" + tab_id,
            },
        });
        button.onclick = function (event) {
            const tab_button = this; // Use 'this' instead of event.target because this way we'll always get a button element, not an element inside the  button (i.e. an icon).
            // Hide all tab contents and get the max dimensions
            let max_width = 0;
            let max_height = 0;
            const tab_header = tab_button.parentElement;
            if (null === tab_header) {
                throw new Error("Tab header is missing. Did not get a parent from tab button.");
            }
            const container_element = tab_header.parentElement;
            if (null === container_element) {
                throw new Error("Container element is missing. Did not get a parent from tab header.");
            }
            const tab_contents = container_element.findAll("div.SC-tab-content"); // Do not get all tab contents that exist, because there might be multiple tab systems open at the same time.
            const is_main_settings_modal = container_element.hasClass("vertical-tab-content");
            for (const index in tab_contents) {
                const tab_content = tab_contents[index];
                // Get the maximum tab dimensions so that all tabs can have the same dimensions.
                // But don't do it if this is the main settings modal
                if (!is_main_settings_modal) {
                    tab_content.addClass("SC-tab-active"); // Need to make the tab visible temporarily in order to get the dimensions.
                    if (tab_content.offsetHeight > max_height) {
                        max_height = tab_content.offsetHeight;
                    }
                    if (tab_content.offsetWidth > max_width) {
                        max_width = tab_content.offsetWidth;
                    }
                }
                // Finally hide the tab
                tab_content.removeClass("SC-tab-active");
            }
            // Remove active status from all buttons
            const adjacent_tab_buttons = tab_header.findAll(".SC-tab-header-button"); // Do not get all tab buttons that exist, because there might be multiple tab systems open at the same time.
            for (const index in adjacent_tab_buttons) {
                const tab_button = adjacent_tab_buttons[index];
                tab_button.removeClass("SC-tab-active");
            }
            // Activate the clicked tab
            tab_button.addClass("SC-tab-active");
            const activateTabAttribute = tab_button.attributes.getNamedItem("activateTab");
            if (null === activateTabAttribute) {
                throw new Error("Tab button has no 'activateTab' HTML attribute! Murr!");
            }
            const activate_tab_id = activateTabAttribute.value;
            const tab_content = document.getElementById(activate_tab_id);
            if (null === tab_content) {
                throw new Error("No tab content was found with activate_tab_id '" + activate_tab_id + "'! Hmph!");
            }
            tab_content.addClass("SC-tab-active");
            // Mark the clicked tab as active in TabStructure (just to report which tab is currently active)
            tab_structure.active_tab_id = activate_tab_id.replace(/^SC-tab-/, ""); // Remove "SC-tab" prefix.
            // Focus an element (if a focusable element is present)
            tab_content.find(".SC-focus-element-on-tab-opening")?.focus(); // ? = If not found, do nothing.
            // Apply the max dimensions to this tab
            // But don't do it if this is the main settings modal
            if (!is_main_settings_modal) {
                tab_content.style.width = max_width + "px";
                tab_content.style.height = max_height + "px";
            }
            // Do nothing else (I don't know if this is needed or not)
            event.preventDefault();
        };
        obsidian.setIcon(button, tab.icon);
        button.insertAdjacentText("beforeend", " " + tab.title);
        tab_buttons[tab_id] = button;
        // Create content container
        tab_content_containers[tab_id] = container_element.createEl("div", { attr: { class: "SC-tab-content", id: "SC-tab-" + tab_id } });
        // Generate content
        tab.content_generator(tab_content_containers[tab_id]);
        // Memorize the first tab's button
        if (undefined === first_button) {
            first_button = button;
        }
    }
    // Activate the first tab
    if (undefined !== first_button) {
        first_button.click();
    }
    // Return the TabStructure
    return tab_structure;
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
/**
 * TODO: Rename to ShellCommandSettingsModal
 */
class ExtraOptionsModal extends SC_Modal {
    constructor(plugin, shell_command_id, setting_tab) {
        super(plugin);
        this.shell_command_id = shell_command_id;
        this.t_shell_command = plugin.getTShellCommands()[shell_command_id];
        this.name_setting = setting_tab.setting_groups[shell_command_id].name_setting;
        this.setting_tab = setting_tab;
    }
    onOpen() {
        super.onOpen();
        this.modalEl.createEl("h2", { text: this.t_shell_command.getDefaultShellCommand() }); // TODO: Use this.setTitle() instead.
        // Tabs
        this.tab_structure = createTabs(this.modalEl, {
            "extra-options-general": {
                title: "General",
                icon: "gear",
                content_generator: (container_element) => {
                    this.tabGeneral(container_element);
                },
            },
            "extra-options-preactions": {
                title: "Preactions",
                icon: "note-glyph",
                content_generator: (container_element) => {
                    this.tabPreactions(container_element);
                },
            },
            "extra-options-output": {
                title: "Output",
                icon: "lines-of-text",
                content_generator: (container_element) => {
                    this.tabOutput(container_element);
                },
            },
            "extra-options-environments": {
                title: "Environments",
                icon: "stacked-levels",
                content_generator: (container_element) => {
                    this.tabEnvironments(container_element);
                },
            },
            "extra-options-events": {
                title: "Events",
                icon: "dice",
                content_generator: (container_element) => {
                    this.tabEvents(container_element);
                },
            },
            "extra-options-variables": {
                title: "Variables",
                icon: "code-glyph",
                content_generator: (container_element) => {
                    this.tabVariables(container_element);
                },
            },
        });
        // Hotkeys for moving to next/previous shell command
        const switch_to_t_shell_command = (t_shell_command) => {
            const new_modal = new ExtraOptionsModal(this.plugin, t_shell_command.getId(), this.setting_tab);
            this.close(); // Needs to be closed before the new one is opened, otherwise the new one's tab content won't be shown.
            new_modal.open();
            new_modal.activateTab(this.tab_structure.active_tab_id);
        };
        this.scope.register(["Mod"], "ArrowUp", () => {
            const previousTShellCommand = this.t_shell_command.previousTShellCommand();
            if (previousTShellCommand) {
                switch_to_t_shell_command(previousTShellCommand);
            }
        });
        this.scope.register(["Mod"], "ArrowDown", () => {
            const nextTShellCommand = this.t_shell_command.nextTShellCommand();
            if (nextTShellCommand) {
                switch_to_t_shell_command(nextTShellCommand);
            }
        });
        new obsidian.Setting(this.modalEl)
            .setDesc("Tip! Hit " + CmdOrCtrl() + " + up/down to switch to previous/next shell command.");
    }
    tabGeneral(container_element) {
        // Alias field
        const alias_container = container_element.createDiv({ attr: { class: "SC-setting-group" } });
        new obsidian.Setting(alias_container)
            .setName("Alias");
        const on_alias_change = async (value) => {
            // Change the actual alias value
            this.t_shell_command.getConfiguration().alias = value;
            // Update Obsidian command palette
            this.t_shell_command.renameObsidianCommand(this.t_shell_command.getShellCommand(), this.t_shell_command.getAlias());
            // UpdateShell commands settings panel
            this.name_setting.nameEl.innerHTML = generateShellCommandFieldIconAndName(this.t_shell_command);
            // Save
            await this.plugin.saveSettings();
        };
        const alias_setting = new obsidian.Setting(alias_container)
            .addText(text => text
            .setValue(this.t_shell_command.getAlias())
            .onChange(on_alias_change))
            .setClass("SC-no-description");
        const alias_input_element = alias_setting.controlEl.find("input");
        alias_input_element.addClass("SC-focus-element-on-tab-opening"); // Focus without a need to click the field.
        if (this.plugin.settings.show_autocomplete_menu) {
            // Show autocomplete menu (= a list of available variables).
            createAutocomplete(this.plugin, alias_input_element, on_alias_change);
        }
        alias_container.createEl("p", { text: "If not empty, the alias will be displayed in the command palette instead of the actual command. An alias is never executed as a command." });
        alias_container.createEl("p", { text: "You can also use the same {{}} style variables in aliases that are used in shell commands. When variables are used in aliases, they do not affect the command execution in any way, but it's a nice way to reveal what values your command will use, even when an alias hides most of the other technical details. Starting a variable with {{! will prevent escaping special characters in command palette." });
        // Icon field
        const current_icon = this.t_shell_command.getConfiguration().icon;
        const icon_setting = new obsidian.Setting(container_element)
            .setDesc("If defined, the icon will be shown in file menu, folder menu, and editor menu in front of the alias text. It's also shown in the settings. It makes it easier to distinguish different shell commands visually from each other.")
            .addDropdown(dropdown => dropdown
            .addOption("no-icon", "No icon") // Need to use a non-empty string like "no-icon", because if 'value' would be "" then it becomes the same as 'display' from some reason, i.e. "No icon".
            .then((dropdown) => {
            // Iterate all available icons.
            for (const icon_id of AUGMENTED_ICON_LIST) {
                // Create an option for the icon.
                dropdown.addOption(icon_id, icon_id);
            }
            dropdown.setValue(current_icon ?? "no-icon"); // "" == the 'No icon' option.
        })
            .onChange(async (new_icon) => {
            if ("no-icon" === new_icon) {
                // Disable icon
                this.t_shell_command.getConfiguration().icon = null;
                // Remove the icon from the modal
                icon_setting.nameEl.innerHTML = "Icon";
            }
            else {
                // Set or change the icon
                this.t_shell_command.getConfiguration().icon = new_icon;
                // Update the icon in the modal
                icon_setting.nameEl.innerHTML = "Icon " + getIconHTML(new_icon);
            }
            // Update (or remove) the icon in the main settings panel
            this.name_setting.nameEl.innerHTML = generateShellCommandFieldIconAndName(this.t_shell_command);
            // Save settings
            await this.plugin.saveSettings();
        }));
        icon_setting.nameEl.innerHTML = "Icon " + (current_icon ? getIconHTML(current_icon) : "");
        // Confirm execution field
        new obsidian.Setting(container_element)
            .setName("Ask confirmation before execution")
            .addToggle(toggle => toggle
            .setValue(this.t_shell_command.getConfirmExecution())
            .onChange(async (value) => {
            this.t_shell_command.getConfiguration().confirm_execution = value;
            const icon_container = this.name_setting.nameEl.find("span.shell-commands-confirm-execution-icon-container");
            if (this.t_shell_command.getConfirmExecution()) {
                // Show icon
                icon_container.removeClass("SC-hide");
            }
            else {
                // Hide icon
                icon_container.addClass("SC-hide");
            }
            await this.plugin.saveSettings();
        }));
        // Stdin field
        new obsidian.Setting(container_element)
            .setName("Pass variables to standard input (stdin) (experimental)")
            .setDesc("Used to pass long texts as input to the shell command. There is a limit to command line length, and e.g. {{note_content}} might provide a value too long to be used as an argument, so it works better when passed to stdin. Also, programs that ask multiple values interactively, can be fed with values using stdin. If there are multiple values that need to be inputted, put them on separate lines. Many shell programs interpret newlines as separators between different values.")
            .addExtraButton(extraButtonComponent => extraButtonComponent
            .setIcon("help")
            .setTooltip("Documentation: Pass variables to stdin")
            .onClick(() => gotoURL(DocumentationStdinContentLink)));
        const stdinSettingContainer = container_element.createDiv({ attr: { class: "SC-setting-group" } });
        const onStdinChange = async (newStdinContent) => {
            if ("" === newStdinContent) {
                // Set to null
                this.t_shell_command.getConfiguration().input_contents.stdin = null;
            }
            else {
                // Set value
                this.t_shell_command.getConfiguration().input_contents.stdin = newStdinContent;
            }
            await this.plugin.saveSettings();
        };
        new obsidian.Setting(stdinSettingContainer)
            .setDesc("Can contain {{variables}} and/or static text.")
            .addTextArea(textareaComponent => {
            textareaComponent
                .setValue(this.t_shell_command.getInputChannels().stdin ?? "");
            decorateMultilineField(this.plugin, textareaComponent, onStdinChange);
            if (this.plugin.settings.show_autocomplete_menu) {
                // Show autocomplete menu (= a list of available variables).
                createAutocomplete(this.plugin, textareaComponent.inputEl, onStdinChange);
            }
        });
        // Shell command id
        new obsidian.Setting(container_element)
            .setDesc(`Shell command id: ${this.shell_command_id}`)
            .addExtraButton(button => button
            .setIcon("documents")
            .setTooltip(`Copy ${this.shell_command_id} to the clipboard.`)
            .onClick(() => {
            copyToClipboard(this.shell_command_id);
            this.plugin.newNotification(`${this.shell_command_id} was copied to the clipboard.`);
        }));
        if (this.t_shell_command.canAddToCommandPalette()) {
            // Only show Obsidian command palette id if the shell command is available in the command palette.
            const obsidian_command_id = this.t_shell_command.getObsidianCommand().id;
            new obsidian.Setting(container_element)
                .setDesc(`Obsidian command palette id: ${obsidian_command_id}`)
                .addExtraButton(button => button
                .setIcon("documents")
                .setTooltip(`Copy ${obsidian_command_id} to the clipboard.`)
                .onClick(() => {
                copyToClipboard(obsidian_command_id);
                this.plugin.newNotification(`${obsidian_command_id} was copied to the clipboard.`);
            }))
                .settingEl.addClass("SC-no-top-border") // No horizontal ruler between the two id elements.
            ;
        }
    }
    tabPreactions(container_element) {
        container_element.createEl("p", { text: "Preactions are performed before the actual shell command gets executed, to do certain preparations for the shell command." });
        const preactions_configuration = this.t_shell_command.getConfiguration().preactions;
        // Load config values
        let preaction_prompt_configuration = null;
        for (const preaction_configuration of preactions_configuration) {
            switch (preaction_configuration.type) {
                case "prompt":
                    preaction_prompt_configuration = preaction_configuration;
                    break;
                default:
                    throw new Error("Unrecognised preaction type: " + preaction_configuration.type);
            }
        }
        // Preaction: Prompt
        const prompt_options = {};
        this.plugin.getPrompts().forEach((prompt) => {
            prompt_options[prompt.getID()] = prompt.getTitle();
        });
        let old_selected_prompt_option = (preaction_prompt_configuration?.enabled) ? preaction_prompt_configuration.prompt_id : "no-prompt";
        new obsidian.Setting(container_element)
            .setName("Prompt")
            .setDesc("Prompts are used to ask values from the user right before shell command execution. The values can be accessed in the shell command via custom variables. You can manage all prompts in the plugin's main settings view, under the 'Preactions' tab.")
            .addDropdown(dropdown => dropdown
            .addOption("no-prompt", "No prompt")
            .addOptions(prompt_options)
            .addOption("new", "Create a new prompt")
            .setValue(old_selected_prompt_option)
            .onChange(async (new_prompt_id) => {
            // Create a PreactionPromptConfiguration if it does not exist.
            if (!preaction_prompt_configuration) {
                preaction_prompt_configuration = getDefaultPreaction_Prompt_Configuration();
                preactions_configuration.push(preaction_prompt_configuration);
                this.t_shell_command.resetPreactions();
            }
            // Interpret the selection
            switch (new_prompt_id) {
                case "new": {
                    // Create a new Prompt.
                    const model = getModel(PromptModel.name);
                    const new_prompt = model.newInstance(this.plugin.settings);
                    this.plugin.saveSettings().then(() => {
                        const modal = new PromptSettingsModal(this.plugin, new_prompt, undefined, "Create prompt", async () => {
                            // Prompt is created.
                            dropdown.addOption(new_prompt.getID(), new_prompt.getTitle());
                            dropdown.setValue(new_prompt.getID());
                            preaction_prompt_configuration.enabled = true; // 'as Preaction_Prompt_Configuration' tells TypeScript that the variable is not null.
                            preaction_prompt_configuration.prompt_id = new_prompt.getID();
                            await this.plugin.saveSettings();
                            old_selected_prompt_option = dropdown.getValue();
                        }, async () => {
                            // Prompt creation was cancelled.
                            dropdown.setValue(old_selected_prompt_option); // Reset the dropdown selection.
                            model.deleteInstance(new_prompt);
                            await this.plugin.saveSettings();
                        });
                        modal.open();
                    });
                    break;
                }
                case "no-prompt": {
                    // Disable the prompt.
                    preaction_prompt_configuration.enabled = false;
                    this.t_shell_command.resetPreactions();
                    await this.plugin.saveSettings();
                    old_selected_prompt_option = dropdown.getValue();
                    break;
                }
                default: {
                    // Use an existing prompt.
                    preaction_prompt_configuration.enabled = true;
                    preaction_prompt_configuration.prompt_id = new_prompt_id;
                    await this.plugin.saveSettings();
                    old_selected_prompt_option = dropdown.getValue();
                    break;
                }
            }
        }));
    }
    tabOutput(container_element) {
        // Output channeling
        const stdout_channel_setting = this.newOutputChannelSetting(container_element, "Output channel for stdout", "stdout");
        this.newOutputChannelSetting(container_element, "Output channel for stderr", "stderr", "If both stdout and stderr use the same channel, stderr will be combined to same message with stdout.");
        // Output wrappers
        this.newOutputWrapperSetting(container_element, "Output wrapper for stdout", "stdout", "Output wrappers can be used to surround output with predefined text, e.g. to put output into a code block. Note: If 'Output mode' is 'Realtime', wrappers will probably appear multiple times in output!");
        this.newOutputWrapperSetting(container_element, "Output wrapper for stderr", "stderr");
        // Output handling mode
        new obsidian.Setting(container_element)
            .setName("Output handling mode")
            .setDesc("Set to 'Realtime' if your shell command runs for a long time AND you want output handling to start as soon as any outputted content is available. Output channels might be used multiple times during a single process. 'Wait until finished' postpones output handling until all output is received, and handles it as a single bunch. If uncertain, use the traditional 'Wait until finished'.")
            .addDropdown(dropdown => dropdown
            .addOptions({
            "buffered": "Wait until finished",
            "realtime": "Realtime (experimental)",
        })
            .setValue(this.t_shell_command.getConfiguration().output_handling_mode)
            .onChange(async (newMode) => {
            this.t_shell_command.getConfiguration().output_handling_mode = newMode;
            await this.plugin.saveSettings();
        }))
            // Documentation link
            .addExtraButton(icon => icon
            .setIcon("help")
            .onClick(() => gotoURL(DocumentationOutputHandlingModeLink))
            .setTooltip("Documentation: Output handling mode"));
        // Order of output channels
        new obsidian.Setting(container_element)
            .setName("Order of stdout/stderr output")
            .setDesc("When output contains both errors and normal output, which one should be presented first? (Only matters if 'Output handling' is 'Wait until finished').")
            .addDropdown(dropdown => dropdown
            .addOptions({
            "stdout-first": "Stdout first, then stderr.",
            "stderr-first": "Stderr first, then stdout.",
        })
            .setValue(this.t_shell_command.getOutputChannelOrder())
            .onChange(async (value) => {
            this.t_shell_command.getConfiguration().output_channel_order = value;
            await this.plugin.saveSettings();
        }));
        // Focus on the stdout channel dropdown field
        stdout_channel_setting.controlEl.find("select").addClass("SC-focus-element-on-tab-opening");
        // Ignore errors field
        new obsidian.Setting(container_element)
            .setName("Ignore error codes")
            .setDesc("A comma separated list of numbers. If executing a shell command fails with one of these exit codes, no error message will be displayed, and the above stderr channel will be ignored. Stdout channel will still be used for stdout. Error codes must be integers and greater than or equal to 0. Anything else will be removed. Note: If 'Output handling' is 'Realtime', no exit code based ignoring can be done, as an error code is only received when a shell command process finishes.")
            .addText(text => text
            .setValue(this.t_shell_command.getIgnoreErrorCodes().join(","))
            .onChange(async (value) => {
            // Parse the string of comma separated numbers
            const ignore_error_codes = [];
            const raw_error_codes = value.split(",");
            for (const i in raw_error_codes) {
                const raw_error_code = raw_error_codes[i];
                const error_code_candidate = parseInt(raw_error_code.trim()); // E.g. an empty string converts to NaN (= Not a Number).
                // Ensure that the error code is not NaN, 0 or a negative number.
                if (!isNaN(error_code_candidate) && error_code_candidate >= 0) {
                    // The candidate is legit.
                    ignore_error_codes.push(error_code_candidate);
                }
            }
            // Save the validated error numbers
            this.t_shell_command.getConfiguration().ignore_error_codes = ignore_error_codes;
            await this.plugin.saveSettings();
            // Update icon
            const icon_container = this.name_setting.nameEl.find("span.shell-commands-ignored-error-codes-icon-container");
            if (this.t_shell_command.getIgnoreErrorCodes().length) {
                // Show icon
                icon_container.setAttr("aria-label", generateIgnoredErrorCodesIconTitle(this.t_shell_command.getIgnoreErrorCodes()));
                icon_container.removeClass("SC-hide");
            }
            else {
                // Hide icon
                icon_container.addClass("SC-hide");
            }
        }));
    }
    tabEnvironments(container_element) {
        // Platform specific shell commands
        let platform_id;
        let is_first = true;
        for (platform_id in PlatformNames) {
            const setting_group = createPlatformSpecificShellCommandField(this.plugin, container_element, this.t_shell_command, platform_id, this.plugin.settings.show_autocomplete_menu);
            if (is_first) {
                // Focus on the first OS specific shell command field
                setting_group.shell_command_setting.controlEl.find("textarea").addClass("SC-focus-element-on-tab-opening");
                is_first = false;
            }
        }
        // Platform specific shell selection
        createShellSelectionField(this.plugin, container_element, this.t_shell_command.getShells(), false);
    }
    tabEvents(container_element) {
        // Command palette
        const command_palette_availability_setting = new obsidian.Setting(container_element)
            .setName("Availability in Obsidian's command palette")
            .addDropdown(dropdown => dropdown
            .addOptions(CommandPaletteOptions)
            .setValue(this.t_shell_command.getConfiguration().command_palette_availability)
            .onChange(async (value) => {
            // Store value
            this.t_shell_command.getConfiguration().command_palette_availability = value;
            // Update command palette
            if (this.t_shell_command.canAddToCommandPalette()) {
                // Register to command palette
                this.t_shell_command.registerToCommandPalette();
            }
            else {
                // Unregister from command palette
                this.t_shell_command.unregisterFromCommandPalette();
            }
            // Save
            await this.plugin.saveSettings();
        }));
        // Focus on the command palette availability field
        command_palette_availability_setting.controlEl.find("select").addClass("SC-focus-element-on-tab-opening");
        // Events
        new obsidian.Setting(container_element)
            .setName("Execute this shell command automatically when:")
            .setHeading() // Make the name bold
        ;
        getSC_Events(this.plugin).forEach((sc_event) => {
            const is_event_enabled = this.t_shell_command.isSC_EventEnabled(sc_event.static().getCode());
            const setting = new obsidian.Setting(container_element)
                .setName(sc_event.static().getTitle())
                .addToggle(toggle => toggle
                .setValue(is_event_enabled)
                .onChange(async (enable) => {
                if (enable) {
                    // Enable the event
                    this.t_shell_command.enableSC_Event(sc_event);
                    extra_settings_container.style.display = "block"; // Show extra settings
                }
                else {
                    // Disable the event
                    this.t_shell_command.disableSC_Event(sc_event);
                    extra_settings_container.style.display = "none"; // Hide extra settings
                }
                // Save
                await this.plugin.saveSettings();
            }))
                // Documentation icon
                .addExtraButton(icon => icon
                .setIcon("help")
                .onClick(() => gotoURL(sc_event.static().getDocumentationLink()))
                .setTooltip("Documentation: " + sc_event.static().getTitle() + " event"));
            // Mention additional variables (if any)
            if (sc_event.createSummaryOfEventVariables(setting.descEl)) {
                setting.descEl.insertAdjacentText("afterbegin", "Additional variables: ");
            }
            // Extra settings
            const extra_settings_container = container_element.createDiv();
            extra_settings_container.style.display = is_event_enabled ? "block" : "none";
            sc_event.createExtraSettingsFields(extra_settings_container, this.t_shell_command);
        });
    }
    tabVariables(containerElement) {
        // Default values for variables
        new obsidian.Setting(containerElement)
            .setName("Default values for variables")
            .setDesc("Certain variables can be inaccessible during certain situations, e.g. {{file_name}} is not available when no file pane is focused. You can define default values that will be used when a variable is otherwise unavailable.")
            .setHeading();
        createVariableDefaultValueFields(this.plugin, containerElement, this.t_shell_command);
    }
    activateTab(tab_id) {
        if (undefined === this.tab_structure.buttons[tab_id]) {
            throw Error("Invalid tab id: " + tab_id);
        }
        this.tab_structure.buttons[tab_id].click();
    }
    newOutputChannelSetting(container_element, title, output_stream_name, description = "") {
        const output_channel_options = getOutputChannelsOptionList(output_stream_name);
        return new obsidian.Setting(container_element)
            .setName(title)
            .setDesc(description)
            .addDropdown(dropdown => dropdown
            .addOptions(output_channel_options)
            .setValue(this.t_shell_command.getOutputChannels()[output_stream_name])
            .onChange(async (value) => {
            this.t_shell_command.getConfiguration().output_channels[output_stream_name] = value;
            await this.plugin.saveSettings();
        }));
    }
    newOutputWrapperSetting(container_element, title, output_stream_name, description = "") {
        const output_wrapper_options = {};
        this.plugin.getOutputWrappers().forEach((output_wrapper) => {
            output_wrapper_options[output_wrapper.getID()] = output_wrapper.getTitle();
        });
        const output_wrappers = this.t_shell_command.getConfiguration().output_wrappers;
        let old_selected_output_wrapper_option = output_wrappers[output_stream_name] ?? "no-output-wrapper";
        return new obsidian.Setting(container_element)
            .setName(title)
            .setDesc(description)
            .addDropdown(dropdown_component => dropdown_component
            .addOption("no-output-wrapper", "No " + output_stream_name + " wrapper")
            .addOptions(output_wrapper_options)
            .addOption("new", "Create a new output wrapper")
            .setValue(old_selected_output_wrapper_option)
            .onChange(async (output_wrapper_id) => {
            switch (output_wrapper_id) {
                case "new": {
                    // Create a new OutputWrapper.
                    const output_wrapper_model = getModel(OutputWrapperModel.name);
                    const new_output_wrapper = output_wrapper_model.newInstance(this.plugin.settings);
                    this.plugin.saveSettings().then(() => {
                        const modal = new OutputWrapperSettingsModal(this.plugin, new_output_wrapper, undefined, "Create output wrapper", async () => {
                            // Output wrapper is created.
                            dropdown_component.addOption(new_output_wrapper.getID(), new_output_wrapper.getTitle());
                            dropdown_component.setValue(new_output_wrapper.getID());
                            output_wrappers[output_stream_name] = new_output_wrapper.getID();
                            await this.plugin.saveSettings();
                            old_selected_output_wrapper_option = dropdown_component.getValue();
                        }, async () => {
                            // Prompt creation was cancelled.
                            dropdown_component.setValue(old_selected_output_wrapper_option); // Reset the dropdown selection.
                            output_wrapper_model.deleteInstance(new_output_wrapper);
                            await this.plugin.saveSettings();
                        });
                        modal.open();
                    });
                    break;
                }
                case "no-output-wrapper": {
                    // Disable output wrapper.
                    output_wrappers[output_stream_name] = null;
                    await this.plugin.saveSettings();
                    break;
                }
                default: {
                    // Use an existing output wrapper.
                    output_wrappers[output_stream_name] = output_wrapper_id;
                    await this.plugin.saveSettings();
                    break;
                }
            }
        }));
    }
    approve() {
        // No need to perform any action, just close the modal.
        this.close();
    }
}
ExtraOptionsModal.GENERAL_OPTIONS_SUMMARY = "Alias, Icon, Confirmation, Stdin";
ExtraOptionsModal.PREACTIONS_OPTIONS_SUMMARY = "Preactions: Prompt for asking values from user";
ExtraOptionsModal.OUTPUT_OPTIONS_SUMMARY = "Stdout/stderr handling, Ignore errors";
ExtraOptionsModal.ENVIRONMENTS_OPTIONS_SUMMARY = "Shell selection, Operating system specific shell commands";
ExtraOptionsModal.EVENTS_SUMMARY = "Events";
ExtraOptionsModal.VARIABLES_SUMMARY = "Default values for variables";

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
/**
 * TODO: Rename to DeleteShellCommandModal
 */
class DeleteModal extends SC_Modal {
    constructor(plugin, shell_command_id, setting_group, shell_command_element) {
        super(plugin);
        this.shell_command_id = shell_command_id;
        this.t_shell_command = plugin.getTShellCommands()[shell_command_id];
        this.setting_group = setting_group;
        this.shell_command_element = shell_command_element;
    }
    onOpen() {
        super.onOpen();
        this.modalEl.createEl("h2", { text: "Delete: " + this.t_shell_command.getShellCommand() }); // TODO: Use this.setTitle() instead.
        if (this.t_shell_command.getAlias()) {
            this.modalEl.createEl("p", { text: "Alias: " + this.t_shell_command.getAlias() });
        }
        this.modalEl.createEl("p", { text: "Are you sure you want to delete this shell command?" });
        const delete_button = this.modalEl.createEl("button", { text: "Yes, delete" });
        delete_button.onclick = async () => this.approve();
    }
    async approve() {
        // Unregister possible events in order to prevent them becoming ghosts that just keep executing even after removing the configuration.
        this.t_shell_command.unregisterSC_Events();
        // Remove the command
        debugLog("Command " + this.shell_command_id + " gonna be removed.");
        this.t_shell_command.unregisterFromCommandPalette(); // Remove from the command palette.
        delete this.plugin.getTShellCommands()[this.shell_command_id]; // Remove the TShellCommand object.
        // Remove from the plugin's settings.
        const shellCommandIndex = this.plugin.getShellCommandConfigurationIndex(this.shell_command_id);
        // Index probably always exists, but check just in case. Will make TypeScript compiler happy. :)
        if (undefined == shellCommandIndex) {
            throw new Error("Shell command deletion failed. Did not get shell command index in settings container.");
        }
        this.plugin.settings.shell_commands.splice(shellCommandIndex, 1);
        // Remove the setting fields
        this.shell_command_element.remove();
        await this.plugin.saveSettings();
        debugLog("Command removed.");
        this.close();
    }
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
/**
 *
 * @param plugin
 * @param container_element
 * @param setting_tab
 * @param shell_command_id Either a string formatted integer ("0", "1" etc) or "new" if it's a field for a command that does not exist yet.
 * @param show_autocomplete_menu
 */
function createShellCommandField(plugin, container_element, setting_tab, shell_command_id, show_autocomplete_menu) {
    const is_new = "new" === shell_command_id;
    let t_shell_command;
    if (is_new) {
        // Create an empty command
        t_shell_command = plugin.newTShellCommand();
        shell_command_id = t_shell_command.getId(); // Replace "new" with a real id.
    }
    else {
        // Use an old shell command
        t_shell_command = plugin.getTShellCommands()[shell_command_id];
    }
    debugLog("Create command field for command #" + shell_command_id + (is_new ? " (NEW)" : ""));
    let shell_command;
    if (is_new) {
        shell_command = "";
    }
    else {
        shell_command = t_shell_command.getDefaultShellCommand();
    }
    // Wrap all shell command setting elements in a single div.
    const shell_command_element = container_element.createDiv();
    shell_command_element.addClass("SC-id-" + shell_command_id);
    const setting_group = CreateShellCommandFieldCore(plugin, shell_command_element, generateShellCommandFieldIconAndName(t_shell_command), shell_command, t_shell_command.getShell(), t_shell_command, show_autocomplete_menu, async (shell_command) => {
        if (is_new) {
            debugLog("Creating new command " + shell_command_id + ": " + shell_command);
        }
        else {
            debugLog("Command " + shell_command_id + " gonna change to: " + shell_command);
        }
        // Do this in both cases, when creating a new command and when changing an old one:
        t_shell_command.getConfiguration().platform_specific_commands.default = shell_command;
        if (is_new) {
            // Create a new command
            // plugin.registerShellCommand(t_shell_command); // I don't think this is needed to be done anymore
            debugLog("Command created.");
        }
        else {
            // Change an old command
            t_shell_command.renameObsidianCommand(t_shell_command.getShellCommand(), t_shell_command.getAlias()); // Change the command's name in Obsidian's command palette and in hotkey settings.
            debugLog("Command changed.");
        }
        await plugin.saveSettings();
    });
    setting_tab.setting_groups[shell_command_id] = setting_group;
    // Primary icon buttons
    setting_group.name_setting
        .addExtraButton(button => button
        .setTooltip("Normal click: Execute now. " + CmdOrCtrl() + " + click: Execute and ask what to do with output.")
        .setIcon("run-command")
        .extraSettingsEl.addEventListener("click", async (event) => {
        const ctrl_clicked = event.ctrlKey;
        // Execute the shell command now (for trying it out in the settings)
        const parsing_process = t_shell_command.createParsingProcess(null); // No SC_Event is available when executing shell commands manually.
        if (await parsing_process.process()) {
            const executor = new ShellCommandExecutor(plugin, t_shell_command, null); // No SC_Event is available when manually executing the shell command.
            await executor.doPreactionsAndExecuteShellCommand(parsing_process, ctrl_clicked ? "modal" : undefined // If ctrl/cmd is pressed, override output channels with 'Ask after execution' modal. Otherwise, use undefined to indicate that the shell command's normal output channels should be used.
            );
        }
        else {
            parsing_process.displayErrorMessages();
        }
    }))
        .addExtraButton(button => button
        .setTooltip(ExtraOptionsModal.GENERAL_OPTIONS_SUMMARY)
        .onClick(async () => {
        // Open an extra options modal: General tab
        const modal = new ExtraOptionsModal(plugin, shell_command_id, setting_tab);
        modal.open();
        modal.activateTab("extra-options-general");
    }))
        .addExtraButton(button => button
        .setTooltip(ExtraOptionsModal.PREACTIONS_OPTIONS_SUMMARY)
        .setIcon("note-glyph")
        .onClick(async () => {
        // Open an extra options modal: Preactions tab
        const modal = new ExtraOptionsModal(plugin, shell_command_id, setting_tab);
        modal.open();
        modal.activateTab("extra-options-preactions");
    }))
        .addExtraButton(button => button
        .setTooltip(ExtraOptionsModal.OUTPUT_OPTIONS_SUMMARY)
        .setIcon("lines-of-text")
        .onClick(async () => {
        // Open an extra options modal: Output tab
        const modal = new ExtraOptionsModal(plugin, shell_command_id, setting_tab);
        modal.open();
        modal.activateTab("extra-options-output");
    }))
        .addExtraButton(button => button
        .setTooltip(ExtraOptionsModal.ENVIRONMENTS_OPTIONS_SUMMARY)
        .setIcon("stacked-levels")
        .onClick(async () => {
        // Open an extra options modal: Environments tab
        const modal = new ExtraOptionsModal(plugin, shell_command_id, setting_tab);
        modal.open();
        modal.activateTab("extra-options-environments");
    }))
        .addExtraButton(button => button
        .setTooltip(ExtraOptionsModal.EVENTS_SUMMARY)
        .setIcon("dice")
        .onClick(async () => {
        // Open an extra options modal: Events tab
        const modal = new ExtraOptionsModal(plugin, shell_command_id, setting_tab);
        modal.open();
        modal.activateTab("extra-options-events");
    }))
        .addExtraButton(button => button
        .setTooltip(ExtraOptionsModal.VARIABLES_SUMMARY)
        .setIcon("code-glyph")
        .onClick(async () => {
        // Open an extra options modal: Variables tab
        const modal = new ExtraOptionsModal(plugin, shell_command_id, setting_tab);
        modal.open();
        modal.activateTab("extra-options-variables");
    }))
        .addExtraButton(button => button
        .setTooltip("Delete this shell command")
        .setIcon("trash")
        .onClick(async () => {
        // Open a delete modal
        const modal = new DeleteModal(plugin, shell_command_id, setting_group, shell_command_element);
        modal.open();
    }));
    // Informational icons (= non-clickable)
    const icon_container = setting_group.name_setting.nameEl.createEl("span", { attr: { class: "SC-main-icon-container" } });
    // "Ask confirmation" icon.
    const confirm_execution_icon_container = icon_container.createEl("span", { attr: { "aria-label": "Asks confirmation before execution.", class: "shell-commands-confirm-execution-icon-container" } });
    obsidian.setIcon(confirm_execution_icon_container, "languages");
    if (!t_shell_command.getConfirmExecution()) {
        // Do not display the icon for commands that do not use confirmation.
        confirm_execution_icon_container.addClass("SC-hide");
    }
    // "Ignored error codes" icon
    const ignored_error_codes_icon_container = icon_container.createEl("span", { attr: { "aria-label": generateIgnoredErrorCodesIconTitle(t_shell_command.getIgnoreErrorCodes()), class: "shell-commands-ignored-error-codes-icon-container" } });
    obsidian.setIcon(ignored_error_codes_icon_container, "strikethrough-glyph");
    if (!t_shell_command.getIgnoreErrorCodes().length) {
        // Do not display the icon for commands that do not ignore any errors.
        ignored_error_codes_icon_container.addClass("SC-hide");
    }
    // Secondary icon buttons
    setting_group.preview_setting.addExtraButton(button => button
        .setIcon("link")
        .setTooltip("Copy this shell command's Obsidian URI to the clipboard. Visiting the URI executes the shell command. " + CmdOrCtrl() + " + click: Copy a markdown link.")
        // onClick() handler - use a custom one instead of ExtraButtonComponent.onClick(), because Obsidian API (at least v. 0.14.8) does not support detecting CTRL press. https://forum.obsidian.md/t/fr-settings-pass-mouseevent-to-extrabuttoncomponent-onclick/37177
        .extraSettingsEl.addEventListener("click", (event) => {
        const ctrl_clicked = event.ctrlKey;
        const execution_uri = t_shell_command.getExecutionURI();
        let result;
        if (ctrl_clicked) {
            // A full link is wanted.
            result = `[${escapeMarkdownLinkCharacters(t_shell_command.getAlias())}](${escapeMarkdownLinkCharacters(execution_uri)})`;
        }
        else {
            // Only the URI is wanted.
            result = execution_uri;
        }
        copyToClipboard(result);
        plugin.newNotification("Copied to clipboard: " + os.EOL + result);
    }));
    if (t_shell_command.canHaveHotkeys()) {
        setting_group.preview_setting.addExtraButton(button => button
            .setIcon("any-key")
            .setTooltip("Go to hotkey settings.")
            .onClick(() => {
            // The most important parts of this closure function are copied 2022-04-27 from https://github.com/pjeby/hotkey-helper/blob/c8a032e4c52bd9ce08cb909cec15d1ed9d0a3439/src/plugin.js#L436-L442 (also from other lines of the same file).
            // @ts-ignore This is private API access. Not good, but then again the feature is not crucial - if it breaks, it won't interrupt anything important.
            plugin.app.setting?.openTabById("hotkeys");
            // @ts-ignore
            const hotkeys_settings_tab = plugin.app.setting.settingTabs.filter(tab => tab.id === "hotkeys").shift();
            if (hotkeys_settings_tab && hotkeys_settings_tab.searchInputEl && hotkeys_settings_tab.updateHotkeyVisibility) {
                debugLog("Hotkeys: Filtering by shell command " + t_shell_command.getObsidianCommand().name);
                hotkeys_settings_tab.searchInputEl.value = t_shell_command.getObsidianCommand().name;
                hotkeys_settings_tab.updateHotkeyVisibility();
            }
            else {
                debugLog("Hotkeys: Cannot do filtering due to API changes.");
            }
        }));
    }
    // Add hotkey information
    if (!is_new && t_shell_command.canHaveHotkeys()) {
        const hotkeys = getHotkeysForShellCommand(plugin, shell_command_id);
        if (hotkeys) {
            let hotkeys_joined = "";
            hotkeys.forEach((hotkey) => {
                if (hotkeys_joined) {
                    hotkeys_joined += "<br>";
                }
                hotkeys_joined += HotkeyToString(hotkey);
            });
            const hotkey_div = setting_group.preview_setting.controlEl.createEl("div", { attr: { class: "setting-item-description SC-hotkey-info" } });
            // Comment out the icon because it would look like a clickable button (as there are other clickable icons in the settings).
            // setIcon(hotkey_div, "any-key", 22); // Hotkey icon
            hotkey_div.insertAdjacentHTML("beforeend", " " + hotkeys_joined);
        }
    }
    debugLog("Created.");
}
/**
 * @param t_shell_command
 * @public Exported because ShellCommandExtraOptionsModal uses this too.
 */
function generateShellCommandFieldIconAndName(t_shell_command) {
    const icon_html = t_shell_command.getIconHTML() + " ";
    if (t_shell_command.getAlias()) {
        return icon_html + t_shell_command.getAlias();
    }
    return icon_html + "Shell command without alias";
}
/**
 * @param ignored_error_codes
 * @public Exported because ShellCommandExtraOptionsModal uses this too.
 */
function generateIgnoredErrorCodesIconTitle(ignored_error_codes) {
    const plural = ignored_error_codes.length !== 1 ? "s" : "";
    return "Ignored error" + plural + ": " + ignored_error_codes.join(",");
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class SC_MainSettingsTab extends obsidian.PluginSettingTab {
    constructor(app, plugin) {
        super(app, plugin);
        this.setting_groups = {};
        this.last_position = {
            scroll_position: 0,
            tab_name: "main-shell-commands",
        };
        this.plugin = plugin;
    }
    display() {
        const { containerEl } = this;
        containerEl.empty();
        this.tab_structure = createTabs(containerEl, {
            "main-shell-commands": {
                title: "Shell commands",
                icon: "run-command",
                content_generator: (container_element) => {
                    this.tabShellCommands(container_element);
                },
            },
            "main-environments": {
                title: "Environments",
                icon: "stacked-levels",
                content_generator: (container_element) => {
                    this.tabEnvironments(container_element);
                },
            },
            "main-preactions": {
                title: "Preactions",
                icon: "note-glyph",
                content_generator: (container_element) => {
                    this.tabPreactions(container_element);
                },
            },
            "main-output": {
                title: "Output",
                icon: "lines-of-text",
                content_generator: (container_element) => {
                    this.tabOutput(container_element);
                },
            },
            "main-events": {
                title: "Events",
                icon: "dice",
                content_generator: (container_element) => {
                    this.tabEvents(container_element);
                },
            },
            "main-variables": {
                title: "Variables",
                icon: "code-glyph",
                content_generator: (container_element) => {
                    this.tabVariables(container_element);
                },
            },
        });
        // Documentation link & GitHub links
        containerEl.createEl("p").insertAdjacentHTML("beforeend", "<a href=\"" + DocumentationMainLink + "\">Documentation</a> - " +
            "<a href=\"" + GitHubLink + "\">SC on GitHub</a> - " +
            "<a href=\"" + ChangelogLink + "\">SC version: " + this.plugin.getPluginVersion() + "</a>");
        // Copyright notice
        const copyright_paragraph = containerEl.createEl("p");
        copyright_paragraph.addClass("SC-small-font");
        copyright_paragraph.insertAdjacentHTML("beforeend", `
            <em>Shell commands</em> plugin Copyright &copy; 2021 - 2023 Jarkko Linnanvirta. This program comes with ABSOLUTELY NO WARRANTY. This is free software, and you are welcome to redistribute it under certain conditions. See more information in the license: <a href="${LicenseLink}">GNU GPL-3.0</a>.
        `);
        // KEEP THIS AFTER CREATING ALL ELEMENTS:
        this.rememberLastPosition(containerEl);
    }
    tabShellCommands(container_element) {
        // Show a search field
        this.createSearchField(container_element);
        // A <div> element for all command input fields. New command fields can be created at the bottom of this element.
        const command_fields_container = container_element.createEl("div");
        // Fields for modifying existing commands
        let shell_commands_exist = false;
        for (const command_id in this.plugin.getTShellCommands()) {
            createShellCommandField(this.plugin, command_fields_container, this, command_id, this.plugin.settings.show_autocomplete_menu);
            shell_commands_exist = true;
        }
        // 'No shell commands yet' paragraph.
        const no_shell_commands_paragraph = container_element.createEl("p", { text: "No shell commands yet, click the 'New shell command' button below." });
        if (shell_commands_exist) {
            // Shell commands exist, so do not show the "No shell commands yet" text.
            no_shell_commands_paragraph.hide();
        }
        // "New command" button
        new obsidian.Setting(container_element)
            .addButton(button => button
            .setButtonText("New shell command")
            .onClick(async () => {
            createShellCommandField(this.plugin, command_fields_container, this, "new", this.plugin.settings.show_autocomplete_menu);
            no_shell_commands_paragraph.hide();
            debugLog("New empty command created.");
        }));
    }
    createSearchField(container_element) {
        const search_container = container_element.createDiv();
        const search_title = "Search shell commands";
        const search_setting = new obsidian.Setting(search_container)
            .setName(search_title)
            .setDesc("Looks up shell commands' aliases, commands, ids and icons.")
            .addSearch(search_component => search_component
            .onChange((search_term) => {
            let count_matches = 0;
            for (const shell_command_id in this.plugin.getTShellCommands()) {
                let matched = false;
                // Check if a search term was defined.
                if ("" == search_term) {
                    // Show all shell commands.
                    matched = true;
                }
                else {
                    // A search term is defined.
                    // Define fields where to look for the search term
                    const t_shell_command = this.plugin.getTShellCommands()[shell_command_id];
                    const search_targets = [
                        t_shell_command.getId(),
                        t_shell_command.getConfiguration().alias,
                    ];
                    search_targets.push(...Object.values(t_shell_command.getPlatformSpecificShellCommands()));
                    // Only include icon in the search if it's defined.
                    const icon = t_shell_command.getConfiguration().icon;
                    if (icon) {
                        search_targets.push(icon);
                    }
                    // Check if it's a match
                    search_targets.forEach((search_target) => {
                        if (search_target.toLocaleLowerCase().contains(search_term.toLocaleLowerCase())) {
                            matched = true;
                            debugLog("Search " + search_term + " MATCHED " + search_target);
                        }
                    });
                }
                // Show or hide the shell command.
                const shell_command_element = document.querySelector("div.SC-id-" + shell_command_id);
                if (!shell_command_element) {
                    throw new Error("Shell command setting element does not exist with selector div.SC-id-" + shell_command_id);
                }
                if (matched) {
                    shell_command_element.removeClass("SC-hide");
                    count_matches++;
                }
                else {
                    shell_command_element.addClass("SC-hide");
                }
            }
            // Display match count
            if ("" == search_term) {
                // Don't show match count.
                search_setting.setName(search_title);
            }
            else {
                // Show match count.
                switch (count_matches) {
                    case 0: {
                        search_setting.setName("No matches");
                        break;
                    }
                    case 1: {
                        search_setting.setName("1 match");
                        break;
                    }
                    default: {
                        search_setting.setName(count_matches + " matches");
                        break;
                    }
                }
            }
        }).then((search_component) => {
            // Focus on the search field.
            search_component.inputEl.addClass("SC-focus-element-on-tab-opening");
        }));
    }
    tabEvents(container_element) {
        // A general description about events
        container_element.createEl("p", { text: "Events introduce a way to execute shell commands automatically in certain situations, e.g. when Obsidian starts. They are set up for each shell command separately, but this tab contains general options for them." });
        // Enable/disable all events
        new obsidian.Setting(container_element)
            .setName("Enable events")
            .setDesc("This is a quick way to immediately turn off all events, if you want.")
            .addToggle(toggle => toggle
            .setValue(this.plugin.settings.enable_events)
            .onChange(async (enable_events) => {
            // The toggle was clicked.
            this.plugin.settings.enable_events = enable_events;
            if (enable_events) {
                // Register events.
                this.plugin.registerSC_Events(true);
            }
            else {
                // Unregister events.
                this.plugin.unregisterSC_Events();
            }
            await this.plugin.saveSettings();
        }));
        // A list of current enable events
        container_element.createEl("p", { text: "The following gives just a quick glance over which events are enabled on which shell commands. To enable/disable events for a shell command, go to the particular shell command's settings via the 'Shell commands' tab. The list is only updated when you reopen the whole settings panel." });
        let found_enabled_event = false;
        getSC_Events(this.plugin).forEach((sc_event) => {
            const event_enabled_t_shell_commands = sc_event.getTShellCommands();
            // Has the event been enabled for any shell commands?
            if (event_enabled_t_shell_commands.length) {
                // Yes, it's enabled.
                // Show a list of shell commands
                const paragraph_element = container_element.createEl("p", { text: sc_event.static().getTitle() });
                const list_element = paragraph_element.createEl("ul");
                event_enabled_t_shell_commands.forEach((t_shell_command) => {
                    list_element.createEl("li", { text: t_shell_command.getAliasOrShellCommand() });
                });
                found_enabled_event = true;
            }
        });
        if (!found_enabled_event) {
            container_element.createEl("p", { text: "No events are enabled for any shell commands." });
        }
    }
    tabVariables(container_element) {
        // "Preview variables in command palette" field
        new obsidian.Setting(container_element)
            .setName("Preview variables in command palette and menus")
            .setDesc("If on, variable names are substituted with their realtime values when you view your commands in the command palette and right click context menus (if used). A nice way to ensure your commands will use correct values.")
            .addToggle(checkbox => checkbox
            .setValue(this.plugin.settings.preview_variables_in_command_palette)
            .onChange(async (value) => {
            debugLog("Changing preview_variables_in_command_palette to " + value);
            this.plugin.settings.preview_variables_in_command_palette = value;
            await this.plugin.saveSettings();
        }));
        // "Show autocomplete menu" field
        new obsidian.Setting(container_element)
            .setName("Show autocomplete menu")
            .setDesc("If on, a dropdown menu shows up when you begin writing {{variable}} names, showing matching variables and their instructions. Also allows defining custom suggestions in autocomplete.yaml file - see the documentation.")
            .addToggle(checkbox => checkbox
            .setValue(this.plugin.settings.show_autocomplete_menu)
            .onChange(async (value) => {
            debugLog("Changing show_autocomplete_menu to " + value);
            this.plugin.settings.show_autocomplete_menu = value;
            this.display(); // Re-render the whole settings view to apply the change.
            await this.plugin.saveSettings();
        }))
            .addExtraButton(extra_button => extra_button
            .setIcon("help")
            .setTooltip("Documentation: Autocomplete")
            .onClick(() => {
            gotoURL(DocumentationAutocompleteLink);
        }));
        // Custom variables
        new obsidian.Setting(container_element)
            .setName("Custom variables")
            .setHeading() // Make the "Variables" text bold.
            .addExtraButton(extra_button => extra_button
            .setIcon("pane-layout")
            .setTooltip("Open a pane that displays all custom variables and their values.")
            .onClick(() => {
            this.plugin.createCustomVariableView();
        }))
            .addExtraButton(extra_button => extra_button
            .setIcon("help")
            .setTooltip("Documentation: Custom variables")
            .onClick(() => {
            gotoURL(DocumentationCustomVariablesLink);
        }));
        // Settings for each CustomVariable
        const custom_variable_model = getModel(CustomVariableModel.name);
        const custom_variable_container = container_element.createDiv();
        this.plugin.getCustomVariableInstances().forEach((custom_variable_instance) => {
            custom_variable_model.createSettingFields(custom_variable_instance, custom_variable_container);
        });
        createNewModelInstanceButton(this.plugin, CustomVariableModel.name, container_element, custom_variable_container, this.plugin.settings).then();
        // Built-in variable instructions
        new obsidian.Setting(container_element)
            .setName("Built-in variables")
            .setHeading() // Make the "Variables" text bold.
            .addExtraButton(extra_button => extra_button
            .setIcon("help")
            .setTooltip("Documentation: Built-in variables")
            .onClick(() => {
            gotoURL(DocumentationBuiltInVariablesIndexLink);
        }));
        for (const variable of this.plugin.getVariables()) {
            if (!(variable instanceof CustomVariable)) {
                const variableSettingGroupElement = container_element.createDiv();
                variableSettingGroupElement.addClass("SC-setting-group");
                // Variable name and documentation link
                const variableHeadingSetting = new obsidian.Setting(variableSettingGroupElement) // Use container_element instead of variableSettingGroup.
                    .setHeading()
                    .addExtraButton(extraButton => extraButton
                    .setIcon("help")
                    .setTooltip("Documentation: " + variable.getFullName() + " variable")
                    .onClick(() => gotoURL(variable.getDocumentationLink())));
                variableHeadingSetting.nameEl.insertAdjacentHTML("afterbegin", variable.getHelpName());
                // Variable description
                const variableDescriptionSetting = new obsidian.Setting(variableSettingGroupElement)
                    .setClass("SC-full-description") // Without this, description would be shrunk to 50% of space. This setting does not have control elements, so 100% width is ok.
                ;
                variableDescriptionSetting.descEl.insertAdjacentHTML("afterbegin", variable.help_text);
                const availability_text = variable.getAvailabilityText();
                if (availability_text) {
                    variableDescriptionSetting.descEl.insertAdjacentHTML("beforeend", "<br>" + availability_text);
                }
                // Variable default value
                const defaultValueSettingTitle = "Default value for " + variable.getFullName();
                if (variable.isAlwaysAvailable()) {
                    new obsidian.Setting(variableSettingGroupElement)
                        .setName(defaultValueSettingTitle)
                        .setDesc(variable.getFullName() + " is always available, so it cannot have a default value.");
                }
                else {
                    createVariableDefaultValueField(this.plugin, variableSettingGroupElement, defaultValueSettingTitle, variable);
                }
            }
        }
        container_element.createEl("p", { text: "When you type variables into commands, a preview text appears under the command field to show how the command will look like when it gets executed with variables substituted with their real values." });
        container_element.createEl("p", { text: "Special characters in variable values are tried to be escaped (except if you use CMD as the shell in Windows). This is to improve security so that a variable won't accidentally cause bad things to happen. If you want to use a raw, unescaped value, add an exclamation mark before the variable's name, e.g. {{!title}}, but be careful, it's dangerous!" });
        container_element.createEl("p", { text: "There is no way to prevent variable parsing. If you need {{ }} characters in your command, they won't be parsed as variables as long as they do not contain any of the variable names listed above. If you need to pass e.g. {{title}} literally to your command, there is no way to do it atm, please create a discussion in GitHub." });
        container_element.createEl("p", { text: "All variables that access the current file, may cause the command preview to fail if you had no file panel active when you opened the settings window - e.g. you had focus on graph view instead of a note = no file is currently active. But this does not break anything else than the preview." });
    }
    tabEnvironments(container_element) {
        // "Working directory" field
        new obsidian.Setting(container_element)
            .setName("Working directory")
            .setDesc("A directory where your commands will be run. If empty, defaults to your vault's location. Can be relative (= a folder in the vault) or absolute (= complete from filesystem root).")
            .addText(text => text
            .setPlaceholder(getVaultAbsolutePath(this.app))
            .setValue(this.plugin.settings.working_directory)
            .onChange(async (value) => {
            debugLog("Changing working_directory to " + value);
            this.plugin.settings.working_directory = value;
            await this.plugin.saveSettings();
        }));
        // Platforms' default shells
        createShellSelectionField(this.plugin, container_element, this.plugin.settings.default_shells, true);
        // PATH environment variable fields
        createPATHAugmentationFields(this.plugin, container_element, this.plugin.settings.environment_variable_path_augmentations);
    }
    tabPreactions(container_element) {
        // Prompts
        const prompt_model = getModel(PromptModel.name);
        new obsidian.Setting(container_element)
            .setName("Prompts")
            .setHeading() // Make the "Prompts" text to appear as a heading.
        ;
        const prompts_container_element = container_element.createDiv();
        this.plugin.getPrompts().forEach((prompt) => {
            prompt_model.createSettingFields(prompt, prompts_container_element);
        });
        // 'New prompt' button
        const new_prompt_button_promise = createNewModelInstanceButton(this.plugin, PromptModel.name, container_element, prompts_container_element, this.plugin.settings);
        new_prompt_button_promise.then((result) => {
            prompt_model.openSettingsModal(result.instance, result.main_setting); // Open the prompt settings modal, as the user will probably want to configure it now anyway.
        });
    }
    tabOutput(container_element) {
        // Output wrappers
        const output_wrapper_model = getModel(OutputWrapperModel.name);
        new obsidian.Setting(container_element)
            .setName("Output wrappers")
            .setHeading() // Make the "Output wrappers" text to appear as a heading.
            .addExtraButton(extra_button => extra_button
            .setIcon("help")
            .setTooltip("Documentation: Output wrappers")
            .onClick(() => gotoURL(DocumentationOutputWrappersLink)));
        const output_wrappers_container_element = container_element.createDiv();
        this.plugin.getOutputWrappers().forEach((output_wrapper) => {
            output_wrapper_model.createSettingFields(output_wrapper, output_wrappers_container_element);
        });
        // 'New output wrapper' button
        const new_output_wrapper_button_promise = createNewModelInstanceButton(this.plugin, OutputWrapperModel.name, container_element, output_wrappers_container_element, this.plugin.settings);
        new_output_wrapper_button_promise.then((result) => {
            output_wrapper_model.openSettingsModal(result.instance, result.main_setting); // Open the output wrapper settings modal, as the user will probably want to configure it now anyway.
        });
        // "Error message duration" field
        this.createNotificationDurationField(container_element, "Error message duration", "Concerns messages about failed shell commands.", "error_message_duration");
        // "Notification message duration" field
        this.createNotificationDurationField(container_element, "Notification message duration", "Concerns informational, non-fatal messages, e.g. output directed to 'Notification balloon'.", "notification_message_duration");
        // "Show a notification when executing shell commands" field
        new obsidian.Setting(container_element)
            .setName("Show a notification when executing shell commands")
            .addDropdown(dropdown_component => dropdown_component
            .addOptions({
            "disabled": "Do not show",
            "quick": "Show for " + this.plugin.settings.notification_message_duration + " seconds",
            "permanent": "Show until the process is finished",
            "if-long": "Show only if executing takes long",
        })
            .setValue(this.plugin.settings.execution_notification_mode)
            .onChange(async (new_execution_notification_mode) => {
            // Save the change.
            this.plugin.settings.execution_notification_mode = new_execution_notification_mode;
            await this.plugin.saveSettings();
        }));
        // "Output channel 'Clipboard' displays a notification message, too" field
        new obsidian.Setting(container_element)
            .setName("Output channel 'Clipboard' displays a notification message, too")
            .setDesc("If a shell command's output is directed to the clipboard, also show the output in a popup box on the top right corner. This helps to notice what was inserted into clipboard.")
            .addToggle(checkbox => checkbox
            .setValue(this.plugin.settings.output_channel_clipboard_also_outputs_to_notification)
            .onChange(async (value) => {
            this.plugin.settings.output_channel_clipboard_also_outputs_to_notification = value;
            await this.plugin.saveSettings();
        }));
    }
    createNotificationDurationField(container_element, title, description, setting_name) {
        new obsidian.Setting(container_element)
            .setName(title)
            .setDesc(description + " In seconds, between 1 and 180.")
            .addText(field => field
            .setValue(String(this.plugin.settings[setting_name]))
            .onChange(async (duration_string) => {
            const duration = parseInt(duration_string);
            if (duration >= 1 && duration <= 180) {
                debugLog("Change " + setting_name + " from " + this.plugin.settings[setting_name] + " to " + duration);
                this.plugin.settings[setting_name] = duration;
                await this.plugin.saveSettings();
                debugLog("Changed.");
            }
            // Don't show a notice if duration is not between 1 and 180, because this function is called every time a user types in this field, so the value might not be final.
        }));
    }
    rememberLastPosition(container_element) {
        const last_position = this.last_position;
        // Go to last position now
        this.tab_structure.buttons[last_position.tab_name].click();
        window.setTimeout(() => {
            container_element.scrollTo({
                top: this.last_position.scroll_position,
                behavior: "auto",
            });
        }, 0); // 'timeout' can be 0 ms, no need to wait any longer.
        // Listen to changes
        container_element.addEventListener("scroll", (event) => {
            this.last_position.scroll_position = container_element.scrollTop;
        });
        for (const tab_name in this.tab_structure.buttons) {
            const button = this.tab_structure.buttons[tab_name];
            button.onClickEvent((event) => {
                last_position.tab_name = tab_name;
            });
        }
    }
}

/**
 * Copied 2021-10-29 from https://gist.github.com/TheDistantSea/8021359
 * Modifications:
 *  - Made compatible with TypeScript by adding type definitions.
 *  - Changed var to let.
 *
 * Compares two software version numbers (e.g. "1.7.1" or "1.2b").
 *
 * This function was born in http://stackoverflow.com/a/6832721.
 *
 * @param {string} v1 The first version to be compared.
 * @param {string} v2 The second version to be compared.
 * @param {object} [options] Optional flags that affect comparison behavior:
 * <ul>
 *     <li>
 *         <tt>lexicographical: true</tt> compares each part of the version strings lexicographically instead of
 *         naturally; this allows suffixes such as "b" or "dev" but will cause "1.10" to be considered smaller than
 *         "1.2".
 *     </li>
 *     <li>
 *         <tt>zeroExtend: true</tt> changes the result if one version string has less parts than the other. In
 *         this case the shorter string will be padded with "zero" parts instead of being considered smaller.
 *     </li>
 * </ul>
 * @returns {number|NaN}
 * <ul>
 *    <li>0 if the versions are equal</li>
 *    <li>a negative integer iff v1 < v2</li>
 *    <li>a positive integer iff v1 > v2</li>
 *    <li>NaN if either version string is in the wrong format</li>
 * </ul>
 *
 * @copyright by Jon Papaioannou (["john", "papaioannou"].join(".") + "@gmail.com")
 * @license This function is in the public domain. Do what you want with it, no strings attached.
 */
function versionCompare(v1, v2, options = {}) {
    let lexicographical = options && options.lexicographical, zeroExtend = options && options.zeroExtend, v1parts = v1.split('.'), v2parts = v2.split('.');
    function isValidPart(x) {
        return (lexicographical ? /^\d+[A-Za-z]*$/ : /^\d+$/).test(x);
    }
    if (!v1parts.every(isValidPart) || !v2parts.every(isValidPart)) {
        return NaN;
    }
    if (zeroExtend) {
        while (v1parts.length < v2parts.length)
            v1parts.push("0");
        while (v2parts.length < v1parts.length)
            v2parts.push("0");
    }
    if (!lexicographical) {
        v1parts = v1parts.map(Number);
        v2parts = v2parts.map(Number);
    }
    for (let i = 0; i < v1parts.length; ++i) {
        if (v2parts.length == i) {
            return 1;
        }
        if (v1parts[i] == v2parts[i]) {
            continue;
        }
        else if (v1parts[i] > v2parts[i]) {
            return 1;
        }
        else {
            return -1;
        }
    }
    if (v1parts.length != v2parts.length) {
        return -1;
    }
    return 0;
}

/*
 * 'Shell commands' plugin for Obsidian.
 * Copyright (C) 2021 - 2023 Jarkko Linnanvirta
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3.0 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Contact the author (Jarkko Linnanvirta): https://github.com/Taitava/
 */
class SC_Plugin extends obsidian.Plugin {
    constructor() {
        super(...arguments);
        this.obsidian_commands = {};
        this.t_shell_commands = {};
        /**
         * Holder for shell commands and aliases, whose variables are parsed before the actual execution during command
         * palette preview. This array gets emptied after every time a shell command is executed via the command palette.
         *
         * This is only used for command palette, not when executing a shell command from the settings panel, nor when
         * executing shell commands via SC_Events.
         *
         * @private
         */
        this.cached_parsing_processes = {};
        this.autocompleteMenus = [];
    }
    async onload() {
        // debugLog('loading plugin'); // Wouldn't do anything, as DEBUG_ON is not set before settings are loaded.
        // Load settings
        if (!await this.loadSettings()) {
            // Loading the settings has failed due to an unsupported settings file version.
            // The plugin should not be used, and it has actually disabled itself, but the code execution needs to be
            // stopped manually.
            return;
        }
        // Now debugLog() can be used.
        debugLog("Loading Shell commands plugin version: " + this.getPluginVersion());
        // Define models
        introduceModels(this);
        // Run possible configuration migrations
        await RunMigrations(this);
        // Generate TShellCommand objects from configuration (only after configuration migrations are done)
        this.loadTShellCommands();
        // Load Prompts
        const prompt_model = getModel(PromptModel.name);
        this.prompts = prompt_model.loadInstances(this.settings);
        // Load CustomVariables (configuration instances)
        const custom_variable_model = getModel(CustomVariableModel.name);
        this.custom_variable_instances = custom_variable_model.loadInstances(this.settings);
        // Load variables (both built-in and custom ones). Do this AFTER loading configs for custom variables!
        this.variables = loadVariables(this);
        // Load output wrappers
        const output_wrapper_model = getModel(OutputWrapperModel.name);
        this.output_wrappers = output_wrapper_model.loadInstances(this.settings);
        // Make all defined shell commands to appear in the Obsidian command palette.
        const shell_commands = this.getTShellCommands();
        for (const shell_command_id in shell_commands) {
            const t_shell_command = shell_commands[shell_command_id];
            if (t_shell_command.canAddToCommandPalette()) {
                this.registerShellCommand(t_shell_command);
            }
        }
        // Perform event registrations, if enabled.
        if (this.settings.enable_events) {
            this.registerSC_Events(false);
        }
        // Load a custom autocomplete list if it exists.
        this.loadCustomAutocompleteList();
        // Create a SettingsTab.
        this.addSettingTab(new SC_MainSettingsTab(this.app, this));
        // Make it possible to create CustomVariableViews.
        this.registerView(CustomVariableView.ViewType, (leaf) => new CustomVariableView(this, leaf));
        // Debug reserved IDs
        debugLog("IDGenerator's reserved IDs:");
        debugLog(getIDGenerator().getReservedIDs());
        // Register an URI handler.
        this.registerURIHandler();
    }
    loadTShellCommands() {
        this.t_shell_commands = {}; // TODO: Consider changing this to either an array or a Map.
        const shell_command_configurations = this.getShellCommandConfigurations();
        for (const shell_command_configuration of shell_command_configurations) {
            this.t_shell_commands[shell_command_configuration.id] = new TShellCommand(this, shell_command_configuration);
        }
    }
    getTShellCommands() {
        return this.t_shell_commands;
    }
    getVariables() {
        return this.variables;
    }
    getPrompts() {
        return this.prompts;
    }
    getCustomVariableInstances() {
        return this.custom_variable_instances;
    }
    getShellCommandConfigurations() {
        return this.settings.shell_commands;
    }
    getOutputWrappers() {
        return this.output_wrappers;
    }
    /**
     * Tries to find an index at which a ShellCommandConfiguration object is located in this.settings.shell_commands.
     * Returns undefined, if it's not found.
     *
     * DO NOT EXPOSE THE INDEX OUTSIDE THE PLUGIN! It's not a stable reference to a shell command, because shell commands
     * can be reordered (well, at least in some future version of the plugin). Always use the ID as a stable, externally
     * safe reference!
     *
     * @param shell_command_id
     */
    getShellCommandConfigurationIndex(shell_command_id) {
        return this.settings.shell_commands.findIndex((shell_command_configuration) => {
            return shell_command_configuration.id == shell_command_id;
        });
    }
    /**
     * Returns an Obsidian URI that complies with the format obsidian://action/?vault=XYZ and that may contain possible
     * custom arguments at the end.
     *
     * Note that if 'action' is 'open' and a 'file' argument is present in 'uri_arguments', the URI will use the shorthand syntax described here: https://help.obsidian.md/Advanced+topics/Using+obsidian+URI#Shorthand+formats
     *
     * @param action
     * @param uri_arguments
     */
    getObsidianURI(action, uri_arguments = {}) {
        const encoded_vault_name = encodeURIComponent(this.app.vault.getName());
        let base_uri;
        // Check which kind of uri type should be used: shorthand or normal
        if ("open" === action && uri_arguments.file !== undefined) {
            // Use shorthand uri type for opening a file.
            const encoded_file = encodeURIComponent(uri_arguments.file);
            base_uri = `obsidian://vault/${encoded_vault_name}/${encoded_file}`;
            delete uri_arguments.file; // Prevent adding an extra '&file=' argument to the end of the URI.
        }
        else {
            // Use normal uri type for everything else.
            base_uri = `obsidian://${action}/?vault=${encoded_vault_name}`;
        }
        let concatenated_uri_arguments = "";
        for (const uri_argument_name in uri_arguments) {
            const uri_argument_value = encodeURIComponent(uri_arguments[uri_argument_name]);
            concatenated_uri_arguments += `&${uri_argument_name}=${uri_argument_value}`;
        }
        return base_uri + concatenated_uri_arguments;
    }
    /**
     * Creates a new shell command object and registers it to Obsidian's command palette, but does not save the modified
     * configuration to disk. To save the addition, call saveSettings().
     */
    newTShellCommand() {
        const shell_command_id = getIDGenerator().generateID();
        const shell_command_configuration = newShellCommandConfiguration(shell_command_id);
        this.settings.shell_commands.push(shell_command_configuration);
        const t_shell_command = new TShellCommand(this, shell_command_configuration);
        this.t_shell_commands[shell_command_id] = t_shell_command;
        if (t_shell_command.canAddToCommandPalette()) { // This is probably always true, because the default configuration enables adding to the command palette, but check just in case.
            this.registerShellCommand(t_shell_command);
        }
        return t_shell_command;
    }
    /**
     * TODO: Move to TShellCommand.registerToCommandPalette(), but split to multiple methods.
     *
     * @param t_shell_command
     */
    registerShellCommand(t_shell_command) {
        const shell_command_id = t_shell_command.getId();
        debugLog("Registering shell command #" + shell_command_id + "...");
        // Define a function for executing the shell command.
        const executor = async (parsing_process) => {
            if (!parsing_process) {
                parsing_process = t_shell_command.createParsingProcess(null); // No SC_Event is available when executing shell commands via the command palette / hotkeys.
                // Try to process variables that can be processed before performing preactions.
                await parsing_process.process();
            }
            if (parsing_process.getParsingResults().shell_command?.succeeded) { // .shell_command should always be present (even if parsing did not succeed), but if it's not, show errors in the else block.
                // The command was parsed correctly.
                const executor_instance = new ShellCommandExecutor(// Named 'executor_instance' because 'executor' is another constant.
                this, t_shell_command, null // No SC_Event is available when executing via command palette or hotkey.
                );
                await executor_instance.doPreactionsAndExecuteShellCommand(parsing_process);
            }
            else {
                // The command could not be parsed correctly.
                // Display error messages
                parsing_process.displayErrorMessages();
            }
        };
        // Register an Obsidian command
        const obsidian_command = {
            id: this.generateObsidianCommandId(shell_command_id),
            name: generateObsidianCommandName(this, t_shell_command.getShellCommand(), t_shell_command.getAlias()),
            // Use 'checkCallback' instead of normal 'callback' because we also want to get called when the command palette is opened.
            checkCallback: (is_opening_command_palette) => {
                if (is_opening_command_palette) {
                    // The user is currently opening the command palette.
                    // Check can the shell command be shown in command palette
                    if (!t_shell_command.canShowInCommandPalette()) {
                        // Cancel preview and deny showing in command palette.
                        debugLog("Shell command #" + t_shell_command.getId() + " won't be shown in command palette.");
                        return false;
                    }
                    // Do not execute the command yet, but parse variables for preview, if enabled in the settings.
                    debugLog("Getting command palette preview for shell command #" + t_shell_command.getId());
                    if (this.settings.preview_variables_in_command_palette) {
                        // Preparse variables
                        const parsing_process = t_shell_command.createParsingProcess(null); // No SC_Event is available when executing shell commands via the command palette / hotkeys.
                        parsing_process.process().then((parsing_succeeded) => {
                            if (parsing_succeeded) {
                                // Parsing succeeded
                                // Rename Obsidian command
                                const parsingResults = parsing_process.getParsingResults();
                                /** Don't confuse this name with ShellCommandParsingResult interface! The properties are very different. TODO: Rename ShellCommandParsingResult to something else. */
                                const shellCommandParsingResult = parsingResults["shell_command"]; // Use 'as' to denote that properties exist on this line and below.
                                const aliasParsingResult = parsingResults["alias"];
                                const parsedShellCommand = shellCommandParsingResult.parsed_content;
                                const parsedAlias = aliasParsingResult.parsed_content;
                                t_shell_command.renameObsidianCommand(parsedShellCommand, parsedAlias);
                                // Store the preparsed variables so that they will be used if this shell command gets executed.
                                this.cached_parsing_processes[t_shell_command.getId()] = parsing_process;
                            }
                            else {
                                // Parsing failed, so use unparsed t_shell_command.getShellCommand() and t_shell_command.getAlias().
                                t_shell_command.renameObsidianCommand(t_shell_command.getShellCommand(), t_shell_command.getAlias());
                                this.cached_parsing_processes[t_shell_command.getId()] = undefined;
                            }
                        });
                    }
                    else {
                        // Parsing is disabled, so use unparsed t_shell_command.getShellCommand() and t_shell_command.getAlias().
                        t_shell_command.renameObsidianCommand(t_shell_command.getShellCommand(), t_shell_command.getAlias());
                        this.cached_parsing_processes[t_shell_command.getId()] = undefined;
                    }
                    return true; // Tell Obsidian this command can be shown in command palette.
                }
                else {
                    // The user has instructed to execute the command.
                    executor(this.cached_parsing_processes[t_shell_command.getId()]).then(() => {
                        // Delete the whole array of preparsed commands. Even though we only used just one command from it, we need to notice that opening a command
                        // palette might generate multiple preparsed commands in the array, but as the user selects and executes only one command, all these temporary
                        // commands are now obsolete. Delete them just in case the user toggles the variable preview feature off in the settings, or executes commands via hotkeys. We do not want to
                        // execute obsolete commands accidentally.
                        // This deletion also needs to be done even if the executed command was not a preparsed command, because
                        // even when preparsing is turned on in the settings, some commands may fail to parse, and therefore they would not be in this array, but other
                        // commands might be.
                        this.cached_parsing_processes = {}; // Removes obsolete preparsed variables from all shell commands.
                        return; // When we are not in the command palette check phase, there's no need to return a value. Just have this 'return' statement because all other return points have a 'return' too.
                    });
                }
            }
        };
        this.addCommand(obsidian_command);
        this.obsidian_commands[shell_command_id] = obsidian_command; // Store the reference so that we can edit the command later in ShellCommandsSettingsTab if needed. TODO: Use tShellCommand instead.
        t_shell_command.setObsidianCommand(obsidian_command);
        debugLog("Registered.");
    }
    /**
     * Goes through all events and all shell commands, and for each shell command, registers all the events that the shell
     * command as enabled in its configuration. Does not modify the configurations.
     *
     * @param called_after_changing_settings Set to: true, if this happens after changing configuration; false, if this happens during loading the plugin.
     */
    registerSC_Events(called_after_changing_settings) {
        // Make sure that Obsidian is fully loaded before allowing any events to trigger.
        this.app.workspace.onLayoutReady(() => {
            // Even after Obsidian is fully loaded, wait a while in order to prevent SC_Event_onActiveLeafChanged triggering right after start-up.
            // At least on Obsidian 0.12.19 it's not enough to delay until onLayoutReady, need to wait a bit more in order to avoid the miss-triggering.
            window.setTimeout(() => {
                // Iterate all shell commands and register possible events.
                const shell_commands = this.getTShellCommands();
                for (const shell_command_id in shell_commands) {
                    const t_shell_command = shell_commands[shell_command_id];
                    t_shell_command.registerSC_Events(called_after_changing_settings);
                }
            }, 0); // 0 means to call the callback on "the next event cycle", according to window.setTimeout() documentation. It should be a long enough delay. But if SC_Event_onActiveLeafChanged still gets triggered during start-up, this value can be raised to for example 1000 (= one second).
        });
    }
    /**
     * Goes through all events and all shell commands, and makes sure all of them are unregistered, e.g. will not trigger
     * automatically. Does not modify the configurations.
     */
    unregisterSC_Events() {
        // Iterate all events
        getSC_Events(this).forEach((sc_event) => {
            // Iterate all shell commands
            const shell_commands = this.getTShellCommands();
            for (const shell_command_id in shell_commands) {
                const t_shell_command = shell_commands[shell_command_id];
                sc_event.unregister(t_shell_command);
            }
        });
    }
    /**
     * Defines an Obsidian protocol handler that allows receiving requests via obsidian://shell-commands URI.
     * @private
     */
    registerURIHandler() {
        this.registerObsidianProtocolHandler(SC_Plugin.SHELL_COMMANDS_URI_ACTION, async (parameters) => {
            const parameter_names = Object.getOwnPropertyNames(parameters);
            // Assign values to custom variables (also delete some unneeded entries from parameter_names)
            let custom_variable_assignments_failed = false;
            for (const parameter_index in parameter_names) {
                const parameter_name = parameter_names[parameter_index];
                // Check if the parameter name is a custom variable
                if (parameter_name.match(/^_/)) {
                    // This parameter defines a value for a custom variable
                    // Find the variable.
                    let found_custom_variable = false;
                    for (const variable of this.getVariables()) {
                        if (variable instanceof CustomVariable && variable.variable_name === parameter_name) {
                            // Found the correct variable.
                            found_custom_variable = true;
                            // Assign the given value to the custom variable.
                            await variable.setValue(parameters[parameter_name]);
                        }
                    }
                    if (!found_custom_variable) {
                        this.newError("Shell commands URI: A custom variable does not exist: " + parameter_name);
                        custom_variable_assignments_failed = true;
                    }
                }
            }
            if (!custom_variable_assignments_failed) {
                // Determine action
                if (undefined !== parameters.execute) {
                    // Execute a shell command.
                    const executable_shell_command_id = parameters.execute;
                    parameter_names.remove("execute"); // Mark the parameter as handled. Prevents showing an error message for an unrecognised parameter.
                    // Find the executable shell command
                    let found_t_shell_command = false;
                    const shell_commands = this.getTShellCommands();
                    for (const shell_command_id in shell_commands) {
                        const t_shell_command = shell_commands[shell_command_id];
                        if (t_shell_command.getId() === executable_shell_command_id) {
                            // This is the correct shell command.
                            found_t_shell_command = true;
                            // Execute it.
                            const executor = new ShellCommandExecutor(this, t_shell_command, null);
                            await executor.doPreactionsAndExecuteShellCommand();
                        }
                    }
                    if (!found_t_shell_command) {
                        this.newError("Shell commands URI: A shell command id does not exist: " + executable_shell_command_id);
                    }
                }
            }
            // Raise errors for any left-over parameters, if exists.
            for (const parameter_name of parameter_names) {
                switch (parameter_name) {
                    case "": // For some reason Obsidian 0.14.5 adds an empty-named parameter if there are no ?query=parameters present.
                    case "action": // Obsidian provides this always. Don't show an error message for this.
                    case "vault": // Obsidian handles this parameter automatically. Just make sure no error message is displayed when this is present.
                        // Do nothing
                        break;
                    default:
                        if (parameter_name.match(/^_/)) ;
                        else {
                            // Throw an error for everything else.
                            this.newError("Shell commands URI: Unrecognised parameter: " + parameter_name);
                        }
                }
            }
        });
    }
    generateObsidianCommandId(shell_command_id) {
        return "shell-command-" + shell_command_id;
    }
    onunload() {
        debugLog('Unloading Shell commands plugin.');
        // Close CustomVariableViews.
        this.app.workspace.detachLeavesOfType(CustomVariableView.ViewType);
        // Close autocomplete menus.
        for (const autocompleteMenu of this.autocompleteMenus) {
            autocompleteMenu?.destroy();
        }
    }
    /**
     *
     * @param current_settings_version
     * @private
     * @return True if the given settings version is supported by this plugin version, or an error message string if it's not supported.
     */
    isSettingsVersionSupported(current_settings_version) {
        if (current_settings_version === "prior-to-0.7.0") {
            // 0.x.y supports all old settings formats that do not define a version number. This support will be removed in 1.0.0.
            return true;
        }
        else {
            // Compare the version number
            /** Note that the plugin version may be different than what will be used in the version comparison. The plugin version will be displayed in possible error messages. */
            const plugin_version = this.getPluginVersion();
            const version_comparison = versionCompare(SC_Plugin.SettingsVersion, current_settings_version);
            if (version_comparison === 0) {
                // The versions are equal.
                // Supported.
                return true;
            }
            else if (version_comparison < 0) {
                // The compared version is newer than what the plugin can support.
                return "The settings file is saved by a newer version of this plugin, so this plugin does not support the structure of the settings file. Please upgrade this plugin to at least version " + current_settings_version + ". Now the plugin version is " + plugin_version;
            }
            else {
                // The compared version is older than the version that the plugin currently uses to write settings.
                // 0.x.y supports all old settings versions. In 1.0.0, some old settings formats might lose their support, but that's not yet certain.
                return true;
            }
        }
    }
    getPluginVersion() {
        return this.manifest.version;
    }
    async loadSettings() {
        // Try to read a settings file
        let all_settings;
        this.settings = await this.loadData(); // May have missing main settings fields, if the settings file is from an older version of SC. It will be migrated later.
        if (null === this.settings) {
            // The settings file does not exist.
            // Use default settings
            this.settings = getDefaultSettings(true);
            all_settings = this.settings;
        }
        else {
            // Succeeded to load a settings file.
            // In case the settings file does not have 'debug' or 'settings_version' fields, create them.
            all_settings = combineObjects(getDefaultSettings(false), this.settings); // This temporary settings object always has all fields defined (except sub fields, such as shell command specific fields, may still be missing, but they are not needed this early). This is used so that it's certain that the fields 'debug' and 'settings_version' exist.
        }
        // Update debug status - before this line debugging is always OFF!
        setDEBUG_ON(all_settings.debug);
        // Ensure that the loaded settings file is supported.
        const version_support = this.isSettingsVersionSupported(all_settings.settings_version);
        if (typeof version_support === "string") {
            // The settings version is not supported.
            new obsidian.Notice("SHELL COMMANDS PLUGIN HAS DISABLED ITSELF in order to prevent misinterpreting settings / corrupting the settings file!", 120 * 1000);
            new obsidian.Notice(version_support, 120 * 1000);
            await this.disablePlugin();
            return false; // The plugin should not be used.
        }
        return true; // Settings are loaded and the plugin can be used.
    }
    async saveSettings() {
        // Update settings version in case it's old.
        this.settings.settings_version = SC_Plugin.SettingsVersion;
        // Write settings
        await this.saveData(this.settings);
    }
    loadCustomAutocompleteList() {
        const custom_autocomplete_file_name = "autocomplete.yaml";
        const custom_autocomplete_file_path = path__namespace.join(getPluginAbsolutePath(this), custom_autocomplete_file_name);
        if (fs__namespace.existsSync(custom_autocomplete_file_path)) {
            debugLog("loadCustomAutocompleteList(): " + custom_autocomplete_file_name + " exists, will load it now.");
            const custom_autocomplete_content = fs__namespace.readFileSync(custom_autocomplete_file_path).toLocaleString();
            const result = addCustomAutocompleteItems(custom_autocomplete_content);
            if (true === result) {
                // OK
                debugLog("loadCustomAutocompleteList(): " + custom_autocomplete_file_name + " loaded.");
            }
            else {
                // An error has occurred.
                debugLog("loadCustomAutocompleteList(): " + result);
                this.newError("Shell commands: Unable to parse " + custom_autocomplete_file_name + ": " + result);
            }
        }
        else {
            debugLog("loadCustomAutocompleteList(): " + custom_autocomplete_file_name + " does not exists, so won't load it. This is perfectly ok.");
        }
    }
    /**
     * Puts the given Autocomplete menu into a list of menus that will be destroyed when the plugin unloads.
     * @param autocompleteMenu
     */
    registerAutocompleteMenu(autocompleteMenu) {
        this.autocompleteMenus.push(autocompleteMenu);
    }
    async disablePlugin() {
        // This unfortunately accesses a private API.
        // @ts-ignore
        await this.app.plugins.disablePlugin(this.manifest.id);
    }
    getPluginId() {
        return this.manifest.id;
    }
    getPluginName() {
        return this.manifest.name;
    }
    newError(message, timeout = this.getErrorMessageDurationMs()) {
        return new obsidian.Notice(message, timeout);
    }
    newErrors(messages) {
        messages.forEach((message) => {
            this.newError(message);
        });
    }
    /**
     *
     * @param message
     * @param timeout Custom timeout in milliseconds. If not set, the timeout will be fetched from user configurable settings. Use 0 if you want to disable the timeout, i.e. show the notification until it's explicitly hidden by clinking it, or via code.
     */
    newNotification(message, timeout = this.getNotificationMessageDurationMs()) {
        return new obsidian.Notice(message, timeout);
    }
    getNotificationMessageDurationMs() {
        return this.settings.notification_message_duration * 1000; // * 1000 = convert seconds to milliseconds.
    }
    getErrorMessageDurationMs() {
        return this.settings.error_message_duration * 1000; // * 1000 = convert seconds to milliseconds.
    }
    getDefaultShell() {
        const operating_system = getOperatingSystem();
        let shell_name = this.settings.default_shells[operating_system]; // Can also be undefined.
        if (undefined === shell_name) {
            shell_name = getUsersDefaultShell();
        }
        return shell_name;
    }
    createCustomVariableView() {
        const leaf = this.app.workspace.getRightLeaf(false);
        leaf.setViewState({
            type: CustomVariableView.ViewType,
            active: true,
        }).then();
        this.app.workspace.revealLeaf(leaf);
    }
    /**
     * Called when CustomVariable values are changed.
     */
    async updateCustomVariableViews() {
        for (const leaf of this.app.workspace.getLeavesOfType(CustomVariableView.ViewType)) {
            await leaf.view.updateContent();
        }
    }
    /**
     * Used by OutputChannel_StatusBar.
     * TODO: Make it possible to have multiple status bar elements. It should be a shell command level setting, where a shell command opts for either to use their own status bar element, or a common one.
     */
    getOutputStatusBarElement() {
        if (!this.statusBarElement) {
            this.statusBarElement = this.addStatusBarItem();
        }
        return this.statusBarElement;
    }
    /**
     * Creates an icon button that when clicked, will send a request to terminate shell command execution intermittently.
     *
     * @param containerElement
     * @param processTerminator A callback that will actually terminate the shell command execution process.
     */
    createRequestTerminatingButton(containerElement, processTerminator) {
        const button = containerElement.createEl('a', {
            prepend: true,
            attr: {
                "aria-label": "Request to terminate the process",
                class: "SC-icon-terminate-process",
            },
        });
        obsidian.setIcon(button, "power");
        button.onclick = (event) => {
            processTerminator();
            event.preventDefault();
            event.stopPropagation();
        };
    }
}
/**
 * Defines the settings structure version. Change this when a new plugin version is released, but only if that plugin
 * version introduces changes to the settings structure. Do not change if the settings structure stays unchanged.
 */
SC_Plugin.SettingsVersion = "0.18.0";
SC_Plugin.SHELL_COMMANDS_URI_ACTION = "shell-commands";

module.exports = SC_Plugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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