# Example Notebooks

The example notebooks in this directory demonstrate various functionalities of `HERE Map Widget for Jupyter`.

## Prerequisites
Before you run the Notebooks make sure you have:
- A HERE developer account, free and available under [HERE Developer Portal](https://developer.here.com)
- An [API key](https://developer.here.com/documentation/identity-access-management/dev_guide/topics/dev-apikey.html) from the [HERE Developer Portal](https://developer.here.com)
- An XYZ API access token from your XYZ Hub server or the [XYZ portal](https://www.here.xyz) see also it's [Getting
  Started](https://www.here.xyz/getting-started/).
## Notebooks

- [Add ipywidgets over map](./add_ipywidgets.ipynb) - Display interactive ipywidget over map and control traits of the map.
- [Basemaps](./basemaps.ipynb) - Display various basemaps.
- [Choropleth layer](./choropleth_layer.ipynb) - Add a choropleth layer over map.
- [Circle](./circle.ipynb) - Add circle object over map.
- [Custom icons](./custom_icons.ipynb) - Add custom SVG icons for marker.
- [Custom marker icons](./custom_marker_icon.ipynb) - Add custom image icons for marker.
- [Data Hub space](./datahub_space.ipynb) - Visualise datahub space data on the map.
- [Data Hub space style](./datahub_space_style.ipynb) - Provide custom style to data in datahub space.
- [Distance measurment control](./distance_measurement_control.ipynb) - Add measurement control over map to calculate distance between points.
- [DOM marker](./dom_marker.ipynb) - Display a marker that is capable of receiving DOM events.
- [Extrusion](./extrusion.ipynb) - 3D extrusion of the geometric shapes.
- [Forest fire analysis](./forest_fire_analysis.ipynb) - Analysis use case for forest fire.
- [Geodata layer](./geodata.ipynb) - Add Geopandas dataframe as layer over map.
- [Group objects](./group_objects.ipynb) - Add multiple objects over map as single group object.
- [Image overlay](./image_overlay.ipynb) - Add image overlay over map.
- [Infobubble](./infobubble.ipynb) - Open an infobubble based on click event.
- [Japan data](./japan_data.ipynb) - Visualise japan specific data over map.
- [KML layer](./kml.ipynb) - Visualise data from kml file.
- [Map basics](./map_basics_demo.ipynb) - Basic map widget functionalities for vector data.
- [Map settings control](./map_settings_control.ipynb) - Enable and disable various layers on the map.
- [Marker cluster](./marker_cluster.ipynb) - Cluster multiple markers together to better visualize the data.
- [Marker trace on linestring](./marker_trace_on_linestring.ipynb) - 3D use case for marker tracing.
- [Movable shapes](./movable_shapes_objects.ipynb) - Display moveable geometric shapes on a map.
- [Polygon](./polygon.ipynb) - Display polygon on a map.
- [Rectangle](./rectangle.ipynb) - Display rectangle object on a map.
- [Search control](./search_control.ipynb) - Search Addresses using serch control on the map.
- [Split map control](./splitmap_control.ipynb) - Visualise two layers at the same time on the map using split map control.



