"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DateTimeAttribute = exports.BooleanAttribute = exports.NumberAttribute = exports.StringAttribute = void 0;
const core_1 = require("@aws-cdk/core");
/**
 * The String custom attribute type.
 */
class StringAttribute {
    constructor(props = {}) {
        if (props.minLen && !core_1.Token.isUnresolved(props.minLen) && props.minLen < 0) {
            throw new Error(`minLen cannot be less than 0 (value: ${props.minLen}).`);
        }
        if (props.maxLen && !core_1.Token.isUnresolved(props.maxLen) && props.maxLen > 2048) {
            throw new Error(`maxLen cannot be greater than 2048 (value: ${props.maxLen}).`);
        }
        this.minLen = props === null || props === void 0 ? void 0 : props.minLen;
        this.maxLen = props === null || props === void 0 ? void 0 : props.maxLen;
        this.mutable = props === null || props === void 0 ? void 0 : props.mutable;
    }
    bind() {
        let stringConstraints;
        if (this.minLen || this.maxLen) {
            stringConstraints = {
                minLen: this.minLen,
                maxLen: this.maxLen,
            };
        }
        return {
            dataType: 'String',
            stringConstraints,
            mutable: this.mutable,
        };
    }
}
exports.StringAttribute = StringAttribute;
/**
 * The Number custom attribute type.
 */
class NumberAttribute {
    constructor(props = {}) {
        this.min = props === null || props === void 0 ? void 0 : props.min;
        this.max = props === null || props === void 0 ? void 0 : props.max;
        this.mutable = props === null || props === void 0 ? void 0 : props.mutable;
    }
    bind() {
        let numberConstraints;
        if (this.min || this.max) {
            numberConstraints = {
                min: this.min,
                max: this.max,
            };
        }
        return {
            dataType: 'Number',
            numberConstraints,
            mutable: this.mutable,
        };
    }
}
exports.NumberAttribute = NumberAttribute;
/**
 * The Boolean custom attribute type.
 */
class BooleanAttribute {
    constructor(props = {}) {
        this.mutable = props === null || props === void 0 ? void 0 : props.mutable;
    }
    bind() {
        return {
            dataType: 'Boolean',
            mutable: this.mutable,
        };
    }
}
exports.BooleanAttribute = BooleanAttribute;
/**
 * The DateTime custom attribute type.
 */
class DateTimeAttribute {
    constructor(props = {}) {
        this.mutable = props === null || props === void 0 ? void 0 : props.mutable;
    }
    bind() {
        return {
            dataType: 'DateTime',
            mutable: this.mutable,
        };
    }
}
exports.DateTimeAttribute = DateTimeAttribute;
//# sourceMappingURL=data:application/json;base64,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