"""
=======================================================================
  Constants
=======================================================================

  Data
  ----
    Ptable
    Ptable_inv_n
    Ptable_upper
    aa
    aa_letters
    ions
    segment_letters
    solvent

"""


## Periodic Table ·····················································
# www.nist.gov/pml/atomic-weights-and-isotopic-compositions-relative-atomic-masses
# m: mass of most common isotope,  m_std: standard atomic weight
Ptable = { 
    'H'  : { 'N':   1, 'm':   1.00782503223, 'm_std':  (1.00784 + 1.00811)/2 },
    'He' : { 'N':   2, 'm':   4.00260325413, 'm_std':   4.002602 },
    'Li' : { 'N':   3, 'm':   7.0160034366 , 'm_std':  (6.938 + 6.997)/2 },
    'Be' : { 'N':   4, 'm':   9.012183065  , 'm_std':   9.0121831 },
    'B'  : { 'N':   5, 'm':  11.00930536   , 'm_std': (10.806 + 10.821)/2 },
    'C'  : { 'N':   6, 'm':  12.00000000000, 'm_std': (12.0096 + 12.0116)/2 },
    'N'  : { 'N':   7, 'm':  14.00307400443, 'm_std': (14.00643 + 14.00728)/2 },
    'O'  : { 'N':   8, 'm':  15.99491461957, 'm_std': (15.99903 + 15.99977)/2 },
    'F'  : { 'N':   9, 'm':  18.99840316273, 'm_std':  18.998403163 },
    'Ne' : { 'N':  10, 'm':  19.9924401762 , 'm_std':  20.1797 },
    'Na' : { 'N':  11, 'm':  22.9897692820 , 'm_std':  22.98976928 },
    'Mg' : { 'N':  12, 'm':  23.985041697  , 'm_std': (24.304 + 24.307)/2 },
    'Al' : { 'N':  13, 'm':  26.98153853   , 'm_std':  26.9815385 },
    'Si' : { 'N':  14, 'm':  27.97692653465, 'm_std': (28.084 + 28.086)/2 },
    'P'  : { 'N':  15, 'm':  30.97376199842, 'm_std':  30.973761998 },
    'S'  : { 'N':  16, 'm':  31.9720711744 , 'm_std': (32.059 + 32.076)/2 },
    'Cl' : { 'N':  17, 'm':  34.968852682  , 'm_std': (35.446 + 35.457)/2 },
    'Ar' : { 'N':  18, 'm':  39.9623831237 , 'm_std':  39.948 },
    'K'  : { 'N':  19, 'm':  38.9637064864 , 'm_std':  39.0983 },
    'Ca' : { 'N':  20, 'm':  39.962590863  , 'm_std':  40.078 },
    'Sc' : { 'N':  21, 'm':  44.95590828   , 'm_std':  44.955908 },
    'Ti' : { 'N':  22, 'm':  47.94794198   , 'm_std':  47.867 },
    'V'  : { 'N':  23, 'm':  50.94395704   , 'm_std':  50.9415 },
    'Cr' : { 'N':  24, 'm':  51.94050623   , 'm_std':  51.9961 },
    'Mn' : { 'N':  25, 'm':  54.93804391   , 'm_std':  54.938044 },
    'Fe' : { 'N':  26, 'm':  55.93493633   , 'm_std':  55.845 },
    'Co' : { 'N':  27, 'm':  58.93319429   , 'm_std':  58.933194 },
    'Ni' : { 'N':  28, 'm':  57.93534241   , 'm_std':  58.6934 },
    'Cu' : { 'N':  29, 'm':  62.92959772   , 'm_std':  63.546 },
    'Zn' : { 'N':  30, 'm':  63.92914201   , 'm_std':  65.38 },
    'Ga' : { 'N':  31, 'm':  68.9255735    , 'm_std':  69.723 },
    'Ge' : { 'N':  32, 'm':  73.921177761  , 'm_std':  72.630 },
    'As' : { 'N':  33, 'm':  74.92159457   , 'm_std':  74.921595 },
    'Se' : { 'N':  34, 'm':  79.9165218    , 'm_std':  78.971 },
    'Br' : { 'N':  35, 'm':  78.9183376    , 'm_std': (79.901 + 79.907)/2 },
    'Kr' : { 'N':  36, 'm':  83.9114977282 , 'm_std':  83.798 },
    'Rb' : { 'N':  37, 'm':  84.9117897379 , 'm_std':  85.4678 },
    'Sr' : { 'N':  38, 'm':  87.9056125    , 'm_std':  87.62 },
    'Y'  : { 'N':  39, 'm':  88.9058403    , 'm_std':  88.90584 },
    'Zr' : { 'N':  40, 'm':  89.9046977    , 'm_std':  91.224 },
    'Nb' : { 'N':  41, 'm':  92.9063730    , 'm_std':  92.90637 },
    'Mo' : { 'N':  42, 'm':  97.90540482   , 'm_std':  95.95 },
    'Tc' : { 'N':  43, 'm':  98.           , 'm_std':  98. },
    'Ru' : { 'N':  44, 'm': 101.9043441    , 'm_std': 101.07 },
    'Rh' : { 'N':  45, 'm': 102.9054980    , 'm_std': 102.90550 },
    'Pd' : { 'N':  46, 'm': 105.9034804    , 'm_std': 106.42 },
    'Ag' : { 'N':  47, 'm': 106.9050916    , 'm_std': 107.8682 },
    'Cd' : { 'N':  48, 'm': 113.90336509   , 'm_std': 112.414 },
    'In' : { 'N':  49, 'm': 114.903878776  , 'm_std': 114.818 },
    'Sn' : { 'N':  50, 'm': 119.90220163   , 'm_std': 118.710 },
    'Sb' : { 'N':  51, 'm': 120.9038120    , 'm_std': 121.760 },
    'Te' : { 'N':  52, 'm': 129.906222748  , 'm_std': 127.60 },
    'I'  : { 'N':  53, 'm': 126.9044719    , 'm_std': 126.90447 },
    'Xe' : { 'N':  54, 'm': 131.9041550856 , 'm_std': 131.293 },
    'Cs' : { 'N':  55, 'm': 132.9054519610 , 'm_std': 132.90545196 },
    'Ba' : { 'N':  56, 'm': 137.90524700   , 'm_std': 137.327 },
    'La' : { 'N':  57, 'm': 138.9063563    , 'm_std': 138.90547 },
    'Ce' : { 'N':  58, 'm': 139.9054431    , 'm_std': 140.116 },
    'Pr' : { 'N':  59, 'm': 140.9076576    , 'm_std': 140.90766 },
    'Nd' : { 'N':  60, 'm': 141.9077290    , 'm_std': 144.242 },
    'Pm' : { 'N':  61, 'm': 145.           , 'm_std': 145. },
    'Sm' : { 'N':  62, 'm': 151.9197397    , 'm_std': 150.36 },
    'Eu' : { 'N':  63, 'm': 152.9212380    , 'm_std': 151.964 },
    'Gd' : { 'N':  64, 'm': 157.9241123    , 'm_std': 157.25 },
    'Tb' : { 'N':  65, 'm': 158.9253547    , 'm_std': 158.92535 },
    'Dy' : { 'N':  66, 'm': 163.9291819    , 'm_std': 162.500 },
    'Ho' : { 'N':  67, 'm': 164.9303288    , 'm_std': 164.93033 },
    'Er' : { 'N':  68, 'm': 165.9302995    , 'm_std': 167.259 },
    'Tm' : { 'N':  69, 'm': 168.9342179    , 'm_std': 168.93422 },
    'Yb' : { 'N':  70, 'm': 173.9388664    , 'm_std': 173.054 },
    'Lu' : { 'N':  71, 'm': 174.9407752    , 'm_std': 174.9668 },
    'Hf' : { 'N':  72, 'm': 179.9465570    , 'm_std': 178.49 },
    'Ta' : { 'N':  73, 'm': 180.9479958    , 'm_std': 180.94788 },
    'W'  : { 'N':  74, 'm': 183.95093092   , 'm_std': 183.84 },
    'Re' : { 'N':  75, 'm': 186.9557501    , 'm_std': 186.207 },
    'Os' : { 'N':  76, 'm': 191.9614770    , 'm_std': 190.23 },
    'Ir' : { 'N':  77, 'm': 192.9629216    , 'm_std': 192.217 },
    'Pt' : { 'N':  78, 'm': 194.9647917    , 'm_std': 195.084 },
    'Au' : { 'N':  79, 'm': 196.96656879   , 'm_std': 196.966569 },
    'Hg' : { 'N':  80, 'm': 201.97064340   , 'm_std': 200.592 },
    'Tl' : { 'N':  81, 'm': 204.9744278    , 'm_std': (204.382 + 204.385)/2 },
    'Pb' : { 'N':  82, 'm': 207.9766525    , 'm_std': 207.2 },
    'Bi' : { 'N':  83, 'm': 208.9803991    , 'm_std': 208.98040 },
    'Po' : { 'N':  84, 'm': 209.           , 'm_std': 209. },
    'At' : { 'N':  85, 'm': 210.           , 'm_std': 210. },
    'Rn' : { 'N':  86, 'm': 222.           , 'm_std': 222. },
    'Fr' : { 'N':  87, 'm': 223.0197360    , 'm_std': 223. },
    'Ra' : { 'N':  88, 'm': 226.           , 'm_std': 226. },
    'Ac' : { 'N':  89, 'm': 227.           , 'm_std': 227. },
    'Th' : { 'N':  90, 'm': 232.0380558    , 'm_std': 232.0377 },
    'Pa' : { 'N':  91, 'm': 231.0358842    , 'm_std': 231.03588 },
    'U'  : { 'N':  92, 'm': 238.0507884    , 'm_std': 238.02891 },
    'Np' : { 'N':  93, 'm': 237.           , 'm_std': 237. },
    'Pu' : { 'N':  94, 'm': 244.           , 'm_std': 244. },
    'Am' : { 'N':  95, 'm': 243.           , 'm_std': 243. },
    'Cm' : { 'N':  96, 'm': 247.           , 'm_std': 247. },
    'Bk' : { 'N':  97, 'm': 247.           , 'm_std': 247. },
    'Cf' : { 'N':  98, 'm': 251.           , 'm_std': 251. },
    'Es' : { 'N':  99, 'm': 252.           , 'm_std': 252. },
    'Fm' : { 'N': 100, 'm': 257.           , 'm_std': 257. },
    'Md' : { 'N': 101, 'm': 258.           , 'm_std': 258. },
    'No' : { 'N': 102, 'm': 259.           , 'm_std': 259. },
    'Lr' : { 'N': 103, 'm': 262.           , 'm_std': 262. },
    'Rf' : { 'N': 104, 'm': 267.           , 'm_std': 267. },
    'Db' : { 'N': 105, 'm': 268.           , 'm_std': 268. },
    'Sg' : { 'N': 106, 'm': 271.           , 'm_std': 271. },
    'Bh' : { 'N': 107, 'm': 272.           , 'm_std': 272. },
    'Hs' : { 'N': 108, 'm': 270.           , 'm_std': 270. },
    'Mt' : { 'N': 109, 'm': 276.           , 'm_std': 276. },
    'Ds' : { 'N': 110, 'm': 281.           , 'm_std': 281. },
    'Rg' : { 'N': 111, 'm': 280.           , 'm_std': 280. },
    'Cn' : { 'N': 112, 'm': 285.           , 'm_std': 285. },
    'Nh' : { 'N': 113, 'm': 284.           , 'm_std': 284. },
    'Fl' : { 'N': 114, 'm': 289.           , 'm_std': 289. },
    'Mc' : { 'N': 115, 'm': 288.           , 'm_std': 288. },
    'Lv' : { 'N': 116, 'm': 293.           , 'm_std': 293. },
    'Ts' : { 'N': 117, 'm': 292.           , 'm_std': 292. },
    'Og' : { 'N': 118, 'm': 294.           , 'm_std': 294. }
    }
Ptable_inv_n = { j['N']:i for i, j in Ptable.items() }
Ptable.update({
    'D'  : { 'N':   1, 'm':   2.01410177812, 'm_std':   2.01410177812 },
    'T'  : { 'N':   1, 'm':   3.0160492779 , 'm_std':   3.0160492779  } }
    )
Ptable_upper = { i.upper():j for i,j in Ptable.items() }

## AminoAcids ·························································
aa_letters = {'ALA':'A','ARG':'R','ASN':'N','ASP':'D','CYS':'C','GLU':'E','GLN':'Q','GLY':'G','HIS':'H','ILE':'I',
              'LEU':'L','LYS':'K','MET':'M','PHE':'F','PRO':'P','SER':'S','THR':'T','TRP':'W','TYR':'Y','VAL':'V'}
aa_letters.update({'HID':'H', 'HIE':'H', 'HIP':'H', 'CYX':'C', 'CYM':'C', 'LYN':'K', 'ASH':'D', 'GLH':'E'})
aa_letters.update({'HSD':'H', 'HSE':'H', 'HSP':'H'})
aa_letters.update({'SEC':'U'})

# aa set (more efficiency)
aa = { i for i in aa_letters.keys() }

## Ions ·······························································
# resName : segment
ions = {
    'CL' : 'CL',
    'NA' : 'NA',
    'SOD' : 'SOD',
    #  'CA' : 'CA',
    'MG' : 'MG',
    'K'  : 'K' ,
    'RB' : 'RB',
    'CS' : 'CS',
    'LI' : 'LI',
    'ZN' : 'ZN'
    }

## Solvent ····························································
# resName : segment
solvent = { 'SOL' : 'BOX' }

## Segments ···························································
segment_letters = ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z']

