# Generated by Django 3.2.10 on 2021-12-22 08:37

import django.contrib.gis.db.models.fields
import django.core.validators
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('airports', '0005_auto_20211222_0812'),
    ]

    operations = [
        migrations.AlterField(
            model_name='airport',
            name='altitude',
            field=models.FloatField(default=0, help_text='The airport elevation MSL in feet (not metres).', verbose_name='altitude'),
        ),
        migrations.AlterField(
            model_name='airport',
            name='iata',
            field=models.CharField(blank=True, help_text='The three-letter IATA code for the airport (if it has one).', max_length=3, null=True, validators=[django.core.validators.MinLengthValidator(3)], verbose_name='IATA/FAA code'),
        ),
        migrations.AlterField(
            model_name='airport',
            name='ident',
            field=models.CharField(blank=True, help_text='The text identifier used in the OurAirports URL', max_length=12, null=True, verbose_name='identifier'),
        ),
        migrations.AlterField(
            model_name='airport',
            name='local_code',
            field=models.CharField(blank=True, help_text='The local country code for the airport', max_length=12, null=True, verbose_name='local country code'),
        ),
        migrations.AlterField(
            model_name='airport',
            name='location',
            field=django.contrib.gis.db.models.fields.PointField(srid=4326, verbose_name='coordinates'),
        ),
        migrations.AlterField(
            model_name='airport',
            name='municipality',
            field=models.CharField(blank=True, help_text='The primary municipality that the airport serves (when available). Note that this is not necessarily the municipality where the airport is physically located.', max_length=100, null=True, verbose_name='municipality'),
        ),
        migrations.AlterField(
            model_name='airport',
            name='name',
            field=models.CharField(help_text='The official airport name, including "Airport", "Airstrip", etc.', max_length=100, verbose_name='name'),
        ),
        migrations.AlterField(
            model_name='airport',
            name='type',
            field=models.CharField(default='', help_text='The type of the airport. Allowed values are "closed_airport", "heliport", "large_airport", "medium_airport", "seaplane_base", and "small_airport".', max_length=16, verbose_name='type'),
        ),
    ]
