"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EndpointGroup = exports.EndpointConfiguration = void 0;
const cdk = require("@aws-cdk/core");
const ga = require("./globalaccelerator.generated");
/**
 * (experimental) The class for endpoint configuration.
 *
 * @experimental
 */
class EndpointConfiguration extends cdk.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.props = props;
        props.endpointGroup._linkEndpoint(this);
    }
    /**
     * (experimental) render the endpoint configuration for the endpoint group.
     *
     * @experimental
     */
    renderEndpointConfiguration() {
        return {
            clientIpPreservationEnabled: this.props.clientIpReservation,
            endpointId: this.props.endpointId,
            weight: this.props.weight,
        };
    }
}
exports.EndpointConfiguration = EndpointConfiguration;
/**
 * (experimental) EndpointGroup construct.
 *
 * @experimental
 */
class EndpointGroup extends cdk.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _a, _b;
        super(scope, id);
        /**
         * (experimental) The array of the endpoints in this endpoint group.
         *
         * @experimental
         */
        this.endpoints = new Array();
        const resource = new ga.CfnEndpointGroup(this, 'Resource', {
            listenerArn: props.listener.listenerArn,
            endpointGroupRegion: (_a = props.region) !== null && _a !== void 0 ? _a : cdk.Stack.of(this).region,
            endpointConfigurations: cdk.Lazy.any({ produce: () => this.renderEndpoints() }, { omitEmptyArray: true }),
        });
        this.endpointGroupArn = resource.attrEndpointGroupArn;
        this.endpointGroupName = (_b = props.endpointGroupName) !== null && _b !== void 0 ? _b : resource.logicalId;
    }
    /**
     * (experimental) import from ARN.
     *
     * @experimental
     */
    static fromEndpointGroupArn(scope, id, endpointGroupArn) {
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.endpointGroupArn = endpointGroupArn;
            }
        }
        return new Import(scope, id);
    }
    /**
     * (experimental) Add an endpoint.
     *
     * @experimental
     */
    addEndpoint(id, endpointId, props = {}) {
        return new EndpointConfiguration(this, id, {
            endpointGroup: this,
            endpointId,
            ...props,
        });
    }
    /**
     * (experimental) Add an Elastic Load Balancer as an endpoint in this endpoint group.
     *
     * @experimental
     */
    addLoadBalancer(id, lb, props = {}) {
        return new EndpointConfiguration(this, id, {
            endpointId: lb.loadBalancerArn,
            endpointGroup: this,
            ...props,
        });
    }
    /**
     * (experimental) Add an EIP as an endpoint in this endpoint group.
     *
     * @experimental
     */
    addElasticIpAddress(id, eip, props = {}) {
        return new EndpointConfiguration(this, id, {
            endpointId: eip.attrAllocationId,
            endpointGroup: this,
            ...props,
        });
    }
    /**
     * (experimental) Add an EC2 Instance as an endpoint in this endpoint group.
     *
     * @experimental
     */
    addEc2Instance(id, instance, props = {}) {
        return new EndpointConfiguration(this, id, {
            endpointId: instance.instanceId,
            endpointGroup: this,
            ...props,
        });
    }
    /**
     * Links a endpoint to this endpoint group
     * @internal
     */
    _linkEndpoint(endpoint) {
        this.endpoints.push(endpoint);
    }
    renderEndpoints() {
        return this.endpoints.map(e => e.renderEndpointConfiguration());
    }
}
exports.EndpointGroup = EndpointGroup;
//# sourceMappingURL=data:application/json;base64,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