__all__ = ["careplan_mapping", "careplan_references"]

careplan_mapping = {
    "date": "date",
    "identifier": "token",
    "patient": "reference",
    "activity-code": "token",
    "activity-date": "date",
    "activity-reference": "reference",
    "based-on": "reference",
    "care-team": "reference",
    "category": "token",
    "condition": "reference",
    "encounter": "reference",
    "goal": "reference",
    "instantiates-canonical": "reference",
    "instantiates-uri": "uri",
    "intent": "token",
    "part-of": "reference",
    "performer": "reference",
    "replaces": "reference",
    "status": "token",
    "subject": "reference",
}

careplan_references = {
    "patient": ["Patient"],
    "activity-reference": [
        "Appointment",
        "MedicationRequest",
        "Task",
        "NutritionOrder",
        "RequestGroup",
        "VisionPrescription",
        "DeviceRequest",
        "ServiceRequest",
        "CommunicationRequest",
    ],
    "based-on": ["CarePlan"],
    "care-team": ["CareTeam"],
    "condition": ["Condition"],
    "encounter": ["Encounter"],
    "goal": ["Goal"],
    "instantiates-canonical": [
        "Questionnaire",
        "Measure",
        "PlanDefinition",
        "OperationDefinition",
        "ActivityDefinition",
    ],
    "part-of": ["CarePlan"],
    "performer": [
        "Practitioner",
        "Organization",
        "CareTeam",
        "Device",
        "Patient",
        "HealthcareService",
        "PractitionerRole",
        "RelatedPerson",
    ],
    "replaces": ["CarePlan"],
    "subject": ["Group", "Patient"],
}
