from ._view import Component as Component
from .connection import SheetsConnection as SheetsConnection
from .dtypes import EffectiveVal as EffectiveVal, GoogleValueType as GoogleValueType
from .formatting.format_tab import (
    TabCellFormatting as TabCellFormatting,
    TabGridFormatting as TabGridFormatting,
    TabTextFormatting as TabTextFormatting,
)
from .interfaces import AuthConfig as AuthConfig, FullRange as FullRange
from .range import Range as Range
from typing import Any, Dict, Literal, Sequence, Tuple, Union

class Tab(Component[TabCellFormatting, TabGridFormatting, TabTextFormatting]):
    _tab_id: Any = ...
    _title: Any = ...
    _index: Any = ...
    _column_count: Any = ...
    _row_count: Any = ...
    def __init__(
        self,
        gsheet_id: str,
        tab_title: str,
        tab_idx: int,
        tab_id: int,
        column_count: int = ...,
        row_count: int = ...,
        *,
        auth_config: Union[AuthConfig, None] = ...,
        sheets_conn: Union[SheetsConnection, None] = ...,
        autoconnect: bool = ...
    ) -> None: ...
    @property
    def tab_id(self) -> int: ...
    @property
    def format_grid(self) -> TabGridFormatting: ...
    @property
    def format_text(self) -> TabTextFormatting: ...
    @property
    def format_cell(self) -> TabCellFormatting: ...
    @property
    def title(self) -> str: ...
    @property
    def index(self) -> int: ...
    @property
    def column_count(self) -> int: ...
    @property
    def row_count(self) -> int: ...
    def fetch(self) -> Tab: ...
    @staticmethod
    def _unpack_tab_properties(
        properties: Dict[str, Any]
    ) -> Tuple[str, int, int, int, int]: ...
    @classmethod
    def from_properties(
        cls: Any,
        gsheet_id: str,
        properties: Dict[str, Any],
        auth_config: Union[AuthConfig, None] = ...,
        sheets_conn: Union[SheetsConnection, None] = ...,
        autoconnect: bool = ...,
    ) -> Tab: ...
    def full_range(self) -> FullRange: ...
    def get_data(
        self, rng: Union[FullRange, str, None] = ..., value_type: GoogleValueType = ...
    ) -> Tab: ...
    def write_values(
        self,
        data: Sequence[Union[Sequence[Any], Dict[str, Any]]],
        rng: Union[FullRange, str, None] = ...,
        mode: Literal["write", "w", "append", "a"] = ...,
    ) -> Tab: ...
    @classmethod
    def new_tab_request(
        cls: Any,
        tab_title: str,
        tab_id: Union[int, None] = ...,
        tab_idx: Union[int, None] = ...,
        num_rows: int = ...,
        num_cols: int = ...,
    ) -> Dict[str, Any]: ...
    def gen_add_tab_request(self) -> Dict[str, Any]: ...
    def create(self) -> Tab: ...
    def gen_range(self, rng: FullRange) -> Range: ...
