# coding: utf-8

"""
    MailSlurp API

    MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://docs.mailslurp.com/) - [Examples](https://github.com/mailslurp/examples) repository  # noqa: E501

    The version of the OpenAPI document: 6.5.2
    Contact: contact@mailslurp.dev
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from mailslurp_client.configuration import Configuration


class PhoneNumberDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'user_id': 'str',
        'compliance_address': 'str',
        'emergency_address': 'str',
        'phone_number': 'str',
        'phone_country': 'str',
        'phone_plan': 'str',
        'created_at': 'datetime',
        'updated_at': 'datetime'
    }

    attribute_map = {
        'id': 'id',
        'user_id': 'userId',
        'compliance_address': 'complianceAddress',
        'emergency_address': 'emergencyAddress',
        'phone_number': 'phoneNumber',
        'phone_country': 'phoneCountry',
        'phone_plan': 'phonePlan',
        'created_at': 'createdAt',
        'updated_at': 'updatedAt'
    }

    def __init__(self, id=None, user_id=None, compliance_address=None, emergency_address=None, phone_number=None, phone_country=None, phone_plan=None, created_at=None, updated_at=None, local_vars_configuration=None):  # noqa: E501
        """PhoneNumberDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._user_id = None
        self._compliance_address = None
        self._emergency_address = None
        self._phone_number = None
        self._phone_country = None
        self._phone_plan = None
        self._created_at = None
        self._updated_at = None
        self.discriminator = None

        self.id = id
        self.user_id = user_id
        if compliance_address is not None:
            self.compliance_address = compliance_address
        if emergency_address is not None:
            self.emergency_address = emergency_address
        self.phone_number = phone_number
        self.phone_country = phone_country
        self.phone_plan = phone_plan
        self.created_at = created_at
        self.updated_at = updated_at

    @property
    def id(self):
        """Gets the id of this PhoneNumberDto.  # noqa: E501


        :return: The id of this PhoneNumberDto.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this PhoneNumberDto.


        :param id: The id of this PhoneNumberDto.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def user_id(self):
        """Gets the user_id of this PhoneNumberDto.  # noqa: E501


        :return: The user_id of this PhoneNumberDto.  # noqa: E501
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """Sets the user_id of this PhoneNumberDto.


        :param user_id: The user_id of this PhoneNumberDto.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and user_id is None:  # noqa: E501
            raise ValueError("Invalid value for `user_id`, must not be `None`")  # noqa: E501

        self._user_id = user_id

    @property
    def compliance_address(self):
        """Gets the compliance_address of this PhoneNumberDto.  # noqa: E501


        :return: The compliance_address of this PhoneNumberDto.  # noqa: E501
        :rtype: str
        """
        return self._compliance_address

    @compliance_address.setter
    def compliance_address(self, compliance_address):
        """Sets the compliance_address of this PhoneNumberDto.


        :param compliance_address: The compliance_address of this PhoneNumberDto.  # noqa: E501
        :type: str
        """

        self._compliance_address = compliance_address

    @property
    def emergency_address(self):
        """Gets the emergency_address of this PhoneNumberDto.  # noqa: E501


        :return: The emergency_address of this PhoneNumberDto.  # noqa: E501
        :rtype: str
        """
        return self._emergency_address

    @emergency_address.setter
    def emergency_address(self, emergency_address):
        """Sets the emergency_address of this PhoneNumberDto.


        :param emergency_address: The emergency_address of this PhoneNumberDto.  # noqa: E501
        :type: str
        """

        self._emergency_address = emergency_address

    @property
    def phone_number(self):
        """Gets the phone_number of this PhoneNumberDto.  # noqa: E501


        :return: The phone_number of this PhoneNumberDto.  # noqa: E501
        :rtype: str
        """
        return self._phone_number

    @phone_number.setter
    def phone_number(self, phone_number):
        """Sets the phone_number of this PhoneNumberDto.


        :param phone_number: The phone_number of this PhoneNumberDto.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and phone_number is None:  # noqa: E501
            raise ValueError("Invalid value for `phone_number`, must not be `None`")  # noqa: E501

        self._phone_number = phone_number

    @property
    def phone_country(self):
        """Gets the phone_country of this PhoneNumberDto.  # noqa: E501


        :return: The phone_country of this PhoneNumberDto.  # noqa: E501
        :rtype: str
        """
        return self._phone_country

    @phone_country.setter
    def phone_country(self, phone_country):
        """Sets the phone_country of this PhoneNumberDto.


        :param phone_country: The phone_country of this PhoneNumberDto.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and phone_country is None:  # noqa: E501
            raise ValueError("Invalid value for `phone_country`, must not be `None`")  # noqa: E501
        allowed_values = ["US", "GB"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and phone_country not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `phone_country` ({0}), must be one of {1}"  # noqa: E501
                .format(phone_country, allowed_values)
            )

        self._phone_country = phone_country

    @property
    def phone_plan(self):
        """Gets the phone_plan of this PhoneNumberDto.  # noqa: E501


        :return: The phone_plan of this PhoneNumberDto.  # noqa: E501
        :rtype: str
        """
        return self._phone_plan

    @phone_plan.setter
    def phone_plan(self, phone_plan):
        """Sets the phone_plan of this PhoneNumberDto.


        :param phone_plan: The phone_plan of this PhoneNumberDto.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and phone_plan is None:  # noqa: E501
            raise ValueError("Invalid value for `phone_plan`, must not be `None`")  # noqa: E501

        self._phone_plan = phone_plan

    @property
    def created_at(self):
        """Gets the created_at of this PhoneNumberDto.  # noqa: E501


        :return: The created_at of this PhoneNumberDto.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this PhoneNumberDto.


        :param created_at: The created_at of this PhoneNumberDto.  # noqa: E501
        :type: datetime
        """
        if self.local_vars_configuration.client_side_validation and created_at is None:  # noqa: E501
            raise ValueError("Invalid value for `created_at`, must not be `None`")  # noqa: E501

        self._created_at = created_at

    @property
    def updated_at(self):
        """Gets the updated_at of this PhoneNumberDto.  # noqa: E501


        :return: The updated_at of this PhoneNumberDto.  # noqa: E501
        :rtype: datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this PhoneNumberDto.


        :param updated_at: The updated_at of this PhoneNumberDto.  # noqa: E501
        :type: datetime
        """
        if self.local_vars_configuration.client_side_validation and updated_at is None:  # noqa: E501
            raise ValueError("Invalid value for `updated_at`, must not be `None`")  # noqa: E501

        self._updated_at = updated_at

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PhoneNumberDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PhoneNumberDto):
            return True

        return self.to_dict() != other.to_dict()
