# Generated by Django 3.0.3 on 2020-05-04 13:28

import uuid

import django.contrib.auth.models
import django.db.models.deletion
from django.conf import settings
from django.db import migrations
from django.db import models

import tesla_ce.models.enrolment
import tesla_ce.models.informed_consent_document


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0011_update_proxy_permissions'),
    ]

    operations = [
        migrations.CreateModel(
            name='Activity',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('vle_activity_type', models.CharField(help_text='Activity type on the VLE.', max_length=250)),
                ('vle_activity_id', models.CharField(help_text='Activity id on the VLE.', max_length=250)),
                ('description', models.TextField(blank=True, help_text='Activity description.', null=True)),
                ('name', models.CharField(blank=True, help_text='Activity name.', max_length=255, null=True)),
                ('enabled', models.BooleanField(blank=None, default=False, help_text='Whether this activity is enabled or not', null=None)),
                ('start', models.DateTimeField(blank=True, help_text='When activity starts', null=True)),
                ('end', models.DateTimeField(blank=True, help_text='When activity ends', null=True)),
                ('conf', models.TextField(blank=True, help_text='Activity conf.', null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='AssessmentSession',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('connector', models.FileField(help_text='Connector JS file for this session', upload_to='')),
                ('started_at', models.DateTimeField(auto_now_add=True, help_text='Date when this assessment session started')),
                ('checked_at', models.DateTimeField(blank=True, help_text='Last time this assessment session has been checked', null=True)),
                ('closed_at', models.DateTimeField(blank=True, help_text='Date the assessment session has been closed', null=True)),
                ('activity', models.ForeignKey(help_text='Activity of this session', on_delete=django.db.models.deletion.CASCADE, to='tesla_ce.Activity')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Course',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(help_text='Course code.', max_length=250)),
                ('vle_course_id', models.CharField(help_text='Course id on the VLE.', max_length=250)),
                ('description', models.TextField(blank=True, help_text='Course description.', null=True)),
                ('start', models.DateTimeField(blank=True, help_text='When course starts', null=True)),
                ('end', models.DateTimeField(blank=True, help_text='When course ends', null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='Institution',
            fields=[
                ('id', models.AutoField(help_text='Institution Id', primary_key=True, serialize=False, unique=True)),
                ('acronym', models.CharField(help_text='Institution acronym', max_length=255, unique=True)),
                ('name', models.TextField(blank=None, help_text='Name of the institution', null=None)),
                ('external_ic', models.BooleanField(default=False, help_text='Informed Consent is managed externally to TeSLA', null=None)),
                ('mail_domain', models.CharField(blank=True, default=None, help_text='Accepted mail domains for this institution', max_length=255, null=True)),
                ('disable_vle_learner_creation', models.BooleanField(default=False, help_text='If enabled, VLEs cannot create learners', null=None)),
                ('disable_vle_instructor_creation', models.BooleanField(default=False, help_text='If enabled, VLE cannot create instructors', null=None)),
                ('disable_vle_user_creation', models.BooleanField(default=False, help_text='If enabled, VLE cannot create institution users', null=None)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='InstitutionUser',
            fields=[
                ('user_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to=settings.AUTH_USER_MODEL)),
                ('uid', models.CharField(help_text='Unique User Identifier for the institution', max_length=255)),
                ('login_allowed', models.BooleanField(default=False, help_text='Whether this user can login with user/password')),
                ('institution', models.ForeignKey(help_text='Institution of the user', on_delete=django.db.models.deletion.CASCADE, to='tesla_ce.Institution')),
            ],
            options={
                'unique_together': {('institution', 'uid')},
            },
            bases=('auth.user',),
            managers=[
                ('objects', django.contrib.auth.models.UserManager()),
            ],
        ),
        migrations.CreateModel(
            name='Instrument',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='Instrument name.', max_length=250)),
                ('acronym', models.CharField(help_text='Instrument Acronym.', max_length=30, unique=True)),
                ('queue', models.TextField(help_text='Queue this instrument listens to.', unique=True)),
                ('enabled', models.BooleanField(default=False, help_text='The instrument is enabled')),
                ('requires_enrolment', models.BooleanField(default=False, help_text='Whether this instrument requires enrolment')),
                ('description', models.TextField(blank=True, default=None, help_text='Description of the instrument.', null=True)),
                ('identity', models.BooleanField(default=False, help_text='This instrument contributes to the learner identity verification')),
                ('originality', models.BooleanField(default=False, help_text='This instrument contributes to the assessment originality verification')),
                ('authorship', models.BooleanField(default=False, help_text='This instrument contributes to the assessment authorship verification')),
                ('integrity', models.BooleanField(default=False, help_text='This instrument contributes to the assessment integrity verification')),
                ('options_schema', models.TextField(default=None, help_text='Schema for instrument options', null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Message',
            fields=[
                ('code', models.CharField(help_text='Message code', max_length=50, primary_key=True, serialize=False)),
                ('datatype', models.CharField(default='html', help_text='Type of the message', max_length=50)),
                ('description', models.TextField(default=None, help_text='Description of the message for translation', null=True)),
                ('meaning', models.TextField(default=None, help_text='Meaning of the message for translation', null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Provider',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='Provider name.', max_length=250)),
                ('description', models.TextField(blank=True, default=None, help_text='Provider description.', null=True)),
                ('url', models.CharField(default=None, help_text='Provider url.', max_length=250, null=True)),
                ('version', models.CharField(help_text='Provider version.', max_length=15)),
                ('acronym', models.CharField(help_text='Provider Acronym.', max_length=30, unique=True)),
                ('queue', models.CharField(help_text='Queue where provider listens for requests.', max_length=50, unique=True)),
                ('enabled', models.BooleanField(default=False, help_text='Whether this provider is enabled to be used')),
                ('allow_validation', models.BooleanField(default=False, help_text='Whether this provider provides validation feature for data')),
                ('validation_active', models.BooleanField(default=False, help_text='Whether this provider will be used for validation')),
                ('alert_below', models.DecimalField(decimal_places=2, default=None, help_text='Mark as alert for result values below this threshold.', max_digits=4, null=True)),
                ('warning_below', models.DecimalField(decimal_places=2, default=None, help_text='Mark as warning for result values below this threshold.', max_digits=4, null=True)),
                ('inverted_polarity', models.BooleanField(default=False, help_text='If enabled, good values are lower values')),
                ('image', models.CharField(help_text='Provider Docker image.', max_length=250)),
                ('has_service', models.BooleanField(default=False, help_text='Whether this provider starts a service and must be balanced')),
                ('service_port', models.IntegerField(default=None, help_text='Port where service is listening', null=True)),
                ('options_schema', models.TextField(blank=True, default=None, help_text='Schema for provider options.', null=True)),
                ('options', models.TextField(blank=True, default=None, help_text='Provider options.', null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('instrument', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='tesla_ce.Instrument')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ReportActivity',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('identity_level', models.SmallIntegerField(choices=[(0, 'Pending'), (1, 'No Information'), (2, 'Ok'), (3, 'Warning'), (4, 'Alert')], default=0, help_text='Alert level for learner identity.')),
                ('content_level', models.SmallIntegerField(choices=[(0, 'Pending'), (1, 'No Information'), (2, 'Ok'), (3, 'Warning'), (4, 'Alert')], default=0, help_text='Alert level for content authorship.')),
                ('integrity_level', models.SmallIntegerField(choices=[(0, 'Pending'), (1, 'No Information'), (2, 'Ok'), (3, 'Warning'), (4, 'Alert')], default=0, help_text='Alert level for system integrity.')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('activity', models.ForeignKey(help_text='Activity related to this report.', on_delete=django.db.models.deletion.CASCADE, to='tesla_ce.Activity')),
            ],
        ),
        migrations.CreateModel(
            name='Request',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.IntegerField(choices=[(0, 'Stored'), (1, 'Scheduled'), (2, 'Processing'), (3, 'Processed'), (4, 'Error'), (5, 'Timeout'), (6, 'Missing Provider')], default=0, help_text='Status for this request')),
                ('data', models.FileField(help_text='Data path on storage.', max_length=250, upload_to='')),
                ('error_message', models.TextField(help_text='Error message when status is error', null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('activity', models.ForeignKey(default=None, null=True, on_delete=django.db.models.deletion.CASCADE, to='tesla_ce.Activity')),
                ('instruments', models.ManyToManyField(to='tesla_ce.Instrument')),
                ('message_code', models.ForeignKey(default=None, help_text='Related message code', null=True, on_delete=django.db.models.deletion.SET_NULL, to='tesla_ce.Message')),
                ('session', models.ForeignKey(default=None, help_text='Assessment session for this request', null=True, on_delete=django.db.models.deletion.CASCADE, to='tesla_ce.AssessmentSession')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='SENDCategory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('description', models.TextField(help_text='Category description.')),
                ('data', models.TextField(help_text='Category configuration.')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('institution', models.ForeignKey(help_text='Institution this category is defined for', on_delete=django.db.models.deletion.CASCADE, to='tesla_ce.Institution')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Instructor',
            fields=[
                ('institutionuser_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='tesla_ce.InstitutionUser')),
            ],
            options={
                'verbose_name': 'user',
                'verbose_name_plural': 'users',
                'abstract': False,
            },
            bases=('tesla_ce.institutionuser',),
            managers=[
                ('objects', django.contrib.auth.models.UserManager()),
            ],
        ),
        migrations.CreateModel(
            name='Learner',
            fields=[
                ('institutionuser_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='tesla_ce.InstitutionUser')),
                ('learner_id', models.UUIDField(default=uuid.uuid4, help_text='Learner unique ID used to anonymize identity with external providers', unique=True)),
                ('consent_accepted', models.DateTimeField(blank=True, help_text='Date of acceptance of the current Informed Consent', null=True)),
                ('consent_rejected', models.DateTimeField(blank=True, help_text='Date of rejection of the current Informed Consent', null=True)),
                ('joined_at', models.DateTimeField(auto_now_add=True, help_text='Date the learner joined for this institution')),
            ],
            options={
                'verbose_name': 'user',
                'verbose_name_plural': 'users',
                'abstract': False,
            },
            bases=('tesla_ce.institutionuser',),
            managers=[
                ('objects', django.contrib.auth.models.UserManager()),
            ],
        ),
        migrations.CreateModel(
            name='VLE',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='VLE unique name.', max_length=250, unique=True)),
                ('type', models.IntegerField(choices=[(0, 'MOODLE')], default=0, help_text='Type of the VLE.')),
                ('url', models.TextField(blank=True, help_text='VLE url.', null=True)),
                ('lti', models.TextField(blank=True, help_text='VLE lti configuration.', null=True)),
                ('client_id', models.CharField(default=None, help_text='LTI 1.3 Client ID.', max_length=250, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('institution', models.ForeignKey(help_text='Institution this VLE belongs to.', on_delete=django.db.models.deletion.CASCADE, to='tesla_ce.Institution')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='RequestResult',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.IntegerField(choices=[(0, 'Pending'), (1, 'Processed'), (2, 'Error'), (3, 'Timeout'), (4, 'Missing Provider'), (5, 'Missing Enrolment')], default=0, help_text='Status for this result')),
                ('result', models.DecimalField(decimal_places=2, help_text='Normalized result value, summarizing results from providers', max_digits=3, null=True)),
                ('error_message', models.TextField(help_text='Error message when status is error', null=True)),
                ('code', models.IntegerField(choices=[(0, 'Pending'), (1, 'Ok'), (2, 'Warning'), (3, 'Alert')], default=0, help_text='Result code provided after performing the verification process')),
                ('audit', models.FileField(help_text='Audit data for this request.', max_length=250, upload_to='')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('instrument', models.ForeignKey(help_text='Instrument related to this result', on_delete=django.db.models.deletion.CASCADE, to='tesla_ce.Instrument')),
                ('message_code', models.ForeignKey(default=None, help_text='Related message code', null=True, on_delete=django.db.models.deletion.SET_NULL, to='tesla_ce.Message')),
                ('request', models.ForeignKey(help_text='Request related to this result', on_delete=django.db.models.deletion.CASCADE, to='tesla_ce.Request')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='RequestProviderResult',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.IntegerField(choices=[(0, 'Pending'), (1, 'Processed'), (2, 'Error'), (3, 'Timeout'), (4, 'Missing Provider'), (5, 'Missing Enrolment')], default=0, help_text='Status for this result')),
                ('result', models.DecimalField(decimal_places=2, help_text='Normalized result value', max_digits=3, null=True)),
                ('error_message', models.TextField(help_text='Error message when status is error', null=True)),
                ('code', models.IntegerField(choices=[(0, 'Pending'), (1, 'Ok'), (2, 'Warning'), (3, 'Alert')], default=0, help_text='Result code provided after performing the verification process')),
                ('audit', models.FileField(help_text='Audit data for this result.', max_length=250, upload_to='')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('message_code', models.ForeignKey(default=None, help_text='Related message code', null=True, on_delete=django.db.models.deletion.SET_NULL, to='tesla_ce.Message')),
                ('provider', models.ForeignKey(help_text='Provider related to this result', on_delete=django.db.models.deletion.CASCADE, to='tesla_ce.Provider')),
                ('request', models.ForeignKey(help_text='Request related to this result', on_delete=django.db.models.deletion.CASCADE, to='tesla_ce.Request')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='InformedConsent',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('version', models.CharField(help_text='Informed consent version.', max_length=250)),
                ('valid_from', models.DateTimeField(help_text='Informed consent valid from')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('institution', models.ForeignKey(help_text='Institution of the informed consent', on_delete=django.db.models.deletion.CASCADE, to='tesla_ce.Institution')),
            ],
            options={
                'unique_together': {('institution', 'version')},
            },
        ),
        migrations.CreateModel(
            name='EnrolmentSample',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.IntegerField(choices=[(0, 'Stored'), (1, 'Valid'), (2, 'Error'), (3, 'Timeout'), (4, 'Missing Validator')], default=0, help_text='Status for this sample')),
                ('error_message', models.TextField(blank=None, default=None, help_text='Error message when status is error', null=True)),
                ('data', models.FileField(help_text='Data path on storage.', max_length=250, upload_to='')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('instruments', models.ManyToManyField(help_text='Instruments this sample is collected for', to='tesla_ce.Instrument')),
                ('message_code', models.ForeignKey(default=None, help_text='Related message code', null=True, on_delete=django.db.models.deletion.SET_NULL, to='tesla_ce.Message')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='CourseGroup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='Group name.', max_length=250)),
                ('description', models.TextField(blank=True, help_text='Group description.', null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('courses', models.ManyToManyField(blank=True, help_text='Courses in this group.', to='tesla_ce.Course')),
                ('institution', models.ForeignKey(help_text='Institution for this group.', on_delete=django.db.models.deletion.CASCADE, to='tesla_ce.Institution')),
                ('parent', models.ForeignKey(blank=True, help_text='Parent group.', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='children', to='tesla_ce.CourseGroup')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='course',
            name='vle',
            field=models.ForeignKey(help_text='Course VLE.', on_delete=django.db.models.deletion.CASCADE, to='tesla_ce.VLE'),
        ),
        migrations.CreateModel(
            name='ActivityInstrument',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('required', models.BooleanField(help_text='Is instrument required?')),
                ('active', models.BooleanField(help_text='Is instrument active?')),
                ('options', models.TextField(blank=True, help_text='Instrument options?', null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('activity', models.ForeignKey(help_text='Activity.', on_delete=django.db.models.deletion.CASCADE, related_name='configuration', to='tesla_ce.Activity')),
                ('alternative_to', models.ForeignKey(help_text='Primary instrument to be used.', null=True, on_delete=django.db.models.deletion.CASCADE, to='tesla_ce.ActivityInstrument')),
                ('instrument', models.ForeignKey(help_text='Activity.', on_delete=django.db.models.deletion.CASCADE, to='tesla_ce.Instrument')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='activity',
            name='course',
            field=models.ForeignKey(help_text='Activity VLE.', on_delete=django.db.models.deletion.CASCADE, to='tesla_ce.Course'),
        ),
        migrations.AddField(
            model_name='activity',
            name='vle',
            field=models.ForeignKey(help_text='Activity VLE.', on_delete=django.db.models.deletion.CASCADE, to='tesla_ce.VLE'),
        ),
        migrations.AddField(
            model_name='request',
            name='learner',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='tesla_ce.Learner'),
        ),
        migrations.CreateModel(
            name='ReportActivityInstrument',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('enrolment', models.SmallIntegerField(help_text='Enrolment percentage', null=None)),
                ('confidence', models.SmallIntegerField(help_text='Confidence percentage', null=None)),
                ('result', models.SmallIntegerField(help_text='Result percentage', null=None)),
                ('identity_level', models.SmallIntegerField(choices=[(0, 'Pending'), (1, 'No Information'), (2, 'Ok'), (3, 'Warning'), (4, 'Alert')], default=0, help_text='Alert level for learner identity.')),
                ('content_level', models.SmallIntegerField(choices=[(0, 'Pending'), (1, 'No Information'), (2, 'Ok'), (3, 'Warning'), (4, 'Alert')], default=0, help_text='Alert level for content authorship.')),
                ('integrity_level', models.SmallIntegerField(choices=[(0, 'Pending'), (1, 'No Information'), (2, 'Ok'), (3, 'Warning'), (4, 'Alert')], default=0, help_text='Alert level for system integrity.')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('instrument', models.ForeignKey(help_text='Instrument related to this report detail.', on_delete=django.db.models.deletion.CASCADE, to='tesla_ce.Instrument')),
                ('report', models.ForeignKey(help_text='Related Activity Report.', on_delete=django.db.models.deletion.CASCADE, to='tesla_ce.ReportActivity')),
            ],
            options={
                'unique_together': {('report', 'instrument')},
            },
        ),
        migrations.AddField(
            model_name='reportactivity',
            name='learner',
            field=models.ForeignKey(help_text='Learner related to this report.', on_delete=django.db.models.deletion.CASCADE, to='tesla_ce.Learner'),
        ),
        migrations.CreateModel(
            name='MessageLocale',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('locale', models.CharField(help_text='Locale', max_length=10)),
                ('message', models.TextField(help_text='Message')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('code', models.ForeignKey(help_text='Message code', on_delete=django.db.models.deletion.CASCADE, to='tesla_ce.Message')),
            ],
            options={
                'unique_together': {('code', 'locale')},
            },
        ),
        migrations.AddField(
            model_name='learner',
            name='consent',
            field=models.ForeignKey(help_text='Current Informed consent of the learner', null=True, on_delete=django.db.models.deletion.SET_NULL, to='tesla_ce.InformedConsent'),
        ),
        migrations.CreateModel(
            name='InformedConsentDocument',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language', models.CharField(max_length=30)),
                ('html', models.TextField(blank=True, help_text='HTML version of IC', null=True)),
                ('pdf', models.FileField(blank=True, help_text='PDF version of IC.', null=True, upload_to=tesla_ce.models.informed_consent_document.get_upload_path)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('consent', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='tesla_ce.InformedConsent')),
            ],
            options={
                'unique_together': {('consent', 'language')},
            },
        ),
        migrations.CreateModel(
            name='EnrolmentSampleValidation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.IntegerField(choices=[(0, 'Validating'), (1, 'Valid'), (2, 'Error'), (3, 'Timeout')], default=0, help_text='Validation status for this sample')),
                ('info', models.FileField(help_text='Validation information path on storage.', max_length=250, upload_to='')),
                ('contribution', models.DecimalField(decimal_places=2, default=None, help_text='Estimated contribution of this sample to the enrolment model', max_digits=5, null=True)),
                ('error_message', models.TextField(blank=None, default=None, help_text='Error message when status is error', null=True)),
                ('included', models.BooleanField(default=False, help_text='Whether this sample is included in current model')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('message_code', models.ForeignKey(default=None, help_text='Related message code', null=True, on_delete=django.db.models.deletion.SET_NULL, to='tesla_ce.Message')),
                ('provider', models.ForeignKey(help_text='Provider that performed the validation of the sample', on_delete=django.db.models.deletion.CASCADE, to='tesla_ce.Provider')),
                ('sample', models.ForeignKey(help_text='Related Sample', on_delete=django.db.models.deletion.CASCADE, to='tesla_ce.EnrolmentSample')),
            ],
            options={
                'unique_together': {('sample', 'provider')},
            },
        ),
        migrations.AddField(
            model_name='enrolmentsample',
            name='learner',
            field=models.ForeignKey(help_text='Related learner', on_delete=django.db.models.deletion.CASCADE, to='tesla_ce.Learner'),
        ),
        migrations.AddField(
            model_name='course',
            name='instructors',
            field=models.ManyToManyField(blank=True, help_text='Course instructors.', to='tesla_ce.Instructor'),
        ),
        migrations.AddField(
            model_name='course',
            name='learners',
            field=models.ManyToManyField(blank=True, help_text='Course learners.', to='tesla_ce.Learner'),
        ),
        migrations.AddField(
            model_name='assessmentsession',
            name='learner',
            field=models.ForeignKey(help_text='Learner of this session', on_delete=django.db.models.deletion.CASCADE, to='tesla_ce.Learner'),
        ),
        migrations.CreateModel(
            name='Alert',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('level', models.IntegerField(choices=[(0, 'Info'), (1, 'Warning'), (2, 'Alert'), (3, 'Error')], default=0, help_text='Level of the alert')),
                ('data', models.FileField(help_text='Data path on storage.', max_length=250, upload_to='')),
                ('raised_at', models.DateTimeField(help_text='When the alert was raised.')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('activity', models.ForeignKey(help_text='Related activity', on_delete=django.db.models.deletion.CASCADE, to='tesla_ce.Activity')),
                ('instruments', models.ManyToManyField(help_text='Instruments related to this alert', to='tesla_ce.Instrument')),
                ('message_code', models.ForeignKey(default=None, help_text='Related message code', null=True, on_delete=django.db.models.deletion.SET_NULL, to='tesla_ce.Message')),
                ('session', models.ForeignKey(default=None, help_text='Related assessment session', null=True, on_delete=django.db.models.deletion.SET_NULL, to='tesla_ce.AssessmentSession')),
                ('learner', models.ForeignKey(help_text='Related learner', on_delete=django.db.models.deletion.CASCADE, to='tesla_ce.Learner')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AlterUniqueTogether(
            name='activity',
            unique_together={('vle', 'vle_activity_type', 'vle_activity_id')},
        ),
        migrations.CreateModel(
            name='SENDLearner',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('expires_at', models.DateTimeField(null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('category', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='tesla_ce.SENDCategory')),
                ('learner', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='tesla_ce.Learner')),
            ],
            options={
                'unique_together': {('learner', 'category')},
            },
        ),
        migrations.AlterUniqueTogether(
            name='reportactivity',
            unique_together={('activity', 'learner')},
        ),
        migrations.CreateModel(
            name='Enrolment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('percentage', models.DecimalField(decimal_places=2, help_text='Percentage of enrolment for this learner', max_digits=5)),
                ('can_analyse', models.BooleanField(default=False, help_text='This provider can verify learner samples')),
                ('locked_at', models.DateTimeField(default=None, help_text='This model is locked for an update process', null=True)),
                ('locked_by', models.UUIDField(blank=None, default=None, help_text='Task blocking this model', null=True)),
                ('model', models.FileField(default=None, help_text='Path to stored model', max_length=250, null=True, upload_to=tesla_ce.models.enrolment.get_upload_path)),
                ('model_samples', models.IntegerField(default=0, help_text='Number of enrolment samples used for the model', null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('provider', models.ForeignKey(help_text='Related provider', on_delete=django.db.models.deletion.CASCADE, to='tesla_ce.Provider')),
                ('learner', models.ForeignKey(help_text='Related learner', on_delete=django.db.models.deletion.CASCADE, to='tesla_ce.Learner')),
            ],
            options={
                'unique_together': {('learner', 'provider')},
            },
        ),
        migrations.AlterUniqueTogether(
            name='course',
            unique_together={('vle', 'vle_course_id')},
        ),
    ]
