from ..profile_generic.ver1 import ProfileGeneric as ProfileGenericVer1, CaptureObjects


class SPODES3CurrentProfile(ProfileGenericVer1):
    """Cosem3 Б.1 Текущие значения"""
    scaler_profile_key = bytes((1, 0, 94, 7, 3, 255))


class SPODES3MonthProfile(ProfileGenericVer1):
    """СПОДЭС3 В.4 Параметры ежемесячного профиля"""
    scaler_profile_key = bytes((1, 0, 94, 7, 1, 255))


class SPODES3DailyProfile(ProfileGenericVer1):
    """СПОДЭС3 В.3 Параметры ежесуточного профиля"""
    scaler_profile_key = bytes((1, 0, 94, 7, 2, 255))


class SPODES3LoadProfile(ProfileGenericVer1):
    """СПОДЭС3 В.2 Параметры профиля нагрузки"""
    scaler_profile_key = bytes((1, 0, 94, 7, 4, 255))


class SPODES3DisplayReadout(ProfileGenericVer1):
    """СПОДЭС3 13.12. Настройка индикации"""
    AVAILABLE_CAPTURE_OBJECTS: CaptureObjects = CaptureObjects([
        (3, "1.0.1.8.0.255", 2, 0),
        # 3    "1.0.1.8.0.255"    2
        # 3    "1.0.1.8.1.255"    2
        # 3    "1.0.1.8.2.255"    2
        # 3    "1.0.1.8.3.255"    2
        # 3    "1.0.2.8.4.255"    2
        # 3    "1.0.2.8.0.255"    2
        # 3    "1.0.2.8.1.255"    2
        # 3    "1.0.2.8.2.255"    2
        # 3    "1.0.2.8.3.255"    2
        # 3    "1.0.2.8.4.255"    2
        # 3    "1.0.3.8.0.255"    2
        # 3    "1.0.3.8.1.255"    2
        # 3    "1.0.3.8.2.255"    2
        # 3    "1.0.3.8.3.255"    2
        # 3    "1.0.3.8.4.255"    2
        # 3    "1.0.4.8.0.255"    2
        # 3    "1.0.4.8.1.255"    2
        # 3    "1.0.4.8.2.255"    2
        # 3    "1.0.4.8.3.255"    2
        # 3    "1.0.4.8.3.255"    2
        # 3    "1.0.12.7.0.255"    2
        # 3    "1.0.12.7.0.255"    2
        # 3    "1.0.32.7.0.255"    2
        # 3    "1.0.52.7.0.255"    2
        # 3    "1.0.124.7.0.255"    2
        # 3    "1.0.125.7.0.255"    2
        # 3    "1.0.126.7.0.255"    2
        # 3    "1.0.11.7.0.255"    2
        # 3    "1.0.91.7.0.255"    2
        # 3    "1.0.31.7.0.255"    2
        # 3    "1.0.51.7.0.255"    2
        # 3    "1.0.71.7.0.255"    2
        # 3    "1.0.1.7.0.255"    2
        # 3    "1.0.21.7.0.255"    2
        # 3    "1.0.41.7.0.255"    2
        # 3    "1.0.61.7.0.255"    2
        # 3    "1.0.3.7.0.255"    2
        # 3    "1.0.23.7.0.255"    2
        # 3    "1.0.43.7.0.255"    2
        # 3    "1.0.63.7.0.255"    2
        # 3    "1.0.9.7.0.255"    2
        # 3    "1.0.29.7.0.255"    2
        # 3    "1.0.49.7.0.255"    2
        # 3    "1.0.69.7.0.255"    2
        # 3    "1.0.13.7.0.255"    2
        # 3    "1.0.33.7.0.255"    2
        # 3    "1.0.53.7.0.255"    2
        # 3    "1.0.73.7.0.255"    2
        # 3    "1.0.14.7.0.255"    2
        # 8    "0.0.1.0.0.255"    2
        # 3    "1.0.1.8.0.101"    2
        # 3    "1.0.1.8.1.101"    2
        # 3    "1.0.1.8.2.101"    2
        # 3    "1.0.1.8.3.101"    2
        # 3    "1.0.2.8.4.101"    2
        # 3    "1.0.2.8.0.101"    2
        # 3    "1.0.2.8.1.101"    2
        # 3    "1.0.2.8.2.101"    2
        # 3    "1.0.2.8.3.101"    2
        # 3    "1.0.2.8.4.101"    2
        # 3    "1.0.3.8.0.101"    2
        # 3    "1.0.3.8.1.101"    2
        # 3    "1.0.3.8.2.101"    2
        # 3    "1.0.3.8.3.101"    2
        # 3    "1.0.3.8.4.101"    2
        # 3    "1.0.4.8.0.101"    2
        # 3    "1.0.4.8.1.101"    2
        # 3    "1.0.4.8.2.101"    2
        # 3    "1.0.4.8.3.101"    2
        # 3    "1.0.4.8.3.101"    2
        # 23    "0.0.22.0.0.255"    2
        # 23    "0.1.22.0.0.255"    2
        # 23    "0.2.22.0.0.255"    2
        # 23    "0.3.22.0.0.255"    2
        # 70    "0.0.96.3.10.255"    3
        # 1    "0.0.96.1.2.255"    2
        # 1    "0.0.96.1.8.255"    2
        # 1    "0.0.96.4.3.255"    2
    ])
