import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CloudAssetOrganizationFeedConfig extends cdktf.TerraformMetaArguments {
    /**
    * A list of the full names of the assets to receive updates. You must specify either or both of
  assetNames and assetTypes. Only asset updates matching specified assetNames and assetTypes are
  exported to the feed. For example: //compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1.
  See https://cloud.google.com/apis/design/resourceNames#fullResourceName for more info.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_organization_feed#asset_names CloudAssetOrganizationFeed#asset_names}
    */
    readonly assetNames?: string[];
    /**
    * A list of types of the assets to receive updates. You must specify either or both of assetNames
  and assetTypes. Only asset updates matching specified assetNames and assetTypes are exported to
  the feed. For example: "compute.googleapis.com/Disk"
  See https://cloud.google.com/asset-inventory/docs/supported-asset-types for a list of all
  supported asset types.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_organization_feed#asset_types CloudAssetOrganizationFeed#asset_types}
    */
    readonly assetTypes?: string[];
    /**
    * The project whose identity will be used when sending messages to the
  destination pubsub topic. It also specifies the project for API
  enablement check, quota, and billing.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_organization_feed#billing_project CloudAssetOrganizationFeed#billing_project}
    */
    readonly billingProject: string;
    /**
    * Asset content type. If not specified, no content but the asset name and type will be returned. Possible values: ["CONTENT_TYPE_UNSPECIFIED", "RESOURCE", "IAM_POLICY", "ORG_POLICY", "ACCESS_POLICY"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_organization_feed#content_type CloudAssetOrganizationFeed#content_type}
    */
    readonly contentType?: string;
    /**
    * This is the client-assigned asset feed identifier and it needs to be unique under a specific parent.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_organization_feed#feed_id CloudAssetOrganizationFeed#feed_id}
    */
    readonly feedId: string;
    /**
    * The organization this feed should be created in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_organization_feed#org_id CloudAssetOrganizationFeed#org_id}
    */
    readonly orgId: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_organization_feed#condition CloudAssetOrganizationFeed#condition}
    */
    readonly condition?: CloudAssetOrganizationFeedCondition;
    /**
    * feed_output_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_organization_feed#feed_output_config CloudAssetOrganizationFeed#feed_output_config}
    */
    readonly feedOutputConfig: CloudAssetOrganizationFeedFeedOutputConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_organization_feed#timeouts CloudAssetOrganizationFeed#timeouts}
    */
    readonly timeouts?: CloudAssetOrganizationFeedTimeouts;
}
export interface CloudAssetOrganizationFeedCondition {
    /**
    * Description of the expression. This is a longer text which describes the expression,
  e.g. when hovered over it in a UI.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_organization_feed#description CloudAssetOrganizationFeed#description}
    */
    readonly description?: string;
    /**
    * Textual representation of an expression in Common Expression Language syntax.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_organization_feed#expression CloudAssetOrganizationFeed#expression}
    */
    readonly expression: string;
    /**
    * String indicating the location of the expression for error reporting, e.g. a file
  name and a position in the file.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_organization_feed#location CloudAssetOrganizationFeed#location}
    */
    readonly location?: string;
    /**
    * Title for the expression, i.e. a short string describing its purpose.
  This can be used e.g. in UIs which allow to enter the expression.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_organization_feed#title CloudAssetOrganizationFeed#title}
    */
    readonly title?: string;
}
export declare function cloudAssetOrganizationFeedConditionToTerraform(struct?: CloudAssetOrganizationFeedConditionOutputReference | CloudAssetOrganizationFeedCondition): any;
export declare class CloudAssetOrganizationFeedConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CloudAssetOrganizationFeedCondition | undefined;
    set internalValue(value: CloudAssetOrganizationFeedCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
}
export interface CloudAssetOrganizationFeedFeedOutputConfigPubsubDestination {
    /**
    * Destination on Cloud Pubsub topic.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_organization_feed#topic CloudAssetOrganizationFeed#topic}
    */
    readonly topic: string;
}
export declare function cloudAssetOrganizationFeedFeedOutputConfigPubsubDestinationToTerraform(struct?: CloudAssetOrganizationFeedFeedOutputConfigPubsubDestinationOutputReference | CloudAssetOrganizationFeedFeedOutputConfigPubsubDestination): any;
export declare class CloudAssetOrganizationFeedFeedOutputConfigPubsubDestinationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CloudAssetOrganizationFeedFeedOutputConfigPubsubDestination | undefined;
    set internalValue(value: CloudAssetOrganizationFeedFeedOutputConfigPubsubDestination | undefined);
    private _topic?;
    get topic(): string;
    set topic(value: string);
    get topicInput(): string | undefined;
}
export interface CloudAssetOrganizationFeedFeedOutputConfig {
    /**
    * pubsub_destination block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_organization_feed#pubsub_destination CloudAssetOrganizationFeed#pubsub_destination}
    */
    readonly pubsubDestination: CloudAssetOrganizationFeedFeedOutputConfigPubsubDestination;
}
export declare function cloudAssetOrganizationFeedFeedOutputConfigToTerraform(struct?: CloudAssetOrganizationFeedFeedOutputConfigOutputReference | CloudAssetOrganizationFeedFeedOutputConfig): any;
export declare class CloudAssetOrganizationFeedFeedOutputConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CloudAssetOrganizationFeedFeedOutputConfig | undefined;
    set internalValue(value: CloudAssetOrganizationFeedFeedOutputConfig | undefined);
    private _pubsubDestination;
    get pubsubDestination(): CloudAssetOrganizationFeedFeedOutputConfigPubsubDestinationOutputReference;
    putPubsubDestination(value: CloudAssetOrganizationFeedFeedOutputConfigPubsubDestination): void;
    get pubsubDestinationInput(): CloudAssetOrganizationFeedFeedOutputConfigPubsubDestination | undefined;
}
export interface CloudAssetOrganizationFeedTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_organization_feed#create CloudAssetOrganizationFeed#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_organization_feed#delete CloudAssetOrganizationFeed#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_organization_feed#update CloudAssetOrganizationFeed#update}
    */
    readonly update?: string;
}
export declare function cloudAssetOrganizationFeedTimeoutsToTerraform(struct?: CloudAssetOrganizationFeedTimeoutsOutputReference | CloudAssetOrganizationFeedTimeouts | cdktf.IResolvable): any;
export declare class CloudAssetOrganizationFeedTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CloudAssetOrganizationFeedTimeouts | undefined;
    set internalValue(value: CloudAssetOrganizationFeedTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_organization_feed google_cloud_asset_organization_feed}
*/
export declare class CloudAssetOrganizationFeed extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/cloud_asset_organization_feed google_cloud_asset_organization_feed} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CloudAssetOrganizationFeedConfig
    */
    constructor(scope: Construct, id: string, config: CloudAssetOrganizationFeedConfig);
    private _assetNames?;
    get assetNames(): string[];
    set assetNames(value: string[]);
    resetAssetNames(): void;
    get assetNamesInput(): string[] | undefined;
    private _assetTypes?;
    get assetTypes(): string[];
    set assetTypes(value: string[]);
    resetAssetTypes(): void;
    get assetTypesInput(): string[] | undefined;
    private _billingProject?;
    get billingProject(): string;
    set billingProject(value: string);
    get billingProjectInput(): string | undefined;
    private _contentType?;
    get contentType(): string;
    set contentType(value: string);
    resetContentType(): void;
    get contentTypeInput(): string | undefined;
    private _feedId?;
    get feedId(): string;
    set feedId(value: string);
    get feedIdInput(): string | undefined;
    get id(): string;
    get name(): string;
    private _orgId?;
    get orgId(): string;
    set orgId(value: string);
    get orgIdInput(): string | undefined;
    private _condition;
    get condition(): CloudAssetOrganizationFeedConditionOutputReference;
    putCondition(value: CloudAssetOrganizationFeedCondition): void;
    resetCondition(): void;
    get conditionInput(): CloudAssetOrganizationFeedCondition | undefined;
    private _feedOutputConfig;
    get feedOutputConfig(): CloudAssetOrganizationFeedFeedOutputConfigOutputReference;
    putFeedOutputConfig(value: CloudAssetOrganizationFeedFeedOutputConfig): void;
    get feedOutputConfigInput(): CloudAssetOrganizationFeedFeedOutputConfig | undefined;
    private _timeouts;
    get timeouts(): CloudAssetOrganizationFeedTimeoutsOutputReference;
    putTimeouts(value: CloudAssetOrganizationFeedTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): CloudAssetOrganizationFeedTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
