import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CloudRunServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#autogenerate_revision_name CloudRunService#autogenerate_revision_name}
    */
    readonly autogenerateRevisionName?: boolean | cdktf.IResolvable;
    /**
    * The location of the cloud run instance. eg us-central1
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#location CloudRunService#location}
    */
    readonly location: string;
    /**
    * Name must be unique within a namespace, within a Cloud Run region.
  Is required when creating resources. Name is primarily intended
  for creation idempotence and configuration definition. Cannot be updated.
  More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#name CloudRunService#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#project CloudRunService#project}
    */
    readonly project?: string;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#metadata CloudRunService#metadata}
    */
    readonly metadata?: CloudRunServiceMetadata;
    /**
    * template block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#template CloudRunService#template}
    */
    readonly template?: CloudRunServiceTemplate;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#timeouts CloudRunService#timeouts}
    */
    readonly timeouts?: CloudRunServiceTimeouts;
    /**
    * traffic block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#traffic CloudRunService#traffic}
    */
    readonly traffic?: CloudRunServiceTraffic[] | cdktf.IResolvable;
}
export declare class CloudRunServiceStatusConditions extends cdktf.ComplexComputedList {
    get message(): string;
    get reason(): string;
    get status(): string;
    get type(): string;
}
export declare class CloudRunServiceStatus extends cdktf.ComplexComputedList {
    get conditions(): cdktf.IResolvable;
    get latestCreatedRevisionName(): string;
    get latestReadyRevisionName(): string;
    get observedGeneration(): number;
    get url(): string;
}
export interface CloudRunServiceMetadata {
    /**
    * Annotations is a key value map stored with a resource that
  may be set by external tools to store and retrieve arbitrary metadata. More
  info: http://kubernetes.io/docs/user-guide/annotations
  
  **Note**: The Cloud Run API may add additional annotations that were not provided in your config.
  If terraform plan shows a diff where a server-side annotation is added, you can add it to your config
  or apply the lifecycle.ignore_changes rule to the metadata.0.annotations field.
  
  Cloud Run (fully managed) uses the following annotation keys to configure features on a Service:
  
  - 'run.googleapis.com/ingress' sets the [ingress settings](https://cloud.google.com/sdk/gcloud/reference/run/deploy#--ingress)
    for the Service. For example, '"run.googleapis.com/ingress" = "all"'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#annotations CloudRunService#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Map of string keys and values that can be used to organize and categorize
  (scope and select) objects. May match selectors of replication controllers
  and routes.
  More info: http://kubernetes.io/docs/user-guide/labels
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#labels CloudRunService#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * In Cloud Run the namespace must be equal to either the
  project ID or project number.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#namespace CloudRunService#namespace}
    */
    readonly namespace?: string;
}
export declare function cloudRunServiceMetadataToTerraform(struct?: CloudRunServiceMetadataOutputReference | CloudRunServiceMetadata): any;
export declare class CloudRunServiceMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CloudRunServiceMetadata | undefined;
    set internalValue(value: CloudRunServiceMetadata | undefined);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    get generation(): number;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    get resourceVersion(): string;
    get selfLink(): string;
    get uid(): string;
}
export interface CloudRunServiceTemplateMetadata {
    /**
    * Annotations is a key value map stored with a resource that
  may be set by external tools to store and retrieve arbitrary metadata. More
  info: http://kubernetes.io/docs/user-guide/annotations
  
  **Note**: The Cloud Run API may add additional annotations that were not provided in your config.
  If terraform plan shows a diff where a server-side annotation is added, you can add it to your config
  or apply the lifecycle.ignore_changes rule to the metadata.0.annotations field.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#annotations CloudRunService#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Map of string keys and values that can be used to organize and categorize
  (scope and select) objects. May match selectors of replication controllers
  and routes.
  More info: http://kubernetes.io/docs/user-guide/labels
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#labels CloudRunService#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name must be unique within a namespace, within a Cloud Run region.
  Is required when creating resources. Name is primarily intended
  for creation idempotence and configuration definition. Cannot be updated.
  More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#name CloudRunService#name}
    */
    readonly name?: string;
    /**
    * In Cloud Run the namespace must be equal to either the
  project ID or project number. It will default to the resource's project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#namespace CloudRunService#namespace}
    */
    readonly namespace?: string;
}
export declare function cloudRunServiceTemplateMetadataToTerraform(struct?: CloudRunServiceTemplateMetadataOutputReference | CloudRunServiceTemplateMetadata): any;
export declare class CloudRunServiceTemplateMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CloudRunServiceTemplateMetadata | undefined;
    set internalValue(value: CloudRunServiceTemplateMetadata | undefined);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    get generation(): number;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    get resourceVersion(): string;
    get selfLink(): string;
    get uid(): string;
}
export interface CloudRunServiceTemplateSpecContainersEnv {
    /**
    * Name of the environment variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#name CloudRunService#name}
    */
    readonly name?: string;
    /**
    * Variable references $(VAR_NAME) are expanded
  using the previous defined environment variables in the container and
  any route environment variables. If a variable cannot be resolved,
  the reference in the input string will be unchanged. The $(VAR_NAME)
  syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped
  references will never be expanded, regardless of whether the variable
  exists or not.
  Defaults to "".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#value CloudRunService#value}
    */
    readonly value?: string;
}
export declare function cloudRunServiceTemplateSpecContainersEnvToTerraform(struct?: CloudRunServiceTemplateSpecContainersEnv | cdktf.IResolvable): any;
export interface CloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReference {
    /**
    * Name of the referent.
  More info:
  https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#name CloudRunService#name}
    */
    readonly name: string;
}
export declare function cloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReferenceToTerraform(struct?: CloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReferenceOutputReference | CloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReference): any;
export declare class CloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReference | undefined;
    set internalValue(value: CloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReference | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface CloudRunServiceTemplateSpecContainersEnvFromConfigMapRef {
    /**
    * Specify whether the ConfigMap must be defined
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#optional CloudRunService#optional}
    */
    readonly optional?: boolean | cdktf.IResolvable;
    /**
    * local_object_reference block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#local_object_reference CloudRunService#local_object_reference}
    */
    readonly localObjectReference?: CloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReference;
}
export declare function cloudRunServiceTemplateSpecContainersEnvFromConfigMapRefToTerraform(struct?: CloudRunServiceTemplateSpecContainersEnvFromConfigMapRefOutputReference | CloudRunServiceTemplateSpecContainersEnvFromConfigMapRef): any;
export declare class CloudRunServiceTemplateSpecContainersEnvFromConfigMapRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CloudRunServiceTemplateSpecContainersEnvFromConfigMapRef | undefined;
    set internalValue(value: CloudRunServiceTemplateSpecContainersEnvFromConfigMapRef | undefined);
    private _optional?;
    get optional(): boolean | cdktf.IResolvable;
    set optional(value: boolean | cdktf.IResolvable);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
    private _localObjectReference;
    get localObjectReference(): CloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReferenceOutputReference;
    putLocalObjectReference(value: CloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReference): void;
    resetLocalObjectReference(): void;
    get localObjectReferenceInput(): CloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReference | undefined;
}
export interface CloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReference {
    /**
    * Name of the referent.
  More info:
  https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#name CloudRunService#name}
    */
    readonly name: string;
}
export declare function cloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReferenceToTerraform(struct?: CloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReferenceOutputReference | CloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReference): any;
export declare class CloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReference | undefined;
    set internalValue(value: CloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReference | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface CloudRunServiceTemplateSpecContainersEnvFromSecretRef {
    /**
    * Specify whether the Secret must be defined
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#optional CloudRunService#optional}
    */
    readonly optional?: boolean | cdktf.IResolvable;
    /**
    * local_object_reference block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#local_object_reference CloudRunService#local_object_reference}
    */
    readonly localObjectReference?: CloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReference;
}
export declare function cloudRunServiceTemplateSpecContainersEnvFromSecretRefToTerraform(struct?: CloudRunServiceTemplateSpecContainersEnvFromSecretRefOutputReference | CloudRunServiceTemplateSpecContainersEnvFromSecretRef): any;
export declare class CloudRunServiceTemplateSpecContainersEnvFromSecretRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CloudRunServiceTemplateSpecContainersEnvFromSecretRef | undefined;
    set internalValue(value: CloudRunServiceTemplateSpecContainersEnvFromSecretRef | undefined);
    private _optional?;
    get optional(): boolean | cdktf.IResolvable;
    set optional(value: boolean | cdktf.IResolvable);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
    private _localObjectReference;
    get localObjectReference(): CloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReferenceOutputReference;
    putLocalObjectReference(value: CloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReference): void;
    resetLocalObjectReference(): void;
    get localObjectReferenceInput(): CloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReference | undefined;
}
export interface CloudRunServiceTemplateSpecContainersEnvFrom {
    /**
    * An optional identifier to prepend to each key in the ConfigMap.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#prefix CloudRunService#prefix}
    */
    readonly prefix?: string;
    /**
    * config_map_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#config_map_ref CloudRunService#config_map_ref}
    */
    readonly configMapRef?: CloudRunServiceTemplateSpecContainersEnvFromConfigMapRef;
    /**
    * secret_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#secret_ref CloudRunService#secret_ref}
    */
    readonly secretRef?: CloudRunServiceTemplateSpecContainersEnvFromSecretRef;
}
export declare function cloudRunServiceTemplateSpecContainersEnvFromToTerraform(struct?: CloudRunServiceTemplateSpecContainersEnvFrom | cdktf.IResolvable): any;
export interface CloudRunServiceTemplateSpecContainersPorts {
    /**
    * Port number.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#container_port CloudRunService#container_port}
    */
    readonly containerPort: number;
    /**
    * Name of the port.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#name CloudRunService#name}
    */
    readonly name?: string;
    /**
    * Protocol used on port. Defaults to TCP.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#protocol CloudRunService#protocol}
    */
    readonly protocol?: string;
}
export declare function cloudRunServiceTemplateSpecContainersPortsToTerraform(struct?: CloudRunServiceTemplateSpecContainersPorts | cdktf.IResolvable): any;
export interface CloudRunServiceTemplateSpecContainersResources {
    /**
    * Limits describes the maximum amount of compute resources allowed.
  The values of the map is string form of the 'quantity' k8s type:
  https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#limits CloudRunService#limits}
    */
    readonly limits?: {
        [key: string]: string;
    };
    /**
    * Requests describes the minimum amount of compute resources required.
  If Requests is omitted for a container, it defaults to Limits if that is
  explicitly specified, otherwise to an implementation-defined value.
  The values of the map is string form of the 'quantity' k8s type:
  https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#requests CloudRunService#requests}
    */
    readonly requests?: {
        [key: string]: string;
    };
}
export declare function cloudRunServiceTemplateSpecContainersResourcesToTerraform(struct?: CloudRunServiceTemplateSpecContainersResourcesOutputReference | CloudRunServiceTemplateSpecContainersResources): any;
export declare class CloudRunServiceTemplateSpecContainersResourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CloudRunServiceTemplateSpecContainersResources | undefined;
    set internalValue(value: CloudRunServiceTemplateSpecContainersResources | undefined);
    private _limits?;
    get limits(): {
        [key: string]: string;
    };
    set limits(value: {
        [key: string]: string;
    });
    resetLimits(): void;
    get limitsInput(): {
        [key: string]: string;
    } | undefined;
    private _requests?;
    get requests(): {
        [key: string]: string;
    };
    set requests(value: {
        [key: string]: string;
    });
    resetRequests(): void;
    get requestsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface CloudRunServiceTemplateSpecContainers {
    /**
    * Arguments to the entrypoint.
  The docker image's CMD is used if this is not provided.
  Variable references $(VAR_NAME) are expanded using the container's
  environment. If a variable cannot be resolved, the reference in the input
  string will be unchanged. The $(VAR_NAME) syntax can be escaped with a
  double $$, ie: $$(VAR_NAME). Escaped references will never be expanded,
  regardless of whether the variable exists or not.
  More info:
  https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#args CloudRunService#args}
    */
    readonly args?: string[];
    /**
    * Entrypoint array. Not executed within a shell.
  The docker image's ENTRYPOINT is used if this is not provided.
  Variable references $(VAR_NAME) are expanded using the container's
  environment. If a variable cannot be resolved, the reference in the input
  string will be unchanged. The $(VAR_NAME) syntax can be escaped with a
  double $$, ie: $$(VAR_NAME). Escaped references will never be expanded,
  regardless of whether the variable exists or not.
  More info:
  https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#command CloudRunService#command}
    */
    readonly command?: string[];
    /**
    * Docker image name. This is most often a reference to a container located
  in the container registry, such as gcr.io/cloudrun/hello
  More info: https://kubernetes.io/docs/concepts/containers/images
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#image CloudRunService#image}
    */
    readonly image: string;
    /**
    * Container's working directory.
  If not specified, the container runtime's default will be used, which
  might be configured in the container image.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#working_dir CloudRunService#working_dir}
    */
    readonly workingDir?: string;
    /**
    * env block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#env CloudRunService#env}
    */
    readonly env?: CloudRunServiceTemplateSpecContainersEnv[] | cdktf.IResolvable;
    /**
    * env_from block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#env_from CloudRunService#env_from}
    */
    readonly envFrom?: CloudRunServiceTemplateSpecContainersEnvFrom[] | cdktf.IResolvable;
    /**
    * ports block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#ports CloudRunService#ports}
    */
    readonly ports?: CloudRunServiceTemplateSpecContainersPorts[] | cdktf.IResolvable;
    /**
    * resources block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#resources CloudRunService#resources}
    */
    readonly resources?: CloudRunServiceTemplateSpecContainersResources;
}
export declare function cloudRunServiceTemplateSpecContainersToTerraform(struct?: CloudRunServiceTemplateSpecContainers | cdktf.IResolvable): any;
export interface CloudRunServiceTemplateSpec {
    /**
    * ContainerConcurrency specifies the maximum allowed in-flight (concurrent)
  requests per container of the Revision. Values are:
  - '0' thread-safe, the system should manage the max concurrency. This is
      the default value.
  - '1' not-thread-safe. Single concurrency
  - '2-N' thread-safe, max concurrency of N
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#container_concurrency CloudRunService#container_concurrency}
    */
    readonly containerConcurrency?: number;
    /**
    * Email address of the IAM service account associated with the revision of the
  service. The service account represents the identity of the running revision,
  and determines what permissions the revision has. If not provided, the revision
  will use the project's default service account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#service_account_name CloudRunService#service_account_name}
    */
    readonly serviceAccountName?: string;
    /**
    * TimeoutSeconds holds the max duration the instance is allowed for responding to a request.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#timeout_seconds CloudRunService#timeout_seconds}
    */
    readonly timeoutSeconds?: number;
    /**
    * containers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#containers CloudRunService#containers}
    */
    readonly containers?: CloudRunServiceTemplateSpecContainers[] | cdktf.IResolvable;
}
export declare function cloudRunServiceTemplateSpecToTerraform(struct?: CloudRunServiceTemplateSpecOutputReference | CloudRunServiceTemplateSpec): any;
export declare class CloudRunServiceTemplateSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CloudRunServiceTemplateSpec | undefined;
    set internalValue(value: CloudRunServiceTemplateSpec | undefined);
    private _containerConcurrency?;
    get containerConcurrency(): number;
    set containerConcurrency(value: number);
    resetContainerConcurrency(): void;
    get containerConcurrencyInput(): number | undefined;
    private _serviceAccountName?;
    get serviceAccountName(): string;
    set serviceAccountName(value: string);
    resetServiceAccountName(): void;
    get serviceAccountNameInput(): string | undefined;
    get servingState(): string;
    private _timeoutSeconds?;
    get timeoutSeconds(): number;
    set timeoutSeconds(value: number);
    resetTimeoutSeconds(): void;
    get timeoutSecondsInput(): number | undefined;
    private _containers?;
    get containers(): CloudRunServiceTemplateSpecContainers[] | cdktf.IResolvable;
    set containers(value: CloudRunServiceTemplateSpecContainers[] | cdktf.IResolvable);
    resetContainers(): void;
    get containersInput(): cdktf.IResolvable | CloudRunServiceTemplateSpecContainers[] | undefined;
}
export interface CloudRunServiceTemplate {
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#metadata CloudRunService#metadata}
    */
    readonly metadata?: CloudRunServiceTemplateMetadata;
    /**
    * spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#spec CloudRunService#spec}
    */
    readonly spec?: CloudRunServiceTemplateSpec;
}
export declare function cloudRunServiceTemplateToTerraform(struct?: CloudRunServiceTemplateOutputReference | CloudRunServiceTemplate): any;
export declare class CloudRunServiceTemplateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CloudRunServiceTemplate | undefined;
    set internalValue(value: CloudRunServiceTemplate | undefined);
    private _metadata;
    get metadata(): CloudRunServiceTemplateMetadataOutputReference;
    putMetadata(value: CloudRunServiceTemplateMetadata): void;
    resetMetadata(): void;
    get metadataInput(): CloudRunServiceTemplateMetadata | undefined;
    private _spec;
    get spec(): CloudRunServiceTemplateSpecOutputReference;
    putSpec(value: CloudRunServiceTemplateSpec): void;
    resetSpec(): void;
    get specInput(): CloudRunServiceTemplateSpec | undefined;
}
export interface CloudRunServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#create CloudRunService#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#delete CloudRunService#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#update CloudRunService#update}
    */
    readonly update?: string;
}
export declare function cloudRunServiceTimeoutsToTerraform(struct?: CloudRunServiceTimeoutsOutputReference | CloudRunServiceTimeouts | cdktf.IResolvable): any;
export declare class CloudRunServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CloudRunServiceTimeouts | undefined;
    set internalValue(value: CloudRunServiceTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface CloudRunServiceTraffic {
    /**
    * LatestRevision may be optionally provided to indicate that the latest ready
  Revision of the Configuration should be used for this traffic target. When
  provided LatestRevision must be true if RevisionName is empty; it must be
  false when RevisionName is non-empty.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#latest_revision CloudRunService#latest_revision}
    */
    readonly latestRevision?: boolean | cdktf.IResolvable;
    /**
    * Percent specifies percent of the traffic to this Revision or Configuration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#percent CloudRunService#percent}
    */
    readonly percent: number;
    /**
    * RevisionName of a specific revision to which to send this portion of traffic.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#revision_name CloudRunService#revision_name}
    */
    readonly revisionName?: string;
}
export declare function cloudRunServiceTrafficToTerraform(struct?: CloudRunServiceTraffic | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service google_cloud_run_service}
*/
export declare class CloudRunService extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service google_cloud_run_service} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CloudRunServiceConfig
    */
    constructor(scope: Construct, id: string, config: CloudRunServiceConfig);
    private _autogenerateRevisionName?;
    get autogenerateRevisionName(): boolean | cdktf.IResolvable;
    set autogenerateRevisionName(value: boolean | cdktf.IResolvable);
    resetAutogenerateRevisionName(): void;
    get autogenerateRevisionNameInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    status(index: string): CloudRunServiceStatus;
    private _metadata;
    get metadata(): CloudRunServiceMetadataOutputReference;
    putMetadata(value: CloudRunServiceMetadata): void;
    resetMetadata(): void;
    get metadataInput(): CloudRunServiceMetadata | undefined;
    private _template;
    get template(): CloudRunServiceTemplateOutputReference;
    putTemplate(value: CloudRunServiceTemplate): void;
    resetTemplate(): void;
    get templateInput(): CloudRunServiceTemplate | undefined;
    private _timeouts;
    get timeouts(): CloudRunServiceTimeoutsOutputReference;
    putTimeouts(value: CloudRunServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): CloudRunServiceTimeouts | undefined;
    private _traffic?;
    get traffic(): CloudRunServiceTraffic[] | cdktf.IResolvable;
    set traffic(value: CloudRunServiceTraffic[] | cdktf.IResolvable);
    resetTraffic(): void;
    get trafficInput(): cdktf.IResolvable | CloudRunServiceTraffic[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
