"use strict";
var _a, _b, _c, _d, _e;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudfunctionsFunction = exports.CloudfunctionsFunctionTimeoutsOutputReference = exports.cloudfunctionsFunctionTimeoutsToTerraform = exports.CloudfunctionsFunctionSourceRepositoryOutputReference = exports.cloudfunctionsFunctionSourceRepositoryToTerraform = exports.CloudfunctionsFunctionEventTriggerOutputReference = exports.cloudfunctionsFunctionEventTriggerToTerraform = exports.CloudfunctionsFunctionEventTriggerFailurePolicyOutputReference = exports.cloudfunctionsFunctionEventTriggerFailurePolicyToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function cloudfunctionsFunctionEventTriggerFailurePolicyToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        retry: cdktf.booleanToTerraform(struct.retry),
    };
}
exports.cloudfunctionsFunctionEventTriggerFailurePolicyToTerraform = cloudfunctionsFunctionEventTriggerFailurePolicyToTerraform;
class CloudfunctionsFunctionEventTriggerFailurePolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._retry !== undefined) {
            hasAnyValues = true;
            internalValueResult.retry = this._retry;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._retry = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._retry = value.retry;
        }
    }
    get retry() {
        return this.getBooleanAttribute('retry');
    }
    set retry(value) {
        this._retry = value;
    }
    // Temporarily expose input value. Use with caution.
    get retryInput() {
        return this._retry;
    }
}
exports.CloudfunctionsFunctionEventTriggerFailurePolicyOutputReference = CloudfunctionsFunctionEventTriggerFailurePolicyOutputReference;
_a = JSII_RTTI_SYMBOL_1;
CloudfunctionsFunctionEventTriggerFailurePolicyOutputReference[_a] = { fqn: "@cdktf/provider-google.CloudfunctionsFunctionEventTriggerFailurePolicyOutputReference", version: "0.6.33" };
function cloudfunctionsFunctionEventTriggerToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        event_type: cdktf.stringToTerraform(struct.eventType),
        resource: cdktf.stringToTerraform(struct.resource),
        failure_policy: cloudfunctionsFunctionEventTriggerFailurePolicyToTerraform(struct.failurePolicy),
    };
}
exports.cloudfunctionsFunctionEventTriggerToTerraform = cloudfunctionsFunctionEventTriggerToTerraform;
class CloudfunctionsFunctionEventTriggerOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
        // failure_policy - computed: false, optional: true, required: false
        this._failurePolicy = new CloudfunctionsFunctionEventTriggerFailurePolicyOutputReference(this, "failure_policy", true);
    }
    get internalValue() {
        var _f, _g;
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._eventType !== undefined) {
            hasAnyValues = true;
            internalValueResult.eventType = this._eventType;
        }
        if (this._resource !== undefined) {
            hasAnyValues = true;
            internalValueResult.resource = this._resource;
        }
        if (((_f = this._failurePolicy) === null || _f === void 0 ? void 0 : _f.internalValue) !== undefined) {
            hasAnyValues = true;
            internalValueResult.failurePolicy = (_g = this._failurePolicy) === null || _g === void 0 ? void 0 : _g.internalValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._eventType = undefined;
            this._resource = undefined;
            this._failurePolicy.internalValue = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._eventType = value.eventType;
            this._resource = value.resource;
            this._failurePolicy.internalValue = value.failurePolicy;
        }
    }
    get eventType() {
        return this.getStringAttribute('event_type');
    }
    set eventType(value) {
        this._eventType = value;
    }
    // Temporarily expose input value. Use with caution.
    get eventTypeInput() {
        return this._eventType;
    }
    get resource() {
        return this.getStringAttribute('resource');
    }
    set resource(value) {
        this._resource = value;
    }
    // Temporarily expose input value. Use with caution.
    get resourceInput() {
        return this._resource;
    }
    get failurePolicy() {
        return this._failurePolicy;
    }
    putFailurePolicy(value) {
        this._failurePolicy.internalValue = value;
    }
    resetFailurePolicy() {
        this._failurePolicy.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get failurePolicyInput() {
        return this._failurePolicy.internalValue;
    }
}
exports.CloudfunctionsFunctionEventTriggerOutputReference = CloudfunctionsFunctionEventTriggerOutputReference;
_b = JSII_RTTI_SYMBOL_1;
CloudfunctionsFunctionEventTriggerOutputReference[_b] = { fqn: "@cdktf/provider-google.CloudfunctionsFunctionEventTriggerOutputReference", version: "0.6.33" };
function cloudfunctionsFunctionSourceRepositoryToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        url: cdktf.stringToTerraform(struct.url),
    };
}
exports.cloudfunctionsFunctionSourceRepositoryToTerraform = cloudfunctionsFunctionSourceRepositoryToTerraform;
class CloudfunctionsFunctionSourceRepositoryOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._url !== undefined) {
            hasAnyValues = true;
            internalValueResult.url = this._url;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._url = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._url = value.url;
        }
    }
    // deployed_url - computed: true, optional: false, required: false
    get deployedUrl() {
        return this.getStringAttribute('deployed_url');
    }
    get url() {
        return this.getStringAttribute('url');
    }
    set url(value) {
        this._url = value;
    }
    // Temporarily expose input value. Use with caution.
    get urlInput() {
        return this._url;
    }
}
exports.CloudfunctionsFunctionSourceRepositoryOutputReference = CloudfunctionsFunctionSourceRepositoryOutputReference;
_c = JSII_RTTI_SYMBOL_1;
CloudfunctionsFunctionSourceRepositoryOutputReference[_c] = { fqn: "@cdktf/provider-google.CloudfunctionsFunctionSourceRepositoryOutputReference", version: "0.6.33" };
function cloudfunctionsFunctionTimeoutsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        create: cdktf.stringToTerraform(struct.create),
        delete: cdktf.stringToTerraform(struct.delete),
        read: cdktf.stringToTerraform(struct.read),
        update: cdktf.stringToTerraform(struct.update),
    };
}
exports.cloudfunctionsFunctionTimeoutsToTerraform = cloudfunctionsFunctionTimeoutsToTerraform;
class CloudfunctionsFunctionTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._create !== undefined) {
            hasAnyValues = true;
            internalValueResult.create = this._create;
        }
        if (this._delete !== undefined) {
            hasAnyValues = true;
            internalValueResult.delete = this._delete;
        }
        if (this._read !== undefined) {
            hasAnyValues = true;
            internalValueResult.read = this._read;
        }
        if (this._update !== undefined) {
            hasAnyValues = true;
            internalValueResult.update = this._update;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._create = undefined;
            this._delete = undefined;
            this._read = undefined;
            this._update = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._create = value.create;
            this._delete = value.delete;
            this._read = value.read;
            this._update = value.update;
        }
    }
    get create() {
        return this.getStringAttribute('create');
    }
    set create(value) {
        this._create = value;
    }
    resetCreate() {
        this._create = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createInput() {
        return this._create;
    }
    get delete() {
        return this.getStringAttribute('delete');
    }
    set delete(value) {
        this._delete = value;
    }
    resetDelete() {
        this._delete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteInput() {
        return this._delete;
    }
    get read() {
        return this.getStringAttribute('read');
    }
    set read(value) {
        this._read = value;
    }
    resetRead() {
        this._read = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get readInput() {
        return this._read;
    }
    get update() {
        return this.getStringAttribute('update');
    }
    set update(value) {
        this._update = value;
    }
    resetUpdate() {
        this._update = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get updateInput() {
        return this._update;
    }
}
exports.CloudfunctionsFunctionTimeoutsOutputReference = CloudfunctionsFunctionTimeoutsOutputReference;
_d = JSII_RTTI_SYMBOL_1;
CloudfunctionsFunctionTimeoutsOutputReference[_d] = { fqn: "@cdktf/provider-google.CloudfunctionsFunctionTimeoutsOutputReference", version: "0.6.33" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function google_cloudfunctions_function}
*/
class CloudfunctionsFunction extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function google_cloudfunctions_function} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CloudfunctionsFunctionConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'google_cloudfunctions_function',
            terraformGeneratorMetadata: {
                providerName: 'google'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        // event_trigger - computed: false, optional: true, required: false
        this._eventTrigger = new CloudfunctionsFunctionEventTriggerOutputReference(this, "event_trigger", true);
        // source_repository - computed: false, optional: true, required: false
        this._sourceRepository = new CloudfunctionsFunctionSourceRepositoryOutputReference(this, "source_repository", true);
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new CloudfunctionsFunctionTimeoutsOutputReference(this, "timeouts", true);
        this._availableMemoryMb = config.availableMemoryMb;
        this._buildEnvironmentVariables = config.buildEnvironmentVariables;
        this._description = config.description;
        this._entryPoint = config.entryPoint;
        this._environmentVariables = config.environmentVariables;
        this._httpsTriggerUrl = config.httpsTriggerUrl;
        this._ingressSettings = config.ingressSettings;
        this._labels = config.labels;
        this._maxInstances = config.maxInstances;
        this._name = config.name;
        this._project = config.project;
        this._region = config.region;
        this._runtime = config.runtime;
        this._serviceAccountEmail = config.serviceAccountEmail;
        this._sourceArchiveBucket = config.sourceArchiveBucket;
        this._sourceArchiveObject = config.sourceArchiveObject;
        this._timeout = config.timeout;
        this._triggerHttp = config.triggerHttp;
        this._vpcConnector = config.vpcConnector;
        this._vpcConnectorEgressSettings = config.vpcConnectorEgressSettings;
        this._eventTrigger.internalValue = config.eventTrigger;
        this._sourceRepository.internalValue = config.sourceRepository;
        this._timeouts.internalValue = config.timeouts;
    }
    get availableMemoryMb() {
        return this.getNumberAttribute('available_memory_mb');
    }
    set availableMemoryMb(value) {
        this._availableMemoryMb = value;
    }
    resetAvailableMemoryMb() {
        this._availableMemoryMb = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get availableMemoryMbInput() {
        return this._availableMemoryMb;
    }
    get buildEnvironmentVariables() {
        return this.getStringMapAttribute('build_environment_variables');
    }
    set buildEnvironmentVariables(value) {
        this._buildEnvironmentVariables = value;
    }
    resetBuildEnvironmentVariables() {
        this._buildEnvironmentVariables = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get buildEnvironmentVariablesInput() {
        return this._buildEnvironmentVariables;
    }
    get description() {
        return this.getStringAttribute('description');
    }
    set description(value) {
        this._description = value;
    }
    resetDescription() {
        this._description = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get descriptionInput() {
        return this._description;
    }
    get entryPoint() {
        return this.getStringAttribute('entry_point');
    }
    set entryPoint(value) {
        this._entryPoint = value;
    }
    resetEntryPoint() {
        this._entryPoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get entryPointInput() {
        return this._entryPoint;
    }
    get environmentVariables() {
        return this.getStringMapAttribute('environment_variables');
    }
    set environmentVariables(value) {
        this._environmentVariables = value;
    }
    resetEnvironmentVariables() {
        this._environmentVariables = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get environmentVariablesInput() {
        return this._environmentVariables;
    }
    get httpsTriggerUrl() {
        return this.getStringAttribute('https_trigger_url');
    }
    set httpsTriggerUrl(value) {
        this._httpsTriggerUrl = value;
    }
    resetHttpsTriggerUrl() {
        this._httpsTriggerUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get httpsTriggerUrlInput() {
        return this._httpsTriggerUrl;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get ingressSettings() {
        return this.getStringAttribute('ingress_settings');
    }
    set ingressSettings(value) {
        this._ingressSettings = value;
    }
    resetIngressSettings() {
        this._ingressSettings = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ingressSettingsInput() {
        return this._ingressSettings;
    }
    get labels() {
        return this.getStringMapAttribute('labels');
    }
    set labels(value) {
        this._labels = value;
    }
    resetLabels() {
        this._labels = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get labelsInput() {
        return this._labels;
    }
    get maxInstances() {
        return this.getNumberAttribute('max_instances');
    }
    set maxInstances(value) {
        this._maxInstances = value;
    }
    resetMaxInstances() {
        this._maxInstances = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxInstancesInput() {
        return this._maxInstances;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get project() {
        return this.getStringAttribute('project');
    }
    set project(value) {
        this._project = value;
    }
    resetProject() {
        this._project = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get projectInput() {
        return this._project;
    }
    get region() {
        return this.getStringAttribute('region');
    }
    set region(value) {
        this._region = value;
    }
    resetRegion() {
        this._region = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get regionInput() {
        return this._region;
    }
    get runtime() {
        return this.getStringAttribute('runtime');
    }
    set runtime(value) {
        this._runtime = value;
    }
    // Temporarily expose input value. Use with caution.
    get runtimeInput() {
        return this._runtime;
    }
    get serviceAccountEmail() {
        return this.getStringAttribute('service_account_email');
    }
    set serviceAccountEmail(value) {
        this._serviceAccountEmail = value;
    }
    resetServiceAccountEmail() {
        this._serviceAccountEmail = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get serviceAccountEmailInput() {
        return this._serviceAccountEmail;
    }
    get sourceArchiveBucket() {
        return this.getStringAttribute('source_archive_bucket');
    }
    set sourceArchiveBucket(value) {
        this._sourceArchiveBucket = value;
    }
    resetSourceArchiveBucket() {
        this._sourceArchiveBucket = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sourceArchiveBucketInput() {
        return this._sourceArchiveBucket;
    }
    get sourceArchiveObject() {
        return this.getStringAttribute('source_archive_object');
    }
    set sourceArchiveObject(value) {
        this._sourceArchiveObject = value;
    }
    resetSourceArchiveObject() {
        this._sourceArchiveObject = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sourceArchiveObjectInput() {
        return this._sourceArchiveObject;
    }
    get timeout() {
        return this.getNumberAttribute('timeout');
    }
    set timeout(value) {
        this._timeout = value;
    }
    resetTimeout() {
        this._timeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutInput() {
        return this._timeout;
    }
    get triggerHttp() {
        return this.getBooleanAttribute('trigger_http');
    }
    set triggerHttp(value) {
        this._triggerHttp = value;
    }
    resetTriggerHttp() {
        this._triggerHttp = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get triggerHttpInput() {
        return this._triggerHttp;
    }
    get vpcConnector() {
        return this.getStringAttribute('vpc_connector');
    }
    set vpcConnector(value) {
        this._vpcConnector = value;
    }
    resetVpcConnector() {
        this._vpcConnector = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vpcConnectorInput() {
        return this._vpcConnector;
    }
    get vpcConnectorEgressSettings() {
        return this.getStringAttribute('vpc_connector_egress_settings');
    }
    set vpcConnectorEgressSettings(value) {
        this._vpcConnectorEgressSettings = value;
    }
    resetVpcConnectorEgressSettings() {
        this._vpcConnectorEgressSettings = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vpcConnectorEgressSettingsInput() {
        return this._vpcConnectorEgressSettings;
    }
    get eventTrigger() {
        return this._eventTrigger;
    }
    putEventTrigger(value) {
        this._eventTrigger.internalValue = value;
    }
    resetEventTrigger() {
        this._eventTrigger.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get eventTriggerInput() {
        return this._eventTrigger.internalValue;
    }
    get sourceRepository() {
        return this._sourceRepository;
    }
    putSourceRepository(value) {
        this._sourceRepository.internalValue = value;
    }
    resetSourceRepository() {
        this._sourceRepository.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sourceRepositoryInput() {
        return this._sourceRepository.internalValue;
    }
    get timeouts() {
        return this._timeouts;
    }
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            available_memory_mb: cdktf.numberToTerraform(this._availableMemoryMb),
            build_environment_variables: cdktf.hashMapper(cdktf.stringToTerraform)(this._buildEnvironmentVariables),
            description: cdktf.stringToTerraform(this._description),
            entry_point: cdktf.stringToTerraform(this._entryPoint),
            environment_variables: cdktf.hashMapper(cdktf.stringToTerraform)(this._environmentVariables),
            https_trigger_url: cdktf.stringToTerraform(this._httpsTriggerUrl),
            ingress_settings: cdktf.stringToTerraform(this._ingressSettings),
            labels: cdktf.hashMapper(cdktf.stringToTerraform)(this._labels),
            max_instances: cdktf.numberToTerraform(this._maxInstances),
            name: cdktf.stringToTerraform(this._name),
            project: cdktf.stringToTerraform(this._project),
            region: cdktf.stringToTerraform(this._region),
            runtime: cdktf.stringToTerraform(this._runtime),
            service_account_email: cdktf.stringToTerraform(this._serviceAccountEmail),
            source_archive_bucket: cdktf.stringToTerraform(this._sourceArchiveBucket),
            source_archive_object: cdktf.stringToTerraform(this._sourceArchiveObject),
            timeout: cdktf.numberToTerraform(this._timeout),
            trigger_http: cdktf.booleanToTerraform(this._triggerHttp),
            vpc_connector: cdktf.stringToTerraform(this._vpcConnector),
            vpc_connector_egress_settings: cdktf.stringToTerraform(this._vpcConnectorEgressSettings),
            event_trigger: cloudfunctionsFunctionEventTriggerToTerraform(this._eventTrigger.internalValue),
            source_repository: cloudfunctionsFunctionSourceRepositoryToTerraform(this._sourceRepository.internalValue),
            timeouts: cloudfunctionsFunctionTimeoutsToTerraform(this._timeouts.internalValue),
        };
    }
}
exports.CloudfunctionsFunction = CloudfunctionsFunction;
_e = JSII_RTTI_SYMBOL_1;
CloudfunctionsFunction[_e] = { fqn: "@cdktf/provider-google.CloudfunctionsFunction", version: "0.6.33" };
// =================
// STATIC PROPERTIES
// =================
CloudfunctionsFunction.tfResourceType = "google_cloudfunctions_function";
//# sourceMappingURL=data:application/json;base64,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