import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeImageConfig extends cdktf.TerraformMetaArguments {
    /**
    * An optional description of this resource. Provide this property when
  you create the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image#description ComputeImage#description}
    */
    readonly description?: string;
    /**
    * Size of the image when restored onto a persistent disk (in GB).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image#disk_size_gb ComputeImage#disk_size_gb}
    */
    readonly diskSizeGb?: number;
    /**
    * The name of the image family to which this image belongs. You can
  create disks by specifying an image family instead of a specific
  image name. The image family always returns its latest image that is
  not deprecated. The name of the image family must comply with
  RFC1035.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image#family ComputeImage#family}
    */
    readonly family?: string;
    /**
    * Labels to apply to this Image.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image#labels ComputeImage#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Any applicable license URI.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image#licenses ComputeImage#licenses}
    */
    readonly licenses?: string[];
    /**
    * Name of the resource; provided by the client when the resource is
  created. The name must be 1-63 characters long, and comply with
  RFC1035. Specifically, the name must be 1-63 characters long and
  match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means
  the first character must be a lowercase letter, and all following
  characters must be a dash, lowercase letter, or digit, except the
  last character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image#name ComputeImage#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image#project ComputeImage#project}
    */
    readonly project?: string;
    /**
    * The source disk to create this image based on.
  You must provide either this property or the
  rawDisk.source property but not both to create an image.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image#source_disk ComputeImage#source_disk}
    */
    readonly sourceDisk?: string;
    /**
    * URL of the source image used to create this image. In order to create an image, you must provide the full or partial
  URL of one of the following:
  
  * The selfLink URL
  * This property
  * The rawDisk.source URL
  * The sourceDisk URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image#source_image ComputeImage#source_image}
    */
    readonly sourceImage?: string;
    /**
    * URL of the source snapshot used to create this image.
  
  In order to create an image, you must provide the full or partial URL of one of the following:
  
  * The selfLink URL
  * This property
  * The sourceImage URL
  * The rawDisk.source URL
  * The sourceDisk URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image#source_snapshot ComputeImage#source_snapshot}
    */
    readonly sourceSnapshot?: string;
    /**
    * guest_os_features block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image#guest_os_features ComputeImage#guest_os_features}
    */
    readonly guestOsFeatures?: ComputeImageGuestOsFeatures[] | cdktf.IResolvable;
    /**
    * raw_disk block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image#raw_disk ComputeImage#raw_disk}
    */
    readonly rawDisk?: ComputeImageRawDisk;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image#timeouts ComputeImage#timeouts}
    */
    readonly timeouts?: ComputeImageTimeouts;
}
export interface ComputeImageGuestOsFeatures {
    /**
    * The type of supported feature. Read [Enabling guest operating system features](https://cloud.google.com/compute/docs/images/create-delete-deprecate-private-images#guest-os-features) to see a list of available options. Possible values: ["MULTI_IP_SUBNET", "SECURE_BOOT", "SEV_CAPABLE", "UEFI_COMPATIBLE", "VIRTIO_SCSI_MULTIQUEUE", "WINDOWS", "GVNIC"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image#type ComputeImage#type}
    */
    readonly type: string;
}
export declare function computeImageGuestOsFeaturesToTerraform(struct?: ComputeImageGuestOsFeatures | cdktf.IResolvable): any;
export interface ComputeImageRawDisk {
    /**
    * The format used to encode and transmit the block device, which
  should be TAR. This is just a container and transmission format
  and not a runtime format. Provided by the client when the disk
  image is created. Default value: "TAR" Possible values: ["TAR"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image#container_type ComputeImage#container_type}
    */
    readonly containerType?: string;
    /**
    * An optional SHA1 checksum of the disk image before unpackaging.
  This is provided by the client when the disk image is created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image#sha1 ComputeImage#sha1}
    */
    readonly sha1?: string;
    /**
    * The full Google Cloud Storage URL where disk storage is stored
  You must provide either this property or the sourceDisk property
  but not both.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image#source ComputeImage#source}
    */
    readonly source: string;
}
export declare function computeImageRawDiskToTerraform(struct?: ComputeImageRawDiskOutputReference | ComputeImageRawDisk): any;
export declare class ComputeImageRawDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ComputeImageRawDisk | undefined;
    set internalValue(value: ComputeImageRawDisk | undefined);
    private _containerType?;
    get containerType(): string;
    set containerType(value: string);
    resetContainerType(): void;
    get containerTypeInput(): string | undefined;
    private _sha1?;
    get sha1(): string;
    set sha1(value: string);
    resetSha1(): void;
    get sha1Input(): string | undefined;
    private _source?;
    get source(): string;
    set source(value: string);
    get sourceInput(): string | undefined;
}
export interface ComputeImageTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image#create ComputeImage#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image#delete ComputeImage#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image#update ComputeImage#update}
    */
    readonly update?: string;
}
export declare function computeImageTimeoutsToTerraform(struct?: ComputeImageTimeoutsOutputReference | ComputeImageTimeouts | cdktf.IResolvable): any;
export declare class ComputeImageTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ComputeImageTimeouts | undefined;
    set internalValue(value: ComputeImageTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_image google_compute_image}
*/
export declare class ComputeImage extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_image google_compute_image} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeImageConfig
    */
    constructor(scope: Construct, id: string, config: ComputeImageConfig);
    get archiveSizeBytes(): number;
    get creationTimestamp(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _diskSizeGb?;
    get diskSizeGb(): number;
    set diskSizeGb(value: number);
    resetDiskSizeGb(): void;
    get diskSizeGbInput(): number | undefined;
    private _family?;
    get family(): string;
    set family(value: string);
    resetFamily(): void;
    get familyInput(): string | undefined;
    get id(): string;
    get labelFingerprint(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _licenses?;
    get licenses(): string[];
    set licenses(value: string[]);
    resetLicenses(): void;
    get licensesInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _sourceDisk?;
    get sourceDisk(): string;
    set sourceDisk(value: string);
    resetSourceDisk(): void;
    get sourceDiskInput(): string | undefined;
    private _sourceImage?;
    get sourceImage(): string;
    set sourceImage(value: string);
    resetSourceImage(): void;
    get sourceImageInput(): string | undefined;
    private _sourceSnapshot?;
    get sourceSnapshot(): string;
    set sourceSnapshot(value: string);
    resetSourceSnapshot(): void;
    get sourceSnapshotInput(): string | undefined;
    private _guestOsFeatures?;
    get guestOsFeatures(): ComputeImageGuestOsFeatures[] | cdktf.IResolvable;
    set guestOsFeatures(value: ComputeImageGuestOsFeatures[] | cdktf.IResolvable);
    resetGuestOsFeatures(): void;
    get guestOsFeaturesInput(): cdktf.IResolvable | ComputeImageGuestOsFeatures[] | undefined;
    private _rawDisk;
    get rawDisk(): ComputeImageRawDiskOutputReference;
    putRawDisk(value: ComputeImageRawDisk): void;
    resetRawDisk(): void;
    get rawDiskInput(): ComputeImageRawDisk | undefined;
    private _timeouts;
    get timeouts(): ComputeImageTimeoutsOutputReference;
    putTimeouts(value: ComputeImageTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeImageTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
