import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeRouterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Name of the resource. The name must be 1-63 characters long, and
  comply with RFC1035. Specifically, the name must be 1-63 characters
  long and match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?'
  which means the first character must be a lowercase letter, and all
  following characters must be a dash, lowercase letter, or digit,
  except the last character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_router#name DataGoogleComputeRouter#name}
    */
    readonly name: string;
    /**
    * A reference to the network to which this router belongs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_router#network DataGoogleComputeRouter#network}
    */
    readonly network: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_router#project DataGoogleComputeRouter#project}
    */
    readonly project?: string;
    /**
    * Region where the router resides.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_router#region DataGoogleComputeRouter#region}
    */
    readonly region?: string;
}
export declare class DataGoogleComputeRouterBgpAdvertisedIpRanges extends cdktf.ComplexComputedList {
    get description(): string;
    get range(): string;
}
export declare class DataGoogleComputeRouterBgp extends cdktf.ComplexComputedList {
    get advertiseMode(): string;
    get advertisedGroups(): string[];
    get advertisedIpRanges(): cdktf.IResolvable;
    get asn(): number;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/compute_router google_compute_router}
*/
export declare class DataGoogleComputeRouter extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/compute_router google_compute_router} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleComputeRouterConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleComputeRouterConfig);
    bgp(index: string): DataGoogleComputeRouterBgp;
    get creationTimestamp(): string;
    get description(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    get networkInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get selfLink(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
