import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleMonitoringNotificationChannelConfig extends cdktf.TerraformMetaArguments {
    /**
    * An optional human-readable name for this notification channel. It is recommended that you specify a non-empty and unique name in order to make it easier to identify the channels in your project, though this is not enforced. The display name is limited to 512 Unicode characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/monitoring_notification_channel#display_name DataGoogleMonitoringNotificationChannel#display_name}
    */
    readonly displayName?: string;
    /**
    * Configuration fields that define the channel and its behavior. The
  permissible and required labels are specified in the
  NotificationChannelDescriptor corresponding to the type field.
  
  Labels with sensitive data are obfuscated by the API and therefore Terraform cannot
  determine if there are upstream changes to these fields. They can also be configured via
  the sensitive_labels block, but cannot be configured in both places.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/monitoring_notification_channel#labels DataGoogleMonitoringNotificationChannel#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/monitoring_notification_channel#project DataGoogleMonitoringNotificationChannel#project}
    */
    readonly project?: string;
    /**
    * The type of the notification channel. This field matches the value of the NotificationChannelDescriptor.type field. See https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.notificationChannelDescriptors/list to get the list of valid values such as "email", "slack", etc...
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/monitoring_notification_channel#type DataGoogleMonitoringNotificationChannel#type}
    */
    readonly type?: string;
    /**
    * User-supplied key/value data that does not need to conform to the corresponding NotificationChannelDescriptor's schema, unlike the labels field. This field is intended to be used for organizing and identifying the NotificationChannel objects.The field can contain up to 64 entries. Each key and value is limited to 63 Unicode characters or 128 bytes, whichever is smaller. Labels and values can contain only lowercase letters, numerals, underscores, and dashes. Keys must begin with a letter.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/monitoring_notification_channel#user_labels DataGoogleMonitoringNotificationChannel#user_labels}
    */
    readonly userLabels?: {
        [key: string]: string;
    };
}
export declare class DataGoogleMonitoringNotificationChannelSensitiveLabels extends cdktf.ComplexComputedList {
    get authToken(): string;
    get password(): string;
    get serviceKey(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/monitoring_notification_channel google_monitoring_notification_channel}
*/
export declare class DataGoogleMonitoringNotificationChannel extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/monitoring_notification_channel google_monitoring_notification_channel} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleMonitoringNotificationChannelConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGoogleMonitoringNotificationChannelConfig);
    get description(): string;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    get enabled(): cdktf.IResolvable;
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    sensitiveLabels(index: string): DataGoogleMonitoringNotificationChannelSensitiveLabels;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _userLabels?;
    get userLabels(): {
        [key: string]: string;
    };
    set userLabels(value: {
        [key: string]: string;
    });
    resetUserLabels(): void;
    get userLabelsInput(): {
        [key: string]: string;
    } | undefined;
    get verificationStatus(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
