import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleRuntimeconfigConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the runtime config.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/runtimeconfig_config#name DataGoogleRuntimeconfigConfig#name}
    */
    readonly name: string;
    /**
    * The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/runtimeconfig_config#project DataGoogleRuntimeconfigConfig#project}
    */
    readonly project?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/runtimeconfig_config google_runtimeconfig_config}
*/
export declare class DataGoogleRuntimeconfigConfig extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/runtimeconfig_config google_runtimeconfig_config} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleRuntimeconfigConfigConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleRuntimeconfigConfigConfig);
    get description(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
