import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DnsPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * A textual description field. Defaults to 'Managed by Terraform'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy#description DnsPolicy#description}
    */
    readonly description?: string;
    /**
    * Allows networks bound to this policy to receive DNS queries sent
  by VMs or applications over VPN connections. When enabled, a
  virtual IP address will be allocated from each of the sub-networks
  that are bound to this policy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy#enable_inbound_forwarding DnsPolicy#enable_inbound_forwarding}
    */
    readonly enableInboundForwarding?: boolean | cdktf.IResolvable;
    /**
    * Controls whether logging is enabled for the networks bound to this policy.
  Defaults to no logging if not set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy#enable_logging DnsPolicy#enable_logging}
    */
    readonly enableLogging?: boolean | cdktf.IResolvable;
    /**
    * User assigned name for this policy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy#name DnsPolicy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy#project DnsPolicy#project}
    */
    readonly project?: string;
    /**
    * alternative_name_server_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy#alternative_name_server_config DnsPolicy#alternative_name_server_config}
    */
    readonly alternativeNameServerConfig?: DnsPolicyAlternativeNameServerConfig;
    /**
    * networks block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy#networks DnsPolicy#networks}
    */
    readonly networks?: DnsPolicyNetworks[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy#timeouts DnsPolicy#timeouts}
    */
    readonly timeouts?: DnsPolicyTimeouts;
}
export interface DnsPolicyAlternativeNameServerConfigTargetNameServers {
    /**
    * Forwarding path for this TargetNameServer. If unset or 'default' Cloud DNS will make forwarding
  decision based on address ranges, i.e. RFC1918 addresses go to the VPC, Non-RFC1918 addresses go
  to the Internet. When set to 'private', Cloud DNS will always send queries through VPC for this target Possible values: ["default", "private"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy#forwarding_path DnsPolicy#forwarding_path}
    */
    readonly forwardingPath?: string;
    /**
    * IPv4 address to forward to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy#ipv4_address DnsPolicy#ipv4_address}
    */
    readonly ipv4Address: string;
}
export declare function dnsPolicyAlternativeNameServerConfigTargetNameServersToTerraform(struct?: DnsPolicyAlternativeNameServerConfigTargetNameServers | cdktf.IResolvable): any;
export interface DnsPolicyAlternativeNameServerConfig {
    /**
    * target_name_servers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy#target_name_servers DnsPolicy#target_name_servers}
    */
    readonly targetNameServers: DnsPolicyAlternativeNameServerConfigTargetNameServers[] | cdktf.IResolvable;
}
export declare function dnsPolicyAlternativeNameServerConfigToTerraform(struct?: DnsPolicyAlternativeNameServerConfigOutputReference | DnsPolicyAlternativeNameServerConfig): any;
export declare class DnsPolicyAlternativeNameServerConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DnsPolicyAlternativeNameServerConfig | undefined;
    set internalValue(value: DnsPolicyAlternativeNameServerConfig | undefined);
    private _targetNameServers?;
    get targetNameServers(): DnsPolicyAlternativeNameServerConfigTargetNameServers[] | cdktf.IResolvable;
    set targetNameServers(value: DnsPolicyAlternativeNameServerConfigTargetNameServers[] | cdktf.IResolvable);
    get targetNameServersInput(): cdktf.IResolvable | DnsPolicyAlternativeNameServerConfigTargetNameServers[] | undefined;
}
export interface DnsPolicyNetworks {
    /**
    * The id or fully qualified URL of the VPC network to forward queries to.
  This should be formatted like 'projects/{project}/global/networks/{network}' or
  'https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy#network_url DnsPolicy#network_url}
    */
    readonly networkUrl: string;
}
export declare function dnsPolicyNetworksToTerraform(struct?: DnsPolicyNetworks | cdktf.IResolvable): any;
export interface DnsPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy#create DnsPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy#delete DnsPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy#update DnsPolicy#update}
    */
    readonly update?: string;
}
export declare function dnsPolicyTimeoutsToTerraform(struct?: DnsPolicyTimeoutsOutputReference | DnsPolicyTimeouts | cdktf.IResolvable): any;
export declare class DnsPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DnsPolicyTimeouts | undefined;
    set internalValue(value: DnsPolicyTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/dns_policy google_dns_policy}
*/
export declare class DnsPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/dns_policy google_dns_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DnsPolicyConfig
    */
    constructor(scope: Construct, id: string, config: DnsPolicyConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _enableInboundForwarding?;
    get enableInboundForwarding(): boolean | cdktf.IResolvable;
    set enableInboundForwarding(value: boolean | cdktf.IResolvable);
    resetEnableInboundForwarding(): void;
    get enableInboundForwardingInput(): boolean | cdktf.IResolvable | undefined;
    private _enableLogging?;
    get enableLogging(): boolean | cdktf.IResolvable;
    set enableLogging(value: boolean | cdktf.IResolvable);
    resetEnableLogging(): void;
    get enableLoggingInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _alternativeNameServerConfig;
    get alternativeNameServerConfig(): DnsPolicyAlternativeNameServerConfigOutputReference;
    putAlternativeNameServerConfig(value: DnsPolicyAlternativeNameServerConfig): void;
    resetAlternativeNameServerConfig(): void;
    get alternativeNameServerConfigInput(): DnsPolicyAlternativeNameServerConfig | undefined;
    private _networks?;
    get networks(): DnsPolicyNetworks[] | cdktf.IResolvable;
    set networks(value: DnsPolicyNetworks[] | cdktf.IResolvable);
    resetNetworks(): void;
    get networksInput(): cdktf.IResolvable | DnsPolicyNetworks[] | undefined;
    private _timeouts;
    get timeouts(): DnsPolicyTimeoutsOutputReference;
    putTimeouts(value: DnsPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DnsPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
