import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface HealthcareConsentStoreConfig extends cdktf.TerraformMetaArguments {
    /**
    * Identifies the dataset addressed by this request. Must be in the format
  'projects/{project}/locations/{location}/datasets/{dataset}'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_consent_store#dataset HealthcareConsentStore#dataset}
    */
    readonly dataset: string;
    /**
    * Default time to live for consents in this store. Must be at least 24 hours. Updating this field will not affect the expiration time of existing consents.
  
  A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_consent_store#default_consent_ttl HealthcareConsentStore#default_consent_ttl}
    */
    readonly defaultConsentTtl?: string;
    /**
    * If true, [consents.patch] [google.cloud.healthcare.v1.consent.UpdateConsent] creates the consent if it does not already exist.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_consent_store#enable_consent_create_on_update HealthcareConsentStore#enable_consent_create_on_update}
    */
    readonly enableConsentCreateOnUpdate?: boolean | cdktf.IResolvable;
    /**
    * User-supplied key-value pairs used to organize Consent stores.
  
  Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes, and must
  conform to the following PCRE regular expression: '[\p{Ll}\p{Lo}][\p{Ll}\p{Lo}\p{N}_-]{0,62}'
  
  Label values are optional, must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128
  bytes, and must conform to the following PCRE regular expression: '[\p{Ll}\p{Lo}\p{N}_-]{0,63}'
  
  No more than 64 labels can be associated with a given store.
  
  An object containing a list of "key": value pairs.
  Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_consent_store#labels HealthcareConsentStore#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The name of this ConsentStore, for example:
  "consent1"
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_consent_store#name HealthcareConsentStore#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_consent_store#timeouts HealthcareConsentStore#timeouts}
    */
    readonly timeouts?: HealthcareConsentStoreTimeouts;
}
export interface HealthcareConsentStoreTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_consent_store#create HealthcareConsentStore#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_consent_store#delete HealthcareConsentStore#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_consent_store#update HealthcareConsentStore#update}
    */
    readonly update?: string;
}
export declare function healthcareConsentStoreTimeoutsToTerraform(struct?: HealthcareConsentStoreTimeoutsOutputReference | HealthcareConsentStoreTimeouts | cdktf.IResolvable): any;
export declare class HealthcareConsentStoreTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): HealthcareConsentStoreTimeouts | undefined;
    set internalValue(value: HealthcareConsentStoreTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/healthcare_consent_store google_healthcare_consent_store}
*/
export declare class HealthcareConsentStore extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/healthcare_consent_store google_healthcare_consent_store} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options HealthcareConsentStoreConfig
    */
    constructor(scope: Construct, id: string, config: HealthcareConsentStoreConfig);
    private _dataset?;
    get dataset(): string;
    set dataset(value: string);
    get datasetInput(): string | undefined;
    private _defaultConsentTtl?;
    get defaultConsentTtl(): string;
    set defaultConsentTtl(value: string);
    resetDefaultConsentTtl(): void;
    get defaultConsentTtlInput(): string | undefined;
    private _enableConsentCreateOnUpdate?;
    get enableConsentCreateOnUpdate(): boolean | cdktf.IResolvable;
    set enableConsentCreateOnUpdate(value: boolean | cdktf.IResolvable);
    resetEnableConsentCreateOnUpdate(): void;
    get enableConsentCreateOnUpdateInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _timeouts;
    get timeouts(): HealthcareConsentStoreTimeoutsOutputReference;
    putTimeouts(value: HealthcareConsentStoreTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): HealthcareConsentStoreTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
