import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ProjectConfig extends cdktf.TerraformMetaArguments {
    /**
    * Create the 'default' network automatically.  Default true. If set to false, the default network will be deleted.  Note that, for quota purposes, you will still need to have 1 network slot available to create the project successfully, even if you set auto_create_network to false, since the network will exist momentarily.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project#auto_create_network Project#auto_create_network}
    */
    readonly autoCreateNetwork?: boolean | cdktf.IResolvable;
    /**
    * The alphanumeric ID of the billing account this project belongs to. The user or service account performing this operation with Terraform must have Billing Account Administrator privileges (roles/billing.admin) in the organization. See Google Cloud Billing API Access Control for more details.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project#billing_account Project#billing_account}
    */
    readonly billingAccount?: string;
    /**
    * The numeric ID of the folder this project should be created under. Only one of org_id or folder_id may be specified. If the folder_id is specified, then the project is created under the specified folder. Changing this forces the project to be migrated to the newly specified folder.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project#folder_id Project#folder_id}
    */
    readonly folderId?: string;
    /**
    * A set of key/value label pairs to assign to the project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project#labels Project#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The display name of the project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project#name Project#name}
    */
    readonly name: string;
    /**
    * The numeric ID of the organization this project belongs to. Changing this forces a new project to be created.  Only one of org_id or folder_id may be specified. If the org_id is specified then the project is created at the top level. Changing this forces the project to be migrated to the newly specified organization.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project#org_id Project#org_id}
    */
    readonly orgId?: string;
    /**
    * The project ID. Changing this forces a new project to be created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project#project_id Project#project_id}
    */
    readonly projectId: string;
    /**
    * If true, the Terraform resource can be deleted without deleting the Project via the Google API.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project#skip_delete Project#skip_delete}
    */
    readonly skipDelete?: boolean | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project#timeouts Project#timeouts}
    */
    readonly timeouts?: ProjectTimeouts;
}
export interface ProjectTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project#create Project#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project#delete Project#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project#read Project#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project#update Project#update}
    */
    readonly update?: string;
}
export declare function projectTimeoutsToTerraform(struct?: ProjectTimeoutsOutputReference | ProjectTimeouts | cdktf.IResolvable): any;
export declare class ProjectTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ProjectTimeouts | undefined;
    set internalValue(value: ProjectTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/project google_project}
*/
export declare class Project extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/project google_project} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProjectConfig
    */
    constructor(scope: Construct, id: string, config: ProjectConfig);
    private _autoCreateNetwork?;
    get autoCreateNetwork(): boolean | cdktf.IResolvable;
    set autoCreateNetwork(value: boolean | cdktf.IResolvable);
    resetAutoCreateNetwork(): void;
    get autoCreateNetworkInput(): boolean | cdktf.IResolvable | undefined;
    private _billingAccount?;
    get billingAccount(): string;
    set billingAccount(value: string);
    resetBillingAccount(): void;
    get billingAccountInput(): string | undefined;
    private _folderId?;
    get folderId(): string;
    set folderId(value: string);
    resetFolderId(): void;
    get folderIdInput(): string | undefined;
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get number(): string;
    private _orgId?;
    get orgId(): string;
    set orgId(value: string);
    resetOrgId(): void;
    get orgIdInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _skipDelete?;
    get skipDelete(): boolean | cdktf.IResolvable;
    set skipDelete(value: boolean | cdktf.IResolvable);
    resetSkipDelete(): void;
    get skipDeleteInput(): boolean | cdktf.IResolvable | undefined;
    private _timeouts;
    get timeouts(): ProjectTimeoutsOutputReference;
    putTimeouts(value: ProjectTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ProjectTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
