import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ServiceAccountIamBindingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account_iam_binding#members ServiceAccountIamBinding#members}
    */
    readonly members: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account_iam_binding#role ServiceAccountIamBinding#role}
    */
    readonly role: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account_iam_binding#service_account_id ServiceAccountIamBinding#service_account_id}
    */
    readonly serviceAccountId: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account_iam_binding#condition ServiceAccountIamBinding#condition}
    */
    readonly condition?: ServiceAccountIamBindingCondition;
}
export interface ServiceAccountIamBindingCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account_iam_binding#description ServiceAccountIamBinding#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account_iam_binding#expression ServiceAccountIamBinding#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account_iam_binding#title ServiceAccountIamBinding#title}
    */
    readonly title: string;
}
export declare function serviceAccountIamBindingConditionToTerraform(struct?: ServiceAccountIamBindingConditionOutputReference | ServiceAccountIamBindingCondition): any;
export declare class ServiceAccountIamBindingConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ServiceAccountIamBindingCondition | undefined;
    set internalValue(value: ServiceAccountIamBindingCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/service_account_iam_binding google_service_account_iam_binding}
*/
export declare class ServiceAccountIamBinding extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/service_account_iam_binding google_service_account_iam_binding} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServiceAccountIamBindingConfig
    */
    constructor(scope: Construct, id: string, config: ServiceAccountIamBindingConfig);
    get etag(): string;
    get id(): string;
    private _members?;
    get members(): string[];
    set members(value: string[]);
    get membersInput(): string[] | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _serviceAccountId?;
    get serviceAccountId(): string;
    set serviceAccountId(value: string);
    get serviceAccountIdInput(): string | undefined;
    private _condition;
    get condition(): ServiceAccountIamBindingConditionOutputReference;
    putCondition(value: ServiceAccountIamBindingCondition): void;
    resetCondition(): void;
    get conditionInput(): ServiceAccountIamBindingCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
