import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SourcerepoRepositoryIamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository_iam_member#member SourcerepoRepositoryIamMember#member}
    */
    readonly member: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository_iam_member#project SourcerepoRepositoryIamMember#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository_iam_member#repository SourcerepoRepositoryIamMember#repository}
    */
    readonly repository: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository_iam_member#role SourcerepoRepositoryIamMember#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository_iam_member#condition SourcerepoRepositoryIamMember#condition}
    */
    readonly condition?: SourcerepoRepositoryIamMemberCondition;
}
export interface SourcerepoRepositoryIamMemberCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository_iam_member#description SourcerepoRepositoryIamMember#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository_iam_member#expression SourcerepoRepositoryIamMember#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository_iam_member#title SourcerepoRepositoryIamMember#title}
    */
    readonly title: string;
}
export declare function sourcerepoRepositoryIamMemberConditionToTerraform(struct?: SourcerepoRepositoryIamMemberConditionOutputReference | SourcerepoRepositoryIamMemberCondition): any;
export declare class SourcerepoRepositoryIamMemberConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): SourcerepoRepositoryIamMemberCondition | undefined;
    set internalValue(value: SourcerepoRepositoryIamMemberCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository_iam_member google_sourcerepo_repository_iam_member}
*/
export declare class SourcerepoRepositoryIamMember extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository_iam_member google_sourcerepo_repository_iam_member} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SourcerepoRepositoryIamMemberConfig
    */
    constructor(scope: Construct, id: string, config: SourcerepoRepositoryIamMemberConfig);
    get etag(): string;
    get id(): string;
    private _member?;
    get member(): string;
    set member(value: string);
    get memberInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _repository?;
    get repository(): string;
    set repository(value: string);
    get repositoryInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition;
    get condition(): SourcerepoRepositoryIamMemberConditionOutputReference;
    putCondition(value: SourcerepoRepositoryIamMemberCondition): void;
    resetCondition(): void;
    get conditionInput(): SourcerepoRepositoryIamMemberCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
