import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SqlSslCertConfig extends cdktf.TerraformMetaArguments {
    /**
    * The common name to be used in the certificate to identify the client. Constrained to [a-zA-Z.-_ ]+. Changing this forces a new resource to be created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_ssl_cert#common_name SqlSslCert#common_name}
    */
    readonly commonName: string;
    /**
    * The name of the Cloud SQL instance. Changing this forces a new resource to be created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_ssl_cert#instance SqlSslCert#instance}
    */
    readonly instance: string;
    /**
    * The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_ssl_cert#project SqlSslCert#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_ssl_cert#timeouts SqlSslCert#timeouts}
    */
    readonly timeouts?: SqlSslCertTimeouts;
}
export interface SqlSslCertTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_ssl_cert#create SqlSslCert#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_ssl_cert#delete SqlSslCert#delete}
    */
    readonly delete?: string;
}
export declare function sqlSslCertTimeoutsToTerraform(struct?: SqlSslCertTimeoutsOutputReference | SqlSslCertTimeouts | cdktf.IResolvable): any;
export declare class SqlSslCertTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): SqlSslCertTimeouts | undefined;
    set internalValue(value: SqlSslCertTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/sql_ssl_cert google_sql_ssl_cert}
*/
export declare class SqlSslCert extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/sql_ssl_cert google_sql_ssl_cert} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SqlSslCertConfig
    */
    constructor(scope: Construct, id: string, config: SqlSslCertConfig);
    get cert(): string;
    get certSerialNumber(): string;
    private _commonName?;
    get commonName(): string;
    set commonName(value: string);
    get commonNameInput(): string | undefined;
    get createTime(): string;
    get expirationTime(): string;
    get id(): string;
    private _instance?;
    get instance(): string;
    set instance(value: string);
    get instanceInput(): string | undefined;
    get privateKey(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get serverCaCert(): string;
    get sha1Fingerprint(): string;
    private _timeouts;
    get timeouts(): SqlSslCertTimeoutsOutputReference;
    putTimeouts(value: SqlSslCertTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): SqlSslCertTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
