import { aws_eks as eks } from 'aws-cdk-lib';
import { Construct } from 'constructs';
/**
 * The construct properties for KubeSphere
 */
export interface KubeSphereProps {
    /**
     * The existing Amazon EKS cluster(if any)
     * @default - create a default new cluster
     */
    readonly cluster?: eks.ICluster;
    /**
     * whether to enable the KubeSphere Application Store(openpitrix)
     * @default false
     */
    readonly appStore?: boolean;
    /**
     * Options to create the Amazon EKS managed nodegroup
     * @default - 2x m5.large on-demand instances
     */
    readonly nodegroupOptions?: eks.NodegroupOptions;
}
/**
 * The KubeSphere workload
 */
export declare class KubeSphere extends Construct {
    private readonly nodegroupOptions?;
    constructor(scope: Construct, id: string, props?: KubeSphereProps);
    private _createEksCluster;
}
