#  Copyright 2023 MTS (Mobile Telesystems)
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

from __future__ import annotations

from typing import Optional

from pydantic import Field

from onetl.impl import GenericOptions

# options generated by JDBCMixin methods
PROHIBITED_OPTIONS = frozenset(
    (
        "user",
        "password",
        "driver",
        "url",
    ),
)


class JDBCOptions(GenericOptions):
    """Generic options, related to specific JDBC driver.

    .. note ::

        You can pass any value
        supported by underlying JDBC driver class,
        even if it is not mentioned in this documentation.
    """

    class Config:
        prohibited_options = PROHIBITED_OPTIONS
        extra = "allow"

    query_timeout: Optional[int] = Field(default=None, alias="queryTimeout")
    """The number of seconds the driver will wait for a statement to execute.
    Zero means there is no limit.

    This option depends on driver implementation,
    some drivers can check the timeout of each query instead of an entire JDBC batch.
    """

    fetchsize: Optional[int] = None
    """How many rows to fetch per round trip.

    Tuning this option can influence performance of reading.

    .. warning::

        Default value depends on driver. For example, Oracle has
        default ``fetchsize=10``.
    """
