#  Copyright 2023 MTS (Mobile Telesystems)
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

import textwrap
import warnings
from importlib import import_module

from onetl.core.file_filter import *
from onetl.core.file_limit import *

module_for_class = {
    "DBReader": "db",
    "DBWriter": "db",
    "FileDownloader": "file",
    "DownloadResult": "file",
    "FileUploader": "file",
    "UploadResult": "file",
    "MoveResult": "file",
    "FileResult": "file.file_result",
    "FileSet": "file.file_set",
}


def __getattr__(name: str):
    if name in module_for_class:
        submodule = module_for_class[name]
        msg = f"""
        This import is deprecated since v0.8.0:

            from onetl.core import {name}

        Please use instead:

            from onetl.{submodule} import {name}
        """

        warnings.warn(
            textwrap.dedent(msg),
            UserWarning,
            stacklevel=2,
        )
        return getattr(import_module(f"onetl.{submodule}"), name)

    raise ImportError(f"cannot import name {name!r} from {__name__!r}")
