/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Objects;
import org.firebirdsql.gds.BlobParameterBuffer;
import org.firebirdsql.gds.EventHandle;
import org.firebirdsql.gds.EventHandler;
import org.firebirdsql.gds.impl.wire.XdrInputStream;
import org.firebirdsql.gds.impl.wire.XdrOutputStream;
import org.firebirdsql.gds.ng.AbstractFbDatabase;
import org.firebirdsql.gds.ng.DefaultDatatypeCoder;
import org.firebirdsql.gds.ng.FbBlob;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.FbTransaction;
import org.firebirdsql.gds.ng.WarningMessageCallback;
import org.firebirdsql.gds.ng.wire.AsynchronousProcessor;
import org.firebirdsql.gds.ng.wire.FbWireAsynchronousChannel;
import org.firebirdsql.gds.ng.wire.FbWireBlob;
import org.firebirdsql.gds.ng.wire.FbWireDatabase;
import org.firebirdsql.gds.ng.wire.FbWireOperations;
import org.firebirdsql.gds.ng.wire.FbWireTransaction;
import org.firebirdsql.gds.ng.wire.GenericResponse;
import org.firebirdsql.gds.ng.wire.ProtocolDescriptor;
import org.firebirdsql.gds.ng.wire.Response;
import org.firebirdsql.gds.ng.wire.SqlResponse;
import org.firebirdsql.gds.ng.wire.WireDatabaseConnection;
import org.firebirdsql.gds.ng.wire.WireEventHandle;
import org.firebirdsql.gds.ng.wire.XdrStreamAccess;

public abstract class AbstractFbWireDatabase
extends AbstractFbDatabase<WireDatabaseConnection>
implements FbWireDatabase {
    protected final ProtocolDescriptor protocolDescriptor;
    protected final FbWireOperations wireOperations;
    private FbWireAsynchronousChannel asynchronousChannel;

    protected AbstractFbWireDatabase(WireDatabaseConnection connection, ProtocolDescriptor descriptor) {
        super(connection, DefaultDatatypeCoder.forEncodingFactory(connection.getEncodingFactory()));
        this.protocolDescriptor = Objects.requireNonNull(descriptor, "parameter descriptor should be non-null");
        this.wireOperations = descriptor.createWireOperations(connection, this.getDatabaseWarningCallback(), this.getSynchronizationObject());
    }

    @Override
    public void forceClose() throws SQLException {
        try {
            if (((WireDatabaseConnection)this.connection).isConnected()) {
                ((WireDatabaseConnection)this.connection).close();
            }
        }
        catch (IOException e) {
            throw new FbExceptionBuilder().exception(335544727).cause(e).toFlatSQLException();
        }
        finally {
            this.databaseListenerDispatcher.detached(this);
            this.databaseListenerDispatcher.shutdown();
            this.exceptionListenerDispatcher.shutdown();
        }
    }

    protected final XdrInputStream getXdrIn() throws SQLException {
        return this.getXdrStreamAccess().getXdrIn();
    }

    protected final XdrOutputStream getXdrOut() throws SQLException {
        return this.getXdrStreamAccess().getXdrOut();
    }

    @Override
    public final XdrStreamAccess getXdrStreamAccess() {
        return ((WireDatabaseConnection)this.connection).getXdrStreamAccess();
    }

    @Override
    public final boolean isAttached() {
        return super.isAttached() && ((WireDatabaseConnection)this.connection).isConnected();
    }

    @Override
    protected final void checkConnected() throws SQLException {
        if (!((WireDatabaseConnection)this.connection).isConnected()) {
            throw FbExceptionBuilder.forException(337248273).toFlatSQLException();
        }
    }

    protected final void checkAttached() throws SQLException {
        this.checkConnected();
        if (!this.isAttached()) {
            throw FbExceptionBuilder.forException(337248274).toFlatSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void closeConnection() throws IOException {
        if (!((WireDatabaseConnection)this.connection).isConnected()) {
            return;
        }
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            try {
                ((WireDatabaseConnection)this.connection).close();
            }
            finally {
                this.setDetached();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNetworkTimeout(int milliseconds) throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            try {
                this.checkConnected();
                this.wireOperations.setNetworkTimeout(milliseconds);
            }
            catch (SQLException e) {
                this.exceptionListenerDispatcher.errorOccurred(e);
                throw e;
            }
        }
    }

    @Override
    public final FbBlob createBlobForOutput(FbTransaction transaction, BlobParameterBuffer blobParameterBuffer) {
        FbWireBlob outputBlob = this.protocolDescriptor.createOutputBlob(this, (FbWireTransaction)transaction, blobParameterBuffer);
        outputBlob.addExceptionListener(this.exceptionListenerDispatcher);
        return outputBlob;
    }

    @Override
    public final FbBlob createBlobForInput(FbTransaction transaction, BlobParameterBuffer blobParameterBuffer, long blobId) {
        FbWireBlob inputBlob = this.protocolDescriptor.createInputBlob(this, (FbWireTransaction)transaction, blobParameterBuffer, blobId);
        inputBlob.addExceptionListener(this.exceptionListenerDispatcher);
        return inputBlob;
    }

    @Override
    public final void consumePackets(int numberOfResponses, WarningMessageCallback warningCallback) {
        this.wireOperations.consumePackets(numberOfResponses, warningCallback);
    }

    @Override
    public final GenericResponse readGenericResponse(WarningMessageCallback warningCallback) throws SQLException, IOException {
        return this.wireOperations.readGenericResponse(warningCallback);
    }

    @Override
    public final SqlResponse readSqlResponse(WarningMessageCallback warningCallback) throws SQLException, IOException {
        return this.wireOperations.readSqlResponse(warningCallback);
    }

    @Override
    public final Response readResponse(WarningMessageCallback warningCallback) throws SQLException, IOException {
        return this.wireOperations.readResponse(warningCallback);
    }

    @Override
    public final EventHandle createEventHandle(String eventName, EventHandler eventHandler) {
        return new WireEventHandle(eventName, eventHandler, this.getEncoding());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void queueEvent(EventHandle eventHandle) throws SQLException {
        try {
            this.checkAttached();
            Object object = this.getSynchronizationObject();
            synchronized (object) {
                if (this.asynchronousChannel == null || !this.asynchronousChannel.isConnected()) {
                    this.asynchronousChannel = this.initAsynchronousChannel();
                    AsynchronousProcessor.getInstance().registerAsynchronousChannel(this.asynchronousChannel);
                }
                this.asynchronousChannel.queueEvent(eventHandle);
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void cancelEvent(EventHandle eventHandle) throws SQLException {
        try {
            this.checkAttached();
            Object object = this.getSynchronizationObject();
            synchronized (object) {
                if (this.asynchronousChannel == null || !this.asynchronousChannel.isConnected()) {
                    throw new FbExceptionBuilder().nonTransientException(337248269).toFlatSQLException();
                }
                this.asynchronousChannel.cancelEvent(eventHandle);
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    @Override
    public final void countEvents(EventHandle eventHandle) throws SQLException {
        try {
            if (!(eventHandle instanceof WireEventHandle)) {
                throw new SQLException("Invalid event handle, type: " + eventHandle.getClass().getName());
            }
            ((WireEventHandle)eventHandle).calculateCount();
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    public abstract FbWireAsynchronousChannel initAsynchronousChannel() throws SQLException;

    protected void finalize() throws Throwable {
        try {
            if (!((WireDatabaseConnection)this.connection).isConnected()) {
                return;
            }
            if (this.isAttached()) {
                this.safelyDetach();
            } else {
                this.closeConnection();
            }
        }
        finally {
            super.finalize();
        }
    }
}

