/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.config;

import com.datical.liquibase.ext.checks.config.FileAccessor;
import com.datical.liquibase.ext.checks.config.FileAccessor$FileAccessorDTO;
import com.datical.liquibase.ext.checks.config.IFileAccessor;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.CheckSettingsConfig;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import liquibase.Scope;
import liquibase.util.StringUtil;
import org.yaml.snakeyaml.Yaml;

public class CheckSettingsConfigHelper {
    public static final String LIQUIBASE_CHECKS_SETTINGS_CONF = "liquibase.checks-settings.conf";
    private final String checkSettingsFilename;
    private final IFileAccessor fileAccessor;
    private final Yaml yaml = new Yaml();

    public CheckSettingsConfigHelper() {
        this((String)null);
    }

    public CheckSettingsConfigHelper(String string) {
        this.fileAccessor = new FileAccessor();
        if (StringUtil.isEmpty(string)) {
            this.checkSettingsFilename = LIQUIBASE_CHECKS_SETTINGS_CONF;
            return;
        }
        this.checkSettingsFilename = string;
    }

    public CheckSettingsConfig read(List<AbstractLiquibaseRule> list) {
        FileAccessor$FileAccessorDTO object2;
        try {
            object2 = this.fileAccessor.loadFileContents(this.checkSettingsFilename);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string2 = Scope.getCurrentScope().getUI().prompt(this.checkSettingsFilename + " does not exist." + System.lineSeparator() + "Would you like to create it? (Y/n)", "Y", (string, clazz) -> {
                if (string == null || !string.equalsIgnoreCase("y") && !string.equalsIgnoreCase("yes") && !string.equalsIgnoreCase("n") && !string.equalsIgnoreCase("no")) {
                    throw new IllegalArgumentException();
                }
                return string;
            }, String.class);
            if (string2 != null && (string2.equalsIgnoreCase("y") || string2.equalsIgnoreCase("yes"))) {
                this.write(CheckSettingsConfig.generateDefaultConfigFromRules(list));
                Scope.getCurrentScope().getUI().sendMessage(this.checkSettingsFilename + " successfully created!");
                FileAccessor$FileAccessorDTO fileAccessor$FileAccessorDTO = this.fileAccessor.loadFileContents(this.checkSettingsFilename);
                return (CheckSettingsConfig)this.yaml.loadAs(fileAccessor$FileAccessorDTO.contents, CheckSettingsConfig.class);
            }
            Scope.getCurrentScope().getUI().sendMessage("No changes have been made to default check configuration.");
            return null;
        }
        CheckSettingsConfig checkSettingsConfig = (CheckSettingsConfig)this.yaml.loadAs(object2.contents, CheckSettingsConfig.class);
        if (!object2.versioned) {
            checkSettingsConfig.getRules().forEach(abstractConfigurableRule -> abstractConfigurableRule.setSeverity(SeverityEnum.INFO));
            this.write(checkSettingsConfig);
        }
        if (object2.encoded) {
            this.write(checkSettingsConfig);
        }
        for (AbstractLiquibaseRule abstractLiquibaseRule : list) {
            AbstractConfigurableRule abstractConfigurableRule2 = checkSettingsConfig.getRuleById(abstractLiquibaseRule.getId());
            if (abstractConfigurableRule2 == null || abstractConfigurableRule2.getSeverity() == abstractLiquibaseRule.getSeverity()) continue;
            abstractLiquibaseRule.setSeverity(abstractConfigurableRule2.getSeverity());
        }
        if (this.addMissingRules(list, checkSettingsConfig)) {
            this.write(checkSettingsConfig);
        }
        this.sortRulesByPriority(list, checkSettingsConfig);
        return checkSettingsConfig;
    }

    public CheckSettingsConfigHelper(IFileAccessor iFileAccessor) {
        this.fileAccessor = iFileAccessor;
        this.checkSettingsFilename = LIQUIBASE_CHECKS_SETTINGS_CONF;
    }

    private void sortRulesByPriority(List<AbstractLiquibaseRule> object, CheckSettingsConfig checkSettingsConfig) {
        ArrayList<AbstractConfigurableRule> arrayList = new ArrayList<AbstractConfigurableRule>(checkSettingsConfig.getRules().size());
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                AbstractLiquibaseRule abstractLiquibaseRule = (AbstractLiquibaseRule)object.next();
                arrayList.addAll(checkSettingsConfig.getExecutableRulesByRuleId(abstractLiquibaseRule.getId()));
            }
        }
        CheckSettingsConfig checkSettingsConfig2 = checkSettingsConfig;
        checkSettingsConfig2.setUnrecognizedRules(checkSettingsConfig2.getRules().stream().filter(abstractConfigurableRule -> !arrayList.contains(abstractConfigurableRule)).collect(Collectors.toList()));
        checkSettingsConfig.setRules(arrayList);
    }

    private boolean addMissingRules(List<AbstractLiquibaseRule> object, CheckSettingsConfig checkSettingsConfig) {
        boolean bl2 = false;
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                AbstractLiquibaseRule abstractLiquibaseRule = (AbstractLiquibaseRule)object.next();
                if (checkSettingsConfig.getRuleById(abstractLiquibaseRule.getId()) != null) continue;
                bl2 = checkSettingsConfig.getRules().add(AbstractConfigurableRule.fromRuleImplementation(abstractLiquibaseRule));
            }
        }
        return bl2;
    }

    public void write(CheckSettingsConfig object) {
        object = this.yaml.dump(object);
        this.fileAccessor.writeFileContents(this.checkSettingsFilename, (String)object);
    }
}

