/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.dynamic;

import com.datical.liquibase.ext.checks.JSqlParserCache;
import com.datical.liquibase.ext.checks.dynamic.AbstractObjectNamingRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import liquibase.change.AbstractChange;
import liquibase.change.core.CreateTableChange;
import liquibase.change.core.DropTableChange;
import liquibase.change.core.RenameTableChange;
import liquibase.repackaged.net.sf.jsqlparser.schema.Table;
import liquibase.repackaged.net.sf.jsqlparser.statement.alter.Alter;
import liquibase.repackaged.net.sf.jsqlparser.statement.alter.AlterExpression;
import liquibase.repackaged.net.sf.jsqlparser.statement.alter.RenameTableStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.table.CreateTable;
import liquibase.repackaged.net.sf.jsqlparser.statement.drop.Drop;
import liquibase.util.StringUtil;

public abstract class AbstractTableNamingRule
extends AbstractObjectNamingRule {
    @Override
    public final List<String> getValue(AbstractChange abstractChange) {
        if (abstractChange instanceof RenameTableChange) {
            return Collections.singletonList(((RenameTableChange)abstractChange).getNewTableName());
        }
        if (abstractChange instanceof CreateTableChange) {
            return Collections.singletonList(((CreateTableChange)abstractChange).getTableName());
        }
        if (abstractChange instanceof DropTableChange) {
            return Collections.singletonList(((DropTableChange)abstractChange).getTableName());
        }
        return null;
    }

    @Override
    public final List<String> getValue(String stringArray, String string) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        stringArray = StringUtil.splitSQL((String)stringArray, string);
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = JSqlParserCache.parseSql(stringArray[i2], true);
            if (object instanceof CreateTable) {
                arrayList.add(((CreateTable)object).getTable().getName());
                continue;
            }
            if (object instanceof Drop) {
                arrayList.add(((Drop)object).getName().getName());
                continue;
            }
            if (object instanceof Alter) {
                object = ((Alter)object).getAlterExpressions().iterator();
                while (object.hasNext()) {
                    Map.Entry<Table, Table> entry = ((AlterExpression)((Object)object.next())).getNewTableName();
                    if (!StringUtil.isNotEmpty((String)((Object)entry))) continue;
                    arrayList.add(entry);
                }
                continue;
            }
            if (!(object instanceof RenameTableStatement)) continue;
            for (Map.Entry<Table, Table> entry : ((RenameTableStatement)object).getTableNames()) {
                if (!StringUtil.isNotEmpty(entry.getValue().getName())) continue;
                arrayList.add(((Table)entry.getValue()).getName());
            }
        }
        return arrayList.stream().map(this::sanitizeTableNames).collect(Collectors.toList());
    }

    private String sanitizeTableNames(String string) {
        Iterator<String> iterator = Arrays.asList("\"", "[", "`");
        List<String> list = Arrays.asList("\"", "]", "`");
        String string2 = string;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (!string.startsWith(string3)) continue;
            string2 = string2.substring(string3.length());
            break;
        }
        for (String string3 : list) {
            if (!string.endsWith(string3)) continue;
            string2 = string2.substring(0, string2.length() - string3.length());
            break;
        }
        return string2;
    }
}

