/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.checks;

import com.datical.liquibase.ext.checks.config.CheckSettingsConfigHelper;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.CheckSettingsConfig;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import com.datical.liquibase.ext.command.checks.AbstractChecksCommandStep;
import com.datical.liquibase.ext.command.checks.ChecksCopyCommandStep;
import com.datical.liquibase.ext.command.checks.ChecksShowCommandStep;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import liquibase.Scope;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.exception.CommandExecutionException;

public class ChecksCustomizeCommandStep
extends AbstractChecksCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"checks", "customize"};
    public static final CommandArgumentDefinition<String> CHECK_NAME_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_SETTINGS_FILE_ARG;

    @Override
    public final void run(CommandResultsBuilder commandResultsBuilder) {
        List<DynamicRuleParameter> list = commandResultsBuilder.getCommandScope();
        String string2 = ((CommandScope)((Object)list)).getConfiguredValue(CHECKS_SETTINGS_FILE_ARG).getValue();
        list = ((CommandScope)((Object)list)).getConfiguredValue(CHECK_NAME_ARG).getValue();
        CheckSettingsConfigHelper checkSettingsConfigHelper = new CheckSettingsConfigHelper(string2);
        List<AbstractLiquibaseRule> list2 = ChecksCustomizeCommandStep.listAllRules();
        CheckSettingsConfig checkSettingsConfig = checkSettingsConfigHelper.read(list2);
        if (checkSettingsConfig == null) {
            commandResultsBuilder.addResult("statusCode", (Object)0);
            return;
        }
        Object object = list2.stream().filter(arg_0 -> ChecksCustomizeCommandStep.lambda$run$0((String)((Object)list), arg_0)).findFirst();
        if (((Optional)object).isPresent() && !((Optional)object).get().isConfigurable()) {
            AbstractConfigurableRule abstractConfigurableRule = checkSettingsConfig.getRuleById(((AbstractLiquibaseRule)(object = ((Optional)object).get())).getId());
            if (abstractConfigurableRule == null) {
                throw new CommandExecutionException("Unable to locate check to modify '" + ((AbstractLiquibaseRule)object).getShortName() + "' in configuration settings.");
            }
            if (ChecksCustomizeCommandStep.modifySeverity(abstractConfigurableRule)) {
                checkSettingsConfigHelper.write(checkSettingsConfig);
            }
            Scope.getCurrentScope().getUI().sendMessage("Customization complete. Review the table below to confirm your changes.");
            ChecksShowCommandStep.writeTableToOutput(commandResultsBuilder, string2, false);
            commandResultsBuilder.addResult("statusCode", (Object)0);
            return;
        }
        object = checkSettingsConfig.getDynamicConfigurableRuleByShortName((String)((Object)list), "does not have customization options");
        AbstractLiquibaseRule abstractLiquibaseRule = ChecksCustomizeCommandStep.findConfigurableParentRule((AbstractConfigurableRule)object, list2, (String)((Object)list), "does not have customization options");
        if (!abstractLiquibaseRule.hasDefaultParameterValues() && !((DynamicRule)object).isCopy()) {
            Scope.getCurrentScope().getUI().sendMessage(System.lineSeparator() + "This check can not be customized directly because one or more fields does not have a default value.  Creating a copy of this check and initiating the customization workflow.");
            ChecksCopyCommandStep.doCopy(checkSettingsConfig, list, list2, string2, commandResultsBuilder, checkSettingsConfigHelper);
        } else {
            ChecksCustomizeCommandStep.modifySeverity((AbstractConfigurableRule)object);
            list = ChecksCustomizeCommandStep.promptForParameters(abstractLiquibaseRule.getParameters(), (DynamicRule)object);
            if (!((AbstractConfigurableRule)object).isEnabled() && (list2 = Scope.getCurrentScope().getUI().prompt("This check is disabled.  Enable it? (Y/n)", null, (string, clazz) -> {
                if (string == null || !string.equalsIgnoreCase("y") && !string.equalsIgnoreCase("n")) {
                    throw new IllegalArgumentException();
                }
                return string;
            }, String.class)) != null && ((String)((Object)list2)).equalsIgnoreCase("y")) {
                ((AbstractConfigurableRule)object).setEnabled(true);
            }
            ((DynamicRule)object).getParameters().clear();
            ((DynamicRule)object).getParameters().addAll(list);
            checkSettingsConfigHelper.write(checkSettingsConfig);
            Scope.getCurrentScope().getUI().sendMessage("Customization complete. Review the table below to confirm your changes.");
            ChecksShowCommandStep.writeTableToOutput(commandResultsBuilder, string2, false);
        }
        commandResultsBuilder.addResult("statusCode", (Object)0);
    }

    public static List<DynamicRuleParameter> promptForParameters(List<RuleParameter<?>> object, DynamicRule dynamicRule) {
        ArrayList<DynamicRuleParameter> arrayList = new ArrayList<DynamicRuleParameter>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (RuleParameter)object.next();
            if (!((RuleParameter)object2).shouldPrompt(arrayList)) continue;
            Optional<DynamicRuleParameter> optional = dynamicRule.getParameters().stream().filter(arg_0 -> ChecksCustomizeCommandStep.lambda$promptForParameters$2((RuleParameter)object2, arg_0)).findFirst();
            Object object3 = ((RuleParameter)object2).getDefaultValue();
            optional = !optional.isPresent() ? null : optional.get().getValue();
            Optional<DynamicRuleParameter> optional2 = optional;
            optional = ((RuleParameter)object2).getInteractiveCommandLineValueGetter().prompt((RuleParameter<?>)object2, (List<DynamicRuleParameter>)arrayList, object3, optional2, optional2 != null || object3 != null);
            object2 = new DynamicRuleParameter(((RuleParameter)object2).getParameter(), optional);
            arrayList.add((DynamicRuleParameter)object2);
        }
        return arrayList;
    }

    @Override
    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    @Override
    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setShortDescription("CLI-guided configuration of the named check");
        commandDefinition.setGroupShortDescription(new String[]{"checks"}, "Quality Checks commands");
    }

    private static /* synthetic */ boolean lambda$promptForParameters$2(RuleParameter ruleParameter, DynamicRuleParameter dynamicRuleParameter) {
        return dynamicRuleParameter.getParameterAsEnum() == ruleParameter.getParameter();
    }

    private static /* synthetic */ boolean lambda$run$0(String string, AbstractLiquibaseRule abstractLiquibaseRule) {
        return abstractLiquibaseRule.getShortName().equalsIgnoreCase(string);
    }

    static {
        CommandBuilder commandBuilder = new CommandBuilder(new String[][]{COMMAND_NAME});
        CHECK_NAME_ARG = commandBuilder.argument("checkName", String.class).required().description("Name of check to configure").build();
        CHECKS_SETTINGS_FILE_ARG = commandBuilder.argument("checksSettingsFile", String.class).description("Relative or fully qualified path to a configuration file for checks execution").build();
    }
}

