/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.client.metadata;

import com.google.api.services.bigquery.model.DatasetReference;
import com.simba.googlebigquery.dsi.dataengine.filters.IFilter;
import com.simba.googlebigquery.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.simba.googlebigquery.googlebigquery.client.metadata.BQFetchFunctionColumnsTask;
import com.simba.googlebigquery.googlebigquery.client.metadata.BQMetadataExecutor;
import com.simba.googlebigquery.googlebigquery.client.metadata.BQMetadataResult;
import com.simba.googlebigquery.googlebigquery.client.metadata.BQMetadataRetryRequest;
import com.simba.googlebigquery.googlebigquery.client.metadata.BQThreadPoolExecutor;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQFunction;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQMetadataSource;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQMetadataUtils;
import com.simba.googlebigquery.support.ILogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class BQFetchFunctionsTask
implements Callable<BQMetadataResult> {
    private BQMetadataUtils m_bqMetadataUtils;
    private final ILogger m_connLogger;
    private DatasetReference m_dataset;
    protected IFilter[] m_filters;
    private boolean m_isFunction;
    private Map<MetadataSourceColumnTag, String> m_restrictions;
    private BQThreadPoolExecutor m_threadPool;
    BQMetadataExecutor.FetchType m_type;

    public BQFetchFunctionsTask(ILogger iLogger, BQThreadPoolExecutor bQThreadPoolExecutor, BQMetadataUtils bQMetadataUtils, DatasetReference datasetReference, BQMetadataExecutor.FetchType fetchType, IFilter[] iFilterArray, Map<MetadataSourceColumnTag, String> map) {
        this.m_bqMetadataUtils = bQMetadataUtils;
        this.m_connLogger = iLogger;
        this.m_dataset = datasetReference;
        this.m_filters = iFilterArray;
        this.m_isFunction = BQMetadataExecutor.FetchType.FUNCTION == fetchType || BQMetadataExecutor.FetchType.FUNCTIONCOLUMN == fetchType;
        this.m_threadPool = bQThreadPoolExecutor;
        this.m_restrictions = map;
        this.m_type = fetchType;
    }

    @Override
    public BQMetadataResult call() throws Exception {
        Object object;
        Object object2;
        BQMetadataRetryRequest<List<BQFunction>> bQMetadataRetryRequest = new BQMetadataRetryRequest<List<BQFunction>>(this.m_connLogger){

            @Override
            public List<BQFunction> execute() throws Exception {
                return BQFetchFunctionsTask.this.m_bqMetadataUtils.getFunctions(BQFetchFunctionsTask.this.m_dataset.getProjectId(), BQFetchFunctionsTask.this.m_dataset.getDatasetId(), null, BQFetchFunctionsTask.this.m_isFunction);
            }
        };
        Object object3 = (List)bQMetadataRetryRequest.executeWithRetry();
        if (null != this.m_filters[4] && object3.size() > 0) {
            object2 = new ArrayList();
            object = object3.iterator();
            while (object.hasNext()) {
                BQFunction bQFunction = (BQFunction)object.next();
                if (null != this.m_restrictions.get((Object)MetadataSourceColumnTag.PROCEDURE_NAME) && bQFunction.getFunctionName().equals(this.m_restrictions.get((Object)MetadataSourceColumnTag.PROCEDURE_NAME))) {
                    object2.add(bQFunction);
                    continue;
                }
                if (!BQMetadataSource.doesMetadataPassFilter(bQFunction.getFunctionName(), this.m_filters[4])) continue;
                object2.add(bQFunction);
            }
            object3 = object2;
        }
        if (BQMetadataExecutor.FetchType.FUNCTIONCOLUMN == this.m_type || BQMetadataExecutor.FetchType.PROCEDURECOLUMN == this.m_type) {
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (BQFunction)object2.next();
                this.m_threadPool.submit(new BQFetchFunctionColumnsTask(this.m_connLogger, this.m_bqMetadataUtils, (BQFunction)object, this.m_isFunction, this.m_filters, this.m_restrictions));
            }
        }
        object2 = new BQMetadataResult();
        ((BQMetadataResult)object2).addFunctions((List<BQFunction>)object3);
        return object2;
    }
}

